/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.annotations.CollectionTable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;

public class BasicCollectionAccessor
extends DirectCollectionAccessor {
    private ColumnMetadata m_valueColumn;

    public BasicCollectionAccessor() {
        super("<basic-collection>");
    }

    protected BasicCollectionAccessor(String string) {
        super(string);
    }

    public BasicCollectionAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        if (annotation != null) {
            this.m_valueColumn = new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("valueColumn", annotation), metadataAccessibleObject, this.getAttributeName());
        }
        if (this.isAnnotationPresent(CollectionTable.class)) {
            this.setCollectionTable(new CollectionTableMetadata((Annotation)this.getAnnotation(CollectionTable.class), metadataAccessibleObject, false));
        }
    }

    protected ColumnMetadata getColumn(String string) {
        if (string.equals("metadata_default_value_column")) {
            return this.m_valueColumn == null ? super.getColumn(string) : this.m_valueColumn;
        }
        return super.getColumn(string);
    }

    protected DatabaseField getDatabaseField(DatabaseTable databaseTable, String string) {
        DatabaseField databaseField = super.getDatabaseField(databaseTable, string);
        if (this.getAccessibleObject().isGenericCollectionType()) {
            if (string.equals("metadata_default_key_column")) {
                databaseField.setType(this.getMapKeyReferenceClass());
            } else {
                databaseField.setType(this.getReferenceClass());
            }
        }
        return databaseField;
    }

    protected String getDefaultCollectionTableName() {
        if (this.m_valueColumn != null && this.m_valueColumn.getTable() != null && !this.m_valueColumn.getTable().equals("")) {
            return this.m_valueColumn.getTable();
        }
        return super.getDefaultCollectionTableName();
    }

    protected String getKeyConverter() {
        return null;
    }

    public ColumnMetadata getValueColumn() {
        return this.m_valueColumn;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_valueColumn, metadataAccessibleObject);
    }

    public boolean isBasicCollection() {
        return true;
    }

    public void process() {
        if (!this.isValidDirectCollectionType()) {
            throw ValidationException.invalidTypeForBasicCollectionAttribute(this.getAttributeName(), this.getRawClass(), this.getJavaClass());
        }
        this.processDirectCollectionMapping();
    }

    protected void processCollectionTable(CollectionMapping collectionMapping) {
        super.processCollectionTable(collectionMapping);
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumnMetadata : this.processPrimaryKeyJoinColumns(new PrimaryKeyJoinColumnsMetadata(this.getCollectionTable().getPrimaryKeyJoinColumns()))) {
            DatabaseField databaseField = primaryKeyJoinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, this.getOwningDescriptor().getPrimaryKeyFieldName(), "metadata_default_pk_column"));
            databaseField.setTable(this.getDescriptor().getPrimaryTable());
            DatabaseField databaseField2 = primaryKeyJoinColumnMetadata.getForeignKeyField();
            databaseField2.setName(this.getName(databaseField2, this.getOwningDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column"));
            databaseField2.setTable(this.getReferenceDatabaseTable());
            ((DirectCollectionMapping)collectionMapping).addReferenceKeyField(databaseField2, databaseField);
        }
    }

    protected void setValueColumn(ColumnMetadata columnMetadata) {
        this.m_valueColumn = columnMetadata;
    }
}

