/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import javax.persistence.MapKeyTemporal;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import org.eclipse.persistence.annotations.MapKeyConvert;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CollectionAccessor
extends RelationshipAccessor
implements MappedKeyMapAccessor {
    private static final String ASCENDING = "ASC";
    private static final String DESCENDING = "DESC";
    private Class m_mapKeyClass;
    private ColumnMetadata m_mapKeyColumn;
    private ColumnMetadata m_orderColumn;
    private EnumeratedMetadata m_mapKeyEnumerated;
    private List<AssociationOverrideMetadata> m_mapKeyAssociationOverrides;
    private List<AttributeOverrideMetadata> m_mapKeyAttributeOverrides;
    private List<JoinColumnMetadata> m_mapKeyJoinColumns;
    private String m_mapKey;
    private String m_mapKeyConvert;
    private String m_mapKeyClassName;
    private String m_mappedBy;
    private String m_orderBy;
    private TemporalMetadata m_mapKeyTemporal;

    protected CollectionAccessor(String string) {
        super(string);
    }

    protected CollectionAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        String string = this.m_mappedBy = annotation == null ? "" : (String)MetadataHelper.invokeMethod("mappedBy", annotation);
        if (this.isAnnotationPresent(OrderBy.class)) {
            this.m_orderBy = (String)MetadataHelper.invokeMethod("value", this.getAnnotation(OrderBy.class));
        }
        if (this.isAnnotationPresent(MapKey.class)) {
            this.m_mapKey = (String)MetadataHelper.invokeMethod("name", this.getAnnotation(MapKey.class));
        }
        if (this.isAnnotationPresent(MapKeyClass.class)) {
            this.m_mapKeyClass = (Class)MetadataHelper.invokeMethod("value", this.getAnnotation(MapKeyClass.class));
        }
        if (this.isAnnotationPresent(MapKeyColumn.class)) {
            this.m_mapKeyColumn = new ColumnMetadata((Annotation)this.getAnnotation(MapKeyColumn.class), metadataAccessibleObject, this.getAttributeName());
        }
        this.m_mapKeyJoinColumns = new ArrayList<JoinColumnMetadata>();
        if (this.isAnnotationPresent(MapKeyJoinColumns.class)) {
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("value", this.getAnnotation(MapKeyJoinColumns.class))) {
                this.m_mapKeyJoinColumns.add(new JoinColumnMetadata(annotation2, metadataAccessibleObject));
            }
        }
        if (this.isAnnotationPresent(MapKeyJoinColumn.class)) {
            this.m_mapKeyJoinColumns.add(new JoinColumnMetadata((Annotation)this.getAnnotation(MapKeyJoinColumn.class), metadataAccessibleObject));
        }
        this.m_mapKeyAttributeOverrides = new ArrayList<AttributeOverrideMetadata>();
        if (this.isAnnotationPresent(AttributeOverrides.class)) {
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("value", this.getAnnotation(AttributeOverrides.class))) {
                this.m_mapKeyAttributeOverrides.add(new AttributeOverrideMetadata(annotation2, metadataAccessibleObject));
            }
        }
        if (this.isAnnotationPresent(AttributeOverride.class)) {
            this.m_mapKeyAttributeOverrides.add(new AttributeOverrideMetadata((Annotation)this.getAnnotation(AttributeOverride.class), metadataAccessibleObject));
        }
        this.m_mapKeyAssociationOverrides = new ArrayList<AssociationOverrideMetadata>();
        if (this.isAnnotationPresent(AssociationOverrides.class)) {
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("value", this.getAnnotation(AssociationOverrides.class))) {
                this.m_mapKeyAssociationOverrides.add(new AssociationOverrideMetadata(annotation2, metadataAccessibleObject));
            }
        }
        if (this.isAnnotationPresent(AssociationOverride.class)) {
            this.m_mapKeyAssociationOverrides.add(new AssociationOverrideMetadata((Annotation)this.getAnnotation(AssociationOverride.class), metadataAccessibleObject));
        }
        if (this.isAnnotationPresent(OrderColumn.class)) {
            this.m_orderColumn = new ColumnMetadata((Annotation)this.getAnnotation(OrderColumn.class), metadataAccessibleObject, this.getAttributeName());
        }
        if (this.isAnnotationPresent(MapKeyEnumerated.class)) {
            this.m_mapKeyEnumerated = new EnumeratedMetadata((Annotation)this.getAnnotation(MapKeyEnumerated.class), metadataAccessibleObject);
        }
        if (this.isAnnotationPresent(MapKeyTemporal.class)) {
            this.m_mapKeyTemporal = new TemporalMetadata((Annotation)this.getAnnotation(MapKeyTemporal.class), metadataAccessibleObject);
        }
        if (this.isAnnotationPresent(MapKeyConvert.class)) {
            this.m_mapKeyConvert = (String)MetadataHelper.invokeMethod("value", this.getAnnotation(MapKeyConvert.class));
        }
    }

    @Override
    protected ColumnMetadata getColumn(String string) {
        return this.m_mapKeyColumn == null ? super.getColumn(string) : this.m_mapKeyColumn;
    }

    @Override
    public Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"LAZY");
    }

    @Override
    public EnumeratedMetadata getEnumerated(boolean bl) {
        return this.getMapKeyEnumerated();
    }

    @Override
    public String getMapKey() {
        return this.m_mapKey;
    }

    @Override
    public List<AssociationOverrideMetadata> getMapKeyAssociationOverrides() {
        return this.m_mapKeyAssociationOverrides;
    }

    @Override
    public List<AttributeOverrideMetadata> getMapKeyAttributeOverrides() {
        return this.m_mapKeyAttributeOverrides;
    }

    @Override
    public Class getMapKeyClass() {
        return this.m_mapKeyClass;
    }

    public String getMapKeyClassName() {
        return this.m_mapKeyClassName;
    }

    @Override
    public ColumnMetadata getMapKeyColumn() {
        return this.m_mapKeyColumn;
    }

    @Override
    public String getMapKeyConvert() {
        return this.m_mapKeyConvert;
    }

    public EnumeratedMetadata getMapKeyEnumerated() {
        return this.m_mapKeyEnumerated;
    }

    @Override
    public List<JoinColumnMetadata> getMapKeyJoinColumns() {
        return this.m_mapKeyJoinColumns;
    }

    public TemporalMetadata getMapKeyTemporal() {
        return this.m_mapKeyTemporal;
    }

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    public String getOrderBy() {
        return this.m_orderBy;
    }

    protected ColumnMetadata getOrderColumn() {
        return this.m_orderColumn;
    }

    @Override
    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass == Void.TYPE) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    throw ValidationException.unableToDetermineTargetEntity(this.getAttributeName(), this.getJavaClass());
                }
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    @Override
    protected DatabaseTable getReferenceDatabaseTable() {
        if (this.getMapping().isManyToManyMapping()) {
            return ((ManyToManyMapping)this.getMapping()).getRelationTable();
        }
        return super.getReferenceDatabaseTable();
    }

    @Override
    public TemporalMetadata getTemporal(boolean bl) {
        return this.getMapKeyTemporal();
    }

    @Override
    protected boolean hasConvert(boolean bl) {
        return bl ? this.m_mapKeyConvert != null : super.hasConvert(bl);
    }

    @Override
    public boolean hasEnumerated(boolean bl) {
        return bl ? this.m_mapKeyEnumerated != null : super.hasEnumerated(bl);
    }

    @Override
    public boolean hasTemporal(boolean bl) {
        return bl ? this.m_mapKeyTemporal != null : super.hasTemporal(bl);
    }

    @Override
    public boolean isCollectionAccessor() {
        return true;
    }

    @Override
    public boolean isMappedKeyMapAccessor() {
        return this.isMapAccessor();
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_mapKeyJoinColumns, metadataAccessibleObject);
        this.initXMLObjects(this.m_mapKeyAssociationOverrides, metadataAccessibleObject);
        this.initXMLObjects(this.m_mapKeyAttributeOverrides, metadataAccessibleObject);
        this.initXMLObject(this.m_mapKeyColumn, metadataAccessibleObject);
        this.initXMLObject(this.m_orderColumn, metadataAccessibleObject);
        this.m_mapKeyClass = this.initXMLClassName(this.m_mapKeyClassName);
    }

    @Override
    public void process() {
        if (!this.getAccessibleObject().isSupportedToManyCollectionClass(this.getDescriptor())) {
            throw ValidationException.invalidCollectionTypeForRelationship(this.getJavaClass(), this.getRawClass(), this.getAttributeName());
        }
    }

    protected void process(CollectionMapping collectionMapping) {
        this.setMapping(collectionMapping);
        collectionMapping.setIsReadOnly(false);
        collectionMapping.setIsLazy(this.isLazy());
        collectionMapping.setIsPrivateOwned(this.isPrivateOwned());
        collectionMapping.setJoinFetch(this.getMappingJoinFetchType(this.getJoinFetch()));
        collectionMapping.setAttributeName(this.getAttributeName());
        collectionMapping.setReferenceClassName(this.getReferenceClassName());
        this.setAccessorMethods(collectionMapping);
        this.processCascadeTypes(collectionMapping);
        this.processOrderBy(collectionMapping);
        this.processContainerPolicyAndIndirection(collectionMapping);
        this.processReturnInsertAndUpdate();
    }

    protected void processOrderBy(CollectionMapping collectionMapping) {
        block12: {
            if (this.m_orderBy == null) break block12;
            MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
            if (this.m_orderBy.equals("")) {
                List<String> list = metadataDescriptor.getIdOrderByAttributeNames();
                if (metadataDescriptor.hasEmbeddedIdAttribute()) {
                    String string = metadataDescriptor.getEmbeddedIdAttributeName();
                    for (String string2 : list) {
                        collectionMapping.addAggregateOrderBy(string, string2, false);
                    }
                } else {
                    for (String string : list) {
                        collectionMapping.addOrderBy(string, false);
                    }
                }
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(this.m_orderBy, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken());
                    String string3 = stringTokenizer2.nextToken();
                    MappingAccessor mappingAccessor = metadataDescriptor.getAccessorFor(string3);
                    if (mappingAccessor == null) {
                        throw ValidationException.invalidOrderByValue(string3, metadataDescriptor.getJavaClass(), this.getAccessibleObjectName(), this.getJavaClass());
                    }
                    String string4 = mappingAccessor.getAttributeName();
                    String string5 = string = stringTokenizer2.hasMoreTokens() ? stringTokenizer2.nextToken() : ASCENDING;
                    if (mappingAccessor.isEmbedded()) {
                        for (String string6 : metadataDescriptor.getOrderByAttributeNames()) {
                            collectionMapping.addAggregateOrderBy(this.m_orderBy, string6, string.equals(DESCENDING));
                        }
                        continue;
                    }
                    if (mappingAccessor.getClassAccessor().isEmbeddableAccessor()) {
                        Object object = this.m_orderBy;
                        if (((String)object).contains(".")) {
                            object = ((String)object).substring(0, ((String)object).lastIndexOf("."));
                        }
                        collectionMapping.addAggregateOrderBy((String)object, string4, string.equals(DESCENDING));
                        continue;
                    }
                    collectionMapping.addOrderBy(string4, string.equals(DESCENDING));
                }
            }
        }
    }

    public void setMapKey(String string) {
        this.m_mapKey = string;
    }

    public void setMapKeyAssociationOverrides(List<AssociationOverrideMetadata> list) {
        this.m_mapKeyAssociationOverrides = list;
    }

    public void setMapKeyAttributeOverrides(List<AttributeOverrideMetadata> list) {
        this.m_mapKeyAttributeOverrides = list;
    }

    @Override
    public void setMapKeyClass(Class clazz) {
        this.m_mapKeyClass = clazz;
    }

    public void setMapKeyClassName(String string) {
        this.m_mapKeyClassName = string;
    }

    public void setMapKeyColumn(ColumnMetadata columnMetadata) {
        this.m_mapKeyColumn = columnMetadata;
    }

    public void setMapKeyConvert(String string) {
        this.m_mapKeyConvert = string;
    }

    public void setMapKeyEnumerated(EnumeratedMetadata enumeratedMetadata) {
        this.m_mapKeyEnumerated = enumeratedMetadata;
    }

    public void setMapKeyJoinColumns(List<JoinColumnMetadata> list) {
        this.m_mapKeyJoinColumns = list;
    }

    public void setMapKeyTemporal(TemporalMetadata temporalMetadata) {
        this.m_mapKeyTemporal = temporalMetadata;
    }

    public void setMappedBy(String string) {
        this.m_mappedBy = string;
    }

    public void setOrderBy(String string) {
        this.m_orderBy = string;
    }

    public void setOrderColumn(ColumnMetadata columnMetadata) {
        this.m_orderColumn = columnMetadata;
    }
}

