/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.eclipse.persistence.annotations.Convert;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.LobMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;

public abstract class DirectAccessor
extends MappingAccessor {
    private Boolean m_optional;
    private Enum m_fetch;
    private EnumeratedMetadata m_enumerated;
    private LobMetadata m_lob;
    private String m_convert;
    private TemporalMetadata m_temporal;

    protected DirectAccessor(String string) {
        super(string);
    }

    protected DirectAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        if (this.isAnnotationPresent(Lob.class)) {
            this.m_lob = new LobMetadata((Annotation)this.getAnnotation(Lob.class), this.getAccessibleObject());
        }
        if (this.isAnnotationPresent(Enumerated.class)) {
            this.m_enumerated = new EnumeratedMetadata((Annotation)this.getAnnotation(Enumerated.class), this.getAccessibleObject());
        }
        if (this.isAnnotationPresent(Temporal.class)) {
            this.m_temporal = new TemporalMetadata((Annotation)this.getAnnotation(Temporal.class), this.getAccessibleObject());
        }
        if (this.isAnnotationPresent(Convert.class)) {
            this.m_convert = (String)MetadataHelper.invokeMethod("value", this.getAnnotation(Convert.class));
        }
    }

    public String getConvert() {
        return this.m_convert;
    }

    public abstract FetchType getDefaultFetchType();

    public EnumeratedMetadata getEnumerated() {
        return this.m_enumerated;
    }

    public EnumeratedMetadata getEnumerated(boolean bl) {
        return this.getEnumerated();
    }

    public Enum getFetch() {
        return this.m_fetch;
    }

    protected Class getFieldClassification(Enum enum_) {
        if (enum_.name().equals(TemporalType.DATE.name())) {
            return Date.class;
        }
        if (enum_.name().equals(TemporalType.TIME.name())) {
            return Time.class;
        }
        if (enum_.name().equals(TemporalType.TIMESTAMP.name())) {
            return Timestamp.class;
        }
        return null;
    }

    public LobMetadata getLob() {
        return this.m_lob;
    }

    public LobMetadata getLob(boolean bl) {
        if (bl) {
            return super.getLob(bl);
        }
        return this.getLob();
    }

    public Boolean getOptional() {
        return this.m_optional;
    }

    public TemporalMetadata getTemporal() {
        return this.m_temporal;
    }

    public TemporalMetadata getTemporal(boolean bl) {
        return this.getTemporal();
    }

    protected boolean hasConvert(boolean bl) {
        return this.m_convert != null;
    }

    public boolean hasEnumerated(boolean bl) {
        return this.m_enumerated != null;
    }

    public boolean hasLob(boolean bl) {
        return this.m_lob != null;
    }

    public boolean hasTemporal(boolean bl) {
        return this.m_temporal != null;
    }

    public boolean isOptional() {
        if (this.m_optional == null) {
            return true;
        }
        return this.m_optional;
    }

    public void setConvert(String string) {
        this.m_convert = string;
    }

    public void setEnumerated(EnumeratedMetadata enumeratedMetadata) {
        this.m_enumerated = enumeratedMetadata;
    }

    public void setFetch(Enum enum_) {
        this.m_fetch = enum_;
    }

    public void setLob(LobMetadata lobMetadata) {
        this.m_lob = lobMetadata;
    }

    public void setOptional(Boolean bl) {
        this.m_optional = bl;
    }

    public void setTemporal(TemporalMetadata temporalMetadata) {
        this.m_temporal = temporalMetadata;
    }

    protected boolean usesIndirection() {
        Enum enum_ = this.getFetch();
        if (enum_ == null) {
            enum_ = this.getDefaultFetchType();
        }
        return enum_.name().equals(FetchType.LAZY.name());
    }
}

