/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.MapKey;
import javax.persistence.MapKeyClass;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.MapKeyTemporal;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import org.eclipse.persistence.annotations.MapKeyConvert;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.EmbeddableAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappedKeyMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.AssociationOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.AttributeOverrideMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.EnumeratedMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.TemporalMetadata;
import org.eclipse.persistence.internal.jpa.metadata.tables.CollectionTableMetadata;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementCollectionAccessor
extends DirectCollectionAccessor
implements MappedKeyMapAccessor {
    private Class m_targetClass;
    private Class m_mapKeyClass;
    private Class m_referenceClass;
    private ColumnMetadata m_column;
    private ColumnMetadata m_mapKeyColumn;
    private ColumnMetadata m_orderColumn;
    private EnumeratedMetadata m_mapKeyEnumerated;
    private List<AssociationOverrideMetadata> m_associationOverrides;
    private List<AssociationOverrideMetadata> m_mapKeyAssociationOverrides;
    private List<AttributeOverrideMetadata> m_attributeOverrides;
    private List<AttributeOverrideMetadata> m_mapKeyAttributeOverrides;
    private List<JoinColumnMetadata> m_mapKeyJoinColumns;
    private String m_mapKey;
    private String m_mapKeyConvert;
    private String m_mapKeyClassName;
    private String m_targetClassName;
    private String m_orderBy;
    private TemporalMetadata m_mapKeyTemporal;

    public ElementCollectionAccessor() {
        super("<element-collection>");
    }

    public ElementCollectionAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        this.m_targetClass = (Class)MetadataHelper.invokeMethod("targetClass", annotation);
        this.m_attributeOverrides = new ArrayList<AttributeOverrideMetadata>();
        this.m_mapKeyAttributeOverrides = new ArrayList<AttributeOverrideMetadata>();
        if (this.isAnnotationPresent(AttributeOverrides.class)) {
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("value", this.getAnnotation(AttributeOverrides.class))) {
                this.addAttributeOverride(new AttributeOverrideMetadata(annotation2, metadataAccessibleObject));
            }
        }
        if (this.isAnnotationPresent(AttributeOverride.class)) {
            this.addAttributeOverride(new AttributeOverrideMetadata((Annotation)this.getAnnotation(AttributeOverride.class), metadataAccessibleObject));
        }
        this.m_associationOverrides = new ArrayList<AssociationOverrideMetadata>();
        this.m_mapKeyAssociationOverrides = new ArrayList<AssociationOverrideMetadata>();
        if (this.isAnnotationPresent(AssociationOverrides.class)) {
            for (Annotation annotation2 : (Annotation[])MetadataHelper.invokeMethod("value", this.getAnnotation(AssociationOverrides.class))) {
                this.addAssociationOverride(new AssociationOverrideMetadata(annotation2, metadataAccessibleObject));
            }
        }
        if (this.isAnnotationPresent(AssociationOverride.class)) {
            this.addAssociationOverride(new AssociationOverrideMetadata((Annotation)this.getAnnotation(AssociationOverride.class), metadataAccessibleObject));
        }
        if (this.isAnnotationPresent(Column.class)) {
            this.m_column = new ColumnMetadata((Annotation)this.getAnnotation(Column.class), metadataAccessibleObject, this.getAttributeName());
        }
        if (this.isAnnotationPresent(CollectionTable.class)) {
            this.setCollectionTable(new CollectionTableMetadata((Annotation)this.getAnnotation(CollectionTable.class), metadataAccessibleObject, true));
        }
        if (this.isAnnotationPresent(OrderBy.class)) {
            this.m_orderBy = (String)MetadataHelper.invokeMethod("value", this.getAnnotation(OrderBy.class));
        }
        if (this.isAnnotationPresent(MapKey.class)) {
            this.m_mapKey = (String)MetadataHelper.invokeMethod("name", this.getAnnotation(MapKey.class));
        }
        if (this.isAnnotationPresent(MapKeyClass.class)) {
            this.m_mapKeyClass = (Class)MetadataHelper.invokeMethod("value", this.getAnnotation(MapKeyClass.class));
        }
        if (this.isAnnotationPresent(MapKeyEnumerated.class)) {
            this.m_mapKeyEnumerated = new EnumeratedMetadata((Annotation)this.getAnnotation(MapKeyEnumerated.class), metadataAccessibleObject);
        }
        if (this.isAnnotationPresent(MapKeyTemporal.class)) {
            this.m_mapKeyTemporal = new TemporalMetadata((Annotation)this.getAnnotation(MapKeyTemporal.class), metadataAccessibleObject);
        }
        if (this.isAnnotationPresent(MapKeyColumn.class)) {
            this.m_mapKeyColumn = new ColumnMetadata((Annotation)this.getAnnotation(MapKeyColumn.class), metadataAccessibleObject, this.getAttributeName());
        }
        if (this.isAnnotationPresent(MapKeyConvert.class)) {
            this.m_mapKeyConvert = (String)MetadataHelper.invokeMethod("value", this.getAnnotation(MapKeyConvert.class));
        }
        if (this.isAnnotationPresent(OrderColumn.class)) {
            this.m_orderColumn = new ColumnMetadata((Annotation)this.getAnnotation(OrderColumn.class), metadataAccessibleObject, this.getAttributeName());
        }
    }

    protected void addAttributeOverride(AttributeOverrideMetadata attributeOverrideMetadata) {
        if (attributeOverrideMetadata.getName().startsWith("key.")) {
            attributeOverrideMetadata.setName(attributeOverrideMetadata.getName().substring("key.".length()));
            this.m_mapKeyAttributeOverrides.add(attributeOverrideMetadata);
        } else {
            if (attributeOverrideMetadata.getName().startsWith("value.")) {
                attributeOverrideMetadata.setName(attributeOverrideMetadata.getName().substring("value.".length()));
            }
            this.m_attributeOverrides.add(attributeOverrideMetadata);
        }
    }

    protected void addAssociationOverride(AssociationOverrideMetadata associationOverrideMetadata) {
        if (associationOverrideMetadata.getName().startsWith("key.")) {
            associationOverrideMetadata.setName(associationOverrideMetadata.getName().substring("key.".length()));
            this.m_mapKeyAssociationOverrides.add(associationOverrideMetadata);
        } else {
            if (associationOverrideMetadata.getName().startsWith("value.")) {
                associationOverrideMetadata.setName(associationOverrideMetadata.getName().substring("value.".length()));
            }
            this.m_associationOverrides.add(associationOverrideMetadata);
        }
    }

    public List<AssociationOverrideMetadata> getAssociationOverrides() {
        return this.m_associationOverrides;
    }

    public List<AttributeOverrideMetadata> getAttributeOverrides() {
        return this.m_attributeOverrides;
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    @Override
    protected ColumnMetadata getColumn(String string) {
        if (string.equals("metadata_default_value_column")) {
            return this.m_column == null ? super.getColumn(string) : this.m_column;
        }
        return this.m_mapKeyColumn == null ? super.getColumn(string) : this.m_mapKeyColumn;
    }

    public EmbeddableAccessor getEmbeddableAccessor() {
        return this.getProject().getEmbeddableAccessor(this.getReferenceClass());
    }

    @Override
    public EnumeratedMetadata getEnumerated(boolean bl) {
        if (bl) {
            return this.getMapKeyEnumerated();
        }
        return super.getEnumerated(bl);
    }

    @Override
    protected String getKeyConverter() {
        return this.m_mapKeyConvert;
    }

    @Override
    public String getMapKey() {
        return this.m_mapKey;
    }

    @Override
    public Class getMapKeyClass() {
        return this.m_mapKeyClass;
    }

    @Override
    public List<AssociationOverrideMetadata> getMapKeyAssociationOverrides() {
        return this.m_mapKeyAssociationOverrides;
    }

    @Override
    public List<AttributeOverrideMetadata> getMapKeyAttributeOverrides() {
        return this.m_mapKeyAttributeOverrides;
    }

    public String getMapKeyClassName() {
        return this.m_mapKeyClassName;
    }

    @Override
    public ColumnMetadata getMapKeyColumn() {
        return this.m_mapKeyColumn;
    }

    @Override
    public String getMapKeyConvert() {
        return this.m_mapKeyConvert;
    }

    public EnumeratedMetadata getMapKeyEnumerated() {
        return this.m_mapKeyEnumerated;
    }

    @Override
    public List<JoinColumnMetadata> getMapKeyJoinColumns() {
        return this.m_mapKeyJoinColumns;
    }

    public TemporalMetadata getMapKeyTemporal() {
        return this.m_mapKeyTemporal;
    }

    public String getOrderBy() {
        return this.m_orderBy;
    }

    public ColumnMetadata getOrderColumn() {
        return this.m_orderColumn;
    }

    @Override
    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetClass();
            if (this.m_referenceClass == Void.TYPE) {
                this.m_referenceClass = this.getReferenceClassFromGeneric();
                if (this.m_referenceClass == null) {
                    throw ValidationException.unableToDetermineTargetClass(this.getAttributeName(), this.getJavaClass());
                }
                MetadataLogger metadataLogger = this.getLogger();
                this.getLogger();
                metadataLogger.logConfigMessage("metadata_default_element_collection_reference_class", this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    @Override
    public MetadataDescriptor getReferenceDescriptor() {
        if (this.isDirectEmbeddableCollection()) {
            return this.getEmbeddableAccessor().getDescriptor();
        }
        return super.getReferenceDescriptor();
    }

    protected Class getTargetClass() {
        return this.m_targetClass;
    }

    protected String getTargetClassName() {
        return this.m_targetClassName;
    }

    @Override
    public TemporalMetadata getTemporal(boolean bl) {
        if (bl) {
            return this.getMapKeyTemporal();
        }
        return super.getTemporal(bl);
    }

    @Override
    protected boolean hasConvert(boolean bl) {
        if (bl) {
            return this.m_mapKeyConvert != null;
        }
        return super.hasConvert(bl);
    }

    @Override
    public boolean hasEnumerated(boolean bl) {
        if (bl) {
            return this.m_mapKeyEnumerated != null;
        }
        return super.hasEnumerated(bl);
    }

    @Override
    public boolean hasLob(boolean bl) {
        if (bl) {
            return false;
        }
        return super.hasLob(bl);
    }

    @Override
    protected boolean hasMapKeyClass() {
        return this.m_mapKeyClass != null && !this.m_mapKeyClass.equals(Void.TYPE);
    }

    @Override
    public boolean hasTemporal(boolean bl) {
        if (bl) {
            return this.m_mapKeyTemporal != null;
        }
        return super.hasTemporal(bl);
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_attributeOverrides, metadataAccessibleObject);
        this.initXMLObjects(this.m_associationOverrides, metadataAccessibleObject);
        this.initXMLObjects(this.m_mapKeyAssociationOverrides, metadataAccessibleObject);
        this.initXMLObjects(this.m_mapKeyAttributeOverrides, metadataAccessibleObject);
        this.initXMLObject(this.m_column, metadataAccessibleObject);
        this.initXMLObject(this.m_mapKeyColumn, metadataAccessibleObject);
        this.initXMLObject(this.m_orderColumn, metadataAccessibleObject);
        this.m_targetClass = this.initXMLClassName(this.m_targetClassName);
        this.m_mapKeyClass = this.initXMLClassName(this.m_mapKeyClassName);
    }

    @Override
    public boolean isDirectEmbeddableCollection() {
        return this.getEmbeddableAccessor() != null;
    }

    @Override
    public boolean isMappedKeyMapAccessor() {
        return this.isMapAccessor();
    }

    @Override
    public void process() {
        if (this.isDirectEmbeddableCollection()) {
            this.processDirectEmbeddableCollectionMapping(this.getReferenceDescriptor());
        } else if (this.isValidDirectCollectionType()) {
            this.processDirectCollectionMapping();
        } else if (this.isValidDirectMapType()) {
            this.processDirectMapMapping();
        } else {
            throw ValidationException.invalidTargetClass(this.getAttributeName(), this.getJavaClass());
        }
    }

    @Override
    protected void processCollectionTable(CollectionMapping collectionMapping) {
        super.processCollectionTable(collectionMapping);
        for (JoinColumnMetadata joinColumnMetadata : this.getJoinColumns(this.getCollectionTable().getJoinColumns(), this.getReferenceDescriptor())) {
            DatabaseField databaseField = joinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_pk_column"));
            databaseField.setTable(this.getDescriptor().getPrimaryTable());
            DatabaseField databaseField2 = joinColumnMetadata.getForeignKeyField();
            databaseField2.setName(this.getName(databaseField2, this.getDescriptor().getAlias() + "_" + this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column"));
            databaseField2.setTable(this.getReferenceDatabaseTable());
            if (collectionMapping.isDirectCollectionMapping()) {
                ((DirectCollectionMapping)collectionMapping).addReferenceKeyField(databaseField2, databaseField);
                continue;
            }
            ((AggregateCollectionMapping)collectionMapping).addTargetForeignKeyField(databaseField2, databaseField);
        }
    }

    protected void processDirectEmbeddableCollectionMapping(MetadataDescriptor metadataDescriptor) {
        AggregateCollectionMapping aggregateCollectionMapping = new AggregateCollectionMapping();
        this.process(aggregateCollectionMapping);
        aggregateCollectionMapping.setReferenceClassName(this.getReferenceClassName());
        this.processContainerPolicyAndIndirection(aggregateCollectionMapping);
        metadataDescriptor.setIsEmbeddableCollection();
        this.processMappingsFromEmbeddable(metadataDescriptor, null, aggregateCollectionMapping, this.getAttributeOverrides(this.m_attributeOverrides), this.getAssociationOverrides(this.m_associationOverrides), "");
    }

    protected void processMappingsFromEmbeddable(MetadataDescriptor metadataDescriptor, AggregateObjectMapping aggregateObjectMapping, EmbeddableMapping embeddableMapping, Map<String, AttributeOverrideMetadata> map, Map<String, AssociationOverrideMetadata> map2, String string) {
        for (MappingAccessor mappingAccessor : metadataDescriptor.getAccessors()) {
            Object object;
            Object object2;
            String string2;
            if (!mappingAccessor.isProcessed()) {
                mappingAccessor.process();
            }
            DatabaseMapping databaseMapping = mappingAccessor.getMapping();
            String string3 = string2 = string.equals("") ? databaseMapping.getAttributeName() : string + "." + databaseMapping.getAttributeName();
            if (databaseMapping.isDirectToFieldMapping()) {
                object2 = (DirectToFieldMapping)databaseMapping;
                if (map.containsKey(string2)) {
                    object = map.get(string2).getOverrideField();
                } else {
                    object = (DatabaseField)((AbstractDirectMapping)object2).getField().clone();
                    if (aggregateObjectMapping != null && aggregateObjectMapping.getAggregateToSourceFieldNames().containsKey(((DatabaseField)object).getName())) {
                        object = new DatabaseField(aggregateObjectMapping.getAggregateToSourceFieldNames().get(((DatabaseField)object).getName()));
                    }
                }
                if (!((DatabaseField)object).hasTableName()) {
                    ((DatabaseField)object).setTable(this.getReferenceDatabaseTable());
                }
                this.addFieldNameTranslation(embeddableMapping, string2, (DatabaseField)object, databaseMapping);
                continue;
            }
            if (databaseMapping.isOneToOneMapping()) {
                object2 = (OneToOneMapping)databaseMapping;
                if (((ObjectReferenceMapping)object2).isForeignKeyRelationship()) {
                    object = map2.get(string2);
                    if (object == null) {
                        for (DatabaseField databaseField : ((ObjectReferenceMapping)object2).getForeignKeyFields()) {
                            DatabaseField databaseField2 = (DatabaseField)databaseField.clone();
                            databaseField2.setTable(this.getReferenceDatabaseTable());
                            embeddableMapping.addFieldNameTranslation(databaseField2.getQualifiedName(), databaseField.getName());
                        }
                        continue;
                    }
                    this.processAssociationOverride((AssociationOverrideMetadata)object, embeddableMapping, databaseMapping, this.getReferenceDatabaseTable(), metadataDescriptor);
                    continue;
                }
                throw ValidationException.invalidEmbeddableClassForElementCollection(metadataDescriptor.getJavaClass(), this.getAttributeName(), this.getJavaClass(), databaseMapping.getAttributeName());
            }
            if (databaseMapping.isAggregateObjectMapping()) {
                object2 = metadataDescriptor.getAccessorFor(databaseMapping.getAttributeName());
                this.processMappingsFromEmbeddable(((MappingAccessor)object2).getReferenceDescriptor(), (AggregateObjectMapping)databaseMapping, embeddableMapping, map, map2, string2);
                continue;
            }
            throw ValidationException.invalidEmbeddableClassForElementCollection(metadataDescriptor.getJavaClass(), this.getAttributeName(), this.getJavaClass(), databaseMapping.getAttributeName());
        }
    }

    public void setAssociationOverrides(List<AssociationOverrideMetadata> list) {
        this.m_associationOverrides = list;
    }

    public void setAttributeOverrides(List<AttributeOverrideMetadata> list) {
        this.m_attributeOverrides = list;
    }

    public void setColumn(ColumnMetadata columnMetadata) {
        this.m_column = columnMetadata;
    }

    public String setMapKey(String string) {
        return this.m_mapKey;
    }

    public void setMapKeyAssociationOverrides(List<AssociationOverrideMetadata> list) {
        this.m_mapKeyAssociationOverrides = list;
    }

    public void setMapKeyAttributeOverrides(List<AttributeOverrideMetadata> list) {
        this.m_mapKeyAttributeOverrides = list;
    }

    @Override
    public void setMapKeyClass(Class clazz) {
        this.m_mapKeyClass = clazz;
    }

    public void setMapKeyClassName(String string) {
        this.m_mapKeyClassName = string;
    }

    public void setMapKeyColumn(ColumnMetadata columnMetadata) {
        this.m_mapKeyColumn = columnMetadata;
    }

    public void setMapKeyConvert(String string) {
        this.m_mapKeyConvert = string;
    }

    public void setMapKeyEnumerated(EnumeratedMetadata enumeratedMetadata) {
        this.m_mapKeyEnumerated = enumeratedMetadata;
    }

    public void setMapKeyJoinColumns(List<JoinColumnMetadata> list) {
        this.m_mapKeyJoinColumns = list;
    }

    public void setMapKeyTemporal(TemporalMetadata temporalMetadata) {
        this.m_mapKeyTemporal = temporalMetadata;
    }

    public void setOrderBy(String string) {
        this.m_orderBy = string;
    }

    public void setOrderColumn(ColumnMetadata columnMetadata) {
        this.m_orderColumn = columnMetadata;
    }

    public void setTargetClassName(String string) {
        this.m_targetClassName = string;
    }
}

