/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ObjectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.mappings.OneToOneMapping;

public class OneToOneAccessor
extends ObjectAccessor {
    private String m_mappedBy;

    public OneToOneAccessor() {
        super("<one-to-one>");
    }

    public OneToOneAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        if (annotation != null) {
            this.m_mappedBy = (String)MetadataHelper.invokeMethod("mappedBy", annotation);
            this.setOrphanRemoval((Boolean)MetadataHelper.invokeMethod("orphanRemoval", annotation));
        }
    }

    protected String getLoggingContext() {
        return "metadata_default_one_to_one_reference_class";
    }

    public String getMappedBy() {
        return this.m_mappedBy;
    }

    protected boolean hasMappedBy() {
        return this.m_mappedBy != null && !this.m_mappedBy.equals("");
    }

    public boolean isOneToOne() {
        return true;
    }

    public void process() {
        OneToOneMapping oneToOneMapping = this.initOneToOneMapping();
        this.setMapping(oneToOneMapping);
        if (this.hasMappedBy()) {
            Map<DatabaseField, DatabaseField> map;
            Map<DatabaseField, DatabaseField> map2;
            OneToOneMapping oneToOneMapping2 = null;
            if (!this.getOwningMapping(this.m_mappedBy).isOneToOneMapping()) {
                throw ValidationException.invalidMapping(this.getJavaClass(), this.getReferenceClass());
            }
            oneToOneMapping2 = (OneToOneMapping)this.getOwningMapping(this.m_mappedBy);
            if (this.getDescriptor().usesTablePerClassInheritanceStrategy()) {
                map2 = new HashMap<DatabaseField, DatabaseField>();
                map = new HashMap<DatabaseField, DatabaseField>();
                for (DatabaseField databaseField : oneToOneMapping2.getSourceToTargetKeyFields().keySet()) {
                    DatabaseField databaseField2 = (DatabaseField)oneToOneMapping2.getSourceToTargetKeyFields().get(databaseField).clone();
                    databaseField2.setTable(this.getDescriptor().getPrimaryTable());
                    map.put(databaseField, databaseField2);
                    map2.put(databaseField2, databaseField);
                }
            } else {
                map2 = oneToOneMapping2.getTargetToSourceKeyFields();
                map = oneToOneMapping2.getSourceToTargetKeyFields();
            }
            oneToOneMapping.setSourceToTargetKeyFields(map2);
            oneToOneMapping.setTargetToSourceKeyFields(map);
        } else {
            this.processOwningMappingKeys(oneToOneMapping);
        }
    }

    public void setMappedBy(String string) {
        this.m_mappedBy = string;
    }
}

