/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import javax.persistence.EnumType;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.EnumTypeConverter;

public class EnumeratedMetadata
extends MetadataConverter {
    private Enum m_enumerated;

    public EnumeratedMetadata() {
        this.m_enumerated = EnumType.ORDINAL;
    }

    public EnumeratedMetadata(String string) {
        super(string);
    }

    public EnumeratedMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_enumerated = (Enum)MetadataHelper.invokeMethod("value", annotation);
    }

    public Enum getEnumerated() {
        return this.m_enumerated;
    }

    public static boolean isValidEnumeratedType(Class clazz) {
        return clazz.isEnum();
    }

    public void process(DatabaseMapping databaseMapping, MappingAccessor mappingAccessor, Class clazz, boolean bl) {
        if (!EnumeratedMetadata.isValidEnumeratedType(clazz)) {
            throw ValidationException.invalidTypeForEnumeratedAttribute(databaseMapping.getAttributeName(), clazz, mappingAccessor.getJavaClass());
        }
        this.setConverter(databaseMapping, new EnumTypeConverter(databaseMapping, clazz, this.m_enumerated.name().equals(EnumType.ORDINAL.name())), bl);
    }

    public void setEnumerated(Enum enum_) {
        this.m_enumerated = enum_;
    }
}

