/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.TemporalType;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataConverter;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;

public class TemporalMetadata
extends MetadataConverter {
    private Enum m_temporal;

    public TemporalMetadata() {
        super("<temporal>");
    }

    public TemporalMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_temporal = (Enum)MetadataHelper.invokeMethod("value", annotation);
    }

    public Enum getTemporal() {
        return this.m_temporal;
    }

    public static boolean isValidTemporalType(Class clazz) {
        return clazz.equals(Date.class) || clazz.equals(Calendar.class) || clazz.equals(GregorianCalendar.class);
    }

    public void process(DatabaseMapping databaseMapping, MappingAccessor mappingAccessor, Class clazz, boolean bl) {
        if (TemporalMetadata.isValidTemporalType(clazz)) {
            if (this.m_temporal.name().equals(TemporalType.DATE.name())) {
                this.setFieldClassification(databaseMapping, java.sql.Date.class, bl);
            } else if (this.m_temporal.name().equals(TemporalType.TIME.name())) {
                this.setFieldClassification(databaseMapping, Time.class, bl);
            } else {
                this.setFieldClassification(databaseMapping, Timestamp.class, bl);
            }
        } else {
            throw ValidationException.invalidTypeForTemporalAttribute(mappingAccessor.getAttributeName(), clazz, mappingAccessor.getJavaClass());
        }
        this.setConverter(databaseMapping, new TypeConversionConverter(databaseMapping), bl);
    }

    public void setTemporal(Enum enum_) {
        this.m_temporal = enum_;
    }
}

