/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.listeners;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;

public class EntityListener
extends DescriptorEventAdapter {
    public static final String POST_BUILD = "postBuild";
    public static final String POST_CLONE = "postClone";
    public static final String POST_DELETE = "postDelete";
    public static final String POST_INSERT = "postInsert";
    public static final String POST_REFRESH = "postRefresh";
    public static final String POST_UPDATE = "postUpdate";
    public static final String PRE_PERSIST = "prePersist";
    public static final String PRE_REMOVE = "preRemove";
    public static final String PRE_UPDATE_WITH_CHANGES = "preUpdateWithChanges";
    private Object m_listener;
    private Class m_entityClass;
    private Hashtable<String, Method> m_methods;
    private Hashtable<Integer, Boolean> m_overriddenEvents;
    private static Hashtable<Integer, String> m_eventStrings;

    protected EntityListener(Class clazz) {
        this.m_entityClass = clazz;
        this.m_methods = new Hashtable();
        this.m_overriddenEvents = new Hashtable();
        if (m_eventStrings == null) {
            m_eventStrings = new Hashtable();
            m_eventStrings.put(new Integer(8), POST_BUILD);
            m_eventStrings.put(new Integer(10), POST_CLONE);
            m_eventStrings.put(new Integer(3), POST_DELETE);
            m_eventStrings.put(new Integer(5), POST_INSERT);
            m_eventStrings.put(new Integer(9), POST_REFRESH);
            m_eventStrings.put(new Integer(7), POST_UPDATE);
            m_eventStrings.put(new Integer(15), PRE_PERSIST);
            m_eventStrings.put(new Integer(16), PRE_REMOVE);
            m_eventStrings.put(new Integer(17), PRE_UPDATE_WITH_CHANGES);
        }
    }

    public EntityListener(Class clazz, Class clazz2) {
        block6: {
            this(clazz2);
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.m_listener = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                        break block6;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.errorInstantiatingClass(clazz, privilegedActionException.getException());
                    }
                }
                this.m_listener = PrivilegedAccessHelper.newInstanceFromClass(clazz);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ValidationException.errorInstantiatingClass(clazz, illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw ValidationException.errorInstantiatingClass(clazz, instantiationException);
            }
        }
    }

    public void addEventMethod(String string, Method method) {
        if (this.m_methods.containsKey(string)) {
            Method method2 = (Method)this.getMethods().get(string);
            if (!method2.getName().equals(method.getName())) {
                throw ValidationException.multipleLifecycleCallbackMethodsForSameLifecycleEvent(this.getListenerClass(), method, this.getEventMethod(string));
            }
        } else {
            this.validateMethod(method);
            this.m_methods.put(string, method);
        }
    }

    public Class getEntityClass() {
        return this.m_entityClass;
    }

    protected Method getEventMethod(int n) {
        String string = m_eventStrings.get(n);
        if (string != null) {
            return this.getEventMethod(string);
        }
        return null;
    }

    protected Method getEventMethod(String string) {
        return this.m_methods.get(string);
    }

    protected String getEventMethodName(String string) {
        Method method = this.getEventMethod(string);
        if (method != null) {
            return method.getName();
        }
        return null;
    }

    public Class getListenerClass() {
        return this.m_listener.getClass();
    }

    public Hashtable getMethods() {
        return this.m_methods;
    }

    public String getPostBuildMethodName() {
        return this.getEventMethodName(POST_BUILD);
    }

    public String getPostCloneMethodName() {
        return this.getEventMethodName(POST_CLONE);
    }

    public String getPostDeleteMethodName() {
        return this.getEventMethodName(POST_DELETE);
    }

    public String getPostInsertMethodName() {
        return this.getEventMethodName(POST_INSERT);
    }

    public String getPostRefreshMethodName() {
        return this.getEventMethodName(POST_REFRESH);
    }

    public String getPostUpdateMethodName() {
        return this.getEventMethodName(POST_UPDATE);
    }

    public String getPrePersistMethodName() {
        return this.getEventMethodName(PRE_PERSIST);
    }

    public String getPreRemoveMethodName() {
        return this.getEventMethodName(PRE_REMOVE);
    }

    public String getPreUpdateWithChangesMethodName() {
        return this.getEventMethodName(PRE_UPDATE_WITH_CHANGES);
    }

    public boolean hasCallbackMethods() {
        return this.m_methods.size() > 0;
    }

    public boolean hasOverriddenEventMethod(Method method, int n) {
        return this.hasOverriddenEventMethod(this.getEventMethod(n), method);
    }

    protected boolean hasOverriddenEventMethod(Method method, Method method2) {
        return method != null && method.getName().equals(method2.getName());
    }

    public boolean hasOverriddenEventMethod(Method method, String string) {
        return this.hasOverriddenEventMethod(this.getEventMethod(string), method);
    }

    protected void invokeMethod(Method method, Object object, Object[] objectArray, DescriptorEvent descriptorEvent) {
        block10: {
            if (method != null) {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            AccessController.doPrivileged(new PrivilegedMethodInvoker(method, object, objectArray));
                            break block10;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            Exception exception = privilegedActionException.getException();
                            if (exception instanceof IllegalAccessException) {
                                throw ValidationException.invalidCallbackMethod(object.getClass(), method.toString());
                            }
                            Throwable throwable = exception.getCause();
                            if (throwable instanceof RuntimeException) {
                                throw (RuntimeException)throwable;
                            }
                            throw (Error)throwable;
                        }
                    }
                    PrivilegedAccessHelper.invokeMethod(method, object, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw ValidationException.invalidCallbackMethod(object.getClass(), method.toString());
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getCause();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw (Error)throwable;
                }
            }
        }
    }

    protected void invokeMethod(String string, DescriptorEvent descriptorEvent) {
        Object[] objectArray = new Object[]{descriptorEvent.getSource()};
        this.invokeMethod(this.getEventMethod(string), this.m_listener, objectArray, descriptorEvent);
    }

    public boolean isOverriddenEvent(DescriptorEvent descriptorEvent, Vector vector) {
        int n = descriptorEvent.getEventCode();
        if (!this.m_overriddenEvents.containsKey(n)) {
            this.m_overriddenEvents.put(n, false);
            Method method = this.getEventMethod(n);
            if (method != null) {
                DescriptorEventManager descriptorEventManager;
                EntityListener entityListener;
                Iterator iterator = vector.iterator();
                while (iterator.hasNext() && (entityListener = (EntityListener)(descriptorEventManager = (DescriptorEventManager)iterator.next()).getEntityEventListener()) != this) {
                    if (!entityListener.hasOverriddenEventMethod(method, n)) continue;
                    this.m_overriddenEvents.put(n, true);
                    break;
                }
            }
        }
        return this.m_overriddenEvents.get(n);
    }

    public void postBuild(DescriptorEvent descriptorEvent) {
        this.invokeMethod(POST_BUILD, descriptorEvent);
    }

    public void postClone(DescriptorEvent descriptorEvent) {
        this.invokeMethod(POST_CLONE, descriptorEvent);
    }

    public void postDelete(DescriptorEvent descriptorEvent) {
        this.invokeMethod(POST_DELETE, descriptorEvent);
    }

    public void postInsert(DescriptorEvent descriptorEvent) {
        this.invokeMethod(POST_INSERT, descriptorEvent);
    }

    public void postRefresh(DescriptorEvent descriptorEvent) {
        this.invokeMethod(POST_REFRESH, descriptorEvent);
    }

    public void postUpdate(DescriptorEvent descriptorEvent) {
        this.invokeMethod(POST_UPDATE, descriptorEvent);
    }

    public void prePersist(DescriptorEvent descriptorEvent) {
        this.invokeMethod(PRE_PERSIST, descriptorEvent);
    }

    public void preRemove(DescriptorEvent descriptorEvent) {
        this.invokeMethod(PRE_REMOVE, descriptorEvent);
    }

    public void preUpdateWithChanges(DescriptorEvent descriptorEvent) {
        this.invokeMethod(PRE_UPDATE_WITH_CHANGES, descriptorEvent);
    }

    public void setPostBuildMethod(Method method) {
        this.addEventMethod(POST_BUILD, method);
    }

    public void setPostCloneMethod(Method method) {
        this.addEventMethod(POST_CLONE, method);
    }

    public void setPostDeleteMethod(Method method) {
        this.addEventMethod(POST_DELETE, method);
    }

    public void setPostInsertMethod(Method method) {
        this.addEventMethod(POST_INSERT, method);
    }

    public void setPostRefreshMethod(Method method) {
        this.addEventMethod(POST_REFRESH, method);
    }

    public void setPostUpdateMethod(Method method) {
        this.addEventMethod(POST_UPDATE, method);
    }

    public void setPrePersistMethod(Method method) {
        this.addEventMethod(PRE_PERSIST, method);
    }

    public void setPreRemoveMethod(Method method) {
        this.addEventMethod(PRE_REMOVE, method);
    }

    public void setPreUpdateWithChangesMethod(Method method) {
        this.addEventMethod(PRE_UPDATE_WITH_CHANGES, method);
    }

    protected void validateMethod(Method method) {
        int n = method.getParameterTypes().length;
        if (n != 1 || !method.getParameterTypes()[0].isAssignableFrom(this.m_entityClass)) {
            Class<?> clazz = n == 0 ? null : method.getParameterTypes()[0];
            throw ValidationException.invalidEntityListenerCallbackMethodArguments(this.m_entityClass, clazz, this.m_listener.getClass(), method.getName());
        }
        this.validateMethodModifiers(method);
    }

    protected void validateMethodModifiers(Method method) {
        int n = method.getModifiers();
        if (Modifier.isStatic(n) || Modifier.isFinal(n)) {
            throw ValidationException.invalidCallbackMethodModifier(this.getListenerClass(), method.getName());
        }
    }
}

