/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

final class MetadataHelper {
    MetadataHelper() {
    }

    static Class getClassForName(String string, ClassLoader classLoader) {
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return (Class)AccessController.doPrivileged(new PrivilegedClassForName(string, true, classLoader));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw ValidationException.unableToLoadClass(string, privilegedActionException.getException());
                }
            }
            return PrivilegedAccessHelper.getClassForName(string, true, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ValidationException.unableToLoadClass(string, classNotFoundException);
        }
    }

    static Object invokeMethod(String string, Object object) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(object.getClass(), string);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, object));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        Exception exception = privilegedActionException.getException();
                        if (exception instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject(method, object);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed(method, object, exception);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(method, object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject(method, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw EntityManagerSetupException.methodInvocationFailed(method, object, invocationTargetException);
            }
        }
        return null;
    }
}

