/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.transformers;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.transformers.MetadataHelper;
import org.eclipse.persistence.mappings.TransformationMapping;

public class ReadTransformerMetadata
extends ORMetadata {
    private Class m_transformerClass;
    private String m_transformerClassName;
    private String m_method;

    public ReadTransformerMetadata() {
        super("<read-transformer>");
    }

    protected ReadTransformerMetadata(String string) {
        super(string);
    }

    public ReadTransformerMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        if (annotation != null) {
            this.m_transformerClass = (Class)MetadataHelper.invokeMethod("transformerClass", annotation);
            this.m_method = (String)MetadataHelper.invokeMethod("method", annotation);
        }
    }

    public String getMethod() {
        return this.m_method;
    }

    public Class getTransformerClass() {
        return this.m_transformerClass;
    }

    public String getTransformerClassName() {
        return this.m_transformerClassName;
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.m_transformerClass = this.initXMLClassName(this.m_transformerClassName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(TransformationMapping transformationMapping, String string) {
        if (this.m_method == null || this.m_method.equals("")) {
            if (this.m_transformerClass.equals(Void.TYPE)) {
                throw ValidationException.readTransformerHasNeitherClassNorMethod(string);
            }
            if (!MetadataHelper.classImplementsInterface(this.m_transformerClass, "org.eclipse.persistence.mappings.transformers.AttributeTransformer")) throw ValidationException.readTransformerClassDoesntImplementAttributeTransformer(string);
            transformationMapping.setAttributeTransformerClassName(this.m_transformerClass.getName());
            return;
        } else {
            if (!this.m_transformerClass.equals(Void.TYPE)) throw ValidationException.readTransformerHasBothClassAndMethod(string);
            transformationMapping.setAttributeTransformation(this.m_method);
        }
    }

    public void setMethod(String string) {
        this.m_method = string;
    }

    public void setTransformerClass(Class clazz) {
        this.m_transformerClass = clazz;
    }

    public void setTransformerClassName(String string) {
        this.m_transformerClassName = string;
    }
}

