/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.transformers;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.ColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.transformers.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.transformers.ReadTransformerMetadata;
import org.eclipse.persistence.mappings.TransformationMapping;

public class WriteTransformerMetadata
extends ReadTransformerMetadata {
    private ColumnMetadata m_column;

    public WriteTransformerMetadata() {
        super("<write-transformer>");
    }

    public WriteTransformerMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.m_column = new ColumnMetadata((Annotation)MetadataHelper.invokeMethod("column", annotation), metadataAccessibleObject);
    }

    public ColumnMetadata getColumn() {
        return this.m_column;
    }

    public boolean hasFieldName() {
        return this.m_column != null && this.m_column.getName() != null && this.m_column.getName().length() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void process(TransformationMapping transformationMapping, String string) {
        if (!this.hasFieldName()) throw ValidationException.writeTransformerHasNoColumnName(string);
        if (this.getMethod() == null || this.getMethod().equals("")) {
            if (this.getTransformerClass().equals(Void.TYPE)) {
                throw ValidationException.writeTransformerHasNeitherClassNorMethod(string, this.m_column.getName());
            }
            if (!MetadataHelper.classImplementsInterface(this.getTransformerClass(), "org.eclipse.persistence.mappings.transformers.FieldTransformer")) throw ValidationException.writeTransformerClassDoesntImplementFieldTransformer(string, this.m_column.getName());
            transformationMapping.addFieldTransformerClassName(this.m_column.getDatabaseField(), this.getTransformerClass().getName());
            return;
        } else {
            if (!this.getTransformerClass().equals(Void.TYPE)) throw ValidationException.writeTransformerHasBothClassAndMethod(string, this.m_column.getName());
            transformationMapping.addFieldTransformation(this.m_column.getDatabaseField(), this.getMethod());
        }
    }

    public void setColumn(ColumnMetadata columnMetadata) {
        this.m_column = columnMetadata;
    }

    public void setFieldName(String string) {
        if (this.m_column == null) {
            this.m_column = new ColumnMetadata();
        }
        this.m_column.setName(string);
    }
}

