/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.exceptions.JPQLException;
import org.eclipse.persistence.internal.jpa.parsing.AttributeNode;
import org.eclipse.persistence.internal.jpa.parsing.IdentificationVariableDeclNode;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.internal.jpa.parsing.VariableNode;

public class JoinDeclNode
extends IdentificationVariableDeclNode {
    private Node path;
    private boolean outerJoin;

    public Node getPath() {
        return this.path;
    }

    public void setPath(Node node) {
        this.path = node;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean bl) {
        this.outerJoin = bl;
    }

    public Node qualifyAttributeAccess(ParseTreeContext parseTreeContext) {
        if (this.path != null) {
            this.path = this.path.qualifyAttributeAccess(parseTreeContext);
        }
        return this;
    }

    public void validate(ParseTreeContext parseTreeContext) {
        super.validate(parseTreeContext);
        if (this.path != null) {
            this.path.validate(parseTreeContext);
            this.setType(this.path.getType());
            if (this.path.isDotNode()) {
                TypeHelper typeHelper = parseTreeContext.getTypeHelper();
                VariableNode variableNode = (VariableNode)this.path.getLeft();
                AttributeNode attributeNode = (AttributeNode)this.path.getRight();
                if (variableNode != null && attributeNode != null && typeHelper.isEmbeddedAttribute(variableNode.getType(), attributeNode.getAttributeName())) {
                    throw JPQLException.unsupportJoinArgument(parseTreeContext.getQueryInfo(), this.getLine(), this.getColumn(), "Join", this.getType().toString());
                }
            }
        }
    }
}

