/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.AggregateNode;
import org.eclipse.persistence.internal.jpa.parsing.DotNode;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;

public class SumNode
extends AggregateNode {
    public void applyToQuery(ObjectLevelReadQuery objectLevelReadQuery, GenerationContext generationContext) {
        if (objectLevelReadQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)objectLevelReadQuery;
            reportQuery.addAttribute(this.resolveAttribute(), this.generateExpression(generationContext), this.calculateReturnType(generationContext));
        }
    }

    public void validate(ParseTreeContext parseTreeContext) {
        if (this.left != null) {
            this.left.validate(parseTreeContext);
            TypeHelper typeHelper = parseTreeContext.getTypeHelper();
            this.setType(this.calculateReturnType(this.left.getType(), typeHelper));
        }
    }

    protected Expression addAggregateExression(Expression expression) {
        return expression.sum();
    }

    protected Class calculateReturnType(GenerationContext generationContext) {
        Class clazz = null;
        if (this.getLeft().isDotNode()) {
            DotNode dotNode = (DotNode)this.getLeft();
            Class clazz2 = dotNode.getTypeOfDirectToField(generationContext);
            TypeHelper typeHelper = generationContext.getParseTreeContext().getTypeHelper();
            clazz = (Class)this.calculateReturnType(clazz2, typeHelper);
        }
        return clazz;
    }

    protected Object calculateReturnType(Object object, TypeHelper typeHelper) {
        Object object2 = null;
        if (typeHelper.isIntegralType(object)) {
            object2 = typeHelper.getLongClassType();
        } else if (typeHelper.isFloatingPointType(object)) {
            object2 = typeHelper.getDoubleClassType();
        } else if (typeHelper.isBigIntegerType(object)) {
            object2 = typeHelper.getBigIntegerType();
        } else if (typeHelper.isBigDecimalType(object)) {
            object2 = typeHelper.getBigDecimalType();
        }
        return object2;
    }

    public String getAsString() {
        return "SUM(" + this.left.getAsString() + ")";
    }
}

