/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnionField;
import org.eclipse.persistence.oxm.record.MarshalRecord;

public abstract class MappingNodeValue
extends NodeValue {
    public abstract DatabaseMapping getMapping();

    public boolean isMappingNodeValue() {
        return true;
    }

    protected String getValueToWrite(QName qName, Object object, XMLConversionManager xMLConversionManager, NamespaceResolver namespaceResolver) {
        if (qName != null && XMLConstants.QNAME_QNAME.equals(qName)) {
            return this.getStringForQName((QName)object, namespaceResolver);
        }
        return (String)xMLConversionManager.convertObject(object, ClassConstants.STRING, qName);
    }

    protected QName getSchemaType(XMLField xMLField, Object object, AbstractSession abstractSession) {
        QName qName = null;
        if (xMLField.getLeafElementType() != null) {
            qName = xMLField.getLeafElementType();
        } else if (xMLField.isTypedTextField()) {
            qName = xMLField.getXMLType(object.getClass());
        } else {
            if (xMLField.isUnionField()) {
                return this.getSingleValueToWriteForUnion((XMLUnionField)xMLField, object, abstractSession);
            }
            if (xMLField.getSchemaType() != null) {
                qName = xMLField.getSchemaType();
            }
        }
        return qName;
    }

    protected QName getSingleValueToWriteForUnion(XMLUnionField xMLUnionField, Object object, AbstractSession abstractSession) {
        ArrayList arrayList = xMLUnionField.getSchemaTypes();
        QName qName = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            QName qName2 = (QName)xMLUnionField.getSchemaTypes().get(i);
            try {
                if (qName2 == null) continue;
                Class clazz = xMLUnionField.getJavaClass(qName2);
                object = ((XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager()).convertObject(object, clazz, qName2);
                qName = qName2;
                break;
            }
            catch (ConversionException conversionException) {
                if (i != arrayList.size() - 1) continue;
                qName = qName2;
            }
        }
        return qName;
    }

    protected String getStringForQName(QName qName, NamespaceResolver namespaceResolver) {
        if (null == qName) {
            return null;
        }
        if (null == qName.getNamespaceURI()) {
            return qName.getLocalPart();
        }
        String string = qName.getNamespaceURI();
        if (namespaceResolver == null) {
            throw XMLMarshalException.namespaceResolverNotSpecified(string);
        }
        String string2 = namespaceResolver.resolveNamespaceURI(string);
        if (null == string2) {
            return qName.getLocalPart();
        }
        return string2 + ':' + qName.getLocalPart();
    }

    protected void updateNamespaces(QName qName, MarshalRecord marshalRecord) {
        if (qName != null && !qName.equals(XMLConstants.STRING_QNAME)) {
            String string = marshalRecord.getNamespaceResolver().resolveNamespaceURI(qName.getNamespaceURI());
            if (string == null || string.equals("")) {
                string = marshalRecord.getNamespaceResolver().generatePrefix();
                marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + string, qName.getNamespaceURI());
            }
            String string2 = string + ":" + qName.getLocalPart();
            this.addTypeAttribute(marshalRecord, string2);
        }
    }

    protected void addTypeAttribute(MarshalRecord marshalRecord, String string) {
        String string2 = null;
        if (marshalRecord.getNamespaceResolver() != null) {
            string2 = marshalRecord.getNamespaceResolver().resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
        } else {
            string2 = "xsi";
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (string2 == null) {
            string2 = marshalRecord.getNamespaceResolver().generatePrefix("xsi");
            marshalRecord.attribute("http://www.w3.org/2000/xmlns/", "http://www.w3.org/2000/xmlns/", "xmlns:" + string2, "http://www.w3.org/2001/XMLSchema-instance");
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", string2 + ":" + "type", string);
    }
}

