/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XMLAnyAttributeMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.record.MarshalRecord;

public class XPathNode {
    private NodeValue unmarshalNodeValue;
    private NodeValue marshalNodeValue;
    private XPathFragment xPathFragment;
    private XPathNode parent;
    private List attributeChildren;
    private List nonAttributeChildren;
    private List selfChildren;
    private Map attributeChildrenMap;
    private Map nonAttributeChildrenMap;
    private XMLAnyAttributeMappingNodeValue anyAttributeNodeValue;
    private XPathNode anyAttributeNode;

    public XPathFragment getXPathFragment() {
        return this.xPathFragment;
    }

    public void setXPathFragment(XPathFragment xPathFragment) {
        this.xPathFragment = xPathFragment;
    }

    public NodeValue getNodeValue() {
        return this.unmarshalNodeValue;
    }

    public void setNodeValue(NodeValue nodeValue) {
        this.marshalNodeValue = nodeValue;
        this.unmarshalNodeValue = nodeValue;
        if (null != nodeValue) {
            nodeValue.setXPathNode(this);
        }
    }

    public NodeValue getUnmarshalNodeValue() {
        return this.unmarshalNodeValue;
    }

    public void setUnmarshalNodeValue(NodeValue nodeValue) {
        if (null != nodeValue) {
            nodeValue.setXPathNode(this);
        }
        this.unmarshalNodeValue = nodeValue;
    }

    public NodeValue getMarshalNodeValue() {
        return this.marshalNodeValue;
    }

    public void setMarshalNodeValue(NodeValue nodeValue) {
        if (null != nodeValue) {
            nodeValue.setXPathNode(this);
        }
        this.marshalNodeValue = nodeValue;
    }

    public XPathNode getParent() {
        return this.parent;
    }

    public void setParent(XPathNode xPathNode) {
        this.parent = xPathNode;
    }

    public List getAttributeChildren() {
        return this.attributeChildren;
    }

    public List getNonAttributeChildren() {
        return this.nonAttributeChildren;
    }

    public List getSelfChildren() {
        return this.selfChildren;
    }

    public Map getNonAttributeChildrenMap() {
        return this.nonAttributeChildrenMap;
    }

    public Map getAttributeChildrenMap() {
        return this.attributeChildrenMap;
    }

    public void setAnyAttributeNodeValue(XMLAnyAttributeMappingNodeValue xMLAnyAttributeMappingNodeValue) {
        this.anyAttributeNodeValue = xMLAnyAttributeMappingNodeValue;
    }

    public XMLAnyAttributeMappingNodeValue getAnyAttributeNodeValue() {
        return this.anyAttributeNodeValue;
    }

    public XPathNode getAnyAttributeNode() {
        return this.anyAttributeNode;
    }

    public boolean equals(Object object) {
        try {
            XPathNode xPathNode = (XPathNode)object;
            if (this.getXPathFragment() == null && xPathNode.getXPathFragment() != null) {
                return false;
            }
            if (this.getXPathFragment() != null && xPathNode.getXPathFragment() == null) {
                return false;
            }
            if (this.getXPathFragment() == xPathNode.getXPathFragment()) {
                return true;
            }
            return this.getXPathFragment().equals(xPathNode.getXPathFragment());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void addChild(XPathFragment xPathFragment, NodeValue nodeValue, NamespaceResolver namespaceResolver) {
        Map map;
        List list;
        if (xPathFragment != null && namespaceResolver != null && xPathFragment.getNamespaceURI() == null && !xPathFragment.nameIsText()) {
            if (!xPathFragment.isAttribute()) {
                xPathFragment.setNamespaceURI(namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix()));
            } else if (xPathFragment.hasNamespace()) {
                xPathFragment.setNamespaceURI(namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix()));
            }
        }
        XPathNode xPathNode = new XPathNode();
        xPathNode.setXPathFragment(xPathFragment);
        if (xPathFragment != null && xPathFragment.isAttribute()) {
            if (null == this.attributeChildren) {
                this.attributeChildren = new ArrayList();
                this.attributeChildrenMap = new HashMap();
            }
            list = this.attributeChildren;
            map = this.attributeChildrenMap;
        } else {
            if (null == this.nonAttributeChildren) {
                this.nonAttributeChildren = new ArrayList();
                this.nonAttributeChildrenMap = new HashMap();
            }
            list = this.nonAttributeChildren;
            map = this.nonAttributeChildrenMap;
        }
        if (null == xPathFragment) {
            if (nodeValue.isMarshalNodeValue()) {
                xPathNode.setMarshalNodeValue(nodeValue);
            }
            if (nodeValue.isUnmarshalNodeValue()) {
                xPathNode.setUnmarshalNodeValue(nodeValue);
            }
            xPathNode.setParent(this);
            if (nodeValue instanceof XMLAnyAttributeMappingNodeValue) {
                this.setAnyAttributeNodeValue((XMLAnyAttributeMappingNodeValue)nodeValue);
                this.anyAttributeNode = xPathNode;
            } else {
                if (!list.contains(xPathNode)) {
                    list.add(xPathNode);
                }
                map.put(xPathFragment, xPathNode);
            }
            return;
        }
        int n = list.indexOf(xPathNode);
        if (n >= 0) {
            xPathNode = (XPathNode)list.get(n);
        } else {
            xPathNode.setParent(this);
            if (!list.contains(xPathNode)) {
                list.add(xPathNode);
            }
            if (XPathFragment.SELF_FRAGMENT.equals(xPathFragment)) {
                if (null == this.selfChildren) {
                    this.selfChildren = new ArrayList();
                }
                if (!this.selfChildren.contains(xPathNode)) {
                    this.selfChildren.add(xPathNode);
                }
            } else {
                map.put(xPathFragment, xPathNode);
            }
        }
        if (nodeValue.isOwningNode(xPathFragment)) {
            if (nodeValue.isMarshalNodeValue()) {
                xPathNode.setMarshalNodeValue(nodeValue);
            }
            if (nodeValue.isUnmarshalNodeValue()) {
                xPathNode.setUnmarshalNodeValue(nodeValue);
            }
        } else {
            XPathFragment xPathFragment2 = xPathFragment.getNextFragment();
            xPathNode.addChild(xPathFragment2, nodeValue, namespaceResolver);
        }
    }

    public boolean marshal(MarshalRecord marshalRecord, Object object, AbstractSession abstractSession, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        return this.marshal(marshalRecord, object, abstractSession, namespaceResolver, null, marshalContext);
    }

    public boolean marshal(MarshalRecord marshalRecord, Object object, AbstractSession abstractSession, NamespaceResolver namespaceResolver, XMLMarshaller xMLMarshaller, MarshalContext marshalContext) {
        if (null == this.marshalNodeValue || this.marshalNodeValue.isMarshalOnlyNodeValue()) {
            XPathNode xPathNode;
            int n;
            int n2;
            marshalRecord.addGroupingElement(this);
            boolean bl = false;
            if (null != this.attributeChildren) {
                n2 = this.attributeChildren.size();
                for (n = 0; n < n2; ++n) {
                    xPathNode = (XPathNode)this.attributeChildren.get(n);
                    bl = xPathNode.marshal(marshalRecord, object, abstractSession, namespaceResolver, xMLMarshaller, ObjectMarshalContext.getInstance()) || bl;
                }
            }
            if (this.anyAttributeNode != null) {
                boolean bl2 = bl = this.anyAttributeNode.marshal(marshalRecord, object, abstractSession, namespaceResolver, xMLMarshaller, ObjectMarshalContext.getInstance()) || bl;
            }
            if (null != this.nonAttributeChildren) {
                n2 = marshalContext.getNonAttributeChildrenSize(this);
                for (n = 0; n < n2; ++n) {
                    MarshalContext marshalContext2;
                    xPathNode = (XPathNode)marshalContext.getNonAttributeChild(n, this);
                    bl = xPathNode.marshal(marshalRecord, object, abstractSession, namespaceResolver, xMLMarshaller, marshalContext2 = marshalContext.getMarshalContext(n)) || bl;
                }
            }
            if (bl) {
                marshalRecord.endElement(this.getXPathFragment(), namespaceResolver);
            } else {
                marshalRecord.removeGroupingElement(this);
            }
            return bl;
        }
        return marshalContext.marshal(this.marshalNodeValue, this.xPathFragment, marshalRecord, object, abstractSession, namespaceResolver);
    }

    public boolean startElement(MarshalRecord marshalRecord, XPathFragment xPathFragment, Object object, AbstractSession abstractSession, NamespaceResolver namespaceResolver, TreeObjectBuilder treeObjectBuilder, Object object2) {
        if (null == xPathFragment) {
            return false;
        }
        marshalRecord.openStartElement(xPathFragment, namespaceResolver);
        boolean bl = false;
        if (null != this.attributeChildren) {
            int n = this.attributeChildren.size();
            for (int i = 0; i < n; ++i) {
                XPathNode xPathNode = (XPathNode)this.attributeChildren.get(i);
                bl = xPathNode.marshal(marshalRecord, object, abstractSession, namespaceResolver, ObjectMarshalContext.getInstance()) || bl;
            }
        }
        if (this.anyAttributeNode != null) {
            boolean bl2 = bl = this.anyAttributeNode.marshal(marshalRecord, object, abstractSession, namespaceResolver, ObjectMarshalContext.getInstance()) || bl;
        }
        if (null != treeObjectBuilder) {
            bl = treeObjectBuilder.marshalAttributes(marshalRecord, object2, abstractSession) || bl;
        }
        marshalRecord.closeStartElement();
        return bl;
    }

    public boolean marshalSelfAttributes(MarshalRecord marshalRecord, Object object, AbstractSession abstractSession, NamespaceResolver namespaceResolver, XMLMarshaller xMLMarshaller) {
        if (this.marshalNodeValue == null) {
            return false;
        }
        return this.marshalNodeValue.marshalSelfAttributes(this.xPathFragment, marshalRecord, object, abstractSession, namespaceResolver, xMLMarshaller);
    }
}

