/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.DatasourceCallQueryMechanism;
import org.eclipse.persistence.internal.queries.StatementQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class CallQueryMechanism
extends DatasourceCallQueryMechanism {
    public CallQueryMechanism(DatabaseQuery databaseQuery) {
        super(databaseQuery);
    }

    public CallQueryMechanism(DatabaseQuery databaseQuery, DatabaseCall databaseCall) {
        super(databaseQuery, databaseCall);
        databaseCall.setIsFieldMatchingRequired(true);
    }

    public DatabaseCall getDatabaseCall() {
        return (DatabaseCall)this.call;
    }

    public void prepareCall() throws QueryException {
        DatabaseQuery databaseQuery = this.getQuery();
        AbstractSession abstractSession = databaseQuery.getExecutionSession();
        if (this.hasMultipleCalls()) {
            if (this.getQuery().shouldCloneCall()) {
                this.calls = (Vector)this.getCalls().clone();
            }
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                if (!databaseQuery.shouldIgnoreBindAllParameters()) {
                    databaseCall.setUsesBinding(databaseQuery.shouldBindAllParameters());
                }
                if (!databaseQuery.shouldIgnoreCacheStatement()) {
                    databaseCall.setShouldCacheStatement(databaseQuery.shouldCacheStatement());
                }
                databaseCall.setQueryTimeout(databaseQuery.getQueryTimeout());
                if (databaseQuery.isNativeConnectionRequired()) {
                    databaseCall.setIsNativeConnectionRequired(true);
                }
                if (databaseQuery.isReadQuery()) {
                    ReadQuery readQuery = (ReadQuery)databaseQuery;
                    if (!databaseCall.shouldIgnoreFirstRowMaxResultsSettings()) {
                        databaseCall.setMaxRows(readQuery.getMaxRows());
                        if (readQuery.getFirstResult() != 0) {
                            databaseCall.setFirstResult(readQuery.getFirstResult());
                            databaseCall.setIsResultSetScrollable(true);
                            databaseCall.setResultSetType(1004);
                            databaseCall.setResultSetConcurrency(1007);
                        }
                    }
                    databaseCall.setResultSetFetchSize(readQuery.getFetchSize());
                }
                databaseCall.prepare(abstractSession);
            }
        } else if (this.getCall() != null) {
            if (this.getQuery().shouldCloneCall()) {
                this.call = (DatabaseCall)this.getDatabaseCall().clone();
                this.setCall(this.call);
            }
            DatabaseCall databaseCall = this.getDatabaseCall();
            if (!databaseQuery.shouldIgnoreBindAllParameters()) {
                databaseCall.setUsesBinding(databaseQuery.shouldBindAllParameters());
            }
            if (!databaseQuery.shouldIgnoreCacheStatement()) {
                databaseCall.setShouldCacheStatement(databaseQuery.shouldCacheStatement());
            }
            databaseCall.setQueryTimeout(databaseQuery.getQueryTimeout());
            if (databaseQuery.isNativeConnectionRequired()) {
                databaseCall.setIsNativeConnectionRequired(true);
            }
            if (databaseQuery.isReadQuery()) {
                ReadQuery readQuery = (ReadQuery)databaseQuery;
                if (!databaseCall.shouldIgnoreFirstRowMaxResultsSettings()) {
                    databaseCall.setMaxRows(readQuery.getMaxRows());
                    if (readQuery.getFirstResult() != 0) {
                        databaseCall.setFirstResult(readQuery.getFirstResult());
                        databaseCall.setIsResultSetScrollable(true);
                        databaseCall.setResultSetType(1004);
                        databaseCall.setResultSetConcurrency(1007);
                    }
                }
                databaseCall.setResultSetFetchSize(((ReadQuery)databaseQuery).getFetchSize());
            }
            databaseCall.prepare(abstractSession);
        }
    }

    public void prepareCursorSelectAllRows() throws QueryException {
        this.getCall().returnCursor();
        DatabaseQuery databaseQuery = this.getQuery();
        ContainerPolicy containerPolicy = databaseQuery.isReadAllQuery() ? ((ReadAllQuery)databaseQuery).getContainerPolicy() : ((DataReadQuery)databaseQuery).getContainerPolicy();
        if (containerPolicy.isScrollableCursorPolicy()) {
            ScrollableCursorPolicy scrollableCursorPolicy = (ScrollableCursorPolicy)containerPolicy;
            DatabaseCall databaseCall = this.getDatabaseCall();
            databaseCall.setIsResultSetScrollable(true);
            databaseCall.setResultSetType(scrollableCursorPolicy.getResultSetType());
            databaseCall.setResultSetConcurrency(scrollableCursorPolicy.getResultSetConcurrency());
            if (((ReadQuery)this.getQuery()).getFetchSize() == 0) {
                databaseCall.setResultSetFetchSize(scrollableCursorPolicy.getPageSize());
            }
        }
        if (this.getQuery().isReportQuery()) {
            this.prepareReportQueryItems();
        }
        this.prepareCall();
    }

    public void prepareDeleteAll() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                databaseCall.setHasOptimisticLock(true);
            }
        } else {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void prepareDeleteObject() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                databaseCall.setHasOptimisticLock(true);
            }
        } else {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void prepareDoesExist(DatabaseField databaseField) {
        this.getCall().returnOneRow();
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(1);
        ((Vector)nonSynchronizedVector).addElement(databaseField);
        this.getDatabaseCall().setFields(nonSynchronizedVector);
        this.prepareCall();
    }

    public void prepareExecuteSelect() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnManyRows();
                databaseCall.setIsFieldMatchingRequired(this.isCallQueryMechanism());
            }
        } else {
            DatabaseCall databaseCall = this.getDatabaseCall();
            databaseCall.returnManyRows();
            databaseCall.setIsFieldMatchingRequired(this.isCallQueryMechanism());
        }
        this.prepareCall();
    }

    public void prepareSelectAllRows() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnManyRows();
                if (!this.isCallQueryMechanism()) continue;
                databaseCall.setIsFieldMatchingRequired(true);
                databaseCall.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                this.prepareJoining((ObjectLevelReadQuery)this.getQuery());
            }
        } else {
            this.getCall().returnManyRows();
            if (this.isCallQueryMechanism()) {
                DatabaseCall databaseCall = this.getDatabaseCall();
                databaseCall.setIsFieldMatchingRequired(true);
                databaseCall.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                this.prepareJoining((ObjectLevelReadQuery)this.getQuery());
            }
        }
        this.prepareCall();
    }

    protected void prepareJoining(ObjectLevelReadQuery objectLevelReadQuery) {
        if (objectLevelReadQuery.hasJoining()) {
            objectLevelReadQuery.getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), 0);
        }
    }

    public void prepareSelectOneRow() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnOneRow();
                if (!this.isCallQueryMechanism()) continue;
                databaseCall.setIsFieldMatchingRequired(true);
                databaseCall.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                this.prepareJoining((ObjectLevelReadQuery)this.getQuery());
            }
        } else {
            this.getCall().returnOneRow();
            if (this.isCallQueryMechanism()) {
                DatabaseCall databaseCall = this.getDatabaseCall();
                databaseCall.setIsFieldMatchingRequired(true);
                databaseCall.setFields(((ObjectLevelReadQuery)this.getQuery()).getSelectionFields());
                this.prepareJoining((ObjectLevelReadQuery)this.getQuery());
            }
        }
        this.prepareCall();
    }

    public void prepareUpdateObject() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                databaseCall.returnNothing();
                if (!this.getQuery().getDescriptor().usesOptimisticLocking()) continue;
                databaseCall.setHasOptimisticLock(true);
            }
        } else if (this.getCall() != null) {
            this.getCall().returnNothing();
            if (this.getQuery().getDescriptor().usesOptimisticLocking()) {
                this.getDatabaseCall().setHasOptimisticLock(true);
            }
        }
        this.prepareCall();
    }

    public void setCallHasCustomSQLArguments() {
        if (this.hasMultipleCalls()) {
            Enumeration enumeration = this.getCalls().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseCall databaseCall = (DatabaseCall)enumeration.nextElement();
                if (!databaseCall.isSQLCall()) continue;
                ((SQLCall)databaseCall).setHasCustomSQLArguments(true);
            }
        } else if (this.getCall().isSQLCall()) {
            ((SQLCall)this.getCall()).setHasCustomSQLArguments(true);
        }
    }

    protected void updateForeignKeyFieldAfterInsert(WriteObjectQuery writeObjectQuery) {
        Enumeration<DatabaseTable> enumeration = this.getDescriptor().getTables().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseTable databaseTable = enumeration.nextElement();
            SQLUpdateStatement sQLUpdateStatement = new SQLUpdateStatement();
            sQLUpdateStatement.setModifyRow(this.getDescriptor().getObjectBuilder().buildRowForUpdate(writeObjectQuery));
            sQLUpdateStatement.setTranslationRow(this.getTranslationRow());
            sQLUpdateStatement.setTable(databaseTable);
            sQLUpdateStatement.setWhereClause(this.getDescriptor().getObjectBuilder().buildPrimaryKeyExpression(databaseTable));
            StatementQueryMechanism statementQueryMechanism = new StatementQueryMechanism((DatabaseQuery)writeObjectQuery, sQLUpdateStatement);
            writeObjectQuery.setModifyRow(sQLUpdateStatement.getModifyRow());
            statementQueryMechanism.updateObject();
        }
    }
}

