/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.queries.DirectMapUsableContainerPolicy;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ReadQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectMapContainerPolicy
extends InterfaceContainerPolicy
implements DirectMapUsableContainerPolicy {
    protected DatabaseField keyField;
    protected DatabaseField valueField;
    protected Converter keyConverter;
    protected String keyConverterClassName;
    protected Converter valueConverter;

    public DirectMapContainerPolicy() {
    }

    public DirectMapContainerPolicy(Class clazz) {
        super(clazz);
    }

    @Override
    public void addAdditionalFieldsToQuery(ReadQuery readQuery, Expression expression) {
        if (expression == null) {
            ((SQLSelectStatement)((DataReadQuery)readQuery).getSQLStatement()).addField((DatabaseField)this.keyField.clone());
            ((SQLSelectStatement)((DataReadQuery)readQuery).getSQLStatement()).addTable((DatabaseTable)this.keyField.getTable().clone());
        } else {
            ((SQLSelectStatement)((DataReadQuery)readQuery).getSQLStatement()).addField(expression.getTable(this.keyField.getTable()).getField(this.keyField));
        }
    }

    @Override
    public void addFieldsForMapKey(AbstractRecord abstractRecord) {
        abstractRecord.put(this.keyField, (Object)null);
    }

    @Override
    public boolean addInto(Object object, Object object2, Object object3, AbstractSession abstractSession) {
        try {
            ((Map)object3).put(object, object2);
        }
        catch (ClassCastException classCastException) {
            throw QueryException.cannotAddElement(object, object3, classCastException);
        }
        return true;
    }

    @Override
    public boolean addInto(Object object, Object object2, AbstractSession abstractSession) {
        Object object3 = null;
        Object object4 = null;
        if (object instanceof AbstractRecord) {
            AbstractRecord abstractRecord = (AbstractRecord)object;
            object3 = abstractRecord.get(this.keyField);
            object4 = abstractRecord.get(this.valueField);
            return this.addInto(object3, object4, object2, abstractSession);
        }
        if (object instanceof Association) {
            Association association = (Association)object;
            object3 = association.getKey();
            object4 = association.getValue();
            return this.addInto(object3, object4, object2, abstractSession);
        }
        return super.addInto(object, object2, abstractSession);
    }

    @Override
    public Object buildContainerFromVector(Vector vector, AbstractSession abstractSession) {
        Map map = (Map)this.containerInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AbstractRecord abstractRecord = (AbstractRecord)enumeration.nextElement();
            Object object = abstractRecord.get(this.keyField);
            Object object2 = abstractRecord.get(this.valueField);
            if (this.getKeyConverter() != null) {
                object = this.getKeyConverter().convertDataValueToObjectValue(object, abstractSession);
            }
            if (this.valueConverter != null) {
                object2 = this.valueConverter.convertDataValueToObjectValue(object2, abstractSession);
            }
            if (object == null) continue;
            map.put(object, object2);
        }
        return map;
    }

    @Override
    public Object buildKey(AbstractRecord abstractRecord, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) {
        Object object = abstractRecord.get(this.keyField);
        if (this.keyConverter != null) {
            object = this.keyConverter.convertDataValueToObjectValue(object, abstractSession);
        }
        return object;
    }

    @Override
    public void clear(Object object) {
        try {
            ((Map)object).clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object, "clear()");
        }
    }

    @Override
    public boolean compareContainers(Object object, Object object2) {
        if (this.sizeFor(object) != this.sizeFor(object2)) {
            return false;
        }
        Object object3 = this.iteratorFor(object);
        while (this.hasNext(object3)) {
            Map.Entry entry = (Map.Entry)this.nextEntry(object3);
            Object k = entry.getKey();
            if (((Map)object).get(k).equals(((Map)object2).get(k))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean compareKeys(Object object, AbstractSession abstractSession) {
        if (((UnitOfWorkImpl)abstractSession).isClassReadOnly(object.getClass())) {
            return true;
        }
        Object object2 = ((UnitOfWorkImpl)abstractSession).getBackupClone(object, this.getElementDescriptor());
        return this.keyFrom(object2, abstractSession).equals(this.keyFrom(object, abstractSession));
    }

    @Override
    protected boolean contains(Object object, Object object2) {
        return ((Map)object2).containsValue(object);
    }

    @Override
    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.keyConverter != null) {
            if (this.keyConverter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.keyConverter).convertClassNamesToClasses(classLoader);
            } else if (this.keyConverter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.keyConverter).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.keyConverterClassName != null) {
            Converter converter;
            block13: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        Class clazz;
                        try {
                            clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.keyConverterClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, privilegedActionException.getException());
                        }
                        try {
                            converter = (Converter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                            break block13;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, privilegedActionException.getException());
                        }
                    }
                    Class clazz = PrivilegedAccessHelper.getClassForName(this.keyConverterClassName, true, classLoader);
                    converter = (Converter)PrivilegedAccessHelper.newInstanceFromClass(clazz);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, classNotFoundException);
                }
                catch (Exception exception) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, exception);
                }
            }
            this.keyConverter = converter;
        }
    }

    @Override
    public DatabaseField getDirectKeyField() {
        return this.keyField;
    }

    @Override
    public Class getInterfaceType() {
        return ClassConstants.Map_Class;
    }

    @Override
    public List<DatabaseField> getIdentityFieldsForMapKey() {
        ArrayList<DatabaseField> arrayList = new ArrayList<DatabaseField>(1);
        arrayList.add(this.keyField);
        return arrayList;
    }

    @Override
    public boolean hasNext(Object object) {
        return ((MapContainerPolicy.MapContainerPolicyIterator)object).hasNext();
    }

    @Override
    public Map getKeyMappingDataForWriteQuery(Object object, AbstractSession abstractSession) {
        Object object2 = ((Map.Entry)object).getKey();
        HashMap hashMap = new HashMap();
        if (this.keyConverter != null) {
            object2 = this.keyConverter.convertObjectValueToDataValue(object2, abstractSession);
        }
        hashMap.put(this.keyField, object2);
        return hashMap;
    }

    @Override
    public boolean isDirectMapPolicy() {
        return true;
    }

    @Override
    public void initialize(AbstractSession abstractSession, DatabaseTable databaseTable) {
        if (this.getDirectKeyField() == null) {
            throw DescriptorException.directKeyNotSet(this.elementDescriptor);
        }
        this.getDirectKeyField().setTable(databaseTable);
        this.getDirectKeyField().setIndex(1);
    }

    @Override
    public Object iteratorFor(Object object) {
        return new MapContainerPolicy.MapContainerPolicyIterator((Map)object);
    }

    @Override
    public Object keyFromIterator(Object object) {
        return ((MapContainerPolicy.MapContainerPolicyIterator)object).getCurrentKey();
    }

    @Override
    public Object keyFromEntry(Object object) {
        if (object instanceof Map.Entry) {
            return ((Map.Entry)object).getKey();
        }
        return null;
    }

    @Override
    protected Object next(Object object) {
        return ((MapContainerPolicy.MapContainerPolicyIterator)object).next().getValue();
    }

    @Override
    public Object nextEntry(Object object) {
        return ((MapContainerPolicy.MapContainerPolicyIterator)object).next();
    }

    @Override
    public Object nextEntry(Object object, AbstractSession abstractSession) {
        return this.nextEntry(object);
    }

    @Override
    public Object unwrapIteratorResult(Object object) {
        if (object instanceof Map.Entry) {
            return ((Map.Entry)object).getValue();
        }
        return object;
    }

    @Override
    public boolean removeFrom(Object object, Object object2, Object object3, AbstractSession abstractSession) {
        try {
            Object var5_5 = null;
            var5_5 = object != null ? ((Map)object3).remove(object) : ((Map)object3).remove(this.keyFrom(object2, abstractSession));
            return var5_5 != null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object3, "remove(Object element)");
        }
    }

    public boolean removeFromWithIdentity(Object object, Object object2, AbstractSession abstractSession) {
        boolean bl = false;
        Vector vector = new Vector(1);
        try {
            for (Object k : ((Map)object2).keySet()) {
                if (((Map)object2).get(k) != object) continue;
                vector.addElement(k);
                bl = true;
            }
            if (bl) {
                for (int i = 0; i < vector.size(); ++i) {
                    ((Map)object2).remove(vector.elementAt(i));
                }
            }
            return bl;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object2, "remove(Object element)");
        }
    }

    @Override
    public void setDescriptorForKeyMapping(ClassDescriptor classDescriptor) {
        this.elementDescriptor = classDescriptor;
    }

    public void setKeyField(DatabaseField databaseField) {
        this.keyField = databaseField;
    }

    @Override
    public void setKeyField(DatabaseField databaseField, ClassDescriptor classDescriptor) {
        this.setKeyField(databaseField);
    }

    @Override
    public void setValueField(DatabaseField databaseField, Converter converter) {
        this.valueField = databaseField;
        this.valueConverter = converter;
    }

    @Override
    public int sizeFor(Object object) {
        return ((Map)object).size();
    }

    @Override
    public void validateElementAndRehashIfRequired(Object object, Object object2, AbstractSession abstractSession, Object object3) {
        Object object4;
        if (abstractSession.isUnitOfWork() && !this.keyFrom(object4 = ((UnitOfWorkImpl)abstractSession).getBackupClone(object, this.getElementDescriptor()), abstractSession).equals(this.keyFrom(object, abstractSession))) {
            this.removeFrom(object4, object2, abstractSession);
            this.addInto(object3, object2, abstractSession);
        }
    }

    @Override
    public boolean isValidContainer(Object object) {
        return object instanceof Map;
    }

    @Override
    public Converter getKeyConverter() {
        return this.keyConverter;
    }

    @Override
    public void setKeyConverter(Converter converter, DirectMapMapping directMapMapping) {
        this.keyConverter = converter;
    }

    @Override
    public void setKeyConverterClassName(String string, DirectMapMapping directMapMapping) {
        this.keyConverterClassName = string;
    }
}

