/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.CommitManager;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.sessions.factories.ReferenceMode;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.sessions.server.ServerSession;

public class RemoteUnitOfWork
extends UnitOfWorkImpl {
    protected Vector newObjectsCache;
    protected Vector unregisteredNewObjectsCache;
    protected boolean isOnClient = true;
    protected transient RemoteSessionController parentSessionController;

    public RemoteUnitOfWork(RemoteUnitOfWork remoteUnitOfWork) {
        this(remoteUnitOfWork, null);
    }

    public RemoteUnitOfWork(RemoteSession remoteSession) {
        this(remoteSession, null);
        this.isOnClient = true;
    }

    public RemoteUnitOfWork(RemoteUnitOfWork remoteUnitOfWork, ReferenceMode referenceMode) {
        super(remoteUnitOfWork, referenceMode);
    }

    public RemoteUnitOfWork(RemoteSession remoteSession, ReferenceMode referenceMode) {
        super(remoteSession, referenceMode);
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        return this.acquireUnitOfWork(null);
    }

    public UnitOfWorkImpl acquireUnitOfWork(ReferenceMode referenceMode) {
        this.log(2, "transaction", "acquire_unit_of_work");
        this.setNumberOfActiveUnitsOfWork(this.getNumberOfActiveUnitsOfWork() + 1);
        RemoteUnitOfWork remoteUnitOfWork = new RemoteUnitOfWork(this, referenceMode);
        remoteUnitOfWork.discoverAllUnregisteredNewObjectsInParent();
        return remoteUnitOfWork;
    }

    protected Vector collectNewObjects() {
        return Helper.buildVectorFromHashtableElements(this.getNewObjectsCloneToOriginal());
    }

    protected Vector collectUnregisteredNewObjects() {
        this.discoverAllUnregisteredNewObjects();
        return Helper.buildVectorFromHashtableElements(this.getUnregisteredNewObjects());
    }

    protected void commitIntoRemoteUnitOfWork() {
        ((UnitOfWorkImpl)this.getParent()).setWasTransactionBegunPrematurely(this.wasTransactionBegunPrematurely());
        MergeManager mergeManager = new MergeManager(this);
        mergeManager.mergeWorkingCopyIntoRemote();
        Iterator iterator = new IdentityHashMap(this.getCloneMapping()).keySet().iterator();
        while (iterator.hasNext()) {
            mergeManager.mergeChanges(iterator.next(), null);
        }
    }

    public void commitRootUnitOfWork() {
        RemoteUnitOfWork remoteUnitOfWork;
        if (!this.isOnClient()) {
            if (this.isSynchronized()) {
                if (this.getParent().wasJTSTransactionInternallyStarted()) {
                    this.commitInternallyStartedExternalTransaction();
                }
                return;
            }
            this.getEventManager().preCommitUnitOfWork();
            super.commitRootUnitOfWork();
            this.getEventManager().postCommitUnitOfWork();
            return;
        }
        this.setNewObjectsCache(this.collectNewObjects());
        this.setUnregisteredNewObjectsCache(this.collectUnregisteredNewObjects());
        try {
            remoteUnitOfWork = ((RemoteSession)this.getParent()).getRemoteConnection().commitRootUnitOfWork(this);
        }
        catch (RuntimeException runtimeException) {
            if (this.wasTransactionBegunPrematurely()) {
                this.getParent().getTransactionMutex().release();
            }
            this.setWasTransactionBegunPrematurely(false);
            throw runtimeException;
        }
        if (this.wasTransactionBegunPrematurely()) {
            this.getParent().getTransactionMutex().release();
        }
        remoteUnitOfWork.setParent(this);
        remoteUnitOfWork.setProject(this.getProject());
        remoteUnitOfWork.prepareForMergeIntoRemoteUnitOfWork();
        remoteUnitOfWork.commitIntoRemoteUnitOfWork();
        this.commitRootUnitOfWorkOnClient();
    }

    protected void commitRootUnitOfWorkOnClient() {
        Object object;
        Map map = this.collectAndPrepareObjectsForNestedMerge();
        UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (unitOfWorkChangeSet == null) {
            this.setUnitOfWorkChangeSet(new UnitOfWorkChangeSet(this));
            unitOfWorkChangeSet = (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
            this.calculateChanges(new IdentityHashMap(this.cloneMapping), (UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet(), false);
            this.allClones = null;
        }
        Enumeration enumeration = unitOfWorkChangeSet.getNewObjectChangeSets().elements();
        while (enumeration.hasMoreElements()) {
            object = (Map)enumeration.nextElement();
            Iterator iterator = new IdentityHashMap(object).keySet().iterator();
            while (iterator.hasNext()) {
                unitOfWorkChangeSet.putNewObjectInChangesList((ObjectChangeSet)iterator.next(), this);
            }
        }
        object = this.getObjectsDeletedDuringCommit().keySet().iterator();
        while (object.hasNext()) {
            ((UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).addDeletedObject(object.next(), this);
        }
        this.mergeChangesIntoParent();
    }

    public Object executeQuery(String string) throws DatabaseException {
        return this.executeQuery(string, new Vector(1));
    }

    public Object executeQuery(String string, Class clazz) throws DatabaseException {
        return this.executeQuery(string, clazz, new Vector(1));
    }

    public Object executeQuery(String string, Class clazz, Vector vector) throws DatabaseException {
        Serializable serializable;
        RemoteSession remoteSession = null;
        if (this.getParent().isRemoteSession()) {
            remoteSession = (RemoteSession)this.getParent();
        } else {
            serializable = (RemoteUnitOfWork)this.getParent();
            while (((UnitOfWorkImpl)serializable).getParent().isRemoteUnitOfWork()) {
                serializable = (RemoteUnitOfWork)((UnitOfWorkImpl)serializable).getParent();
            }
            remoteSession = (RemoteSession)((UnitOfWorkImpl)serializable).getParent();
        }
        serializable = remoteSession.getRemoteConnection().remoteExecuteNamedQuery(string, clazz, vector);
        ((Transporter)serializable).getQuery().setSession(this);
        return ((Transporter)serializable).getQuery().extractRemoteResult((Transporter)serializable);
    }

    public Object executeQuery(String string, Vector vector) throws DatabaseException {
        if (this.containsQuery(string)) {
            return super.executeQuery(string, vector);
        }
        return this.executeQuery(string, null, vector);
    }

    public ClassDescriptor getDescriptor(Class clazz) {
        return this.getParent().getDescriptor(clazz);
    }

    public Vector getNewObjectsCache() {
        return this.newObjectsCache;
    }

    public RemoteSessionController getParentSessionController() {
        return this.parentSessionController;
    }

    public DatabasePlatform getPlatform() {
        return this.getParent().getPlatform();
    }

    public Platform getDatasourcePlatform() {
        return this.getParent().getDatasourcePlatform();
    }

    public Vector getUnregisteredNewObjectsCache() {
        return this.unregisteredNewObjectsCache;
    }

    public Object internalExecuteQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord) throws DatabaseException, QueryException {
        if (this.isOnClient()) {
            Object object;
            boolean bl;
            boolean bl2 = bl = databaseQuery.isObjectLevelReadQuery() && !databaseQuery.isReportQuery() && databaseQuery.shouldMaintainCache();
            if (bl) {
                object = (ObjectLevelReadQuery)databaseQuery;
                if (this.isAfterWriteChangesButBeforeCommit()) {
                    throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "executeQuery(ObjectLevelReadQuery)");
                }
                Object object2 = ((ObjectLevelReadQuery)object).checkEarlyReturn(this, abstractRecord);
                if (object2 != null) {
                    if (object2 == InvalidObject.instance) {
                        return null;
                    }
                    return object2;
                }
                if (((ObjectLevelReadQuery)object).isLockQuery(this) && !this.wasTransactionBegunPrematurely()) {
                    this.beginEarlyTransaction();
                }
            } else if (databaseQuery.isObjectLevelModifyQuery()) {
                return databaseQuery.executeInUnitOfWork(this, abstractRecord);
            }
            if (!this.getCommitManager().isActive() && databaseQuery.isDataModifyQuery() && !this.wasTransactionBegunPrematurely()) {
                this.beginEarlyTransaction();
            }
            object = this.getParent().executeQuery(databaseQuery, abstractRecord);
            if (bl) {
                object = ((ObjectLevelReadQuery)databaseQuery).registerResultInUnitOfWork(object, this, abstractRecord, false);
            }
            return object;
        }
        return databaseQuery.executeInUnitOfWork(this, abstractRecord);
    }

    protected boolean isOnClient() {
        return this.isOnClient;
    }

    public boolean isRemoteUnitOfWork() {
        return true;
    }

    protected void prepareForMergeIntoRemoteUnitOfWork() {
        Object object;
        Enumeration<Object> enumeration;
        Enumeration<Object> enumeration2;
        IdentityHashMap<Object, Object> identityHashMap = new IdentityHashMap<Object, Object>();
        IdentityHashMap<Object, Object> identityHashMap2 = new IdentityHashMap<Object, Object>();
        Enumeration enumeration3 = this.getNewObjectsCache().elements();
        Enumeration enumeration4 = ((RemoteUnitOfWork)this.getParent()).getNewObjectsCache().elements();
        while (enumeration3.hasMoreElements()) {
            enumeration2 = ((RemoteUnitOfWork)this.getParent()).getNewObjectsOriginalToClone().get(enumeration4.nextElement());
            enumeration = this.getNewObjectsOriginalToClone().get(enumeration3.nextElement());
            if (enumeration == null) continue;
            identityHashMap.put(enumeration2, enumeration);
            identityHashMap2.put(enumeration, enumeration2);
        }
        enumeration2 = this.getUnregisteredNewObjectsCache().elements();
        enumeration = ((RemoteUnitOfWork)this.getParent()).getUnregisteredNewObjectsCache().elements();
        while (enumeration2.hasMoreElements()) {
            object = ((RemoteUnitOfWork)this.getParent()).getUnregisteredNewObjects().get(enumeration.nextElement());
            Object v = this.getUnregisteredNewObjects().get(enumeration2.nextElement());
            identityHashMap.put(object, v);
            identityHashMap2.put(v, object);
        }
        this.setNewObjectsOriginalToClone(identityHashMap);
        this.setNewObjectsCloneToOriginal(identityHashMap2);
        object = new IdentityHashMap();
        for (Object e : this.getObjectsDeletedDuringCommit().keySet()) {
            Vector vector = this.keyFromObject(e);
            Object object2 = this.getParent().getIdentityMapAccessor().getFromIdentityMap(vector, e.getClass());
            if (object2 == null && (object2 = identityHashMap2.get(e)) == null) {
                object2 = e;
            }
            object.put((Object)object2, (Vector)this.keyFromObject(object2));
            ((UnitOfWorkImpl)this.getParent()).getIdentityMapAccessor().removeFromIdentityMap(object2);
        }
        ((UnitOfWorkImpl)this.getParent()).setObjectsDeletedDuringCommit((Map)object);
    }

    public void reinitializeForSession(AbstractSession abstractSession, RemoteSessionController remoteSessionController) {
        if (abstractSession.isServerSession()) {
            abstractSession = ((ServerSession)abstractSession).acquireClientSession();
        }
        this.setIsOnClient(false);
        this.setParentSessionController(remoteSessionController);
        this.setParent(abstractSession);
        this.setProject(abstractSession.getProject());
        this.setProfiler(this.getProfiler());
        this.setEventManager(abstractSession.getEventManager().clone(this));
        this.setSessionLog(abstractSession.getSessionLog());
        this.setLog(abstractSession.getLog());
        this.setCommitManager(new CommitManager(this));
        this.setTransactionMutex(new ConcurrencyManager());
        this.getCommitManager().setCommitOrder(abstractSession.getCommitManager().getCommitOrder());
        if (this.getParent().hasExternalTransactionController()) {
            this.getParent().getExternalTransactionController().registerSynchronizationListener(this, this.getParent());
        }
    }

    protected void setIsOnClient(boolean bl) {
        this.isOnClient = bl;
    }

    protected void setNewObjectsCache(Vector vector) {
        this.newObjectsCache = vector;
    }

    public void setParentSessionController(RemoteSessionController remoteSessionController) {
        this.parentSessionController = remoteSessionController;
    }

    protected void setUnregisteredNewObjectsCache(Vector vector) {
        this.unregisteredNewObjectsCache = vector;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "()";
    }

    public boolean verifyDelete(Object object) {
        return this.getParent().verifyDelete(object);
    }
}

