/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.xr;

import java.net.URL;
import java.security.AccessController;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.persistence.exceptions.SessionLoaderException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.factories.EclipseLinkObjectPersistenceRuntimeXMLProject;
import org.eclipse.persistence.internal.sessions.factories.MissingDescriptorListener;
import org.eclipse.persistence.internal.sessions.factories.SessionsFactory;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.platform.DOMPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sessions.Project;

public class XRSessionsFactory
extends SessionsFactory {
    static Pattern matchDBWSOrProject = Pattern.compile("eclipselink-dbws-or.xml", 2);
    static Pattern matchDBWSOxProject = Pattern.compile("eclipselink-dbws-ox.xml", 2);

    protected Project loadProjectConfig(ProjectConfig projectConfig) {
        Project project = null;
        String string = projectConfig.getProjectString();
        if (projectConfig.isProjectClassConfig()) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    project = (Project)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(this.m_classLoader.loadClass(string)));
                }
                project = (Project)PrivilegedAccessHelper.newInstanceFromClass(this.m_classLoader.loadClass(string));
            }
            catch (Throwable throwable) {
                throw SessionLoaderException.failedToLoadProjectClass(string, throwable);
            }
        } else {
            try {
                Object object;
                Object object2;
                int n;
                int n2;
                Object object3;
                URL uRL = null;
                Matcher matcher = matchDBWSOrProject.matcher(string);
                if (matcher.find()) {
                    object3 = Util.META_INF_PATHS;
                    n2 = ((String[])object3).length;
                    for (n = 0; n < n2 && (uRL = this.m_classLoader.getResource((String)(object2 = (String)(object = object3[n]) + "eclipselink-dbws-or.xml"))) == null; ++n) {
                    }
                } else {
                    matcher = matchDBWSOxProject.matcher(string);
                    if (matcher.find()) {
                        object3 = Util.META_INF_PATHS;
                        n2 = ((String[])object3).length;
                        for (n = 0; n < n2 && (uRL = this.m_classLoader.getResource((String)(object2 = (String)(object = object3[n]) + "eclipselink-dbws-ox.xml"))) == null; ++n) {
                        }
                    }
                }
                if (uRL != null) {
                    object3 = new EclipseLinkObjectPersistenceRuntimeXMLProject();
                    XMLLogin xMLLogin = new XMLLogin();
                    xMLLogin.setDatasourcePlatform(new DOMPlatform());
                    ((Project)object3).setDatasourceLogin(xMLLogin);
                    if (this.m_classLoader != null) {
                        ((Project)object3).getDatasourceLogin().getDatasourcePlatform().getConversionManager().setLoader(this.m_classLoader);
                    }
                    XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
                    object = xMLPlatform.newXMLParser();
                    object.setNamespaceAware(true);
                    object.setWhitespacePreserving(false);
                    object2 = new XMLContext((Project)object3);
                    ((XMLContext)object2).getSession(Project.class).getEventManager().addListener(new MissingDescriptorListener());
                    XMLUnmarshaller xMLUnmarshaller = ((XMLContext)object2).createUnmarshaller();
                    project = (Project)xMLUnmarshaller.unmarshal(uRL);
                }
            }
            catch (ValidationException validationException) {
                if (validationException.getErrorCode() == 7099) {
                    throw SessionLoaderException.failedToLoadProjectXml(string, validationException);
                }
                throw SessionLoaderException.failedToParseXML(string, validationException);
            }
        }
        return project;
    }
}

