/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;

public class JAXBIntrospector
extends javax.xml.bind.JAXBIntrospector {
    private XMLContext context;

    public JAXBIntrospector(XMLContext xMLContext) {
        this.context = xMLContext;
    }

    public boolean isElement(Object object) {
        if (object instanceof JAXBElement) {
            return true;
        }
        try {
            AbstractSession abstractSession = this.context.getSession(object);
            if (abstractSession == null) {
                return false;
            }
            XMLDescriptor xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(object);
            if (xMLDescriptor == null) {
                return false;
            }
            return xMLDescriptor.getDefaultRootElement() != null;
        }
        catch (XMLMarshalException xMLMarshalException) {
            return false;
        }
    }

    public QName getElementName(Object object) {
        if (!this.isElement(object)) {
            return null;
        }
        if (object instanceof JAXBElement) {
            return ((JAXBElement)object).getName();
        }
        try {
            XMLDescriptor xMLDescriptor = (XMLDescriptor)this.context.getSession(object).getDescriptor(object);
            String string = xMLDescriptor.getDefaultRootElement();
            int n = string.indexOf(":");
            if (n == -1) {
                return new QName(string);
            }
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            String string4 = xMLDescriptor.getNamespaceResolver().resolveNamespacePrefix(string2);
            return new QName(string4, string3);
        }
        catch (XMLMarshalException xMLMarshalException) {
            return null;
        }
    }
}

