/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.jaxb.compiler.AnnotationsProcessor;
import org.eclipse.persistence.jaxb.compiler.MappingsGenerator;
import org.eclipse.persistence.jaxb.compiler.SchemaGenerator;
import org.eclipse.persistence.jaxb.compiler.SchemaTypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaModelInput;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator {
    private AnnotationsProcessor annotationsProcessor;
    private SchemaGenerator schemaGenerator;
    private MappingsGenerator mappingsGenerator;
    private Helper helper;

    public Generator(JavaModelInput javaModelInput) {
        this.helper = new Helper(javaModelInput.getJavaModel());
        this.annotationsProcessor = new AnnotationsProcessor(this.helper);
        this.schemaGenerator = new SchemaGenerator(this.helper);
        this.mappingsGenerator = new MappingsGenerator(this.helper);
        this.annotationsProcessor.processClassesAndProperties(javaModelInput.getJavaClasses());
    }

    public boolean hasMarshalCallbacks() {
        return this.getMarshalCallbacks() != null && this.getMarshalCallbacks().size() > 0;
    }

    public boolean hasUnmarshalCallbacks() {
        return this.getUnmarshalCallbacks() != null && this.getUnmarshalCallbacks().size() > 0;
    }

    public SchemaTypeInfo addClass(JavaClass javaClass) {
        return this.annotationsProcessor.addClass(javaClass);
    }

    public Project generateProject() throws Exception {
        return this.mappingsGenerator.generateProject(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), this.annotationsProcessor.getGlobalElements());
    }

    public Collection<Schema> generateSchema() {
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), null);
        return this.schemaGenerator.getAllSchemas();
    }

    public HashMap<String, SchemaTypeInfo> generateSchemaFiles(String string, HashMap<QName, String> hashMap) throws FileNotFoundException {
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), this.annotationsProcessor.getGlobalElements());
        SchemaModelProject schemaModelProject = new SchemaModelProject();
        XMLContext xMLContext = new XMLContext(schemaModelProject);
        XMLMarshaller xMLMarshaller = xMLContext.createMarshaller();
        XMLDescriptor xMLDescriptor = (XMLDescriptor)schemaModelProject.getDescriptor(Schema.class);
        Collection<Schema> collection = this.schemaGenerator.getAllSchemas();
        int n = 0;
        for (Schema schema : collection) {
            File file = new File(string + "/" + schema.getName());
            NamespaceResolver namespaceResolver = schema.getNamespaceResolver();
            namespaceResolver.put("xsd", "http://www.w3.org/2001/XMLSchema");
            xMLDescriptor.setNamespaceResolver(namespaceResolver);
            xMLMarshaller.marshal((Object)schema, new FileOutputStream(file));
            ++n;
        }
        return this.schemaGenerator.getSchemaTypeInfo();
    }

    public HashMap<String, SchemaTypeInfo> generateSchemaFiles(SchemaOutputResolver schemaOutputResolver, HashMap<QName, String> hashMap) {
        this.schemaGenerator.generateSchema(this.annotationsProcessor.getTypeInfoClasses(), this.annotationsProcessor.getTypeInfo(), this.annotationsProcessor.getUserDefinedSchemaTypes(), this.annotationsProcessor.getPackageToNamespaceMappings(), this.annotationsProcessor.getGlobalElements());
        SchemaModelProject schemaModelProject = new SchemaModelProject();
        XMLContext xMLContext = new XMLContext(schemaModelProject);
        XMLMarshaller xMLMarshaller = xMLContext.createMarshaller();
        XMLDescriptor xMLDescriptor = (XMLDescriptor)schemaModelProject.getDescriptor(Schema.class);
        Collection<Schema> collection = this.schemaGenerator.getAllSchemas();
        int n = 0;
        for (Schema schema : collection) {
            try {
                NamespaceResolver namespaceResolver = schema.getNamespaceResolver();
                namespaceResolver.put("xsd", "http://www.w3.org/2001/XMLSchema");
                xMLDescriptor.setNamespaceResolver(namespaceResolver);
                Result result = schemaOutputResolver.createOutput(schema.getTargetNamespace(), schema.getName());
                xMLMarshaller.marshal((Object)schema, result);
                ++n;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.schemaGenerator.getSchemaTypeInfo();
    }

    public HashMap getUnmarshalCallbacks() {
        return this.annotationsProcessor.getUnmarshalCallbacks();
    }

    public HashMap getMarshalCallbacks() {
        return this.annotationsProcessor.getMarshalCallbacks();
    }

    public MappingsGenerator getMappingsGenerator() {
        return this.mappingsGenerator;
    }
}

