/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.xml.bind.Marshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;

public class MarshalCallback {
    private Class domainClass;
    private String domainClassName;
    private Method beforeMarshalCallback;
    private Method afterMarshalCallback;
    private boolean hasBeforeMarshalCallback = false;
    private boolean hasAfterMarshalCallback = false;

    public Method getAfterMarshalCallback() {
        return this.afterMarshalCallback;
    }

    public Method getBeforeMarshalCallback() {
        return this.beforeMarshalCallback;
    }

    public Class getDomainClass() {
        return this.domainClass;
    }

    public void initialize(ClassLoader classLoader) {
        Method method;
        block22: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.domainClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.domainClassName, true, classLoader));
                        break block22;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (privilegedActionException.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)privilegedActionException.getCause();
                        }
                        throw (RuntimeException)privilegedActionException.getCause();
                    }
                }
                this.domainClass = PrivilegedAccessHelper.getClassForName(this.domainClassName, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return;
            }
        }
        Class[] classArray = new Class[]{Marshaller.class};
        if (this.hasBeforeMarshalCallback) {
            try {
                method = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        method = AccessController.doPrivileged(new PrivilegedGetMethod(this.domainClass, "beforeMarshal", classArray, false));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)privilegedActionException.getCause();
                        }
                        throw (RuntimeException)privilegedActionException.getCause();
                    }
                } else {
                    method = PrivilegedAccessHelper.getMethod(this.domainClass, "beforeMarshal", classArray, false);
                }
                this.setBeforeMarshalCallback(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.hasAfterMarshalCallback) {
            try {
                method = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        method = AccessController.doPrivileged(new PrivilegedGetMethod(this.domainClass, "afterMarshal", classArray, false));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)privilegedActionException.getCause();
                        }
                        throw (RuntimeException)privilegedActionException.getCause();
                    }
                } else {
                    method = PrivilegedAccessHelper.getMethod(this.domainClass, "afterMarshal", classArray, false);
                }
                this.setAfterMarshalCallback(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public void setAfterMarshalCallback(Method method) {
        this.afterMarshalCallback = method;
    }

    public void setHasAfterMarshalCallback() {
        this.hasAfterMarshalCallback = true;
    }

    public void setBeforeMarshalCallback(Method method) {
        this.beforeMarshalCallback = method;
    }

    public void setHasBeforeMarshalCallback() {
        this.hasBeforeMarshalCallback = true;
    }

    public void setDomainClass(Class clazz) {
        this.domainClass = clazz;
        this.setDomainClassName(clazz.getName());
    }

    public void setDomainClassName(String string) {
        this.domainClassName = string;
    }
}

