/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import javax.xml.bind.Unmarshaller;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedGetMethod;

public class UnmarshalCallback {
    private Class domainClass;
    private String domainClassName;
    private Method afterUnmarshalCallback;
    private Method beforeUnmarshalCallback;
    private boolean hasAfterUnmarshalCallback = false;
    private boolean hasBeforeUnmarshalCallback = false;

    public Method getAfterUnmarshalCallback() {
        return this.afterUnmarshalCallback;
    }

    public Method getBeforeUnmarshalCallback() {
        return this.beforeUnmarshalCallback;
    }

    public Class getDomainClass() {
        return this.domainClass;
    }

    public void initialize(ClassLoader classLoader) {
        Method method;
        block22: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.domainClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.domainClassName, true, classLoader));
                        break block22;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (privilegedActionException.getCause() instanceof ClassNotFoundException) {
                            throw (ClassNotFoundException)privilegedActionException.getCause();
                        }
                        throw (RuntimeException)privilegedActionException.getCause();
                    }
                }
                this.domainClass = PrivilegedAccessHelper.getClassForName(this.domainClassName, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return;
            }
        }
        Class[] classArray = new Class[]{Unmarshaller.class, Object.class};
        if (this.hasBeforeUnmarshalCallback) {
            try {
                method = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        method = AccessController.doPrivileged(new PrivilegedGetMethod(this.domainClass, "beforeUnmarshal", classArray, false));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)privilegedActionException.getCause();
                        }
                        throw (RuntimeException)privilegedActionException.getCause();
                    }
                } else {
                    method = PrivilegedAccessHelper.getMethod(this.domainClass, "beforeUnmarshal", classArray, false);
                }
                this.setBeforeUnmarshalCallback(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (this.hasAfterUnmarshalCallback) {
            try {
                method = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        method = AccessController.doPrivileged(new PrivilegedGetMethod(this.domainClass, "afterUnmarshal", classArray, false));
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        if (privilegedActionException.getCause() instanceof NoSuchMethodException) {
                            throw (NoSuchMethodException)privilegedActionException.getCause();
                        }
                        throw (RuntimeException)privilegedActionException.getCause();
                    }
                } else {
                    method = PrivilegedAccessHelper.getMethod(this.domainClass, "afterUnmarshal", classArray, false);
                }
                this.setAfterUnmarshalCallback(method);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public void setAfterUnmarshalCallback(Method method) {
        this.afterUnmarshalCallback = method;
    }

    public void setHasAfterUnmarshalCallback() {
        this.hasAfterUnmarshalCallback = true;
    }

    public void setBeforeUnmarshalCallback(Method method) {
        this.beforeUnmarshalCallback = method;
    }

    public void setHasBeforeUnmarshalCallback() {
        this.hasBeforeUnmarshalCallback = true;
    }

    public void setDomainClass(Class clazz) {
        this.domainClass = clazz;
        this.setDomainClassName(clazz.getName());
    }

    public void setDomainClassName(String string) {
        this.domainClassName = string;
    }
}

