/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.mappings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.ReferenceResolver;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.queries.ObjectBuildingQuery;

public class XMLCollectionReferenceMapping
extends XMLObjectReferenceMapping
implements ContainerMapping {
    protected ContainerPolicy containerPolicy;
    private static final String SPACE = " ";
    private boolean usesSingleNode;

    public XMLCollectionReferenceMapping() {
        this.sourceToTargetKeyFieldAssociations = new HashMap();
        this.sourceToTargetKeys = new NonSynchronizedVector();
        this.containerPolicy = ContainerPolicy.buildDefaultPolicy();
        this.usesSingleNode = false;
    }

    public Object buildFieldValue(Object object, XMLField xMLField, AbstractSession abstractSession) {
        if (object == null || this.getReferenceClass() == null) {
            return null;
        }
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        ObjectBuilder objectBuilder = classDescriptor.getObjectBuilder();
        Vector vector = objectBuilder.extractPrimaryKeyFromObject(object, abstractSession);
        XMLField xMLField2 = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xMLField);
        int n = classDescriptor.getPrimaryKeyFields().indexOf(xMLField2);
        if (n == -1) {
            return null;
        }
        return vector.get(n);
    }

    public void buildReference(UnmarshalRecord unmarshalRecord, XMLField xMLField, Object object, AbstractSession abstractSession) {
        Vector vector;
        ReferenceResolver referenceResolver = ReferenceResolver.getInstance(abstractSession);
        if (referenceResolver == null) {
            return;
        }
        Object object2 = unmarshalRecord.getCurrentObject();
        Reference reference = referenceResolver.getReference(this, object2);
        if (reference == null) {
            reference = new Reference((XMLMapping)this, object2, this.getReferenceClass(), new HashMap());
            referenceResolver.addReference(reference);
        }
        XMLField xMLField2 = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xMLField);
        String string = xMLField2.getXPath();
        HashMap hashMap = reference.getPrimaryKeyMap();
        if (hashMap.containsKey(string)) {
            vector = (Vector)hashMap.get(string);
        } else {
            vector = new Vector();
            hashMap.put(string, vector);
        }
        ClassDescriptor classDescriptor = abstractSession.getClassDescriptor(this.getReferenceClass());
        Class clazz = classDescriptor.getTypedField(xMLField2).getType();
        XMLConversionManager xMLConversionManager = (XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager();
        StringTokenizer stringTokenizer = new StringTokenizer((String)object);
        while (stringTokenizer.hasMoreTokens()) {
            Object object3 = xMLConversionManager.convertObject(stringTokenizer.nextToken(), clazz);
            if (object3 == null) continue;
            vector.add(object3);
        }
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (containerPolicy != null && containerPolicy.getContainerClass() == null) {
            Class clazz = abstractSession.getDatasourcePlatform().getConversionManager().convertClassNameToClass(containerPolicy.getContainerClassName());
            containerPolicy.setContainerClass(clazz);
        }
    }

    public Object readFromRowIntoObject(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, AbstractSession abstractSession) throws DatabaseException {
        ClassDescriptor classDescriptor = objectBuildingQuery.getSession().getClassDescriptor(this.getReferenceClass());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Vector<String> vector = this.referenceDescriptor.getPrimaryKeyFieldNames();
        Vector vector2 = new Vector();
        vector2.setSize(vector.size());
        HashMap hashMap = new HashMap();
        for (XMLField xMLField : this.getFields()) {
            XMLField xMLField2 = (XMLField)this.getSourceToTargetKeyFieldAssociations().get(xMLField);
            Object object2 = abstractRecord.getValues(xMLField);
            if (object2 == null || object2 instanceof String || !(object2 instanceof Vector)) {
                return containerPolicy.containerInstance();
            }
            XMLConversionManager xMLConversionManager = (XMLConversionManager)abstractSession.getDatasourcePlatform().getConversionManager();
            Vector<Object> vector3 = new Vector<Object>();
            Iterator iterator = ((Vector)object2).iterator();
            while (iterator.hasNext()) {
                StringTokenizer stringTokenizer = new StringTokenizer((String)iterator.next());
                while (stringTokenizer.hasMoreTokens()) {
                    Object object3 = xMLConversionManager.convertObject(stringTokenizer.nextToken(), classDescriptor.getTypedField(xMLField2).getType());
                    if (object3 == null) continue;
                    vector3.add(object3);
                }
            }
            hashMap.put(xMLField2.getXPath(), vector3);
        }
        ReferenceResolver referenceResolver = ReferenceResolver.getInstance(objectBuildingQuery.getSession());
        if (referenceResolver != null) {
            referenceResolver.addReference(new Reference((XMLMapping)this, object, this.referenceClass, hashMap));
        }
        return null;
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        this.containerPolicy = containerPolicy;
        if (this.containerPolicy instanceof MapContainerPolicy) {
            ((MapContainerPolicy)this.containerPolicy).setElementClass(this.getReferenceClass());
        }
    }

    public void useCollectionClass(Class clazz) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(clazz));
    }

    public void useCollectionClassName(String string) {
        this.setContainerPolicy(new CollectionContainerPolicy(string));
    }

    public void useMapClass(Class clazz, String string) {
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(clazz);
        containerPolicy.setKeyName(string, this.getReferenceClass().getName());
        this.setContainerPolicy(containerPolicy);
    }

    public boolean usesSingleNode() {
        return this.usesSingleNode;
    }

    public void setUsesSingleNode(boolean bl) {
        this.usesSingleNode = bl;
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord abstractRecord, AbstractSession abstractSession) {
        for (XMLField xMLField : this.getFields()) {
            QName qName;
            Object object2;
            Object object3;
            Object object4;
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object5 = this.getAttributeAccessor().getAttributeValueFromObject(object);
            if (object5 == null) {
                return;
            }
            String string = "";
            Object object6 = containerPolicy.iteratorFor(object5);
            if (this.usesSingleNode()) {
                while (containerPolicy.hasNext(object6)) {
                    object4 = containerPolicy.next(object6, abstractSession);
                    object3 = this.buildFieldValue(object4, xMLField, abstractSession);
                    if (object3 == null || (object2 = this.getValueToWrite(qName = this.getSchemaType(xMLField, object3, abstractSession), object3, abstractSession)) == null) continue;
                    string = string + (String)object2;
                    if (!containerPolicy.hasNext(object6)) continue;
                    string = string + SPACE;
                }
                if (string.equals("")) continue;
                abstractRecord.put(xMLField, (Object)string);
                continue;
            }
            object2 = new ArrayList();
            while (containerPolicy.hasNext(object6)) {
                object4 = containerPolicy.next(object6, abstractSession);
                object3 = this.buildFieldValue(object4, xMLField, abstractSession);
                if (object3 == null) continue;
                qName = this.getSchemaType(xMLField, object3, abstractSession);
                string = this.getValueToWrite(qName, object3, abstractSession);
                ((ArrayList)object2).add(string);
            }
            abstractRecord.put(xMLField, object2);
        }
    }

    public void writeSingleValue(Object object, Object object2, XMLRecord xMLRecord, AbstractSession abstractSession) {
        for (XMLField xMLField : this.getFields()) {
            Object object3 = this.buildFieldValue(object, xMLField, abstractSession);
            if (object3 == null) continue;
            QName qName = this.getSchemaType(xMLField, object3, abstractSession);
            String string = this.getValueToWrite(qName, object3, abstractSession);
            xMLRecord.add(xMLField, string);
        }
    }

    public boolean isCollectionMapping() {
        return true;
    }
}

