/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.NullCapableValue;
import org.eclipse.persistence.internal.oxm.Reference;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.record.ObjectUnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.SequencedUnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmappedContentHandlerWrapper;
import org.eclipse.persistence.internal.oxm.record.UnmarshalContext;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractTransformationMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.eclipse.persistence.oxm.record.XMLRecord;
import org.eclipse.persistence.oxm.unmapped.DefaultUnmappedContentHandler;
import org.eclipse.persistence.oxm.unmapped.UnmappedContentHandler;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class UnmarshalRecord
extends XMLRecord
implements ContentHandler,
LexicalHandler {
    protected static final String EMPTY_STRING = "";
    public static final UnmappedContentHandler DEFAULT_UNMAPPED_CONTENT_HANDLER = new DefaultUnmappedContentHandler();
    private XMLReader xmlReader;
    private TreeObjectBuilder treeObjectBuilder;
    private XPathFragment xPathFragment = new XPathFragment();
    private XPathNode xPathNode;
    private int levelIndex = 0;
    private UnmarshalRecord childRecord;
    private UnmarshalRecord parentRecord;
    private DOMRecord transformationRecord;
    private List selfRecords;
    private Map indexMap;
    private Map namespaceMap;
    private Map uriToPrefixMap;
    private List nullCapableValues;
    private Map containersMap;
    private StrBuffer stringBuffer = new StrBuffer();
    private boolean isBufferCDATA = false;
    private Attributes attributes;
    private QName typeQName;
    private String rootElementName;
    private String rootElementNamespaceUri;
    private XMLUnmarshaller unmarshaller;
    private SAXFragmentBuilder fragmentBuilder;
    private String encoding;
    private String version;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private boolean isSelfRecord;
    private UnmarshalContext unmarshalContext;

    public UnmarshalRecord(TreeObjectBuilder treeObjectBuilder) {
        this.treeObjectBuilder = treeObjectBuilder;
        this.nullCapableValues = new ArrayList();
        if (null != treeObjectBuilder) {
            this.xPathNode = treeObjectBuilder.getRootXPathNode();
            if (null != treeObjectBuilder.getNullCapableValues()) {
                this.nullCapableValues.addAll(treeObjectBuilder.getNullCapableValues());
            }
        }
        this.fragmentBuilder = new SAXFragmentBuilder(this);
        this.isSelfRecord = false;
    }

    public String getLocalName() {
        throw XMLMarshalException.operationNotSupported("getLocalName");
    }

    public String getNamespaceURI() {
        throw XMLMarshalException.operationNotSupported("getNamespaceURI");
    }

    public void clear() {
        throw XMLMarshalException.operationNotSupported("clear");
    }

    public Document getDocument() {
        throw XMLMarshalException.operationNotSupported("getDocument");
    }

    public Element getDOM() {
        throw XMLMarshalException.operationNotSupported("getDOM");
    }

    public String transformToXML() {
        throw XMLMarshalException.operationNotSupported("transformToXML");
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public void setXMLReader(XMLReader xMLReader) {
        this.xmlReader = xMLReader;
    }

    public UnmarshalRecord getChildRecord() {
        return this.childRecord;
    }

    public void setChildRecord(UnmarshalRecord unmarshalRecord) {
        this.childRecord = unmarshalRecord;
        if (null != unmarshalRecord) {
            unmarshalRecord.setParentRecord(this);
            unmarshalRecord.session = this.session;
            unmarshalRecord.xmlReader = this.xmlReader;
            unmarshalRecord.setFragmentBuilder(this.getFragmentBuilder());
        }
    }

    public UnmarshalRecord getParentRecord() {
        return this.parentRecord;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public String getRootElementNamespaceUri() {
        return this.rootElementNamespaceUri;
    }

    public void setParentRecord(UnmarshalRecord unmarshalRecord) {
        this.parentRecord = unmarshalRecord;
    }

    public DOMRecord getTransformationRecord() {
        return this.transformationRecord;
    }

    public void setTransformationRecord(DOMRecord dOMRecord) {
        this.transformationRecord = dOMRecord;
    }

    public Map getNamespaceMap() {
        return this.namespaceMap;
    }

    public void setNamespaceMap(Map map) {
        this.namespaceMap = map;
    }

    public Map getUriToPrefixMap() {
        return this.uriToPrefixMap;
    }

    public void setUriToPrefixMap(Map map) {
        this.uriToPrefixMap = map;
    }

    public List getNullCapableValues() {
        return this.nullCapableValues;
    }

    public void removeNullCapableValue(NullCapableValue nullCapableValue) {
        this.getNullCapableValues().remove(nullCapableValue);
    }

    public Object getContainerInstance(ContainerValue containerValue) {
        if (null == this.containersMap) {
            return null;
        }
        return this.containersMap.get(containerValue);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public void setNoNamespaceSchemaLocation(String string) {
        this.noNamespaceSchemaLocation = string;
    }

    public StrBuffer getStringBuffer() {
        return this.stringBuffer;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName qName) {
        this.typeQName = qName;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.getParentRecord() == null && locator instanceof Locator2) {
            Locator2 locator2 = (Locator2)locator;
            this.setEncoding(locator2.getEncoding());
            this.setVersion(locator2.getXMLVersion());
        }
    }

    public Object get(DatabaseField databaseField) {
        XMLField xMLField = this.convertToXMLField(databaseField);
        XPathFragment xPathFragment = xMLField.getLastXPathFragment();
        NamespaceResolver namespaceResolver = xMLField.getNamespaceResolver();
        String string = EMPTY_STRING;
        if (null != namespaceResolver && null == (string = namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix()))) {
            string = EMPTY_STRING;
        }
        return this.attributes.getValue(string, xPathFragment.getLocalName());
    }

    public XPathNode getXPathNode() {
        return this.xPathNode;
    }

    public void startDocument() throws SAXException {
        this.startDocument(null);
    }

    public void startDocument(XMLMapping xMLMapping) throws SAXException {
        try {
            Object object;
            int n;
            XMLDescriptor xMLDescriptor = (XMLDescriptor)this.treeObjectBuilder.getDescriptor();
            this.unmarshalContext = xMLDescriptor.isSequencedObject() ? new SequencedUnmarshalContext() : ObjectUnmarshalContext.getInstance();
            Object object2 = this.getXMLReader().getCurrentObject(this.session, xMLMapping);
            if (object2 == null) {
                object2 = this.treeObjectBuilder.buildNewInstance();
            }
            this.setCurrentObject(object2);
            if (this.unmarshaller != null && this.unmarshaller.getUnmarshalListener() != null) {
                if (this.parentRecord != null) {
                    this.unmarshaller.getUnmarshalListener().beforeUnmarshal(object2, this.parentRecord.getCurrentObject());
                } else {
                    this.unmarshaller.getUnmarshalListener().beforeUnmarshal(object2, null);
                }
            }
            if (this.parentRecord != null) {
                this.xmlReader.newObjectEvent(object2, this.parentRecord.getCurrentObject(), xMLMapping);
            } else {
                this.xmlReader.newObjectEvent(object2, null, xMLMapping);
            }
            List list = this.treeObjectBuilder.getContainerValues();
            if (null != list) {
                this.containersMap = new HashMap(list.size());
                n = list.size();
                for (int i = 0; i < n; ++i) {
                    ContainerValue containerValue = (ContainerValue)list.get(i);
                    object = containerValue.getContainerInstance();
                    this.containersMap.put(containerValue, object);
                }
            }
            if (null != this.xPathNode.getSelfChildren()) {
                int n2 = this.xPathNode.getSelfChildren().size();
                this.selfRecords = new ArrayList(n2);
                for (n = 0; n < n2; ++n) {
                    object = (XPathNode)this.xPathNode.getSelfChildren().get(n);
                    if (null == ((XPathNode)object).getNodeValue()) continue;
                    this.selfRecords.add(((XPathNode)object).getNodeValue().buildSelfRecord(this, this.attributes));
                }
            }
        }
        catch (EclipseLinkException eclipseLinkException) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw eclipseLinkException;
            }
            SAXParseException sAXParseException = new SAXParseException(null, null, null, 0, 0, eclipseLinkException);
            this.xmlReader.getErrorHandler().error(sAXParseException);
        }
    }

    public void endDocument() throws SAXException {
        XMLDescriptor xMLDescriptor;
        Object object;
        Object object2 = this.getCurrentObject();
        if (null != this.selfRecords) {
            int n = this.selfRecords.size();
            for (int i = 0; i < n; ++i) {
                ((UnmarshalRecord)this.selfRecords.get(i)).endDocument();
            }
        }
        try {
            Cloneable cloneable;
            if (null != this.containersMap) {
                for (ContainerValue containerValue : this.containersMap.keySet()) {
                    Object v = this.containersMap.get(containerValue);
                    containerValue.setContainerInstance(object2, v);
                }
            }
            int n = this.getNullCapableValues().size();
            for (int i = 0; i < n; ++i) {
                NullCapableValue nullCapableValue = (NullCapableValue)this.getNullCapableValues().get(i);
                nullCapableValue.setNullValue(object2, this.session);
            }
            object = this.treeObjectBuilder.getTransformationMappings();
            if (null != object) {
                cloneable = new ReadObjectQuery();
                ((DatabaseQuery)cloneable).setSession(this.session);
                int n2 = object.size();
                for (int i = 0; i < n2; ++i) {
                    AbstractTransformationMapping abstractTransformationMapping = (AbstractTransformationMapping)object.get(i);
                    abstractTransformationMapping.readFromRowIntoObject(this.transformationRecord, null, object2, (ObjectBuildingQuery)cloneable, this.session);
                }
            }
            if (this.unmarshaller != null && this.unmarshaller.getUnmarshalListener() != null) {
                if (this.parentRecord != null) {
                    this.unmarshaller.getUnmarshalListener().afterUnmarshal(object2, this.parentRecord.getCurrentObject());
                } else {
                    this.unmarshaller.getUnmarshalListener().afterUnmarshal(object2, null);
                }
            }
            if ((cloneable = (XMLDescriptor)this.session.getDescriptor(object2)) != null && ((ClassDescriptor)cloneable).getEventManager().hasAnyEventListeners()) {
                DescriptorEvent descriptorEvent = new DescriptorEvent(object2);
                descriptorEvent.setSession(this.session);
                descriptorEvent.setRecord(this);
                descriptorEvent.setEventCode(8);
                ((ClassDescriptor)cloneable).getEventManager().executeEvent(descriptorEvent);
            }
        }
        catch (EclipseLinkException eclipseLinkException) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw eclipseLinkException;
            }
            SAXParseException sAXParseException = new SAXParseException(null, null, null, 0, 0, eclipseLinkException);
            this.xmlReader.getErrorHandler().error(sAXParseException);
        }
        if (this.session.isUnitOfWork() && (xMLDescriptor = (XMLDescriptor)this.session.getDescriptor(object2)) != null && xMLDescriptor.getPrimaryKeyFieldNames().size() > 0) {
            Vector vector = this.treeObjectBuilder.extractPrimaryKeyFromObject(object2, this.session);
            object = this.session.getIdentityMapAccessorInstance().acquireDeferredLock(vector, xMLDescriptor.getJavaClass(), xMLDescriptor);
            ((CacheKey)object).setRecord(this);
            ((CacheKey)object).setObject(object2);
            ((CacheKey)object).releaseDeferredLock();
        }
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        Stack<String> stack;
        if (null == this.namespaceMap) {
            this.namespaceMap = new HashMap();
        }
        if (this.uriToPrefixMap == null) {
            this.uriToPrefixMap = new HashMap();
        }
        if ((stack = (Stack<String>)this.namespaceMap.get(string)) == null) {
            stack = new Stack<String>();
            this.namespaceMap.put(string, stack);
        }
        stack.push(string2);
        Stack<String> stack2 = (Stack<String>)this.uriToPrefixMap.get(string2);
        if (stack2 == null) {
            stack2 = new Stack<String>();
            this.uriToPrefixMap.put(string2, stack2);
        }
        stack2.push(string);
    }

    public void endPrefixMapping(String string) throws SAXException {
        Stack stack;
        if (null == this.namespaceMap) {
            return;
        }
        Stack stack2 = (Stack)this.namespaceMap.get(string);
        String string2 = null;
        if (stack2 != null && stack2.size() > 0) {
            string2 = (String)stack2.pop();
        }
        if (string2 != null && this.uriToPrefixMap != null && (stack = (Stack)this.uriToPrefixMap.get(string2)) != null && stack.size() > 0) {
            stack.pop();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (null != this.xPathNode.getXPathFragment() && this.xPathNode.getXPathFragment().nameIsText() && null != this.xPathNode.getUnmarshalNodeValue()) {
            this.xPathNode.getUnmarshalNodeValue().endElement(this.xPathFragment, this);
            if (this.xPathNode.getParent() != null) {
                this.xPathNode = this.xPathNode.getParent();
            }
        }
        if (this.rootElementName == null) {
            this.rootElementName = string3;
            this.rootElementNamespaceUri = string;
            this.schemaLocation = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
            this.noNamespaceSchemaLocation = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation");
        }
        try {
            XPathNode xPathNode;
            if (null != this.selfRecords) {
                int n = this.selfRecords.size();
                for (int i = 0; i < n; ++i) {
                    ((UnmarshalRecord)this.selfRecords.get(i)).startElement(string, string2, string3, attributes);
                }
            }
            if (null == (xPathNode = this.getNonAttributeXPathNode(string, string2, string3))) {
                NodeValue nodeValue = this.xPathNode.getUnmarshalNodeValue();
                if (null == this.xPathNode.getXPathFragment() && nodeValue != null) {
                    XPathFragment xPathFragment = new XPathFragment();
                    if (EMPTY_STRING.equals(string)) {
                        xPathFragment.setLocalName(string3);
                        xPathFragment.setNamespaceURI(null);
                    } else {
                        xPathFragment.setLocalName(string2);
                        xPathFragment.setNamespaceURI(string);
                    }
                    if (nodeValue.startElement(xPathFragment, this, attributes)) {
                        ++this.levelIndex;
                        return;
                    }
                    this.startUnmappedElement(string, string2, string3, attributes);
                    return;
                }
                ++this.levelIndex;
                this.startUnmappedElement(string, string2, string3, attributes);
                return;
            }
            this.xPathNode = xPathNode;
            this.unmarshalContext.startElement(this);
            ++this.levelIndex;
            NodeValue nodeValue = xPathNode.getUnmarshalNodeValue();
            if (null != nodeValue && !nodeValue.startElement(this.xPathFragment, this, attributes)) {
                this.startUnmappedElement(string, string2, string3, attributes);
                return;
            }
            int n = 0;
            while (n < attributes.getLength()) {
                String string4;
                String string5 = attributes.getURI(n);
                String string6 = attributes.getLocalName(n);
                String string7 = attributes.getValue(n);
                NodeValue nodeValue2 = null;
                if ((string6 == null || string6.length() == 0) && (string4 = attributes.getQName(n)) != null && string4.length() > 0) {
                    String string8;
                    int n2 = string4.indexOf(":");
                    string6 = string4.substring(n2 <= 0 ? 0 : n2 + 1, string4.length());
                    String string9 = string8 = n2 == -1 ? null : string4.substring(0, n2);
                    if (string8 != null && string8.equalsIgnoreCase("xmlns") || string8 == null && string6.equalsIgnoreCase("xmlns")) {
                        string5 = "http://www.w3.org/2000/xmlns/";
                    }
                }
                if (this.selfRecords != null) {
                    for (int i = 0; i < this.selfRecords.size(); ++i) {
                        UnmarshalRecord unmarshalRecord = (UnmarshalRecord)this.selfRecords.get(i);
                        nodeValue2 = unmarshalRecord.getAttributeChildNodeValue(string5, string6);
                        if (nodeValue2 == null) continue;
                        nodeValue2.attribute(unmarshalRecord, string5, string6, string7);
                    }
                }
                if (nodeValue2 == null) {
                    nodeValue2 = this.getAttributeChildNodeValue(string5, string6);
                    if (nodeValue2 != null) {
                        nodeValue2.attribute(this, string5, string6, string7);
                    } else if (this.xPathNode.getAnyAttributeNodeValue() != null) {
                        this.xPathNode.getAnyAttributeNodeValue().attribute(this, string5, string6, string7);
                    }
                }
                ++n;
            }
            return;
        }
        catch (EclipseLinkException eclipseLinkException) {
            if (null == this.xmlReader) throw eclipseLinkException;
            if (null == this.xmlReader.getErrorHandler()) {
                throw eclipseLinkException;
            }
            SAXParseException sAXParseException = new SAXParseException(null, null, null, 0, 0, eclipseLinkException);
            this.xmlReader.getErrorHandler().error(sAXParseException);
        }
    }

    public void startUnmappedElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        UnmappedContentHandler unmappedContentHandler;
        if (null != this.selfRecords || null == this.xmlReader || this.isSelfRecord()) {
            return;
        }
        Class clazz = this.unmarshaller.getUnmappedContentHandlerClass();
        if (null == clazz) {
            unmappedContentHandler = DEFAULT_UNMAPPED_CONTENT_HANDLER;
        } else {
            try {
                object = new PrivilegedNewInstanceFromClass(clazz);
                unmappedContentHandler = (UnmappedContentHandler)((PrivilegedNewInstanceFromClass)object).run();
            }
            catch (ClassCastException classCastException) {
                throw XMLMarshalException.unmappedContentHandlerDoesntImplement(classCastException, clazz.getName());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(illegalAccessException, clazz.getName());
            }
            catch (InstantiationException instantiationException) {
                throw XMLMarshalException.errorInstantiatingUnmappedContentHandler(instantiationException, clazz.getName());
            }
        }
        object = new UnmappedContentHandlerWrapper(this, unmappedContentHandler);
        ((UnmappedContentHandlerWrapper)object).startElement(string, string2, string3, attributes);
        this.xmlReader.setContentHandler((ContentHandler)object);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            if (null != this.selfRecords) {
                int n = this.selfRecords.size();
                for (int i = 0; i < n; ++i) {
                    ((UnmarshalRecord)this.selfRecords.get(i)).endElement(string, string2, string3);
                }
            }
            if (null != this.xPathNode.getUnmarshalNodeValue()) {
                this.xPathNode.getUnmarshalNodeValue().endElement(this.xPathFragment, this);
                if (this.xPathNode.getParent() != null) {
                    this.xPathNode = this.xPathNode.getParent();
                }
            }
            if (null != this.xPathNode.getParent()) {
                if (EMPTY_STRING.equals(string)) {
                    this.xPathFragment.setLocalName(string3);
                    this.xPathFragment.setNamespaceURI(null);
                } else {
                    this.xPathFragment.setLocalName(string2);
                    this.xPathFragment.setNamespaceURI(string);
                }
                if (this.xPathFragment.qNameEquals(this.xPathNode.getXPathFragment()) && this.xPathNode.getParent() != null) {
                    this.xPathNode = this.xPathNode.getParent();
                }
            }
            this.unmarshalContext.endElement(this);
            this.typeQName = null;
            --this.levelIndex;
            if (0 == this.levelIndex && null != this.getParentRecord() && !this.isSelfRecord()) {
                this.endDocument();
                UnmarshalRecord unmarshalRecord = this.getParentRecord();
                while (unmarshalRecord.isSelfRecord()) {
                    unmarshalRecord = unmarshalRecord.getParentRecord();
                }
                unmarshalRecord.endElement(string, string2, string3);
                this.xmlReader.setContentHandler(unmarshalRecord);
            }
        }
        catch (EclipseLinkException eclipseLinkException) {
            if (null == this.xmlReader || null == this.xmlReader.getErrorHandler()) {
                throw eclipseLinkException;
            }
            SAXParseException sAXParseException = new SAXParseException(null, null, null, 0, 0, eclipseLinkException);
            this.xmlReader.getErrorHandler().error(sAXParseException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            if (null != this.selfRecords) {
                int n3 = this.selfRecords.size();
                for (int i = 0; i < n3; ++i) {
                    ((UnmarshalRecord)this.selfRecords.get(i)).characters(cArray, n, n2);
                }
            }
            XPathNode xPathNode = null;
            if (null != this.xPathNode.getNonAttributeChildrenMap() && null == (xPathNode = (XPathNode)this.xPathNode.getNonAttributeChildrenMap().get(XPathFragment.TEXT_FRAGMENT)) && (xPathNode = (XPathNode)this.xPathNode.getNonAttributeChildrenMap().get(XPathFragment.ANY_FRAGMENT)) != null) {
                if (0 == n2) {
                    return;
                }
                String string = new String(cArray, n, n2);
                if (EMPTY_STRING.equals(string.trim())) {
                    return;
                }
            }
            if (null != xPathNode) {
                this.xPathNode = xPathNode;
                this.unmarshalContext.characters(this);
            }
            if (null != this.xPathNode.getUnmarshalNodeValue()) {
                this.stringBuffer.append(cArray, n, n2);
            }
        }
        catch (EclipseLinkException eclipseLinkException) {
            if (null == this.xmlReader.getErrorHandler()) {
                throw eclipseLinkException;
            }
            SAXParseException sAXParseException = new SAXParseException(null, null, null, 0, 0, eclipseLinkException);
            this.xmlReader.getErrorHandler().error(sAXParseException);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    protected XPathNode getNonAttributeXPathNode(String string, String string2, String string3) {
        if (0 == this.levelIndex) {
            return this.xPathNode;
        }
        if (EMPTY_STRING.equals(string)) {
            this.xPathFragment.setLocalName(string3);
            this.xPathFragment.setNamespaceURI(null);
        } else {
            this.xPathFragment.setLocalName(string2);
            this.xPathFragment.setNamespaceURI(string);
        }
        XPathNode xPathNode = null;
        Map map = this.xPathNode.getNonAttributeChildrenMap();
        if (null != map && null == (xPathNode = (XPathNode)map.get(this.xPathFragment))) {
            Object object;
            Integer n;
            if (null == this.indexMap) {
                this.indexMap = new HashMap();
                n = new Integer(1);
            } else {
                object = (Integer)this.indexMap.get(this.xPathFragment);
                n = null == object ? new Integer(1) : new Integer((Integer)object + 1);
            }
            this.indexMap.put(this.xPathFragment, n);
            object = new XPathFragment();
            ((XPathFragment)object).setNamespaceURI(this.xPathFragment.getNamespaceURI());
            ((XPathFragment)object).setLocalName(this.xPathFragment.getLocalName());
            ((XPathFragment)object).setIndexValue(n);
            xPathNode = (XPathNode)map.get(object);
            if (null == xPathNode) {
                xPathNode = (XPathNode)map.get(XPathFragment.ANY_FRAGMENT);
            }
        }
        return xPathNode;
    }

    public String resolveNamespacePrefix(String string) {
        Stack stack;
        String string2 = null;
        if (string == null) {
            string = EMPTY_STRING;
        }
        if (null != this.namespaceMap && (stack = (Stack)this.namespaceMap.get(string)) != null && stack.size() > 0) {
            string2 = (String)stack.peek();
        }
        if (null == string2 && null != this.getParentRecord()) {
            string2 = this.getParentRecord().resolveNamespacePrefix(string);
        }
        return string2;
    }

    public String resolveNamespaceUri(String string) {
        Stack stack;
        String string2 = null;
        if (null != this.uriToPrefixMap && (stack = (Stack)this.uriToPrefixMap.get(string)) != null && stack.size() > 0) {
            string2 = (String)stack.peek();
        }
        if (null == string2 && null != this.getParentRecord()) {
            string2 = this.getParentRecord().resolveNamespaceUri(string);
        }
        return string2;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(Helper.getShortClassName(this.getClass()));
        stringWriter.write("()");
        return stringWriter.toString();
    }

    public NodeValue getSelfNodeValueForAttribute(String string, String string2) {
        if (this.selfRecords != null) {
            for (int i = 0; i < this.selfRecords.size(); ++i) {
                UnmarshalRecord unmarshalRecord = (UnmarshalRecord)this.selfRecords.get(i);
                NodeValue nodeValue = unmarshalRecord.getAttributeChildNodeValue(string, string2);
                if (nodeValue == null) continue;
                return nodeValue;
            }
        }
        return null;
    }

    public NodeValue getAttributeChildNodeValue(String string, String string2) {
        Map map = this.xPathNode.getAttributeChildrenMap();
        if (map != null) {
            this.xPathFragment.setLocalName(string2);
            if (EMPTY_STRING.equals(string)) {
                this.xPathFragment.setNamespaceURI(null);
            } else {
                this.xPathFragment.setNamespaceURI(string);
            }
            XPathNode xPathNode = (XPathNode)map.get(this.xPathFragment);
            if (xPathNode != null) {
                return xPathNode.getUnmarshalNodeValue();
            }
        }
        return null;
    }

    public XMLUnmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(XMLUnmarshaller xMLUnmarshaller) {
        this.unmarshaller = xMLUnmarshaller;
    }

    public SAXFragmentBuilder getFragmentBuilder() {
        return this.fragmentBuilder;
    }

    public void setFragmentBuilder(SAXFragmentBuilder sAXFragmentBuilder) {
        this.fragmentBuilder = sAXFragmentBuilder;
    }

    public void resetStringBuffer() {
        this.getStringBuffer().reset();
        this.isBufferCDATA = false;
    }

    public boolean isBufferCDATA() {
        return this.isBufferCDATA;
    }

    public void comment(char[] cArray, int n, int n2) {
    }

    public void startCDATA() {
        if (this.xPathNode.getUnmarshalNodeValue() != null) {
            this.isBufferCDATA = true;
        }
    }

    public void endCDATA() {
    }

    public void startEntity(String string) {
    }

    public void endEntity(String string) {
    }

    public void startDTD(String string, String string2, String string3) {
    }

    public void endDTD() {
    }

    public void setSelfRecord(boolean bl) {
        this.isSelfRecord = bl;
    }

    public boolean isSelfRecord() {
        return this.isSelfRecord;
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public void setAttributeValue(Object object, DatabaseMapping databaseMapping) {
        this.unmarshalContext.setAttributeValue(this, object, databaseMapping);
    }

    public void addAttributeValue(ContainerValue containerValue, Object object) {
        this.unmarshalContext.addAttributeValue(this, containerValue, object);
    }

    public void addAttributeValue(ContainerValue containerValue, Object object, Object object2) {
        this.unmarshalContext.addAttributeValue(this, containerValue, object, object2);
    }

    public void reference(Reference reference) {
        this.unmarshalContext.reference(reference);
    }

    public void unmappedContent() {
        this.unmarshalContext.unmappedContent(this);
    }
}

