/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class WriterRecord
extends MarshalRecord {
    protected Writer writer;
    protected boolean isStartElementOpen = false;
    protected boolean isProcessingCData = false;

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void startDocument(String string, String string2) {
        try {
            this.writer.write("<?xml version=\"");
            this.writer.write(string2);
            this.writer.write("\"");
            if (null != string) {
                this.writer.write(" encoding=\"");
                this.writer.write(string);
                this.writer.write("\"");
            }
            this.writer.write("?>");
            this.writer.write(Helper.cr());
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void endDocument() {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
            }
            this.isStartElementOpen = true;
            this.writer.write(60);
            this.writer.write(xPathFragment.getShortName());
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void element(String string, String string2, String string3) {
        try {
            if (this.isStartElementOpen) {
                this.writer.write(62);
                this.isStartElementOpen = false;
            }
            this.getWriter().write(60);
            this.getWriter().write(string3);
            this.getWriter().write(47);
            this.getWriter().write(62);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String string) {
        this.attribute(null, xPathFragment.getLocalName(), xPathFragment.getShortName(), string);
    }

    public void attribute(String string, String string2, String string3, String string4) {
        try {
            this.writer.write(32);
            this.writer.write(string3);
            this.writer.write(61);
            this.writer.write(34);
            this.writeValue(string4);
            this.writer.write(34);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void closeStartElement() {
    }

    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            if (this.isStartElementOpen) {
                this.writer.write(47);
                this.writer.write(62);
                this.isStartElementOpen = false;
            } else {
                this.writer.write(60);
                this.writer.write(47);
                this.writer.write(xPathFragment.getShortName());
                this.writer.write(62);
            }
            this.isStartElementOpen = false;
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void characters(String string) {
        try {
            if (this.isStartElementOpen) {
                this.isStartElementOpen = false;
                this.writer.write(62);
            }
            this.writeValue(string);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void cdata(String string) {
        try {
            if (this.isStartElementOpen) {
                this.isStartElementOpen = false;
                this.writer.write(62);
            }
            String string2 = "<![CDATA[" + string + "]]>";
            this.writer.write(string2);
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    protected void writeValue(String string) {
        try {
            block6: for (char c : string.toCharArray()) {
                switch (c) {
                    case '&': {
                        this.writer.write("&amp;");
                        continue block6;
                    }
                    case '<': {
                        this.writer.write("&lt;");
                        continue block6;
                    }
                    default: {
                        this.writer.write(c);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw XMLMarshalException.marshalException(iOException);
        }
    }

    public void node(Node node, NamespaceResolver namespaceResolver) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String string = null;
            if (namespaceResolver != null) {
                string = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (string != null) {
                this.attribute(attr.getNamespaceURI(), "", string + ":" + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                WriterRecordContentHandler writerRecordContentHandler = new WriterRecordContentHandler();
                XMLFragmentReader xMLFragmentReader = new XMLFragmentReader(namespaceResolver);
                xMLFragmentReader.setContentHandler(writerRecordContentHandler);
                xMLFragmentReader.setProperty("http://xml.org/sax/properties/lexical-handler", writerRecordContentHandler);
                xMLFragmentReader.parse(node);
            }
            catch (SAXException sAXException) {
                throw XMLMarshalException.marshalException(sAXException);
            }
        }
    }

    protected class WriterRecordContentHandler
    implements ContentHandler,
    LexicalHandler {
        Map<String, String> prefixMappings = new HashMap<String, String>();

        WriterRecordContentHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (WriterRecord.this.isStartElementOpen) {
                    WriterRecord.this.getWriter().write(62);
                }
                WriterRecord.this.getWriter().write(60);
                WriterRecord.this.getWriter().write(string3);
                WriterRecord.this.isStartElementOpen = true;
                this.handleAttributes(attributes);
                this.writePrefixMappings();
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            try {
                if (WriterRecord.this.isStartElementOpen) {
                    WriterRecord.this.getWriter().write(47);
                    WriterRecord.this.getWriter().write(62);
                } else {
                    WriterRecord.this.getWriter().write(60);
                    WriterRecord.this.getWriter().write(47);
                    WriterRecord.this.getWriter().write(string3);
                    WriterRecord.this.getWriter().write(62);
                }
                WriterRecord.this.isStartElementOpen = false;
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            String string3 = WriterRecord.this.getNamespaceResolver().resolveNamespacePrefix(string);
            if (string3 == null || !string3.equals(string2)) {
                this.prefixMappings.put(string, string2);
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (WriterRecord.this.isProcessingCData) {
                WriterRecord.this.cdata(new String(cArray, n, n2));
                return;
            }
            if (WriterRecord.this.isStartElementOpen) {
                try {
                    WriterRecord.this.getWriter().write(62);
                    WriterRecord.this.isStartElementOpen = false;
                }
                catch (IOException iOException) {
                    throw XMLMarshalException.marshalException(iOException);
                }
            }
            WriterRecord.this.writeValue(new String(cArray, n, n2));
        }

        public void comment(char[] cArray, int n, int n2) throws SAXException {
            try {
                if (WriterRecord.this.isStartElementOpen) {
                    WriterRecord.this.getWriter().write(62);
                    WriterRecord.this.isStartElementOpen = false;
                }
                this.writeComment(cArray, n, n2);
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
        }

        public void startCDATA() throws SAXException {
            WriterRecord.this.isProcessingCData = true;
        }

        public void endCDATA() throws SAXException {
            WriterRecord.this.isProcessingCData = false;
        }

        protected void writePrefixMappings() {
            try {
                if (!this.prefixMappings.isEmpty()) {
                    for (String string : this.prefixMappings.keySet()) {
                        WriterRecord.this.getWriter().write(32);
                        WriterRecord.this.getWriter().write("xmlns");
                        if (!string.equals("")) {
                            WriterRecord.this.getWriter().write(":");
                            WriterRecord.this.getWriter().write(string);
                        }
                        WriterRecord.this.getWriter().write(61);
                        WriterRecord.this.getWriter().write(34);
                        WriterRecord.this.getWriter().write(this.prefixMappings.get(string));
                        WriterRecord.this.getWriter().write(34);
                    }
                    this.prefixMappings.clear();
                }
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
        }

        protected void handleAttributes(Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getQName(i) != null && (attributes.getQName(i).startsWith("xmlns:") || attributes.getQName(i).equals("xmlns"))) continue;
                WriterRecord.this.attribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i));
            }
        }

        protected void writeComment(char[] cArray, int n, int n2) {
            try {
                WriterRecord.this.getWriter().write(60);
                WriterRecord.this.getWriter().write(33);
                WriterRecord.this.getWriter().write(45);
                WriterRecord.this.getWriter().write(45);
                for (int i = n; i < n2; ++i) {
                    WriterRecord.this.getWriter().write(cArray[i]);
                }
                WriterRecord.this.getWriter().write(45);
                WriterRecord.this.getWriter().write(45);
                WriterRecord.this.getWriter().write(62);
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
        }

        protected void writeCharacters(char[] cArray, int n, int n2) {
            try {
                for (int i = n; i < n2; ++i) {
                    WriterRecord.this.getWriter().write(cArray[i]);
                }
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
        }

        public void endDocument() throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void startEntity(String string) throws SAXException {
        }

        public void endEntity(String string) throws SAXException {
        }

        public void startDTD(String string, String string2, String string3) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }
    }
}

