/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.queries.ValueReadQuery;

public class InformixPlatform
extends DatabasePlatform {
    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendInformixTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printTimestampWithoutNanos(timestamp));
        writer.write(46);
        String string = Integer.toString(timestamp.getNanos());
        int n = 0;
        for (int i = Math.min(9 - string.length(), 3); i > 0; --i) {
            writer.write(48);
            ++n;
        }
        if (string.length() + n > 3) {
            string = string.substring(0, 3 - n);
        }
        writer.write(string);
        writer.write("'");
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendInformixCalendar(calendar, writer);
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected void appendInformixCalendar(Calendar calendar, Writer writer) throws IOException {
        writer.write("'");
        writer.write(Helper.printCalendar(calendar));
        writer.write("'");
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendInformixTimestamp(timestamp, writer);
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> hashtable = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        hashtable.put(Boolean.class, new FieldTypeDefinition("SMALLINT default 0", false));
        hashtable.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(Long.class, new FieldTypeDefinition("NUMERIC", 19));
        hashtable.put(Float.class, new FieldTypeDefinition("FLOAT(16)", false));
        hashtable.put(Double.class, new FieldTypeDefinition("DECIMAL(32)", false));
        hashtable.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(BigInteger.class, new FieldTypeDefinition("DECIMAL", 32));
        hashtable.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 32).setLimits(32, -19, 19));
        hashtable.put(Number.class, new FieldTypeDefinition("DECIMAL", 32).setLimits(32, -19, 19));
        hashtable.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(Byte[].class, new FieldTypeDefinition("BYTE", false));
        hashtable.put(Character[].class, new FieldTypeDefinition("TEXT", false));
        hashtable.put(byte[].class, new FieldTypeDefinition("BYTE", false));
        hashtable.put(char[].class, new FieldTypeDefinition("TEXT", false));
        hashtable.put(Blob.class, new FieldTypeDefinition("BYTE", false));
        hashtable.put(Clob.class, new FieldTypeDefinition("TEXT", false));
        hashtable.put(Date.class, new FieldTypeDefinition("DATE", false));
        hashtable.put(Time.class, new FieldTypeDefinition("DATETIME HOUR TO SECOND", false));
        hashtable.put(Timestamp.class, new FieldTypeDefinition("DATETIME YEAR TO FRACTION(5)", false));
        return hashtable;
    }

    public ValueReadQuery buildSelectQueryForIdentity() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("SELECT DISTINCT(DBINFO('sqlca.sqlerrd1')) FROM systables");
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    public int getMaxFieldNameSize() {
        return 18;
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public boolean isInformix() {
        return true;
    }

    public boolean isInformixOuterJoin() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MAX_VALUE));
        hashtable.put(Long.class, new Long(Long.MAX_VALUE));
        hashtable.put(Double.class, new Double(3.4028234663852886E38));
        hashtable.put(Short.class, new Short(Short.MAX_VALUE));
        hashtable.put(Byte.class, new Byte(127));
        hashtable.put(Float.class, new Float(Float.MAX_VALUE));
        hashtable.put(BigInteger.class, new BigInteger("99999999999999999999999999999999999999"));
        hashtable.put(BigDecimal.class, new BigDecimal("9999999999999999999.9999999999999999999"));
        return hashtable;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> hashtable = new Hashtable<Class, Number>();
        hashtable.put(Integer.class, new Integer(Integer.MIN_VALUE));
        hashtable.put(Long.class, new Long(Long.MIN_VALUE));
        hashtable.put(Double.class, new Double(1.401298464324715E-44));
        hashtable.put(Short.class, new Short(Short.MIN_VALUE));
        hashtable.put(Byte.class, new Byte(-128));
        hashtable.put(Float.class, new Float(Float.MIN_VALUE));
        hashtable.put(BigInteger.class, new BigInteger("-99999999999999999999999999999999999999"));
        hashtable.put(BigDecimal.class, new BigDecimal("-9999999999999999999.9999999999999999999"));
        return hashtable;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" SERIAL");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public boolean requiresProcedureCallBrackets() {
        return false;
    }

    public boolean shouldPrintConstraintNameAfter() {
        return true;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsSequenceObjects() {
        return true;
    }

    public ValueReadQuery buildSelectQueryForSequenceObject(String string, Integer n) {
        return new ValueReadQuery("select " + this.getQualifiedName(string) + ".nextval from systables where tabid = 1");
    }

    public Writer buildSequenceObjectCreationWriter(Writer writer, String string, int n, int n2) throws IOException {
        writer.write("CREATE SEQUENCE ");
        writer.write(string);
        if (n != 1) {
            writer.write(" INCREMENT BY " + n);
        }
        writer.write(" START WITH " + n2);
        return writer;
    }

    public Writer buildSequenceObjectDeletionWriter(Writer writer, String string) throws IOException {
        writer.write("DROP SEQUENCE ");
        writer.write(string);
        return writer;
    }

    public boolean isAlterSequenceObjectSupported() {
        return true;
    }

    public Writer buildSequenceObjectAlterIncrementWriter(Writer writer, String string, int n) throws IOException {
        writer.write("ALTER SEQUENCE ");
        writer.write(string);
        writer.write(" INCREMENT BY " + n);
        return writer;
    }
}

