/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server;

import java.io.IOException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public class ServerLog
extends AbstractSessionLog {
    public void log(SessionLogEntry sessionLogEntry) {
        if (!this.shouldLog(sessionLogEntry.getLevel())) {
            return;
        }
        String string = this.getSupplementDetailString(sessionLogEntry);
        if (sessionLogEntry.hasException()) {
            if (sessionLogEntry.getLevel() == 7) {
                string = string + Helper.printStackTraceToString(sessionLogEntry.getException());
            } else if (sessionLogEntry.getLevel() <= 6) {
                string = this.shouldLogExceptionStackTrace() ? string + Helper.printStackTraceToString(sessionLogEntry.getException()) : string + sessionLogEntry.getException();
            }
        } else {
            string = string + this.formatMessage(sessionLogEntry);
        }
        this.basicLog(sessionLogEntry.getLevel(), string);
    }

    protected void basicLog(int n, String string) {
        try {
            this.printPrefixString(n);
            this.getWriter().write(string);
            this.getWriter().write(Helper.cr());
            this.getWriter().flush();
        }
        catch (IOException iOException) {
            throw ValidationException.logIOError(iOException);
        }
    }
}

