/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.xdk;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDComplexType;
import oracle.xml.parser.schema.XSDElement;
import oracle.xml.parser.schema.XSDNode;
import oracle.xml.parser.schema.XSDValidator;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.platform.xml.XMLNamespaceResolver;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.platform.xml.XMLSchemaReference;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.eclipse.persistence.platform.xml.xdk.XDKNamespaceResolver;
import org.eclipse.persistence.platform.xml.xdk.XDKParser;
import org.eclipse.persistence.platform.xml.xdk.XDKTransformer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XDKPlatform
implements XMLPlatform {
    private Method buildSchemaMethod;

    public XDKPlatform() {
        try {
            Class[] classArray = new Class[]{URL.class};
            this.buildSchemaMethod = Helper.getDeclaredMethod(XSDBuilder.class, "build", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    @Override
    public Node selectSingleNodeAdvanced(Node node, String string, XMLNamespaceResolver xMLNamespaceResolver) throws XMLPlatformException {
        try {
            XMLNode xMLNode = (XMLNode)node;
            XDKNamespaceResolver xDKNamespaceResolver = new XDKNamespaceResolver(xMLNamespaceResolver);
            return xMLNode.selectSingleNode(string, (NSResolver)xDKNamespaceResolver);
        }
        catch (XSLException xSLException) {
            throw XMLPlatformException.xmlPlatformInvalidXPath((Exception)((Object)xSLException));
        }
    }

    @Override
    public NodeList selectNodesAdvanced(Node node, String string, XMLNamespaceResolver xMLNamespaceResolver) throws XMLPlatformException {
        try {
            XMLNode xMLNode = (XMLNode)node;
            XDKNamespaceResolver xDKNamespaceResolver = new XDKNamespaceResolver(xMLNamespaceResolver);
            return xMLNode.selectNodes(string, (NSResolver)xDKNamespaceResolver);
        }
        catch (XSLException xSLException) {
            throw XMLPlatformException.xmlPlatformInvalidXPath((Exception)((Object)xSLException));
        }
    }

    @Override
    public Document createDocument() throws XMLPlatformException {
        return new XMLDocument();
    }

    @Override
    public Document createDocumentWithPublicIdentifier(String string, String string2, String string3) throws XMLPlatformException {
        try {
            XMLDocument xMLDocument = (XMLDocument)this.createDocument();
            Element element = xMLDocument.createElement(string);
            xMLDocument.appendChild((Node)element);
            xMLDocument.setDoctype(string, string3, string2);
            return xMLDocument;
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(exception);
        }
    }

    @Override
    public Document createDocumentWithSystemIdentifier(String string, String string2) throws XMLPlatformException {
        try {
            if (null == string2) {
                Document document = this.createDocument();
                Element element = document.createElement(string);
                document.appendChild(element);
                return document;
            }
            XMLDocument xMLDocument = (XMLDocument)this.createDocument();
            Element element = xMLDocument.createElement(string);
            xMLDocument.appendChild((Node)element);
            xMLDocument.setDoctype(string, string2, null);
            return xMLDocument;
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformCouldNotCreateDocument(exception);
        }
    }

    @Override
    public boolean isWhitespaceNode(Text text) {
        try {
            String string = text.getNodeValue();
            if (null == string) {
                return false;
            }
            return string.trim().equals("");
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    @Override
    public String resolveNamespacePrefix(Node node, String string) throws XMLPlatformException {
        Node node2;
        Attr attr;
        if (null == string ? null == node.getPrefix() : string.equals(node.getPrefix())) {
            return node.getNamespaceURI();
        }
        if (node.getNodeType() == 1 && null != (attr = (node2 = (Element)node).getAttributeNode("xmlns:" + string))) {
            return attr.getValue();
        }
        node2 = node.getParentNode();
        if (node2 != null && node2.getNodeType() == 1) {
            return this.resolveNamespacePrefix(node2, string);
        }
        return null;
    }

    @Override
    public XMLParser newXMLParser() {
        return new XDKParser();
    }

    @Override
    public XMLTransformer newXMLTransformer() {
        return new XDKTransformer();
    }

    @Override
    public boolean validateDocument(Document document, URL uRL, ErrorHandler errorHandler) throws XMLPlatformException {
        Object[] objectArray;
        XMLSchema xMLSchema = null;
        XSDValidator xSDValidator = null;
        try {
            objectArray = new Object[]{uRL};
            xMLSchema = (XMLSchema)this.buildSchemaMethod.invoke((Object)new XSDBuilder(), objectArray);
            xSDValidator = new XSDValidator();
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformErrorResolvingXMLSchema(uRL, exception);
        }
        xSDValidator.setXMLProperty("fixedSchema", (Object)xMLSchema);
        objectArray = new XMLError();
        try {
            xSDValidator.setError((XMLError)objectArray);
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformValidationException(sAXException);
        }
        try {
            ((XMLDocument)document).validateContent(xSDValidator, true);
        }
        catch (XMLParseException xMLParseException) {
            // empty catch block
        }
        this.handleErrors((XMLError)objectArray, errorHandler);
        return true;
    }

    @Override
    public boolean validate(Element element, XMLDescriptor xMLDescriptor, ErrorHandler errorHandler) throws XMLPlatformException {
        XMLSchema xMLSchema;
        Object[] objectArray;
        org.eclipse.persistence.oxm.schema.XMLSchemaReference xMLSchemaReference = xMLDescriptor.getSchemaReference();
        NamespaceResolver namespaceResolver = xMLDescriptor.getNamespaceResolver();
        XSDValidator xSDValidator = null;
        try {
            objectArray = new Object[]{xMLSchemaReference.getURL()};
            xMLSchema = (XMLSchema)this.buildSchemaMethod.invoke((Object)new XSDBuilder(), objectArray);
            xSDValidator = new XSDValidator();
        }
        catch (Exception exception) {
            throw XMLPlatformException.xmlPlatformValidationException(exception);
        }
        xSDValidator.setXMLProperty("fixedSchema", (Object)xMLSchema);
        objectArray = this.getNodeFromSchemaReference(xMLSchema, xMLSchemaReference, namespaceResolver);
        if (objectArray == null) {
            xSDValidator.setXMLProperty("ORACLE_XSD_Root_Node", null);
        }
        if (xMLSchemaReference.getType() == 3) {
            if (xMLDescriptor.getDefaultRootElement() != null) {
                xSDValidator.setXMLProperty("ORACLE_XSD_Root_Node", (Object)objectArray);
            } else {
                xSDValidator.setXMLProperty("ORACLE_XSD_Root_Node", (Object)((XSDElement)objectArray).getType());
            }
        } else {
            xSDValidator.setXMLProperty("ORACLE_XSD_Root_Node", (Object)objectArray);
        }
        XMLError xMLError = new XMLError();
        try {
            xSDValidator.setError(xMLError);
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformValidationException(sAXException);
        }
        try {
            ((XMLElement)element).validateContent(xSDValidator, true);
        }
        catch (XMLParseException xMLParseException) {
            // empty catch block
        }
        this.handleErrors(xMLError, errorHandler);
        return true;
    }

    private void handleErrors(XMLError xMLError, ErrorHandler errorHandler) {
        try {
            int n = xMLError.getNumMessages();
            for (int i = 0; i < n; ++i) {
                SAXParseException sAXParseException = new SAXParseException(xMLError.getMessage(i), xMLError.getPublicId(i), xMLError.getSystemId(i), xMLError.getLineNumber(i), xMLError.getColumnNumber(i), xMLError.getException(i));
                if (null == errorHandler) {
                    throw sAXParseException;
                }
                errorHandler.fatalError(sAXParseException);
            }
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformValidationException(sAXException);
        }
    }

    private XSDNode getNodeFromSchemaReference(XMLSchema xMLSchema, XMLSchemaReference xMLSchemaReference, NamespaceResolver namespaceResolver) {
        if (xMLSchemaReference == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(xMLSchemaReference.getSchemaContext(), "/");
        if (!stringTokenizer.hasMoreTokens()) {
            return null;
        }
        String string = "";
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ":");
        if (stringTokenizer2.countTokens() > 1 && (string = namespaceResolver.resolveNamespacePrefix(stringTokenizer2.nextToken())) == null) {
            string = "";
        }
        string2 = stringTokenizer2.nextToken();
        if (xMLSchemaReference.getType() == 2) {
            return xMLSchema.getType(string, string2, 2);
        }
        if (xMLSchemaReference.getType() == 1) {
            return xMLSchema.getType(string, string2, 1);
        }
        XSDElement xSDElement = xMLSchema.getElement(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            if ((xSDElement = this.findChildNode(xSDElement, stringTokenizer.nextToken())) != null) continue;
            return null;
        }
        return xSDElement;
    }

    protected XSDNode findChildNode(XSDElement xSDElement, String string) {
        XSDNode xSDNode = null;
        boolean bl = false;
        XSDNode[] xSDNodeArray = ((XSDComplexType)xSDElement.getType()).getElementSet();
        for (int i = 0; i < xSDNodeArray.length; ++i) {
            xSDNode = xSDNodeArray[i];
            if (!xSDNode.getName().equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            return xSDNode;
        }
        return null;
    }

    @Override
    public void namespaceQualifyFragment(Element element) {
        this.namespaceQualifyFragment(element, new ArrayList<String>());
    }

    private void namespaceQualifyFragment(Element element, List<String> list) {
        Object object;
        Node node;
        Object object2;
        String string = element.getNamespaceURI();
        String string2 = element.getPrefix();
        if (string2 != null && null == (object2 = element.getAttributeNode("xmlns:" + string2)) && !list.contains(string2)) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string2, string);
            list.add(string2);
        }
        object2 = element.getAttributes();
        int n = object2.getLength();
        for (int i = 0; i < n; ++i) {
            int n2;
            Attr attr = (Attr)object2.item(i);
            String string3 = attr.getPrefix();
            if (string3 == null) continue;
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) {
                list.add(attr.getLocalName());
                continue;
            }
            node = element.getAttributeNode("xmlns:" + string3);
            if (null == node && !list.contains(string3)) {
                object = attr.getNamespaceURI();
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string3, (String)object);
                list.add(string3);
            }
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(attr.getNamespaceURI()) || !"type".equals(attr.getLocalName()) || (n2 = ((String)(object = attr.getValue())).indexOf(58)) <= -1) continue;
            String string4 = ((String)object).substring(0, n2);
            node = element.getAttributeNode("xmlns:" + string4);
            if (null != node || list.contains(string4)) continue;
            String string5 = XMLPlatformFactory.getInstance().getXMLPlatform().resolveNamespacePrefix(element, string4);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string4, string5);
            list.add(string4);
        }
        NodeList nodeList = element.getChildNodes();
        int n3 = nodeList.getLength();
        for (int i = 0; i < n3; ++i) {
            node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            object = (Element)node;
            this.namespaceQualifyFragment((Element)object, list);
        }
    }
}

