/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.helper.XSDHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.MimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLFragmentMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLNillableMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLTransformationMapping;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.IsSetNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.AttributeMimeTypePolicy;
import org.eclipse.persistence.sdo.helper.InstanceClassConverter;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDOFragmentMappingAttributeAccessor;
import org.eclipse.persistence.sdo.helper.SDOMethodAttributeAccessor;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.metadata.NamespaceURITransformer;
import org.eclipse.persistence.sdo.helper.metadata.QNameTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOProperty
implements Property,
Serializable {
    private String propertyName;
    private SDOType type;
    private Type containingType;
    private boolean isContainment;
    private boolean hasMany;
    private boolean readOnly;
    private List aliasNames;
    private Object defaultValue;
    private boolean isDefaultSet;
    private int indexInType = -1;
    private int indexInDeclaredProperties = -1;
    private Property opposite;
    private boolean xsd;
    private String xsdLocalName;
    private boolean global;
    private boolean namespaceQualified;
    private transient DatabaseMapping xmlMapping;
    private Map propertyValues;
    private boolean nullable;
    private QName xsdType;
    private boolean valueProperty;
    private List appInfoElements;
    private Map appInfoMap;
    private boolean nameCollision;
    private String uri;
    private boolean isSubstitutable;
    private Collection<SDOProperty> substitutableElements;
    private boolean finalized;
    private static boolean isActivationAvailable = false;
    private HelperContext aHelperContext;

    public SDOProperty(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public SDOProperty(HelperContext helperContext, String string) {
        this(helperContext);
        this.setName(string);
    }

    public SDOProperty(HelperContext helperContext, String string, SDOType sDOType) {
        this(helperContext, string);
        this.setType(sDOType);
    }

    public SDOProperty(HelperContext helperContext, String string, String string2, SDOType sDOType) {
        this(helperContext, string2, sDOType);
        this.setUri(string);
    }

    public String getName() {
        return this.propertyName;
    }

    public SDOType getType() {
        return this.type;
    }

    public boolean isMany() {
        return this.hasMany;
    }

    public boolean isOpenContent() {
        int n = this.getIndexInType();
        return n == -1;
    }

    public boolean isContainment() {
        return this.isContainment;
    }

    public Type getContainingType() {
        return this.containingType;
    }

    public Object getDefault() {
        if (null == this.defaultValue) {
            return this.type.getPseudoDefault();
        }
        return this.defaultValue;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public Property getOpposite() {
        return this.opposite;
    }

    public List getAliasNames() {
        if (this.aliasNames == null) {
            this.aliasNames = new ArrayList();
        }
        return this.aliasNames;
    }

    public void setName(String string) {
        this.propertyName = string;
    }

    public void setType(Type type) {
        this.type = (SDOType)type;
    }

    public void setContainment(boolean bl) {
        this.isContainment = bl;
    }

    public void setMany(boolean bl) {
        this.hasMany = bl;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setAliasNames(List list) {
        this.aliasNames = list;
    }

    public void setContainingType(Type type) {
        this.containingType = type;
    }

    public void setDefault(Object object) {
        this.defaultValue = object;
        this.isDefaultSet = true;
    }

    public void setOpposite(Property property) {
        this.opposite = property;
    }

    public void setXsd(boolean bl) {
        this.xsd = bl;
    }

    public boolean isXsd() {
        return this.xsd;
    }

    public void setXsdLocalName(String string) {
        this.xsdLocalName = string;
    }

    public String getXsdLocalName() {
        return this.xsdLocalName;
    }

    public void setNamespaceQualified(boolean bl) {
        this.namespaceQualified = bl;
    }

    public boolean isNamespaceQualified() {
        return this.namespaceQualified;
    }

    public void setXmlMapping(DatabaseMapping databaseMapping) {
        this.xmlMapping = databaseMapping;
    }

    public DatabaseMapping getXmlMapping() {
        return this.xmlMapping;
    }

    public void setGlobal(boolean bl) {
        this.global = bl;
    }

    public boolean isGlobal() {
        return this.global;
    }

    private void setIsSetNillablePolicyOnMapping(XMLNillableMapping xMLNillableMapping, Object object) {
        AbstractNullPolicy abstractNullPolicy = this.setIsSetPolicyOnMapping(xMLNillableMapping, object);
        abstractNullPolicy.setNullRepresentedByEmptyNode(false);
        abstractNullPolicy.setNullRepresentedByXsiNil(true);
        abstractNullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.XSI_NIL);
    }

    private void setIsSetOptionalPolicyOnMapping(XMLNillableMapping xMLNillableMapping, Object object) {
        AbstractNullPolicy abstractNullPolicy = this.setIsSetPolicyOnMapping(xMLNillableMapping, object);
        abstractNullPolicy.setNullRepresentedByEmptyNode(false);
        abstractNullPolicy.setNullRepresentedByXsiNil(false);
        abstractNullPolicy.setMarshalNullRepresentation(XMLNullRepresentationType.EMPTY_NODE);
    }

    private AbstractNullPolicy setIsSetPolicyOnMapping(XMLNillableMapping xMLNillableMapping, Object object) {
        IsSetNullPolicy isSetNullPolicy = new IsSetNullPolicy();
        isSetNullPolicy.setIsSetMethodName("isSet");
        isSetNullPolicy.setIsSetParameterTypes(new Class[]{ClassConstants.STRING});
        isSetNullPolicy.setIsSetParameters(new Object[]{object});
        xMLNillableMapping.setNullPolicy(isSetNullPolicy);
        return isSetNullPolicy;
    }

    public void buildMapping(String string) {
        this.buildMapping(string, -1);
    }

    public void buildMapping(String string, int n) {
        if (this.getContainingType().isDataType()) {
            return;
        }
        if (this.getType().isChangeSummaryType()) {
            this.buildChangeSummaryMapping();
            this.addMappingToOwner(false, n);
        } else if (this.isNameCollision()) {
            this.xmlMapping = new XMLAnyCollectionMapping();
            this.xmlMapping.setAttributeName(this.getName());
            this.addMappingToOwner(true, n);
        } else {
            boolean bl = true;
            if (!this.getType().isDataType()) {
                if (this.getType().isDataObjectType()) {
                    this.getType().setImplClassName("org.eclipse.persistence.sdo.SDODataObject");
                    if (this.getXsdType() != null && !this.getXsdType().equals(SDOConstants.ANY_TYPE_QNAME)) {
                        this.xmlMapping = this.isMany() ? this.buildXMLCompositeCollectionMapping(string) : this.buildXMLCompositeObjectMapping(string);
                    } else {
                        bl = false;
                        this.xmlMapping = this.isMany() ? this.buildXMLFragmentCollectionMapping(string) : this.buildXMLFragmentMapping(string);
                    }
                } else {
                    if (!this.getType().isFinalized()) {
                        this.getType().getNonFinalizedReferencingProps().add(this);
                        this.getType().getNonFinalizedMappingURIs().add(string);
                        return;
                    }
                    this.xmlMapping = this.isSubstitutable() ? (this.isMany() ? this.buildXMLChoiceCollectionMapping(string) : this.buildXMLChoiceObjectMapping(string)) : (this.isMany() ? (this.isContainment() ? this.buildXMLCompositeCollectionMapping(string) : this.buildXMLCollectionReferenceMapping(string)) : (this.isContainment() ? this.buildXMLCompositeObjectMapping(string) : this.buildXMLObjectReferenceMapping(string)));
                }
            } else if (this.isMany()) {
                MimeTypePolicy mimeTypePolicy = this.getMimeTypePolicy();
                this.xmlMapping = isActivationAvailable && !this.aHelperContext.getXSDHelper().isAttribute((Property)this) && (mimeTypePolicy != null || this.getType().getInstanceClass() != null && this.getType().getInstanceClass().getName().equals("javax.activation.DataHandler") || this.getXsdType() != null && this.getXsdType().equals(XMLConstants.BASE_64_BINARY_QNAME)) ? this.buildXMLBinaryDataCollectionMapping(string, mimeTypePolicy) : (this.isSubstitutable() ? this.buildXMLChoiceCollectionMapping(string) : this.buildXMLCompositeDirectCollectionMapping(string));
            } else {
                MimeTypePolicy mimeTypePolicy = this.getMimeTypePolicy();
                this.xmlMapping = isActivationAvailable && !this.aHelperContext.getXSDHelper().isAttribute((Property)this) && (mimeTypePolicy != null || this.getType().getInstanceClass() != null && this.getType().getInstanceClass().getName().equals("javax.activation.DataHandler") || this.getXsdType() != null && this.getXsdType().equals(XMLConstants.BASE_64_BINARY_QNAME)) ? this.buildXMLBinaryDataMapping(string, mimeTypePolicy) : (this.isSubstitutable() ? this.buildXMLChoiceObjectMapping(string) : (this.getXsdType() != null && this.getXsdType().equals(XMLConstants.QNAME_QNAME) ? this.buildXMLTransformationMapping(string) : this.buildXMLDirectMapping(string)));
            }
            this.addMappingToOwner(bl, n);
        }
    }

    public void buildChangeSummaryMapping() {
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName(this.getName());
        String string = this.getQualifiedXPath(this.getContainingType().getURI(), false);
        xMLCompositeObjectMapping.setXPath(string);
        xMLCompositeObjectMapping.setGetMethodName("getChangeSummary");
        xMLCompositeObjectMapping.setSetMethodName("_setChangeSummary");
        xMLCompositeObjectMapping.setReferenceClass(SDOChangeSummary.class);
        if (this.nullable) {
            this.setIsSetNillablePolicyOnMapping(xMLCompositeObjectMapping, this.propertyName);
        } else {
            this.setIsSetOptionalPolicyOnMapping(xMLCompositeObjectMapping, this.propertyName);
        }
        this.setXmlMapping(xMLCompositeObjectMapping);
    }

    public void addMappingToOwner(boolean bl, int n) {
        if (this.xmlMapping != null) {
            Object object;
            Cloneable cloneable;
            if (bl) {
                cloneable = null;
                if (this.getType().isDataType()) {
                    object = this.getType().getInstanceClass();
                    cloneable = new SDOMethodAttributeAccessor(this, (Class)object);
                } else {
                    cloneable = new SDOMethodAttributeAccessor(this);
                }
                this.xmlMapping.setAttributeAccessor((AttributeAccessor)cloneable);
            }
            if (this.getContainingType() != null && !this.getContainingType().isDataType()) {
                cloneable = ((SDOType)this.getContainingType()).getXmlDescriptor();
                this.xmlMapping.setDescriptor((ClassDescriptor)cloneable);
                object = (XMLMapping)((Object)((SDOType)this.getContainingType()).getXmlDescriptor().getMappingForAttributeName(this.getName()));
                if (object != null) {
                    ((SDOType)this.getContainingType()).getXmlDescriptor().getMappings().remove(object);
                }
                if (n == -1) {
                    ((SDOType)this.getContainingType()).getXmlDescriptor().getMappings().add(this.xmlMapping);
                } else {
                    SDOType sDOType = (SDOType)this.getContainingType();
                    Vector<DatabaseMapping> vector = sDOType.getXmlDescriptor().getMappings();
                    boolean bl2 = false;
                    for (int i = 0; i < vector.size(); ++i) {
                        DatabaseMapping databaseMapping = vector.get(i);
                        SDOProperty sDOProperty = sDOType.getProperty(databaseMapping.getAttributeName());
                        if (sDOProperty == null || n >= sDOProperty.getIndexInType()) continue;
                        vector.add(i, this.xmlMapping);
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        ((SDOType)this.getContainingType()).getXmlDescriptor().getMappings().add(this.xmlMapping);
                    }
                }
            }
        }
    }

    private DatabaseMapping buildXMLBinaryDataMapping(String string, MimeTypePolicy mimeTypePolicy) {
        XMLBinaryDataMapping xMLBinaryDataMapping = new XMLBinaryDataMapping();
        xMLBinaryDataMapping.setAttributeName(this.getName());
        String string2 = this.getQualifiedXPath(string, false);
        xMLBinaryDataMapping.setMimeTypePolicy(mimeTypePolicy);
        xMLBinaryDataMapping.setXPath(string2);
        if (this.getXsdType() != null) {
            ((XMLField)xMLBinaryDataMapping.getField()).setSchemaType(this.getXsdType());
        }
        if (this.shouldAddInstanceClassConverter()) {
            InstanceClassConverter instanceClassConverter = new InstanceClassConverter();
            instanceClassConverter.setCustomClass(this.getType().getInstanceClass());
            xMLBinaryDataMapping.setConverter(instanceClassConverter);
        }
        return xMLBinaryDataMapping;
    }

    private DatabaseMapping buildXMLBinaryDataCollectionMapping(String string, MimeTypePolicy mimeTypePolicy) {
        XMLBinaryDataCollectionMapping xMLBinaryDataCollectionMapping = new XMLBinaryDataCollectionMapping();
        xMLBinaryDataCollectionMapping.setAttributeName(this.getName());
        String string2 = this.getQualifiedXPath(string, false);
        if (!this.getType().getInstanceClassName().equals("javax.activation.DataHandler")) {
            xMLBinaryDataCollectionMapping.setAttributeElementClass(this.getType().getInstanceClass());
        }
        xMLBinaryDataCollectionMapping.setMimeTypePolicy(mimeTypePolicy);
        xMLBinaryDataCollectionMapping.setXPath(string2);
        if (this.getXsdType() != null) {
            ((XMLField)xMLBinaryDataCollectionMapping.getField()).setSchemaType(this.getXsdType());
        }
        if (this.shouldAddInstanceClassConverter()) {
            InstanceClassConverter instanceClassConverter = new InstanceClassConverter();
            instanceClassConverter.setCustomClass(this.getType().getInstanceClass());
            xMLBinaryDataCollectionMapping.setValueConverter(instanceClassConverter);
        }
        return xMLBinaryDataCollectionMapping;
    }

    private DatabaseMapping buildXMLTransformationMapping(String string) {
        XMLTransformationMapping xMLTransformationMapping = new XMLTransformationMapping();
        xMLTransformationMapping.setAttributeName(this.getName());
        String string2 = this.getQualifiedXPath(string, true);
        String string3 = string2.substring(0, string2.lastIndexOf("/text()"));
        QNameTransformer qNameTransformer = new QNameTransformer(string2);
        xMLTransformationMapping.setAttributeTransformer(qNameTransformer);
        xMLTransformationMapping.addFieldTransformer(string2, (FieldTransformer)qNameTransformer);
        NamespaceResolver namespaceResolver = new NamespaceResolver();
        namespaceResolver.put("xmlns", "http://www.w3.org/2000/xmlns/");
        XMLField xMLField = new XMLField();
        xMLField.setNamespaceResolver(namespaceResolver);
        xMLField.setXPath(string3 + "/@" + "xmlns" + ":" + "qns");
        xMLTransformationMapping.addFieldTransformer(xMLField, (FieldTransformer)new NamespaceURITransformer());
        return xMLTransformationMapping;
    }

    private DatabaseMapping buildXMLDirectMapping(String string) {
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(this.getName());
        String string2 = this.getQualifiedXPath(string, true);
        xMLDirectMapping.setXPath(string2);
        if (this.getXsdType() != null) {
            ((XMLField)xMLDirectMapping.getField()).setSchemaType(this.getXsdType());
        }
        if (this.getType().getInstanceClass() != null && this.shouldAddInstanceClassConverter()) {
            InstanceClassConverter instanceClassConverter = new InstanceClassConverter();
            instanceClassConverter.setCustomClass(this.getType().getInstanceClass());
            xMLDirectMapping.setConverter(instanceClassConverter);
        }
        if (this.nullable) {
            this.setIsSetNillablePolicyOnMapping(xMLDirectMapping, this.propertyName);
        } else {
            this.setIsSetOptionalPolicyOnMapping(xMLDirectMapping, this.propertyName);
        }
        return xMLDirectMapping;
    }

    private DatabaseMapping buildXMLCompositeDirectCollectionMapping(String string) {
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(this.getName());
        String string2 = this.getQualifiedXPath(string, true);
        xMLCompositeDirectCollectionMapping.setXPath(string2);
        xMLCompositeDirectCollectionMapping.setAttributeElementClass(this.getType().getInstanceClass());
        if (this.getXsdType() != null) {
            ((XMLField)xMLCompositeDirectCollectionMapping.getField()).setSchemaType(this.getXsdType());
        }
        if (this.getType().equals(SDOConstants.SDO_STRINGS)) {
            xMLCompositeDirectCollectionMapping.setUsesSingleNode(true);
        }
        if (this.getType().getInstanceClass() != null && this.shouldAddInstanceClassConverter()) {
            InstanceClassConverter instanceClassConverter = new InstanceClassConverter();
            instanceClassConverter.setCustomClass(this.getType().getInstanceClass());
            xMLCompositeDirectCollectionMapping.setValueConverter(instanceClassConverter);
        }
        return xMLCompositeDirectCollectionMapping;
    }

    private DatabaseMapping buildXMLCompositeCollectionMapping(String string) {
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(this.getName());
        String string2 = this.getQualifiedXPath(string, false);
        xMLCompositeCollectionMapping.setXPath(string2);
        if (!this.getType().isDataObjectType()) {
            QName qName = this.getType().getXmlDescriptor().getSchemaReference().getSchemaContextAsQName(this.getType().getXmlDescriptor().getNamespaceResolver());
            ((XMLField)xMLCompositeCollectionMapping.getField()).setLeafElementType(qName);
            xMLCompositeCollectionMapping.setReferenceClassName(this.getType().getImplClassName());
            xMLCompositeCollectionMapping.setReferenceClass(this.getType().getImplClass());
        } else if (this.getXsdType() != null) {
            ((XMLField)xMLCompositeCollectionMapping.getField()).setLeafElementType(this.getXsdType());
        }
        xMLCompositeCollectionMapping.useCollectionClass(ListWrapper.class);
        this.setIsSetNillablePolicyOnMapping(xMLCompositeCollectionMapping, this.propertyName);
        return xMLCompositeCollectionMapping;
    }

    private DatabaseMapping buildXMLCompositeObjectMapping(String string) {
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName(this.getName());
        String string2 = this.getQualifiedXPath(string, false);
        xMLCompositeObjectMapping.setXPath(string2);
        if (!this.getType().isDataObjectType()) {
            QName qName = this.getType().getXmlDescriptor().getSchemaReference().getSchemaContextAsQName(this.getType().getXmlDescriptor().getNamespaceResolver());
            ((XMLField)xMLCompositeObjectMapping.getField()).setLeafElementType(qName);
            xMLCompositeObjectMapping.setReferenceClassName(this.getType().getImplClassName());
            xMLCompositeObjectMapping.setReferenceClass(this.getType().getImplClass());
        } else if (this.getXsdType() != null) {
            ((XMLField)xMLCompositeObjectMapping.getField()).setLeafElementType(this.getXsdType());
        }
        if (this.nullable) {
            this.setIsSetNillablePolicyOnMapping(xMLCompositeObjectMapping, this.propertyName);
        } else {
            this.setIsSetOptionalPolicyOnMapping(xMLCompositeObjectMapping, this.propertyName);
        }
        return xMLCompositeObjectMapping;
    }

    private DatabaseMapping buildXMLObjectReferenceMapping(String string) {
        XMLObjectReferenceMapping xMLObjectReferenceMapping = new XMLObjectReferenceMapping();
        xMLObjectReferenceMapping.setAttributeName(this.getName());
        if (this.getType().isDataObjectType()) {
            this.getType().setImplClassName("org.eclipse.persistence.sdo.SDODataObject");
        }
        xMLObjectReferenceMapping.setReferenceClassName(this.getType().getImplClassName());
        xMLObjectReferenceMapping.setReferenceClass(this.getType().getImplClass());
        String string2 = this.getQualifiedXPath(this.getContainingType().getURI(), true);
        SDOProperty sDOProperty = this.getIDProp(this.getType());
        if (sDOProperty == null) {
            throw SDOException.noTargetIdSpecified(this.getType().getURI(), this.getType().getName());
        }
        String string3 = sDOProperty.getQualifiedXPath(this.getType().getURI(), true);
        xMLObjectReferenceMapping.addSourceToTargetKeyFieldAssociation(string2, string3);
        return xMLObjectReferenceMapping;
    }

    private DatabaseMapping buildXMLChoiceObjectMapping(String string) {
        XMLChoiceObjectMapping xMLChoiceObjectMapping = new XMLChoiceObjectMapping();
        xMLChoiceObjectMapping.setAttributeName(this.getName());
        String string2 = this.getQualifiedXPath(string, this.getType().isDataType());
        xMLChoiceObjectMapping.addChoiceElement(string2, this.getType().getImplClass());
        for (SDOProperty sDOProperty : this.getSubstitutableElements()) {
            string2 = sDOProperty.getQualifiedXPath(string, sDOProperty.getType().isDataType(), (SDOType)this.getContainingType());
            xMLChoiceObjectMapping.addChoiceElement(string2, sDOProperty.getType().getImplClass());
        }
        return xMLChoiceObjectMapping;
    }

    private DatabaseMapping buildXMLChoiceCollectionMapping(String string) {
        XMLChoiceCollectionMapping xMLChoiceCollectionMapping = new XMLChoiceCollectionMapping();
        xMLChoiceCollectionMapping.setAttributeName(this.getName());
        xMLChoiceCollectionMapping.useCollectionClass(ListWrapper.class);
        String string2 = this.getQualifiedXPath(string, this.getType().isDataType());
        xMLChoiceCollectionMapping.addChoiceElement(string2, this.getType().getImplClass());
        for (SDOProperty sDOProperty : this.getSubstitutableElements()) {
            string2 = sDOProperty.getQualifiedXPath(string, sDOProperty.getType().isDataType(), (SDOType)this.getContainingType());
            xMLChoiceCollectionMapping.addChoiceElement(string2, sDOProperty.getType().getImplClass());
        }
        return xMLChoiceCollectionMapping;
    }

    private SDOProperty getIDProp(Type type) {
        return (SDOProperty)type.getProperty((String)type.get((Property)SDOConstants.ID_PROPERTY));
    }

    private DatabaseMapping buildXMLCollectionReferenceMapping(String string) {
        XMLCollectionReferenceMapping xMLCollectionReferenceMapping = new XMLCollectionReferenceMapping();
        xMLCollectionReferenceMapping.setAttributeName(this.getName());
        if (this.getType().isDataObjectType()) {
            this.getType().setImplClassName("org.eclipse.persistence.sdo.SDODataObject");
        }
        xMLCollectionReferenceMapping.setReferenceClassName(this.getType().getImplClassName());
        xMLCollectionReferenceMapping.setReferenceClass(this.getType().getImplClass());
        xMLCollectionReferenceMapping.setUsesSingleNode(true);
        xMLCollectionReferenceMapping.useCollectionClass(ArrayList.class);
        String string2 = this.getQualifiedXPath(this.getContainingType().getURI(), true);
        SDOProperty sDOProperty = this.getIDProp(this.getType());
        if (sDOProperty == null) {
            throw SDOException.noTargetIdSpecified(this.getType().getURI(), this.getType().getName());
        }
        String string3 = sDOProperty.getQualifiedXPath(this.getType().getURI(), true);
        xMLCollectionReferenceMapping.addSourceToTargetKeyFieldAssociation(string2, string3);
        return xMLCollectionReferenceMapping;
    }

    private boolean shouldAddInstanceClassConverter() {
        Object object = this.getType().get(SDOConstants.JAVA_CLASS_PROPERTY);
        if (this.getType().isDataType() && object != null) {
            Class clazz = this.getType().getInstanceClass();
            String string = this.getType().getInstanceClassName();
            return (string == null || !string.equals("javax.activation.DataHandler")) && clazz != ClassConstants.ABYTE && clazz != ClassConstants.APBYTE && clazz != ClassConstants.BYTE && clazz != ClassConstants.PBYTE && clazz != ClassConstants.CHAR && clazz != ClassConstants.PCHAR && clazz != ClassConstants.DOUBLE && clazz != ClassConstants.PDOUBLE && clazz != ClassConstants.FLOAT && clazz != ClassConstants.PFLOAT && clazz != ClassConstants.LONG && clazz != ClassConstants.PLONG && clazz != ClassConstants.SHORT && clazz != ClassConstants.PSHORT && clazz != ClassConstants.INTEGER && clazz != ClassConstants.PINT && clazz != ClassConstants.BIGDECIMAL && clazz != ClassConstants.BIGINTEGER && clazz != ClassConstants.STRING && clazz != ClassConstants.UTILDATE && clazz != ClassConstants.CALENDAR && clazz != ClassConstants.TIME && clazz != ClassConstants.SQLDATE && clazz != ClassConstants.TIMESTAMP;
        }
        return false;
    }

    public String getXPath() {
        String string = this.getXsdLocalName();
        if (string == null) {
            string = this.getName();
        }
        return string;
    }

    public String getQualifiedXPath(String string, boolean bl) {
        SDOType sDOType = (SDOType)this.getContainingType();
        return this.getQualifiedXPath(string, bl, sDOType);
    }

    private String getQualifiedXPath(String string, boolean bl, SDOType sDOType) {
        if (this.valueProperty) {
            return "text()";
        }
        String string2 = this.getXPath();
        String string3 = null;
        if (this.isNamespaceQualified()) {
            string3 = sDOType.getXmlDescriptor().getNonNullNamespaceResolver().resolveNamespaceURI(string);
        }
        if (this.aHelperContext.getXSDHelper().isAttribute((Property)this)) {
            if (string3 != null) {
                string2 = string3 + ":" + string2;
            }
            string2 = "@" + string2;
        } else {
            if (string3 != null) {
                string2 = string3 + ":" + string2;
            }
            if (bl) {
                string2 = string2 + "/text()";
            }
        }
        return string2;
    }

    public Object get(Property property) {
        return this.getPropertyValues().get(property);
    }

    public List getInstanceProperties() {
        return new ArrayList(this.getPropertyValues().keySet());
    }

    public void setPropertyValues(Map map) {
        this.propertyValues = map;
    }

    public Map getPropertyValues() {
        if (this.propertyValues == null) {
            this.propertyValues = new HashMap();
        }
        return this.propertyValues;
    }

    public void setInstanceProperty(Property property, Object object) {
        this.getPropertyValues().put(property, object);
        if ("commonj.sdo/xml".equals(((SDOProperty)property).getUri()) && "dataType".equals(property.getName()) && object instanceof Type) {
            this.setType((Type)object);
        }
        if ("org.eclipse.persistence.sdo".equals(((SDOProperty)property).getUri()) && "xmlSchemaType".equals(property.getName()) && object instanceof Type) {
            Type type = (Type)object;
            QName qName = new QName(type.getURI(), type.getName());
            this.setXsdType(qName);
        }
    }

    public void setIndexInType(int n) {
        this.indexInType = n;
    }

    public int getIndexInType() {
        if (this.indexInType == -1 && this.getContainingType() != null) {
            this.indexInType = this.getContainingType().getProperties().indexOf(this);
        }
        return this.indexInType;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setXsdType(QName qName) {
        this.xsdType = qName;
    }

    public QName getXsdType() {
        return this.xsdType;
    }

    public MimeTypePolicy getMimeTypePolicy() {
        String string = (String)this.get(SDOConstants.MIME_TYPE_PROPERTY);
        if (string != null) {
            return new FixedMimeTypePolicy(string);
        }
        string = (String)this.get(SDOConstants.MIME_TYPE_PROPERTY_PROPERTY);
        if (string != null) {
            return new AttributeMimeTypePolicy(string);
        }
        return null;
    }

    public void setIndexInDeclaredProperties(int n) {
        this.indexInDeclaredProperties = n;
    }

    public int getIndexInDeclaredProperties() {
        if (this.indexInDeclaredProperties == -1 && this.getContainingType() != null) {
            this.indexInDeclaredProperties = this.getContainingType().getDeclaredProperties().indexOf(this);
        }
        return this.indexInDeclaredProperties;
    }

    public void setValueProperty(boolean bl) {
        this.valueProperty = bl;
    }

    public boolean isValueProperty() {
        return this.valueProperty;
    }

    public void setAppInfoElements(List list) {
        this.appInfoElements = list;
    }

    public List getAppInfoElements() {
        return this.appInfoElements;
    }

    public Map getAppInfoMap() {
        if (this.appInfoMap == null) {
            this.appInfoMap = ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).buildAppInfoMap(this.appInfoElements);
        }
        return this.appInfoMap;
    }

    public void setNameCollision(boolean bl) {
        this.nameCollision = bl;
    }

    public boolean isNameCollision() {
        return this.nameCollision;
    }

    public boolean isDefaultSet() {
        return this.isDefaultSet;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public String getUri() {
        return this.uri;
    }

    public XMLFragmentMapping buildXMLFragmentMapping(String string) {
        XMLFragmentMapping xMLFragmentMapping = new XMLFragmentMapping();
        xMLFragmentMapping.setAttributeName(this.getName());
        xMLFragmentMapping.setXPath(this.getQualifiedXPath(string, false));
        xMLFragmentMapping.setAttributeAccessor(new SDOFragmentMappingAttributeAccessor(this, this.aHelperContext));
        return xMLFragmentMapping;
    }

    public XMLFragmentCollectionMapping buildXMLFragmentCollectionMapping(String string) {
        XMLFragmentCollectionMapping xMLFragmentCollectionMapping = new XMLFragmentCollectionMapping();
        xMLFragmentCollectionMapping.setAttributeName(this.getName());
        xMLFragmentCollectionMapping.setXPath(this.getQualifiedXPath(string, false));
        xMLFragmentCollectionMapping.setAttributeAccessor(new SDOFragmentMappingAttributeAccessor(this, this.aHelperContext));
        return xMLFragmentCollectionMapping;
    }

    public boolean isSubstitutable() {
        return this.isSubstitutable;
    }

    public void setSubstitutable(boolean bl) {
        this.isSubstitutable = bl;
    }

    public Collection<SDOProperty> getSubstitutableElements() {
        return this.substitutableElements;
    }

    public void setSubstitutableElements(Collection<SDOProperty> collection) {
        this.substitutableElements = collection;
    }

    public void setFinalized(boolean bl) {
        this.finalized = bl;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public int hashCode() {
        int n = 7;
        n = 31 * n + (null == this.getName() ? 0 : this.getName().hashCode());
        n = 31 * n + (null == this.getUri() ? 0 : this.getUri().hashCode());
        return n;
    }

    public boolean equals(Object object) {
        SDOProperty sDOProperty;
        if (object == null) {
            return false;
        }
        try {
            sDOProperty = (SDOProperty)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (sDOProperty.getType() == null ? this.getType() != null : this.getType() == null || !this.getType().equals(sDOProperty.getType())) {
            return false;
        }
        if (sDOProperty.getName() == null ? this.getName() != null : this.getName() == null || !this.getName().equals(sDOProperty.getName())) {
            return false;
        }
        if (sDOProperty.getUri() == null ? this.getUri() != null : this.getUri() == null || !this.getUri().equals(sDOProperty.getUri())) {
            return false;
        }
        XSDHelper xSDHelper = this.aHelperContext.getXSDHelper();
        return !(xSDHelper.isAttribute((Property)this) ? xSDHelper.isElement((Property)sDOProperty) : xSDHelper.isAttribute((Property)sDOProperty));
    }

    static {
        try {
            PrivilegedAccessHelper.getClassForName("javax.activation.DataHandler");
            PrivilegedAccessHelper.getClassForName("javax.mail.internet.MimeMultipart");
            isActivationAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

