/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.sequenced.Setting;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOSequence
implements Sequence {
    private static final String TEXT_XPATH = "text()";
    private SDODataObject dataObject;
    private List<Setting> settings;
    private Map<Key, Setting> valuesToSettings;

    public SDOSequence(SDODataObject sDODataObject) {
        if (null == sDODataObject) {
            throw SDOException.sequenceDataObjectInstanceFieldIsNull();
        }
        this.dataObject = sDODataObject;
        this.settings = new ArrayList<Setting>();
        this.valuesToSettings = new HashMap<Key, Setting>();
    }

    public SDODataObject getDataObject() {
        return this.dataObject;
    }

    public List<Setting> getSettings() {
        return this.settings;
    }

    protected Map<Key, Setting> getValuesToSettings() {
        return this.valuesToSettings;
    }

    public void add(int n, int n2, Object object) {
        SDOProperty sDOProperty = this.dataObject.getInstanceProperty(n2);
        this.add(n, sDOProperty, object);
    }

    public boolean add(int n, Object object) {
        SDOProperty sDOProperty = this.dataObject.getInstanceProperty(n);
        return this.add(sDOProperty, object);
    }

    public void add(int n, Property property, Object object) {
        if (!this.isAllowedInSequence(property)) {
            return;
        }
        if (property != null && property.isOpenContent() && this.dataObject.getType().isOpen()) {
            this.dataObject.addOpenContentProperty(property);
        }
        if (property.isMany()) {
            ListWrapper listWrapper = (ListWrapper)this.dataObject.getList(property);
            if (object instanceof List) {
                for (Object e : (List)object) {
                    Setting setting = this.convertToSetting(property, e);
                    this.valuesToSettings.put(new Key(property, e), setting);
                    this.settings.add(n++, setting);
                    listWrapper.add(e, false);
                }
            } else {
                Setting setting = this.convertToSetting(property, object);
                this.valuesToSettings.put(new Key(property, object), setting);
                this.settings.add(n, setting);
                int n2 = this.getIndexInList(property, object);
                if (n2 != -1) {
                    listWrapper.add(n2, object, false);
                } else {
                    listWrapper.add(object, false);
                }
            }
        } else {
            this.dataObject.setPropertyInternal((SDOProperty)property, object, false);
            Setting setting = this.convertToSetting(property, object);
            this.valuesToSettings.put(new Key(property, object), setting);
            this.settings.add(n, setting);
        }
    }

    private boolean isAllowedInSequence(Property property) {
        if (null == property) {
            return false;
        }
        if (property.isReadOnly()) {
            return false;
        }
        if (this.dataObject.getType().getHelperContext().getXSDHelper().isAttribute(property)) {
            throw SDOException.sequenceAttributePropertyNotSupported(property.getName());
        }
        if (property.isOpenContent() && !this.dataObject.getType().isOpen()) {
            return false;
        }
        if (property.isMany()) {
            return true;
        }
        if (this.dataObject.isSet(property)) {
            throw SDOException.sequenceDuplicateSettingNotSupportedForComplexSingleObject(this.getIndexForProperty(property), property.getName());
        }
        return true;
    }

    public void add(int n, String string, Object object) {
        SDOProperty sDOProperty = this.dataObject.getInstanceProperty(string);
        if (sDOProperty == null) {
            sDOProperty = this.dataObject.defineOpenContentProperty(string, object);
            sDOProperty.setMany(true);
        }
        this.add(n, sDOProperty, object);
    }

    public void add(int n, String string) {
        this.addText(n, string);
    }

    public boolean add(Property property, Object object) {
        if (this.addSettingWithoutModifyingDataObject(property, object)) {
            if (property != null && property.isOpenContent() && this.dataObject.getType().isOpen()) {
                this.dataObject.addOpenContentProperty(property);
            }
            if (object instanceof XMLRoot) {
                object = ((XMLRoot)object).getObject();
            }
            if (property.isMany()) {
                ListWrapper listWrapper = (ListWrapper)this.dataObject.getList(property);
                listWrapper.add(object, false);
            } else {
                this.dataObject.setPropertyInternal((SDOProperty)property, object, false);
            }
            return true;
        }
        return false;
    }

    public boolean add(String string, Object object) {
        SDOProperty sDOProperty = this.dataObject.getInstanceProperty(string);
        if (sDOProperty == null) {
            sDOProperty = this.dataObject.defineOpenContentProperty(string, object);
            sDOProperty.setMany(true);
        }
        return this.add(sDOProperty, object);
    }

    public void add(String string) {
        this.addText(string);
    }

    public void addText(int n, String string) {
        this.dataObject._setModified(true);
        Setting setting = new Setting(null, TEXT_XPATH);
        setting.setObject(this.dataObject);
        setting.setValue(string, false);
        this.settings.add(n, setting);
    }

    public void addText(String string) {
        this.dataObject._setModified(true);
        Setting setting = new Setting(null, TEXT_XPATH);
        setting.setObject(this.dataObject);
        setting.setValue(string, false);
        this.settings.add(setting);
    }

    public Property getProperty(int n) {
        try {
            return this.getProperty(this.settings.get(n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SDOException.invalidIndex(indexOutOfBoundsException, n);
        }
    }

    public Property getProperty(Setting setting) {
        DatabaseMapping databaseMapping = setting.getMapping();
        if (null == databaseMapping) {
            List<Setting> list = setting.getChildren();
            if (null != list && list.size() > 0) {
                return this.getProperty(list.get(0));
            }
        } else {
            SDOProperty sDOProperty = null;
            if (null == setting.getName()) {
                Object object = setting.getValue();
                if (object instanceof DataObject) {
                    Property property = ((DataObject)object).getContainmentProperty();
                    if (property != null) {
                        sDOProperty = this.dataObject.getInstanceProperty(property.getName());
                    }
                    if (sDOProperty == null) {
                        XMLDescriptor xMLDescriptor = ((SDOType)((DataObject)object).getType()).getXmlDescriptor();
                        String string = xMLDescriptor.getDefaultRootElement();
                        int n = string.indexOf(58);
                        String string2 = null;
                        string2 = n > -1 ? string.substring(n + 1, string.length()) : string;
                        sDOProperty = this.dataObject.getInstanceProperty(string2);
                    }
                } else {
                    XMLRoot xMLRoot = (XMLRoot)object;
                    if (null != xMLRoot) {
                        sDOProperty = this.dataObject.getInstanceProperty(xMLRoot.getLocalName());
                    }
                }
            } else {
                sDOProperty = this.dataObject.getInstanceProperty(databaseMapping.getAttributeName());
            }
            return sDOProperty;
        }
        return null;
    }

    public Object getValue(int n) {
        try {
            return this.getValue(this.settings.get(n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SDOException.invalidIndex(indexOutOfBoundsException, n);
        }
    }

    private Object getValue(Setting setting) {
        if (null != setting.getMapping() || setting.getName() != null && setting.getName().equals(TEXT_XPATH)) {
            Object object = setting.getValue();
            if (object instanceof XMLRoot) {
                object = ((XMLRoot)object).getObject();
            }
            return object;
        }
        if (null == setting.getChildren() || setting.getChildren().size() == 0) {
            return null;
        }
        return this.getValue(setting.getChildren().get(0));
    }

    public void move(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = this.settings.size();
        if (n2 < 0 || n2 >= n3) {
            throw SDOException.invalidIndex(null, n2);
        }
        if (n < 0 || n >= n3) {
            throw SDOException.invalidIndex(null, n);
        }
        this.dataObject._setModified(true);
        Setting setting = this.settings.remove(n2);
        this.settings.add(n, setting);
        Property property = this.getProperty(setting);
        if (property != null && property.isMany()) {
            ListWrapper listWrapper = (ListWrapper)this.dataObject.getList(property);
            Object object = this.getValue(setting);
            int n4 = listWrapper.indexOf(object);
            listWrapper.remove(n4, false);
            int n5 = this.getIndexInList(property, object);
            listWrapper.add(n5, object, false);
        }
    }

    public void remove(int n) {
        Setting setting = this.settings.get(n);
        this.remove(setting);
        this.settings.remove(setting);
    }

    private void remove(Setting setting) {
        Object object;
        DatabaseMapping databaseMapping = setting.getMapping();
        if (null != databaseMapping) {
            Object object2;
            object = null;
            if (null == setting.getName()) {
                object2 = (XMLRoot)setting.getValue();
                if (null != object2) {
                    object = this.dataObject.getInstanceProperty(((XMLRoot)object2).getLocalName());
                    this.valuesToSettings.remove(new Key((Property)object, setting.getValue()));
                }
            } else {
                object = this.dataObject.getInstanceProperty(databaseMapping.getAttributeName());
                this.valuesToSettings.remove(new Key((Property)object, setting.getValue()));
            }
            if (object.isMany()) {
                object2 = (ListWrapper)this.dataObject.getList((Property)object);
                ((ListWrapper)object2).remove(setting.getValue(), false, false);
            } else {
                this.dataObject.unset((Property)object, false, false);
            }
        } else if (setting.getName() != null && setting.getName().equals(TEXT_XPATH)) {
            this.dataObject._setModified(true);
        }
        object = setting.getChildren();
        if (null != object) {
            int n = object.size();
            for (int i = 0; i < n; ++i) {
                this.remove((Setting)object.get(i));
            }
        }
    }

    public void addValueToSettings(Setting setting) {
        this.valuesToSettings.put(new Key(this.getProperty(setting), this.getValue(setting)), setting);
    }

    public void removeValueToSettings(Setting setting) {
        this.valuesToSettings.remove(new Key(this.getProperty(setting), this.getValue(setting)));
    }

    public Object setValue(int n, Object object) {
        return this.setValue(this.settings.get(n), object);
    }

    private Object setValue(Setting setting, Object object) {
        if (null == setting.getMapping()) {
            if (setting.getName() != null && setting.getName().equals(TEXT_XPATH)) {
                this.dataObject._setModified(true);
                Object object2 = setting.getValue();
                setting.setValue(object, false);
                return object2;
            }
            List<Setting> list = setting.getChildren();
            if (null != list && list.size() > 0) {
                return this.setValue(list.get(0), object);
            }
            return null;
        }
        Property property = this.getProperty(setting);
        Object object3 = setting.getValue();
        if (property.isMany()) {
            ListWrapper listWrapper = (ListWrapper)this.dataObject.getList(property);
            int n = listWrapper.indexOf(object3);
            listWrapper.remove(object3, property.isContainment(), false);
            listWrapper.add(n, object, false);
            setting.setValue(object, false);
        } else {
            if (this.dataObject.isSet(property)) {
                this.updateSettingWithoutModifyingDataObject(property, this.dataObject.get(property), object);
                setting.setValue(object);
            } else {
                this.addSettingWithoutModifyingDataObject(property, object);
            }
            this.dataObject.setPropertyInternal((SDOProperty)property, object, false);
        }
        return object3;
    }

    public int size() {
        return this.settings.size();
    }

    private Setting convertToSetting(Property property, Object object) {
        SDOProperty sDOProperty = (SDOProperty)property;
        DatabaseMapping databaseMapping = sDOProperty.getXmlMapping();
        Setting setting = new Setting();
        SDOType sDOType = this.dataObject.getType();
        XMLDescriptor xMLDescriptor = sDOType.getXmlDescriptor();
        if (null == databaseMapping) {
            setting.setObject(this.dataObject);
            databaseMapping = xMLDescriptor.getMappingForAttributeName("openContentProperties");
            setting.setMapping(databaseMapping);
            XMLRoot xMLRoot = new XMLRoot();
            if (object instanceof XMLRoot) {
                xMLRoot.setLocalName(((XMLRoot)object).getLocalName());
                xMLRoot.setNamespaceURI(((XMLRoot)object).getNamespaceURI());
                xMLRoot.setObject(((XMLRoot)object).getObject());
            } else {
                QName qName;
                xMLRoot.setLocalName(sDOProperty.getName());
                xMLRoot.setNamespaceURI(sDOProperty.getUri());
                xMLRoot.setObject(object);
                SDOTypeHelper sDOTypeHelper = (SDOTypeHelper)this.dataObject.getType().getHelperContext().getTypeHelper();
                if (sDOTypeHelper.getOpenContentProperty(sDOProperty.getUri(), sDOProperty.getName()) == null && (qName = sDOTypeHelper.getXSDTypeFromSDOType(property.getType())) != null && qName != XMLConstants.STRING_QNAME) {
                    xMLRoot.setSchemaType(qName);
                }
            }
            setting.setValue(xMLRoot, false);
        } else {
            setting = this.convertToSetting(databaseMapping, object);
        }
        return setting;
    }

    private Setting convertToSetting(DatabaseMapping databaseMapping, Object object) {
        XMLDescriptor xMLDescriptor = (XMLDescriptor)databaseMapping.getDescriptor();
        NamespaceResolver namespaceResolver = xMLDescriptor.getNamespaceResolver();
        Setting setting = new Setting();
        XMLField xMLField = (XMLField)databaseMapping.getField();
        if (xMLField == null) {
            if (databaseMapping instanceof XMLObjectReferenceMapping) {
                xMLField = (XMLField)((XMLObjectReferenceMapping)databaseMapping).getFields().get(0);
            } else if (databaseMapping instanceof XMLCollectionReferenceMapping) {
                xMLField = (XMLField)((XMLCollectionReferenceMapping)databaseMapping).getFields().get(0);
            }
        }
        Setting setting2 = setting;
        if (xMLField != null) {
            XPathFragment xPathFragment = xMLField.getXPathFragment();
            setting2 = setting = this.convertToSetting(xPathFragment, namespaceResolver);
            while (xPathFragment.getNextFragment() != null) {
                xPathFragment = xPathFragment.getNextFragment();
                Setting setting3 = this.convertToSetting(xPathFragment, namespaceResolver);
                setting2.addChild(setting3);
                setting2 = setting3;
            }
        }
        setting2.setObject(this.dataObject);
        setting2.setMapping(databaseMapping);
        setting2.setValue(object, false);
        return setting;
    }

    private Setting convertToSetting(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        Setting setting = new Setting();
        String string = xPathFragment.getLocalName();
        if (null == string) {
            string = xPathFragment.getShortName();
        }
        setting.setName(string);
        if (xPathFragment.hasNamespace()) {
            setting.setNamespaceURI(namespaceResolver.resolveNamespacePrefix(xPathFragment.getPrefix()));
        }
        return setting;
    }

    public SDOSequence copy() {
        SDOSequence sDOSequence = new SDOSequence(this.dataObject);
        int n = this.settings.size();
        for (int i = 0; i < n; ++i) {
            Setting setting = this.settings.get(i).copy();
            sDOSequence.getSettings().add(setting);
            sDOSequence.getValuesToSettings().put(new Key(this.getProperty(setting), this.getValue(setting)), setting);
        }
        return sDOSequence;
    }

    public boolean addSettingWithoutModifyingDataObject(int n, Property property, Object object) {
        Setting setting = this.convertToSetting(property, object);
        this.valuesToSettings.put(new Key(property, object), setting);
        if (n >= 0) {
            this.settings.add(n, setting);
        } else {
            this.settings.add(setting);
        }
        return true;
    }

    public boolean addSettingWithoutModifyingDataObject(Property property, Object object) {
        return this.addSettingWithoutModifyingDataObject(property, object, true);
    }

    public boolean addSettingWithoutModifyingDataObject(Property property, Object object, boolean bl) {
        if (bl && !this.isAllowedInSequence(property)) {
            return false;
        }
        Setting setting = this.convertToSetting(property, object);
        this.valuesToSettings.put(new Key(property, object), setting);
        this.settings.add(setting);
        return true;
    }

    public void updateSettingWithoutModifyingDataObject(Property property, Object object, Object object2) {
        Key key = new Key(property, object);
        Setting setting = this.valuesToSettings.get(key);
        this.valuesToSettings.remove(key);
        this.valuesToSettings.put(new Key(property, object2), setting);
        while (setting.getMapping() == null) {
            List<Setting> list = setting.getChildren();
            if (list == null || list.size() <= 0) continue;
            setting = list.get(0);
        }
        setting.setValue(object2, false);
    }

    public void removeSettingWithoutModifyingDataObject(Property property, Object object) {
        this.settings.remove(this.valuesToSettings.remove(new Key(property, object)));
    }

    public void removeSettingWithoutModifyingDataObject(Property property) {
        ArrayList<Key> arrayList = new ArrayList<Key>(this.valuesToSettings.keySet());
        int n = this.valuesToSettings.keySet().size();
        for (int i = n - 1; i >= 0; --i) {
            Key key = (Key)arrayList.get(i);
            if (key.getProperty() != property) continue;
            this.settings.remove(this.valuesToSettings.remove(key));
        }
    }

    public int getIndexForProperty(Property property) {
        ArrayList<Key> arrayList = new ArrayList<Key>(this.valuesToSettings.keySet());
        for (int i = 0; i < arrayList.size(); ++i) {
            Key key = (Key)arrayList.get(i);
            if (key.getProperty() != property) continue;
            return this.settings.indexOf(this.valuesToSettings.get(key));
        }
        return -1;
    }

    private int getIndexInList(Property property, Object object) {
        int n = -1;
        for (int i = 0; i < this.settings.size(); ++i) {
            Setting setting = this.settings.get(i);
            Property property2 = this.getProperty(setting);
            if (!property2.equals(property)) continue;
            ++n;
            if (!object.equals(this.getValue(setting))) continue;
            return n;
        }
        return n;
    }

    public static Setting getRootSetting(Setting setting) {
        Setting setting2 = setting;
        while (setting2.getParent() != null) {
            setting2 = setting2.getParent();
        }
        return setting2;
    }

    public void afterUnmarshal() {
        Iterator<Setting> iterator = this.getSettings().iterator();
        while (iterator.hasNext()) {
            this.addValueToSettings(iterator.next());
        }
    }

    private static class Key {
        private Property property;
        private Object value;

        public Key(Property property, Object object) {
            this.property = property;
            this.value = object;
        }

        protected Property getProperty() {
            return this.property;
        }

        protected Object getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            try {
                Key key = (Key)object;
                return this.property == key.getProperty() && this.value == key.getValue();
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            if (this.value == null) {
                return 0;
            }
            return this.value.hashCode();
        }
    }
}

