/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOClassGeneratorListener;

public class ClassBuffer {
    private static final String lsep = System.getProperty("line.separator");
    private static final String lsep2 = lsep + lsep;
    private String indent = "";
    private StringBuffer attributeBuffer;
    private StringBuffer methodBuffer;
    private StringBuffer classBuffer;
    private StringBuffer interfaceBuffer;
    private String interfaceName;
    private String className;
    private String packageName;
    private String uri;
    private String sdoTypeName;
    private boolean closed;
    private boolean generateInterface;
    private SDOType sdoType;
    private SDOClassGeneratorListener sdoClassGeneratorListener;

    public ClassBuffer(SDOClassGeneratorListener sDOClassGeneratorListener) {
        this.setAttributeBuffer(new StringBuffer());
        this.setMethodBuffer(new StringBuffer());
        this.setClassBuffer(new StringBuffer());
        this.setInterfaceBuffer(new StringBuffer());
        this.sdoClassGeneratorListener = sDOClassGeneratorListener;
    }

    public void setAttributeBuffer(StringBuffer stringBuffer) {
        this.attributeBuffer = stringBuffer;
    }

    public StringBuffer getAttributeBuffer() {
        return this.attributeBuffer;
    }

    public void setMethodBuffer(StringBuffer stringBuffer) {
        this.methodBuffer = stringBuffer;
    }

    public StringBuffer getMethodBuffer() {
        return this.methodBuffer;
    }

    public void setClassBuffer(StringBuffer stringBuffer) {
        this.classBuffer = stringBuffer;
    }

    public StringBuffer getClassBuffer() {
        return this.classBuffer;
    }

    public void setInterfaceBuffer(StringBuffer stringBuffer) {
        this.interfaceBuffer = stringBuffer;
    }

    public StringBuffer getInterfaceBuffer() {
        return this.interfaceBuffer;
    }

    public void close() {
        if (!this.closed) {
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preImplAttributes(this.classBuffer);
            }
            this.classBuffer.append(this.attributeBuffer);
            this.classBuffer.append(this.methodBuffer);
            this.classBuffer.append(lsep).append(this.indent).append("}").append(lsep2);
            this.closed = true;
            if (this.isGenerateInterface()) {
                this.interfaceBuffer.append(lsep).append(this.indent).append("}").append(lsep2);
            }
        }
    }

    public void setGenerateInterface(boolean bl) {
        this.generateInterface = bl;
    }

    public boolean isGenerateInterface() {
        return this.generateInterface;
    }

    public void setInterfaceName(String string) {
        this.interfaceName = string;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getClassName() {
        return this.className;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setSdoTypeName(String string) {
        this.sdoTypeName = string;
    }

    public String getSdoTypeName() {
        return this.sdoTypeName;
    }

    public void setSdoType(SDOType sDOType) {
        this.sdoType = sDOType;
    }

    public SDOType getSdoType() {
        return this.sdoType;
    }
}

