/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOSequence;

public class ListWrapper
implements List,
Serializable,
Cloneable {
    protected SDODataObject dataObject;
    protected Property property;
    protected List currentElements = this.getEmptyList();

    private List getEmptyList() {
        return new ArrayList();
    }

    public ListWrapper() {
    }

    public ListWrapper(SDODataObject sDODataObject, Property property) {
        this();
        this.dataObject = sDODataObject;
        this.property = property;
    }

    public ListWrapper(SDODataObject sDODataObject, Property property, List list) {
        this(sDODataObject, property);
        this.currentElements = list;
    }

    public boolean add(Object object) {
        return this.add(object, true);
    }

    public boolean add(Object object, boolean bl) {
        Property property;
        if (object == null && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        this.copyElements();
        boolean bl2 = this.currentElements.add(object);
        this.updateContainment(object, bl);
        if (this.property != null && object != null && (property = this.property.getOpposite()) != null) {
            ((DataObject)object).set(property, (Object)this.dataObject);
        }
        return bl2;
    }

    public void add(int n, Object object) {
        this.add(n, object, true);
    }

    public void add(int n, Object object, boolean bl) {
        Property property;
        if (object == null && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        if (n < 0 || n > this.size()) {
            return;
        }
        this.copyElements();
        this.currentElements.add(n, object);
        this.updateContainment(object, bl);
        if (this.property != null && object != null && (property = this.property.getOpposite()) != null) {
            ((DataObject)object).set(property, (Object)this.dataObject);
            this.dataObject.set(property, null);
        }
    }

    protected boolean isLogging() {
        return this.dataObject != null && this.dataObject.getChangeSummary() != null && this.dataObject.getChangeSummary().isLogging();
    }

    protected void copyElements() {
        if (this.isLogging() && !((SDOChangeSummary)this.dataObject.getChangeSummary()).isDirty(this)) {
            ((SDOChangeSummary)this.dataObject.getChangeSummary()).getOriginalElements().put(this, this.currentElements);
            this.currentElements = new ArrayList(this.currentElements);
        }
    }

    public void undoChanges(SDOChangeSummary sDOChangeSummary) {
        if (null == sDOChangeSummary) {
            return;
        }
        if (sDOChangeSummary.isDirty(this)) {
            this.currentElements = (List)sDOChangeSummary.getOriginalElements().get(this);
            sDOChangeSummary.getOriginalElements().remove(this);
        }
    }

    protected void updateSequence(Property property, Collection collection, boolean bl) {
        if (bl) {
            Iterator iterator = collection.iterator();
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (null != property && !property.getType().isDataType() && property.isContainment()) {
                    if (arrayList.contains(e)) continue;
                    this.updateSequenceSettingInternal(this.property, e);
                    arrayList.add(e);
                    continue;
                }
                this.updateSequenceSettingInternal(this.property, e);
            }
        }
    }

    private void updateSequenceSettingInternal(Property property, Object object) {
        if (this.dataObject.getType().isSequenced()) {
            ((SDOSequence)this.dataObject.getSequence()).addSettingWithoutModifyingDataObject(this.property, object);
        }
    }

    private void removeSequenceSettingInternal(int n, Property property, Object object) {
        if (this.dataObject.getType().isSequenced()) {
            ((SDOSequence)this.dataObject.getSequence()).removeSettingWithoutModifyingDataObject(this.property, object);
        }
    }

    protected void updateContainment(Object object, boolean bl) {
        if (this.property != null && this.property.isContainment() && object instanceof SDODataObject) {
            this.dataObject.updateContainment(this.property, (SDODataObject)object);
        } else if (this.dataObject != null) {
            this.dataObject._setModified(true);
        }
        if (this.property != null && bl) {
            this.updateSequenceSettingInternal(this.property, object);
        }
    }

    protected void updateContainment(Collection collection, boolean bl) {
        if (this.property != null && this.property.isContainment()) {
            this.dataObject.updateContainment(this.property, collection, bl);
        } else if (this.dataObject != null) {
            this.dataObject._setModified(true);
        }
    }

    protected void removeContainment(Object object, boolean bl, boolean bl2) {
        this.removeContainment(0, object, bl, bl2);
    }

    protected void removeContainment(int n, Object object, boolean bl, boolean bl2) {
        if (this.property != null && this.property.isContainment() && object != null) {
            ((SDODataObject)object).detachOrDelete(bl);
        } else {
            this.dataObject._setModified(true);
        }
        if (this.property != null && this.dataObject.getType().isSequenced() && bl2) {
            this.removeSequenceSettingInternal(n, this.property, object);
        }
    }

    public boolean remove(Object object, boolean bl, boolean bl2) {
        this.copyElements();
        this.removeContainment(object, bl, bl2);
        return this.currentElements.remove(object);
    }

    public boolean remove(Object object) {
        return this.remove(object, false, true);
    }

    public boolean addAll(Collection collection) {
        return this.addAll(collection, true);
    }

    public boolean addAll(Collection collection, boolean bl) {
        Property property;
        if (collection.contains(null) && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        this.copyElements();
        boolean bl2 = this.currentElements.addAll(collection);
        this.dataObject._getCurrentValueStore().setManyProperty(this.property, this);
        this.updateContainment(collection, bl);
        if (this.property != null && (property = this.property.getOpposite()) != null) {
            for (Object e : collection) {
                if (e == null) continue;
                ((DataObject)e).set(property, (Object)this.dataObject);
            }
        }
        this.updateSequence(this.property, collection, bl);
        return bl2;
    }

    public boolean addAll(int n, Collection collection) {
        return this.addAll(n, collection, true);
    }

    public boolean addAll(int n, Collection collection, boolean bl) {
        Property property;
        if (n < 0 || n > this.size()) {
            return false;
        }
        if (collection == null || collection.size() == 0) {
            return false;
        }
        if (collection.contains(null) && this.property != null && !this.property.isNullable()) {
            throw new UnsupportedOperationException("Property [" + this.property.getName() + "] is non-nullable");
        }
        this.copyElements();
        boolean bl2 = this.currentElements.addAll(n, collection);
        this.updateContainment(collection, bl);
        if (this.property != null && (property = this.property.getOpposite()) != null) {
            for (Object e : collection) {
                if (e == null) continue;
                ((DataObject)e).set(property, (Object)this.dataObject);
                this.dataObject.set(property, null);
            }
        }
        this.updateSequence(this.property, collection, bl);
        return bl2;
    }

    public boolean removeAll(Collection collection) {
        return this.removeAll(collection, true);
    }

    public boolean removeAll(Collection collection, boolean bl) {
        Iterator iterator = collection.iterator();
        boolean bl2 = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            this.remove(e, false, bl);
            bl2 = true;
        }
        return bl2;
    }

    public boolean retainAll(Collection collection) {
        if (collection == null) {
            return false;
        }
        if (collection.size() == 0) {
            this.clear();
            return true;
        }
        boolean bl = false;
        int n = this.size();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Object object = this.get(n2);
            if (!collection.contains(object)) {
                this.remove(object);
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl;
    }

    public void clear() {
        this.clear(true);
    }

    public void clear(boolean bl) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            this.remove(i, bl);
        }
    }

    public Object set(int n, Object object) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("index " + n + " is out of bounds.");
        }
        Object object2 = this.remove(n);
        this.add(n, object);
        return object2;
    }

    public Object remove(int n, boolean bl) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        this.copyElements();
        int n2 = this.getOccurrenceIndex(n);
        this.removeContainment(n2, this.currentElements.get(n), false, bl);
        return this.currentElements.remove(n);
    }

    private int getOccurrenceIndex(int n) {
        int n2 = 0;
        boolean bl = true;
        Object e = this.currentElements.get(n);
        int n3 = this.size();
        for (int i = 0; i < n3 && i < n + 1; ++i) {
            Object e2 = this.currentElements.get(i);
            if (e != e2) continue;
            if (bl) {
                bl = false;
                continue;
            }
            ++n2;
        }
        return n2;
    }

    public Object remove(int n) {
        return this.remove(n, true);
    }

    public ListIterator listIterator() {
        return this.currentElements.listIterator();
    }

    public ListIterator listIterator(int n) {
        return this.currentElements.listIterator(n);
    }

    public List subList(int n, int n2) {
        return this.currentElements.subList(n, n2);
    }

    public Object[] toArray() {
        return this.currentElements.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.currentElements.toArray(objectArray);
    }

    public int size() {
        return this.currentElements.size();
    }

    public boolean isEmpty() {
        return this.currentElements.isEmpty();
    }

    public boolean contains(Object object) {
        return this.currentElements.contains(object);
    }

    public boolean containsAll(Collection collection) {
        return this.currentElements.containsAll(collection);
    }

    public Iterator iterator() {
        return this.currentElements.iterator();
    }

    public int indexOf(Object object) {
        return this.currentElements.indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return this.currentElements.lastIndexOf(object);
    }

    public Object get(int n) {
        try {
            return this.currentElements.get(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object writeReplace() {
        return this.currentElements;
    }

    public List getCurrentElements() {
        return this.currentElements;
    }

    public void setCurrentElements(List list) {
        this.currentElements = list;
    }

    public Object clone() {
        ListWrapper listWrapper = new ListWrapper(this.dataObject, this.property);
        listWrapper.setCurrentElements(new ArrayList(this.currentElements));
        return listWrapper;
    }
}

