/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.DataHelper;
import commonj.sdo.helper.HelperContext;
import commonj.sdo.impl.HelperProvider;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;

public class SDODataHelper
implements DataHelper {
    private HelperContext aHelperContext;

    public SDODataHelper() {
    }

    public SDODataHelper(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    private XMLConversionManager getXMLConversionManager() {
        return ((SDOXMLHelper)this.getHelperContext().getXMLHelper()).getXmlConversionManager();
    }

    public void setTimeZone(TimeZone timeZone) {
        if (null == timeZone) {
            this.getXMLConversionManager().setTimeZone(TimeZone.getTimeZone("GMT"));
        } else {
            this.getXMLConversionManager().setTimeZone(timeZone);
        }
    }

    public void setTimeZoneQualified(boolean bl) {
        this.getXMLConversionManager().setTimeZoneQualified(bl);
    }

    private Calendar toCalendar(Duration duration, Locale locale) {
        Calendar calendar = locale == null ? Calendar.getInstance(this.getXMLConversionManager().getTimeZone()) : Calendar.getInstance(this.getXMLConversionManager().getTimeZone(), locale);
        calendar.setTimeInMillis(duration.getTimeInMillis(calendar));
        calendar.set(1, duration.getYears());
        calendar.set(2, duration.getMonths() - 1);
        calendar.set(5, duration.getDays());
        calendar.set(11, duration.getHours());
        calendar.set(12, duration.getMinutes());
        calendar.set(13, duration.getSeconds());
        return calendar;
    }

    public Calendar toCalendar(String string) {
        return this.toCalendar(string, null);
    }

    public Calendar toCalendar(String string, Locale locale) {
        GregorianCalendar gregorianCalendar;
        if (null == string) {
            return null;
        }
        if (string.startsWith("P")) {
            return this.toCalendar(this.getXMLConversionManager().convertStringToDuration(string), locale);
        }
        XMLGregorianCalendar xMLGregorianCalendar = this.getXMLConversionManager().convertStringToXMLGregorianCalendar(string);
        if (xMLGregorianCalendar.getTimezone() == Integer.MIN_VALUE) {
            gregorianCalendar = xMLGregorianCalendar.toGregorianCalendar(this.getXMLConversionManager().getTimeZone(), locale, null);
            gregorianCalendar.clear(15);
        } else {
            gregorianCalendar = xMLGregorianCalendar.toGregorianCalendar(xMLGregorianCalendar.getTimeZone(xMLGregorianCalendar.getTimezone()), locale, null);
        }
        return gregorianCalendar;
    }

    public Date toDate(String string) {
        if (null == string) {
            return null;
        }
        if (string.startsWith("P")) {
            Calendar calendar = this.toCalendar(this.getXMLConversionManager().convertStringToDuration(string), null);
            return calendar.getTime();
        }
        try {
            return this.getXMLConversionManager().convertStringToDate(string, null);
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(conversionException);
        }
    }

    public String toDateTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.DATE_TIME_QNAME);
    }

    public String toDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.DATE_TIME_QNAME);
    }

    public String toDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_DAY_QNAME);
    }

    public String toDay(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_DAY_QNAME);
    }

    public String toDuration(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("P");
        stringBuffer.append(calendar.get(1));
        stringBuffer.append("Y");
        stringBuffer.append(calendar.get(2) + 1);
        stringBuffer.append("M");
        stringBuffer.append(calendar.get(5));
        stringBuffer.append("DT");
        stringBuffer.append(calendar.get(10));
        stringBuffer.append("H");
        stringBuffer.append(calendar.get(12));
        stringBuffer.append("M");
        float f = calendar.get(13) * 1000 + calendar.get(14);
        stringBuffer.append(f / 1000.0f);
        stringBuffer.append("S");
        return stringBuffer.toString();
    }

    public String toDuration(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
        return this.toDuration(calendar);
    }

    public String toMonth(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_MONTH_QNAME);
    }

    public String toMonth(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_MONTH_QNAME);
    }

    public String toMonthDay(Calendar calendar) {
        int n;
        if (calendar == null) {
            return null;
        }
        String string = "--";
        boolean bl = calendar.isSet(15);
        if (!calendar.isSet(2) || !calendar.isSet(5)) {
            // empty if block
        }
        if ((n = calendar.get(2) + 1) < 10) {
            string = string + "0";
        }
        string = string + n + "-";
        int n2 = calendar.get(5);
        if (n2 < 10) {
            string = string + "0";
        }
        string = string + n2;
        if (bl) {
            int n3 = calendar.get(15);
            if (0 != n3) {
                if (n3 > 0) {
                    string = string + "+";
                } else {
                    string = string + "-";
                    n3 *= -1;
                }
                double d = (double)n3 / 3600000.0;
                if (d < 10.0) {
                    string = string + "0";
                }
                string = string + (int)d + ":";
                int n4 = (int)((d - (double)((int)d)) * 60.0);
                if (n4 < 10) {
                    string = string + "0";
                }
                string = string + n4;
            } else {
                string = string + "Z";
            }
        }
        return string;
    }

    public String toMonthDay(Date date) {
        if (null == date) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.getXMLConversionManager().getTimeZone());
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        gregorianCalendar.clear();
        gregorianCalendar.setTime(date);
        gregorianCalendar.clear(15);
        return this.toMonthDay(gregorianCalendar);
    }

    public String toTime(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.TIME_QNAME);
    }

    public String toTime(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.TIME_QNAME);
    }

    public String toYear(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_YEAR_QNAME);
    }

    public String toYear(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_YEAR_QNAME);
    }

    public String toYearMonth(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.G_YEAR_MONTH_QNAME);
    }

    public String toYearMonthDay(Date date) {
        if (date == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromDate(date, XMLConstants.DATE_QNAME);
    }

    public String toYearMonth(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.G_YEAR_MONTH_QNAME);
    }

    public String toYearMonthDay(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return this.getXMLConversionManager().stringFromCalendar(calendar, XMLConstants.DATE_QNAME);
    }

    private void setCalendar(Calendar calendar, int n, int n2) {
        switch (n) {
            case 0: {
                calendar.set(1, n2);
                break;
            }
            case 1: {
                calendar.set(2, n2 - 1);
                break;
            }
            case 2: {
                calendar.set(5, n2);
                break;
            }
            case 3: {
                calendar.set(10, n2);
                break;
            }
            case 4: {
                calendar.set(12, n2);
                break;
            }
            case 5: {
                calendar.set(13, n2);
                break;
            }
            case 6: {
                calendar.set(14, n2);
            }
        }
    }

    public Object convertValue(Object object, Class clazz, QName qName) {
        return this.getXMLConversionManager().convertObject(object, clazz, qName);
    }

    public Object convertFromStringValue(String string, Class clazz) {
        if (clazz == ClassConstants.UTILDATE) {
            return this.toDate(string);
        }
        if (clazz == ClassConstants.CALENDAR) {
            return this.toCalendar(string);
        }
        return this.getXMLConversionManager().convertObject(string, clazz);
    }

    public Object convertFromStringValue(String string, Type type) {
        return this.convertFromStringValue(string, type, null);
    }

    public Object convertFromStringValue(String string, Type type, QName qName) {
        Class clazz = ((SDOTypeHelper)this.getHelperContext().getTypeHelper()).getJavaWrapperTypeForSDOType(type);
        if (clazz != null) {
            if (qName == null) {
                return ((SDODataHelper)this.getHelperContext().getDataHelper()).convertFromStringValue(string, clazz);
            }
            return ((SDODataHelper)this.getHelperContext().getDataHelper()).convertFromStringValue(string, clazz, qName);
        }
        return string;
    }

    public Object convertFromStringValue(String string, Class clazz, QName qName) {
        if (clazz == ClassConstants.UTILDATE) {
            return this.toDate(string);
        }
        if (clazz == ClassConstants.CALENDAR) {
            return this.toCalendar(string);
        }
        return this.getXMLConversionManager().convertObject(string, clazz, qName);
    }

    public String convertToStringValue(Object object, Type type) {
        return this.convertToStringValue(object, type, null);
    }

    private String convertToStringValue(Object object, Type type, QName qName) {
        if (object.getClass() == ClassConstants.CALENDAR) {
            if (type.equals(SDOConstants.SDO_DATETIME)) {
                return this.toDateTime((Calendar)object);
            }
            if (type.equals(SDOConstants.SDO_TIME)) {
                return this.toTime((Calendar)object);
            }
            if (type.equals(SDOConstants.SDO_DAY)) {
                return this.toDay((Calendar)object);
            }
            if (type.equals(SDOConstants.SDO_DURATION)) {
                return this.toDuration((Calendar)object);
            }
            if (type.equals(SDOConstants.SDO_MONTH)) {
                return this.toMonth((Calendar)object);
            }
            if (type.equals(SDOConstants.SDO_MONTHDAY)) {
                return this.toMonthDay((Calendar)object);
            }
            if (type.equals(SDOConstants.SDO_YEAR)) {
                return this.toYear((Calendar)object);
            }
            if (type.equals(SDOConstants.SDO_YEARMONTH)) {
                return this.toYearMonth((Calendar)object);
            }
            if (type.equals(SDOConstants.SDO_YEARMONTHDAY)) {
                return this.toYearMonthDay((Calendar)object);
            }
        } else if (object.getClass() == ClassConstants.UTILDATE) {
            if (type.equals(SDOConstants.SDO_DATETIME)) {
                return this.toDateTime((Date)object);
            }
            if (type.equals(SDOConstants.SDO_TIME)) {
                return this.toTime((Date)object);
            }
            if (type.equals(SDOConstants.SDO_DAY)) {
                return this.toDay((Date)object);
            }
            if (type.equals(SDOConstants.SDO_DURATION)) {
                return this.toDuration((Date)object);
            }
            if (type.equals(SDOConstants.SDO_MONTH)) {
                return this.toMonth((Date)object);
            }
            if (type.equals(SDOConstants.SDO_MONTHDAY)) {
                return this.toMonthDay((Date)object);
            }
            if (type.equals(SDOConstants.SDO_YEAR)) {
                return this.toYear((Date)object);
            }
            if (type.equals(SDOConstants.SDO_YEARMONTH)) {
                return this.toYearMonth((Date)object);
            }
            if (type.equals(SDOConstants.SDO_YEARMONTHDAY)) {
                return this.toYearMonthDay((Date)object);
            }
        } else if (object.getClass().getName().equals("javax.activation.DataHandler")) {
            try {
                Class clazz = PrivilegedAccessHelper.getClassForName("org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper");
                Method method = PrivilegedAccessHelper.getMethod(clazz, "getXMLBinaryDataHelper", new Class[0], false);
                Method method2 = PrivilegedAccessHelper.getMethod(clazz, "stringFromDataHandler", new Class[]{Object.class, QName.class, AbstractSession.class}, false);
                Object object2 = PrivilegedAccessHelper.invokeMethod(method, clazz, new Object[0]);
                String string = (String)PrivilegedAccessHelper.invokeMethod(method2, object2, new Object[]{object, qName, ((SDOXMLHelper)this.getHelperContext().getXMLHelper()).getXmlContext().getSession(0)});
                return string;
            }
            catch (Exception exception) {
                return (String)this.getXMLConversionManager().convertObject(object, ClassConstants.STRING, qName);
            }
        }
        return (String)this.getXMLConversionManager().convertObject(object, ClassConstants.STRING, qName);
    }

    public Object convert(Type type, Object object) {
        Class clazz = null;
        if (type.isDataType()) {
            clazz = type.getInstanceClass();
        }
        if (object.getClass() == ClassConstants.STRING) {
            return this.convertFromStringValue((String)object, type);
        }
        if (clazz == ClassConstants.STRING) {
            return this.convertToStringValue(object, type);
        }
        try {
            return this.getXMLConversionManager().convertObject(object, clazz);
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(SDOException.conversionError(conversionException));
        }
    }

    public Object convert(Property property, Object object) {
        if (null == property) {
            throw new IllegalArgumentException(SDOException.conversionError(null));
        }
        Type type = property.getType();
        if (property.isMany()) {
            if (object == null) {
                return null;
            }
            if (!(object instanceof List)) {
                throw new IllegalArgumentException(SDOException.conversionError(null));
            }
            List list = (List)object;
            Object var5_5 = null;
            for (int i = 0; i < list.size(); ++i) {
                var5_5 = list.get(i);
                list.set(i, this.convert(type, var5_5));
            }
            return list;
        }
        return this.convert(type, object);
    }

    public Object convertValueToClass(Property property, Object object, Class clazz) {
        try {
            if (object == null) {
                return null;
            }
            if (clazz == ClassConstants.STRING) {
                return this.convertToStringValue(object, property.getType(), ((SDOProperty)property).getXsdType());
            }
            SDOProperty sDOProperty = (SDOProperty)property;
            DatabaseMapping databaseMapping = sDOProperty.getXmlMapping();
            if (databaseMapping != null && databaseMapping.isDirectToFieldMapping() && sDOProperty.getXsdType() != null) {
                return this.getXMLConversionManager().convertObject(object, clazz, sDOProperty.getXsdType());
            }
            return this.getXMLConversionManager().convertObject(object, clazz);
        }
        catch (ConversionException conversionException) {
            throw new IllegalArgumentException(SDOException.conversionError(conversionException));
        }
    }

    public HelperContext getHelperContext() {
        if (null == this.aHelperContext) {
            this.aHelperContext = HelperProvider.getDefaultContext();
        }
        return this.aHelperContext;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }
}

