/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.All;
import org.eclipse.persistence.internal.oxm.schema.model.Annotation;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.Attribute;
import org.eclipse.persistence.internal.oxm.schema.model.AttributeGroup;
import org.eclipse.persistence.internal.oxm.schema.model.Choice;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexContent;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Element;
import org.eclipse.persistence.internal.oxm.schema.model.Extension;
import org.eclipse.persistence.internal.oxm.schema.model.Group;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.Include;
import org.eclipse.persistence.internal.oxm.schema.model.List;
import org.eclipse.persistence.internal.oxm.schema.model.NestedParticle;
import org.eclipse.persistence.internal.oxm.schema.model.Restriction;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleComponent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleContent;
import org.eclipse.persistence.internal.oxm.schema.model.SimpleType;
import org.eclipse.persistence.internal.oxm.schema.model.TypeDefParticle;
import org.eclipse.persistence.internal.oxm.schema.model.Union;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.SDOXSDHelper;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.eclipse.persistence.sdo.helper.SchemaResolverWrapper;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;
import org.eclipse.persistence.sdo.types.SDODataType;
import org.eclipse.persistence.sdo.types.SDOWrapperType;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDOTypesGenerator {
    private Project schemaProject;
    private Schema rootSchema;
    private HashMap processedComplexTypes;
    private HashMap processedSimpleTypes;
    private HashMap processedElements;
    private HashMap processedAttributes;
    private Map itemNameToSDOName;
    private boolean processImports;
    private boolean returnAllTypes;
    private java.util.List namespaceResolvers;
    private boolean inRestriction;
    private HelperContext aHelperContext;
    private java.util.List<SDOType> anonymousTypes = new ArrayList<SDOType>();
    private Map<QName, Type> generatedTypes;
    private Map<QName, SDOType> generatedTypesByXsdQName = new HashMap<QName, SDOType>();
    private Map<QName, Property> generatedGlobalElements;
    private Map<QName, Property> generatedGlobalAttributes;
    private String packageName;
    private java.util.List<NonContainmentReference> nonContainmentReferences;
    private Map<Type, java.util.List<GlobalRef>> globalRefs;
    private boolean isImportProcessor;

    public SDOTypesGenerator(HelperContext helperContext) {
        this.processedComplexTypes = new HashMap();
        this.processedSimpleTypes = new HashMap();
        this.processedElements = new HashMap();
        this.processedAttributes = new HashMap();
        this.itemNameToSDOName = new HashMap();
        this.namespaceResolvers = new ArrayList();
        this.aHelperContext = helperContext;
    }

    public java.util.List<Type> define(Source source, SchemaResolver schemaResolver) {
        return this.define(source, schemaResolver, false, true);
    }

    public java.util.List<Type> define(Source source, SchemaResolver schemaResolver, boolean bl, boolean bl2) {
        Schema schema = this.getSchema(source, schemaResolver);
        return this.define(schema, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public java.util.List<Type> define(Schema schema, boolean bl, boolean bl2) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        this.setReturnAllTypes(bl);
        this.setProcessImports(bl2);
        this.processSchema(schema);
        arrayList.addAll(this.getGeneratedTypes().values());
        arrayList.addAll(this.anonymousTypes);
        if (!this.isImportProcessor()) {
            void var9_22;
            ArrayList<Type> arrayList2 = new ArrayList<Type>(arrayList);
            for (SDOType object2 : arrayList2) {
                if (!object2.isFinalized()) {
                    throw SDOException.typeReferencedButNotDefined(object2.getURI(), object2.getName());
                }
                for (SDOProperty sDOProperty : object2.getProperties()) {
                    if (!sDOProperty.getType().isDataType() || !sDOProperty.isContainment()) continue;
                    sDOProperty.setContainment(false);
                }
            }
            for (SDOProperty sDOProperty : this.getGeneratedGlobalElements().values()) {
                if (sDOProperty.isFinalized()) continue;
                throw SDOException.referencedPropertyNotFound(sDOProperty.getUri(), sDOProperty.getName());
            }
            for (SDOProperty sDOProperty : this.getGeneratedGlobalAttributes().values()) {
                if (sDOProperty.isFinalized()) continue;
                throw SDOException.referencedPropertyNotFound(sDOProperty.getUri(), sDOProperty.getName());
            }
            for (SDOType sDOType : this.getGeneratedTypes().values()) {
                ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).addType(sDOType);
            }
            for (SDOType sDOType : this.getAnonymousTypes()) {
                ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getAnonymousTypes().add(sDOType);
            }
            boolean bl3 = false;
            while (var9_22 < arrayList2.size()) {
                SDOType sDOType = (SDOType)arrayList2.get((int)var9_22);
                if (!sDOType.isDataType() && sDOType.getBaseTypes().size() == 0 && sDOType.getSubTypes().size() > 0) {
                    sDOType.setupInheritance(null);
                } else if (!sDOType.isDataType() && sDOType.getBaseTypes().size() > 0 && !this.getGeneratedTypes().values().contains(sDOType.getBaseTypes().get(0))) {
                    void var11_31;
                    SDOType sDOType2 = (SDOType)sDOType.getBaseTypes().get(0);
                    while (var11_31 != null) {
                        arrayList2.add((Type)var11_31);
                        if (var11_31.getBaseTypes().size() == 0) {
                            var11_31.setupInheritance(null);
                            Object var11_33 = null;
                            continue;
                        }
                        SDOType sDOType3 = (SDOType)var11_31.getBaseTypes().get(0);
                    }
                }
                ++var9_22;
            }
            ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors(arrayList2);
            for (QName qName : this.getGeneratedGlobalElements().keySet()) {
                SDOProperty sDOProperty = (SDOProperty)this.getGeneratedGlobalElements().get(qName);
                ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).addGlobalProperty(qName, sDOProperty, true);
            }
            for (QName qName : this.getGeneratedGlobalAttributes().keySet()) {
                SDOProperty sDOProperty = (SDOProperty)this.getGeneratedGlobalAttributes().get(qName);
                ((SDOXSDHelper)this.aHelperContext.getXSDHelper()).addGlobalProperty(qName, sDOProperty, false);
            }
            for (java.util.List<GlobalRef> list : this.getGlobalRefs().values()) {
                if (list.size() <= 0) continue;
                GlobalRef globalRef = list.get(0);
                throw SDOException.referencedPropertyNotFound(((SDOProperty)globalRef.getProperty()).getUri(), globalRef.getProperty().getName());
            }
        }
        return arrayList;
    }

    private void processSchema(Schema schema) {
        this.rootSchema = schema;
        this.initialize();
        this.namespaceResolvers.add(this.rootSchema.getNamespaceResolver());
        this.processIncludes(this.rootSchema.getIncludes());
        this.processImports(this.rootSchema.getImports());
        this.preprocessGlobalTypes(this.rootSchema);
        this.processGlobalAttributes(this.rootSchema);
        this.processGlobalElements(this.rootSchema);
        this.processGlobalSimpleTypes(this.rootSchema);
        this.processGlobalComplexTypes(this.rootSchema);
        this.postProcessing();
    }

    private void processImports(java.util.List list) {
        if (list == null || list.size() == 0 || !this.isProcessImports()) {
            return;
        }
        for (Import import_ : list) {
            try {
                this.processImportIncludeInternal(import_);
            }
            catch (Exception exception) {
                throw SDOException.errorProcessingImport(import_.getSchemaLocation(), import_.getNamespace(), exception);
            }
        }
    }

    private void processIncludes(java.util.List list) {
        if (list == null || list.size() == 0 || !this.isProcessImports()) {
            return;
        }
        for (Include include : list) {
            try {
                this.processImportIncludeInternal(include);
            }
            catch (Exception exception) {
                throw SDOException.errorProcessingInclude(include.getSchemaLocation(), exception);
            }
        }
    }

    private void processImportIncludeInternal(Include include) throws Exception {
        if (include.getSchema() != null) {
            SDOTypesGenerator sDOTypesGenerator = new SDOTypesGenerator(this.aHelperContext);
            sDOTypesGenerator.setAnonymousTypes(this.getAnonymousTypes());
            sDOTypesGenerator.setGeneratedTypes(this.getGeneratedTypes());
            sDOTypesGenerator.setGeneratedTypesByXsdQName(this.getGeneratedTypesByXsdQName());
            sDOTypesGenerator.setGeneratedGlobalElements(this.getGeneratedGlobalElements());
            sDOTypesGenerator.setGeneratedGlobalAttributes(this.getGeneratedGlobalAttributes());
            sDOTypesGenerator.setIsImportProcessor(true);
            java.util.List<Type> list = sDOTypesGenerator.define(include.getSchema(), this.isReturnAllTypes(), this.isProcessImports());
            this.processedComplexTypes.putAll(sDOTypesGenerator.processedComplexTypes);
            this.processedSimpleTypes.putAll(sDOTypesGenerator.processedSimpleTypes);
            this.processedElements.putAll(sDOTypesGenerator.processedElements);
            this.processedAttributes.putAll(sDOTypesGenerator.processedAttributes);
            if (null != list) {
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    SDOType sDOType = (SDOType)list.get(i);
                    this.getGeneratedTypes().put(sDOType.getQName(), sDOType);
                }
            }
            for (QName qName : sDOTypesGenerator.getGeneratedGlobalElements().keySet()) {
                this.getGeneratedGlobalElements().put(qName, sDOTypesGenerator.getGeneratedGlobalElements().get(qName));
            }
            for (QName qName : sDOTypesGenerator.getGeneratedGlobalAttributes().keySet()) {
                this.getGeneratedGlobalAttributes().put(qName, sDOTypesGenerator.getGeneratedGlobalAttributes().get(qName));
            }
            for (Type type : sDOTypesGenerator.getGlobalRefs().keySet()) {
                this.getGlobalRefs().put(type, sDOTypesGenerator.getGlobalRefs().get(type));
            }
        }
    }

    private boolean typesExists(String string, String string2) {
        Object object;
        Serializable serializable;
        boolean bl = false;
        if (string != null && (string.equals("commonj.sdo/java") || string.equals("commonj.sdo") || string.equals("commonj.sdo/xml"))) {
            bl = true;
        } else {
            serializable = new QName(string, string2);
            object = this.processedComplexTypes.get(serializable);
            if (object != null) {
                bl = true;
            }
        }
        if (!bl) {
            serializable = (SDOType)this.aHelperContext.getTypeHelper().getType(string, string2);
            if (serializable != null && ((SDOType)serializable).isFinalized()) {
                if (this.isReturnAllTypes()) {
                    object = new QName(string, string2);
                    this.getGeneratedTypes().put((QName)object, (Type)serializable);
                }
                return true;
            }
            if (serializable == null) {
                object = new QName(string, string2);
                SDOType sDOType = (SDOType)this.getGeneratedTypes().get(object);
                if (sDOType != null && sDOType.isFinalized()) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private void processGlobalComplexTypes(Schema schema) {
        Collection collection = schema.getTopLevelComplexTypes().values();
        if (collection == null) {
            return;
        }
        for (ComplexType complexType : collection) {
            String string = schema.getTargetNamespace();
            if (null == string) {
                string = "";
            }
            this.processGlobalComplexType(string, schema.getDefaultNamespace(), complexType);
        }
    }

    private void processGlobalComplexType(String string, String string2, ComplexType complexType) {
        QName qName = new QName(string, complexType.getName());
        Object v = this.processedComplexTypes.get(qName);
        if (v == null) {
            this.processComplexType(string, string2, complexType.getName(), complexType);
            this.processedComplexTypes.put(qName, complexType);
        }
    }

    private SDOType processComplexType(String string, String string2, String string3, ComplexType complexType) {
        if (complexType == null) {
            return null;
        }
        boolean bl = this.addNextNamespaceResolver(complexType.getAttributesMap());
        SDOType sDOType = this.startComplexType(string, string2, string3, complexType);
        if (sDOType != null) {
            if (complexType.getComplexContent() != null) {
                this.processComplexContent(string, string2, complexType.getComplexContent(), sDOType);
                this.finishComplexType(sDOType);
            } else if (complexType.getSimpleContent() != null) {
                this.processSimpleContent(string, string2, complexType.getSimpleContent(), sDOType);
                this.finishComplexType(sDOType);
            } else {
                if (complexType.getChoice() != null) {
                    this.processChoice(string, string2, sDOType, complexType.getChoice(), false);
                } else if (complexType.getSequence() != null) {
                    this.processSequence(string, string2, sDOType, complexType.getSequence(), false);
                } else if (complexType.getAll() != null) {
                    this.processAll(string, string2, sDOType, complexType.getAll(), false);
                }
                this.processOrderedAttributes(string, string2, sDOType, complexType.getOrderedAttributes());
                this.finishComplexType(sDOType);
            }
        }
        if (bl) {
            this.namespaceResolvers.remove(this.namespaceResolvers.size() - 1);
        }
        return sDOType;
    }

    private SDOType startComplexType(String string, String string2, String string3, ComplexType complexType) {
        String string4 = (String)complexType.getAttributesMap().get(SDOConstants.SDOXML_NAME_QNAME);
        String string5 = string3;
        if (string4 != null) {
            this.itemNameToSDOName.put(string3, string4);
            string5 = string3;
            string3 = string4;
        }
        boolean bl = false;
        if (null != complexType.getName()) {
            bl = this.typesExists(string, string3);
        }
        if (!bl) {
            return this.startNewComplexType(string, string3, string5, complexType);
        }
        return null;
    }

    private SDOType startNewComplexType(String string, String string2, String string3, ComplexType complexType) {
        java.util.List list;
        Object object;
        Object object2;
        SDOType sDOType = null == complexType.getName() ? this.createSDOTypeForName(string, string2, string3) : this.getGeneratedTypesByXsdQName().get(new QName(string, complexType.getName()));
        if (complexType.isMixed()) {
            sDOType.setMixed(true);
            sDOType.setSequenced(true);
        }
        if (complexType.getAnyAttribute() != null) {
            sDOType.setOpen(true);
        }
        sDOType.setAbstract(complexType.isAbstractValue());
        sDOType.setDataType(false);
        String string4 = (String)complexType.getAttributesMap().get(SDOConstants.SDOXML_ALIASNAME_QNAME);
        if (string4 != null) {
            object2 = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
            object = (java.util.List)((XMLConversionManager)object2).convertObject(string4, java.util.List.class);
            sDOType.setAliasNames((java.util.List)object);
        }
        if ((object2 = (String)complexType.getAttributesMap().get(SDOConstants.SDOXML_SEQUENCE_QNAME)) != null) {
            object = new Boolean((String)object2);
            sDOType.setSequenced((Boolean)object);
        }
        if ((object = complexType.getAnnotation()) != null && (list = ((Annotation)object).getDocumentation()) != null && list.size() > 0) {
            sDOType.setInstanceProperty(SDOConstants.DOCUMENTATION_PROPERTY, list);
        }
        sDOType.preInitialize(this.packageName, this.namespaceResolvers);
        if (complexType.getAnnotation() != null) {
            sDOType.setAppInfoElements(complexType.getAnnotation().getAppInfo());
        }
        return sDOType;
    }

    private void finishComplexType(SDOType sDOType) {
        sDOType.postInitialize();
    }

    private void processOrderedAttributes(String string, String string2, SDOType sDOType, java.util.List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof Attribute) {
                this.processAttribute(string, string2, sDOType, (Attribute)e, false);
                continue;
            }
            if (!(e instanceof AttributeGroup)) continue;
            this.processAttributeGroup(string, string2, sDOType, (AttributeGroup)e);
        }
    }

    private void processGlobalAttributes(Schema schema) {
        Collection collection = schema.getTopLevelAttributes().values();
        if (collection == null) {
            return;
        }
        for (Attribute attribute : collection) {
            String string = schema.getTargetNamespace();
            if (null == string) {
                string = "";
            }
            this.processGlobalAttribute(string, schema.getDefaultNamespace(), attribute);
        }
    }

    private void processGlobalAttribute(String string, String string2, Attribute attribute) {
        if (attribute.getName() != null) {
            QName qName = new QName(string, attribute.getName());
            Object v = this.processedAttributes.get(qName);
            if (v == null) {
                SDOType sDOType = this.processAttribute(string, string2, null, attribute, true);
                this.processedAttributes.put(qName, attribute);
                if (null != sDOType && !this.getGeneratedTypes().containsKey(sDOType.getQName())) {
                    this.getGeneratedTypes().put(sDOType.getQName(), sDOType);
                    this.anonymousTypes.remove(sDOType);
                }
            }
        } else {
            this.processAttribute(string, string2, null, attribute, true);
        }
    }

    private void processGroup(String string, String string2, SDOType sDOType, TypeDefParticle typeDefParticle, Group group, boolean bl) {
        String string3;
        if (!bl && this.maxOccursGreaterThanOne(group.getMaxOccurs())) {
            bl = true;
        }
        if ((string3 = group.getRef()) != null) {
            int n = string3.indexOf(":");
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (n > -1) {
                string5 = string3.substring(n + 1, string3.length());
                string4 = string3.substring(0, n);
                string6 = this.getURIForPrefix(string4);
            } else {
                string5 = string3;
                string6 = string;
            }
            Group group2 = this.rootSchema.getGroup(string6, string5);
            if (group2 != null) {
                if (group2.getChoice() != null) {
                    group2.getChoice().setMaxOccurs(group.getMaxOccurs());
                    this.processChoice(string, string2, sDOType, group2.getChoice(), bl);
                } else if (group2.getSequence() != null) {
                    group2.getSequence().setMaxOccurs(group.getMaxOccurs());
                    this.processSequence(string, string2, sDOType, group2.getSequence(), bl);
                } else if (group2.getAll() != null) {
                    group2.getAll().setMaxOccurs(group.getMaxOccurs());
                    this.processAll(string, string2, sDOType, group2.getAll(), bl);
                }
            }
        }
    }

    private SDOType processAttribute(String string, String string2, SDOType sDOType, Attribute attribute, boolean bl) {
        SimpleType simpleType = attribute.getSimpleType();
        if (simpleType != null) {
            SDOType sDOType2 = this.processSimpleType(string, string2, attribute.getName(), simpleType);
            this.processSimpleAttribute(string, string2, sDOType, attribute, bl, this.rootSchema.isAttributeFormDefault(), sDOType2);
            sDOType2.setXsdLocalName(attribute.getName());
            sDOType2.setXsd(true);
            return sDOType2;
        }
        this.processSimpleAttribute(string, string2, sDOType, attribute, bl, this.rootSchema.isAttributeFormDefault(), null);
        return null;
    }

    private void processAttributeGroup(String string, String string2, SDOType sDOType, AttributeGroup attributeGroup) {
        String string3 = attributeGroup.getRef();
        if (string3 != null) {
            int n = string3.indexOf(":");
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (n > -1) {
                string5 = string3.substring(n + 1, string3.length());
                string4 = string3.substring(0, n);
                string6 = this.getURIForPrefix(string4);
            } else {
                string5 = string3;
                string6 = string;
            }
            AttributeGroup attributeGroup2 = this.rootSchema.getAttributeGroup(string6, string5);
            if (attributeGroup2 != null) {
                int n2 = attributeGroup2.getAttributes().size();
                if (attributeGroup2.getAnyAttribute() != null) {
                    this.processAnyAttribute(string, string2, sDOType);
                }
                for (int i = 0; i < n2; ++i) {
                    this.processAttribute(string, string2, sDOType, (Attribute)attributeGroup2.getAttributes().get(i), false);
                }
            }
        }
    }

    private void processAttributes(String string, String string2, SDOType sDOType, java.util.List list) {
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Attribute attribute = (Attribute)list.get(i);
            this.processAttribute(string, string2, sDOType, attribute, false);
        }
    }

    private void processGlobalSimpleTypes(Schema schema) {
        Collection collection = schema.getTopLevelSimpleTypes().values();
        if (collection == null) {
            return;
        }
        for (SimpleType simpleType : collection) {
            String string = schema.getTargetNamespace();
            if (null == string) {
                string = "";
            }
            this.processGlobalSimpleType(string, schema.getDefaultNamespace(), simpleType);
        }
    }

    private void processGlobalSimpleType(String string, String string2, SimpleType simpleType) {
        QName qName = new QName(string, simpleType.getName());
        if (!this.processedSimpleTypes.containsKey(qName)) {
            this.processSimpleType(string, string2, simpleType.getName(), simpleType);
            this.processedSimpleTypes.put(qName, simpleType);
        }
    }

    private SDOType startSimpleType(String string, String string2, String string3, String string4, SimpleType simpleType) {
        boolean bl = this.typesExists(string, string3);
        if (!bl) {
            return this.startNewSimpleType(string, string2, string3, string4, simpleType);
        }
        if (this.returnAllTypes) {
            return this.getExisitingType(string, string3);
        }
        return null;
    }

    private SDOType startNewSimpleType(String string, String string2, String string3, String string4, SimpleType simpleType) {
        Serializable serializable;
        Object object;
        SDOType sDOType;
        if (null == simpleType.getName()) {
            sDOType = this.createSDOTypeForName(string, string3, string4);
            sDOType.setDataType(true);
        } else {
            sDOType = this.getGeneratedTypesByXsdQName().get(new QName(string, simpleType.getName()));
        }
        SDOTypeHelper sDOTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
        QName qName = null;
        if (simpleType.getRestriction() != null) {
            object = simpleType.getRestriction().getBaseType();
            qName = this.getQNameForString(string2, (String)object);
            serializable = this.getTypeForXSDQName(qName);
            sDOType.addBaseType((SDOType)serializable);
            sDOType.setInstanceClass(((SDOType)serializable).getInstanceClass());
        }
        object = new SDOWrapperType((Type)sDOType, string3, sDOTypeHelper, qName);
        sDOTypeHelper.getWrappersHashMap().put(sDOType.getQName(), object);
        sDOTypeHelper.getTypesHashMap().put(((SDOType)object).getQName(), object);
        sDOTypeHelper.getImplClassesToSDOType().put(((SDOType)object).getXmlDescriptor().getJavaClass(), (SDOType)object);
        serializable = new ArrayList(1);
        ((ArrayList)serializable).add(object);
        ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).addDescriptors((java.util.List)((Object)serializable));
        if (simpleType.getAnnotation() != null) {
            sDOType.setAppInfoElements(simpleType.getAnnotation().getAppInfo());
        }
        return sDOType;
    }

    private SDOType processSimpleType(String string, String string2, String string3, SimpleType simpleType) {
        SDOType sDOType;
        String string4;
        if (simpleType == null) {
            return null;
        }
        boolean bl = this.addNextNamespaceResolver(simpleType.getAttributesMap());
        String string5 = string4 = string3;
        String string6 = (String)simpleType.getAttributesMap().get(SDOConstants.SDOXML_NAME_QNAME);
        if (string6 != null) {
            this.itemNameToSDOName.put(string3, string6);
            string4 = string6;
        }
        if ((sDOType = this.startSimpleType(string, string2, string4, string5, simpleType)) != null) {
            Union union;
            List list;
            Restriction restriction = simpleType.getRestriction();
            if (restriction != null) {
                this.processRestriction(string, string2, sDOType, restriction);
            }
            if ((list = simpleType.getList()) != null) {
                this.processList(string, string2, string3, list, sDOType);
            }
            if ((union = simpleType.getUnion()) != null) {
                this.processUnion(string, string2, string3, union, sDOType);
            }
            this.finishSimpleType(string, string2, string3, simpleType, sDOType);
        }
        if (bl) {
            this.namespaceResolvers.remove(this.namespaceResolvers.size() - 1);
        }
        return sDOType;
    }

    private void finishSimpleType(String string, String string2, String string3, SimpleType simpleType, SDOType sDOType) {
        Object object;
        Object object2;
        String string4 = (String)simpleType.getAttributesMap().get(SDOConstants.SDOXML_ALIASNAME_QNAME);
        if (string4 != null) {
            object2 = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
            object = (java.util.List)((XMLConversionManager)object2).convertObject(string4, java.util.List.class);
            sDOType.setAliasNames((java.util.List)object);
        }
        if ((object2 = (String)simpleType.getAttributesMap().get(SDOConstants.SDOJAVA_INSTANCECLASS_QNAME)) != null) {
            sDOType.setInstanceProperty(SDOConstants.JAVA_CLASS_PROPERTY, object2);
            sDOType.setBaseTypes(null);
        }
        if ((object = (String)simpleType.getAttributesMap().get(SDOConstants.SDOJAVA_EXTENDEDINSTANCECLASS_QNAME)) != null) {
            sDOType.setInstanceClassName((String)object);
        }
        sDOType.postInitialize();
    }

    private void processChoice(String string, String string2, SDOType sDOType, Choice choice, boolean bl) {
        if (choice != null) {
            this.processTypeDef(string, string2, sDOType, choice);
            java.util.List list = choice.getOrderedElements();
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!bl && this.maxOccursGreaterThanOne(choice.getMaxOccurs())) {
                    bl = true;
                }
                if (e instanceof Choice) {
                    this.processChoice(string, string2, sDOType, (Choice)e, bl);
                    continue;
                }
                if (e instanceof Sequence) {
                    this.processSequence(string, string2, sDOType, (Sequence)e, bl);
                    continue;
                }
                if (e instanceof Any) {
                    this.processAny(string, string2, (Any)e, sDOType, choice);
                    continue;
                }
                if (e instanceof Element) {
                    this.processElement(string, string2, sDOType, choice, (Element)e, false, bl);
                    continue;
                }
                if (!(e instanceof Group)) continue;
                this.processGroup(string, string2, sDOType, choice, (Group)e, bl);
            }
        }
    }

    private void processSequence(String string, String string2, SDOType sDOType, Sequence sequence, boolean bl) {
        if (sequence != null) {
            this.processTypeDef(string, string2, sDOType, sequence);
            java.util.List list = sequence.getOrderedElements();
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!bl && this.maxOccursGreaterThanOne(sequence.getMaxOccurs())) {
                    bl = true;
                }
                if (e instanceof Choice) {
                    this.processChoice(string, string2, sDOType, (Choice)e, bl);
                    continue;
                }
                if (e instanceof Sequence) {
                    this.processSequence(string, string2, sDOType, (Sequence)e, bl);
                    continue;
                }
                if (e instanceof Any) {
                    this.processAny(string, string2, (Any)e, sDOType, sequence);
                    continue;
                }
                if (e instanceof Element) {
                    this.processElement(string, string2, sDOType, sequence, (Element)e, false, bl);
                    continue;
                }
                if (!(e instanceof Group)) continue;
                this.processGroup(string, string2, sDOType, sequence, (Group)e, bl);
            }
        }
    }

    private void processAll(String string, String string2, SDOType sDOType, All all, boolean bl) {
        if (all != null) {
            sDOType.setSequenced(true);
            this.processTypeDef(string, string2, sDOType, all);
            if (!bl && this.maxOccursGreaterThanOne(all.getMaxOccurs())) {
                bl = true;
            }
            java.util.List list = all.getElements();
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.get(i);
                if (!(e instanceof Element)) continue;
                this.processElement(string, string2, sDOType, all, (Element)e, false, bl);
            }
        }
    }

    private void processComplexContent(String string, String string2, ComplexContent complexContent, SDOType sDOType) {
        if (complexContent != null) {
            if (complexContent.getExtension() != null) {
                this.processExtension(string, string2, sDOType, complexContent.getExtension(), false);
            } else if (complexContent.getRestriction() != null) {
                this.processRestriction(string, string2, sDOType, complexContent.getRestriction());
            }
        }
    }

    private void processSimpleContent(String string, String string2, SimpleContent simpleContent, SDOType sDOType) {
        if (simpleContent != null) {
            if (simpleContent.getExtension() != null) {
                this.processExtension(string, string2, sDOType, simpleContent.getExtension(), true);
            } else if (simpleContent.getRestriction() != null) {
                this.processRestriction(string, string2, sDOType, simpleContent.getRestriction());
            }
        }
    }

    private void processExtension(String string, String string2, SDOType sDOType, Extension extension, boolean bl) {
        if (extension != null) {
            String string3 = extension.getBaseType();
            SDOType sDOType2 = this.getSDOTypeForName(string, string2, string3);
            QName qName = this.getQNameForString(string2, string3);
            if (sDOType2 != null && !sDOType2.isFinalized() && qName.getNamespaceURI().equals(string)) {
                if (sDOType2.isDataType()) {
                    SimpleType simpleType = (SimpleType)this.rootSchema.getTopLevelSimpleTypes().get(qName.getLocalPart());
                    this.processGlobalSimpleType(string, string2, simpleType);
                } else {
                    ComplexType complexType = (ComplexType)this.rootSchema.getTopLevelComplexTypes().get(qName.getLocalPart());
                    this.processGlobalComplexType(string, string2, complexType);
                }
            }
            if (string3 != null) {
                this.processBaseType(sDOType2, string, string2, sDOType, string3, bl);
            }
            if (extension.getChoice() != null) {
                this.processChoice(string, string2, sDOType, extension.getChoice(), false);
            } else if (extension.getSequence() != null) {
                this.processSequence(string, string2, sDOType, extension.getSequence(), false);
            } else if (extension.getAll() != null) {
                // empty if block
            }
            this.processOrderedAttributes(string, string2, sDOType, extension.getOrderedAttributes());
        }
    }

    private void processRestriction(String string, String string2, SDOType sDOType, Restriction restriction) {
        if (restriction != null) {
            String string3 = restriction.getBaseType();
            this.processBaseType(string, string2, sDOType, string3, false, restriction);
            boolean bl = this.inRestriction;
            if (!bl) {
                this.inRestriction = true;
            }
            if (restriction.getChoice() != null) {
                this.processChoice(string, string2, sDOType, restriction.getChoice(), false);
            } else if (restriction.getSequence() != null) {
                this.processSequence(string, string2, sDOType, restriction.getSequence(), false);
            } else if (restriction.getAll() != null) {
                this.processAll(string, string2, sDOType, restriction.getAll(), false);
            }
            this.processAttributes(string, string2, sDOType, restriction.getAttributes());
            if (!bl) {
                this.inRestriction = false;
            }
        }
    }

    private void processUnion(String string, String string2, String string3, Union union, SDOType sDOType) {
        if (union != null) {
            java.util.List list = union.getAllMemberTypes();
            String string4 = null;
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                String string5 = (String)list.get(i);
                SDOType sDOType2 = this.getTypeForName(string, string2, string5);
                QName qName = this.getQNameForString(string2, string5);
                if (!sDOType2.isFinalized() && qName.getNamespaceURI().equals(string)) {
                    object = (SimpleType)this.rootSchema.getTopLevelSimpleTypes().get(qName.getLocalPart());
                    this.processSimpleType(string, string2, qName.getLocalPart(), (SimpleType)object);
                }
                if (i == 0) {
                    string4 = sDOType2.getInstanceClassName();
                    if (string4 != null) continue;
                    break;
                }
                object = sDOType2.getInstanceClassName();
                if (string4.equals(object)) continue;
                sDOType.setInstanceClass(Object.class);
                return;
            }
            if (string4 != null) {
                sDOType.setInstanceClassName(string4);
            } else {
                sDOType.setInstanceClass(Object.class);
            }
        }
    }

    private boolean addNextNamespaceResolver(Map map) {
        NamespaceResolver namespaceResolver = new NamespaceResolver();
        for (QName qName : map.keySet()) {
            if (!qName.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
            String string = (String)map.get(qName);
            String string2 = qName.getLocalPart();
            int n = string2.indexOf(58);
            if (n > -1) {
                string2 = string2.substring(n + 1, string2.length());
            }
            namespaceResolver.put(string2, string);
        }
        if (namespaceResolver.getPrefixes().hasMoreElements()) {
            this.namespaceResolvers.add(namespaceResolver);
            return true;
        }
        return false;
    }

    private void processList(String string, String string2, String string3, List list, SDOType sDOType) {
        if (list != null) {
            sDOType.setXsdList(true);
            sDOType.setInstanceClass(ClassConstants.List_Class);
        }
    }

    private void processBaseType(String string, String string2, SDOType sDOType, String string3, boolean bl, Restriction restriction) {
        if (string3 == null) {
            return;
        }
        SDOType sDOType2 = this.getSDOTypeForName(string, string2, string3);
        QName qName = this.getQNameForString(string2, string3);
        if (!sDOType2.isFinalized() && qName.getNamespaceURI().equals(string)) {
            Object object;
            if (sDOType2.isDataType()) {
                object = (SimpleType)this.rootSchema.getTopLevelSimpleTypes().get(qName.getLocalPart());
                this.processGlobalSimpleType(string, string2, (SimpleType)object);
            } else {
                object = (ComplexType)this.rootSchema.getTopLevelComplexTypes().get(qName.getLocalPart());
                this.processGlobalComplexType(string, string2, (ComplexType)object);
            }
        }
        if (qName.equals(XMLConstants.INTEGER_QNAME) || qName.equals(SDOConstants.POSITIVEINTEGER_QNAME) || qName.equals(SDOConstants.NEGATIVEINTEGER_QNAME) || qName.equals(SDOConstants.NONPOSITIVEINTEGER_QNAME) || qName.equals(SDOConstants.NONNEGATIVEINTEGER_QNAME) || qName.equals(XMLConstants.LONG_QNAME) || qName.equals(SDOConstants.UNSIGNEDLONG_QNAME)) {
            boolean bl2 = false;
            String string4 = restriction.getMaxInclusive();
            if (string4 != null && Integer.parseInt(string4) <= Integer.MAX_VALUE) {
                sDOType2 = this.getTypeForXSDQName(XMLConstants.INT_QNAME);
                bl2 = true;
            }
            if (!bl2 && (string4 = restriction.getMaxExclusive()) != null && Integer.parseInt(string4) < Integer.MAX_VALUE) {
                sDOType2 = this.getTypeForXSDQName(XMLConstants.INT_QNAME);
            }
        }
        this.processBaseType(sDOType2, string, string2, sDOType, string3, bl);
    }

    private void processBaseType(SDOType sDOType, String string, String string2, SDOType sDOType2, String string3, boolean bl) {
        if (bl && sDOType.isDataType()) {
            if (sDOType2 != null) {
                SDOProperty sDOProperty = new SDOProperty(this.aHelperContext);
                sDOProperty.setName("value");
                sDOProperty.setType(sDOType);
                sDOProperty.setValueProperty(true);
                sDOProperty.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.TRUE);
                sDOType2.addDeclaredProperty(sDOProperty);
                sDOProperty.buildMapping(null, -1);
                sDOProperty.setFinalized(true);
            }
            return;
        }
        ArrayList<SDOType> arrayList = new ArrayList<SDOType>();
        arrayList.add(sDOType);
        if (sDOType2 != null) {
            if (sDOType2.isDataType()) {
                QName qName;
                sDOType2.setInstanceClassName(sDOType.getInstanceClassName());
                if (sDOType.getInstanceClass() != null) {
                    sDOType2.setInstanceClass(sDOType.getInstanceClass());
                }
                if ((qName = this.getQNameForString(string2, string3)).equals(XMLConstants.BASE_64_BINARY_QNAME) || qName.equals(XMLConstants.HEX_BINARY_QNAME) || qName.equals(XMLConstants.DATE_QNAME) || qName.equals(XMLConstants.TIME_QNAME) || qName.equals(XMLConstants.DATE_TIME_QNAME)) {
                    sDOType2.setXsdType(qName);
                }
            }
            if (!sDOType2.getBaseTypes().contains(sDOType)) {
                sDOType2.addBaseType(sDOType);
            }
        }
    }

    private void processTypeDef(String string, String string2, SDOType sDOType, TypeDefParticle typeDefParticle) {
        if (this.maxOccursGreaterThanOne(typeDefParticle.getMaxOccurs()) && !sDOType.isSequenced() && this.shouldBeSequenced(typeDefParticle)) {
            sDOType.setSequenced(true);
        }
    }

    private boolean shouldBeSequenced(TypeDefParticle typeDefParticle) {
        block4: {
            block3: {
                java.util.List list = typeDefParticle.getElements();
                if (list != null && list.size() > 1) {
                    return true;
                }
                if (!(typeDefParticle instanceof Sequence)) break block3;
                java.util.List list2 = ((Sequence)typeDefParticle).getOrderedElements();
                for (int i = 0; i < list2.size(); ++i) {
                    boolean bl;
                    Object e = list2.get(i);
                    if (!(e instanceof TypeDefParticle) || !(bl = this.shouldBeSequenced((TypeDefParticle)e))) continue;
                    return true;
                }
                break block4;
            }
            if (!(typeDefParticle instanceof Choice)) break block4;
            java.util.List list = ((Choice)typeDefParticle).getOrderedElements();
            for (int i = 0; i < list.size(); ++i) {
                boolean bl;
                Object e = list.get(i);
                if (!(e instanceof TypeDefParticle) || !(bl = this.shouldBeSequenced((TypeDefParticle)e))) continue;
                return true;
            }
        }
        return false;
    }

    private void processAny(String string, String string2, Any any, SDOType sDOType, TypeDefParticle typeDefParticle) {
        if (any == null) {
            return;
        }
        if (((NestedParticle)((Object)typeDefParticle)).hasAny()) {
            sDOType.setOpen(true);
            sDOType.setSequenced(true);
        }
    }

    private void processGlobalElements(Schema schema) {
        Collection collection = schema.getTopLevelElements().values();
        if (collection == null) {
            return;
        }
        for (Element element : collection) {
            String string = schema.getTargetNamespace();
            if (null == string) {
                string = "";
            }
            this.processGlobalElement(string, schema.getDefaultNamespace(), element);
        }
        this.processSubstitutionGroups(collection, schema.getTargetNamespace(), schema.getDefaultNamespace());
    }

    private void processGlobalElement(String string, String string2, Element element) {
        if (element.getName() != null) {
            QName qName = new QName(string, element.getName());
            Object v = this.processedElements.get(qName);
            if (v == null) {
                SDOType sDOType = this.processElement(string, string2, null, null, element, true, true);
                this.processedElements.put(qName, element);
                if (null != sDOType && !this.getGeneratedTypes().containsKey(sDOType.getQName())) {
                    this.getGeneratedTypes().put(sDOType.getQName(), sDOType);
                    this.anonymousTypes.remove(sDOType);
                }
            }
        } else {
            this.processElement(string, string2, null, null, element, true, true);
        }
    }

    private SDOType processElement(String string, String string2, SDOType sDOType, TypeDefParticle typeDefParticle, Element element, boolean bl, boolean bl2) {
        SDOType sDOType2 = null;
        boolean bl3 = this.addNextNamespaceResolver(element.getAttributesMap());
        ComplexType complexType = element.getComplexType();
        boolean bl4 = true;
        if (!bl) {
            bl4 = this.rootSchema.isElementFormDefault();
        }
        if (!bl2 && this.maxOccursGreaterThanOne(element.getMaxOccurs())) {
            bl2 = true;
        }
        if (complexType != null) {
            sDOType2 = this.processComplexType(string, string2, element.getName(), complexType);
            sDOType2.setXsdLocalName(element.getName());
            sDOType2.setXsd(true);
            this.processSimpleElement(string, string2, sDOType, sDOType2, typeDefParticle, element, bl4, bl, bl2);
        } else if (element.getSimpleType() != null) {
            sDOType2 = this.processSimpleType(string, string2, element.getName(), element.getSimpleType());
            sDOType2.setXsdLocalName(element.getName());
            sDOType2.setXsd(true);
            this.processSimpleElement(string, string2, sDOType, sDOType2, typeDefParticle, element, bl4, bl, bl2);
        } else {
            this.processSimpleElement(string, string2, sDOType, null, typeDefParticle, element, bl4, bl, bl2);
        }
        if (bl3) {
            this.namespaceResolvers.remove(this.namespaceResolvers.size() - 1);
        }
        return sDOType2;
    }

    private void processSimpleElement(String string, String string2, SDOType sDOType, SDOType sDOType2, TypeDefParticle typeDefParticle, Element element, boolean bl, boolean bl2, boolean bl3) {
        Serializable serializable;
        Serializable serializable2;
        if (element == null) {
            return;
        }
        String string3 = (String)element.getAttributesMap().get(SDOConstants.SDOXML_MANY_QNAME);
        if (string3 != null) {
            serializable2 = new Boolean(string3);
            bl3 = (Boolean)serializable2;
        }
        serializable2 = null;
        String string4 = null;
        String string5 = null;
        if (typeDefParticle != null) {
            string5 = sDOType.getURI();
        }
        if (element.getRef() != null) {
            Object object;
            String string6 = element.getRef();
            String string7 = null;
            String string8 = null;
            int n = string6.indexOf(58);
            if (n != -1) {
                object = string6.substring(0, n);
                string7 = string6.substring(n + 1, string6.length());
                string8 = this.getURIForPrefix((String)object);
            } else {
                string7 = string6;
                string8 = string2;
            }
            object = sDOType.getProperty(string7);
            if (object != null) {
                if (this.inRestriction) {
                    return;
                }
                this.updateCollisionProperty(sDOType, (SDOProperty)object);
            } else {
                Object object2;
                SDOProperty sDOProperty = new SDOProperty(this.aHelperContext);
                sDOProperty.setName(string7);
                sDOProperty.setGlobal(false);
                sDOProperty.setContainment(true);
                sDOProperty.setXsd(true);
                sDOProperty.setMany(bl3);
                sDOProperty.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.TRUE);
                if (element.getAnnotation() != null && (object2 = element.getAnnotation().getDocumentation()) != null) {
                    sDOProperty.setInstanceProperty(SDOConstants.DOCUMENTATION_PROPERTY, object2);
                }
                sDOType.addDeclaredProperty(sDOProperty);
                object2 = new GlobalRef();
                ((GlobalRef)object2).setProperty(sDOProperty);
                ((GlobalRef)object2).setIsElement(true);
                ((GlobalRef)object2).setOwningType(sDOType);
                ((GlobalRef)object2).setUri(string8);
                ((GlobalRef)object2).setLocalName(string7);
                this.addGlobalRef((GlobalRef)object2);
            }
            return;
        }
        if (bl2 && (serializable = this.getExistingGlobalProperty(string, element.getName(), true)) != null && ((SDOProperty)serializable).isFinalized()) {
            return;
        }
        serializable2 = this.createNewProperty(string, element.getName(), bl, bl2, true, element.isNillable(), element.getAnnotation());
        if (element.getAnnotation() != null) {
            ((SDOProperty)serializable2).setAppInfoElements(element.getAnnotation().getAppInfo());
        }
        if (element.getType() != null) {
            String string9;
            String string10;
            string4 = element.getType();
            ((SDOProperty)serializable2).setName(element.getName());
            serializable = this.getQNameForString(string2, string4);
            if (bl2 && ((QName)serializable).getNamespaceURI().equals(string)) {
                this.processGlobalItem(string, string2, ((QName)serializable).getLocalPart());
            }
            if (((QName)serializable).equals(XMLConstants.QNAME_QNAME) || ((QName)serializable).equals(XMLConstants.BASE_64_BINARY_QNAME) || ((QName)serializable).equals(XMLConstants.HEX_BINARY_QNAME) || ((QName)serializable).equals(XMLConstants.DATE_QNAME) || ((QName)serializable).equals(XMLConstants.TIME_QNAME) || ((QName)serializable).equals(XMLConstants.DATE_TIME_QNAME)) {
                ((SDOProperty)serializable2).setXsdType((QName)serializable);
            }
            if ((string10 = (String)element.getAttributesMap().get(SDOConstants.XML_MIME_TYPE_QNAME)) != null) {
                ((SDOProperty)serializable2).setInstanceProperty(SDOConstants.MIME_TYPE_PROPERTY, string10);
            }
            if ((string9 = (String)element.getAttributesMap().get(SDOConstants.XML_MIME_TYPE_PROPERTY_QNAME)) != null) {
                ((SDOProperty)serializable2).setInstanceProperty(SDOConstants.MIME_TYPE_PROPERTY_PROPERTY, string9);
            }
            if (!(sDOType2 = this.getSDOTypeForName(string, string2, string4)).isFinalized() && ((QName)serializable).getNamespaceURI().equals(string) && sDOType2.isDataType()) {
                SimpleType simpleType = (SimpleType)this.rootSchema.getTopLevelSimpleTypes().get(((QName)serializable).getLocalPart());
                this.processGlobalSimpleType(string, string2, simpleType);
            }
            if (((SDOProperty)serializable2).getXsdType() == null && sDOType2.getXsdType() != null) {
                ((SDOProperty)serializable2).setXsdType(sDOType2.getXsdType());
            }
            if (sDOType2.isDataType()) {
                ((SDOProperty)serializable2).setContainment(false);
            }
        } else if (element.getComplexType() != null) {
            string4 = element.getName();
            ((SDOProperty)serializable2).setName(element.getComplexType().getNameOrOwnerName());
        } else if (element.getSimpleType() != null) {
            string4 = element.getName();
            ((SDOProperty)serializable2).setName(element.getName());
            if (sDOType2.isDataType()) {
                ((SDOProperty)serializable2).setContainment(false);
            }
        } else {
            ((SDOProperty)serializable2).setName(element.getName());
            sDOType2 = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getSDOTypeFromXSDType(SDOConstants.ANY_TYPE_QNAME);
        }
        sDOType2 = this.processSimpleComponentAnnotations(sDOType, element, (SDOProperty)serializable2, string, string2, sDOType2);
        ((SDOProperty)serializable2).setType(sDOType2);
        this.setDefaultValue((SDOProperty)serializable2, element);
        ((SDOProperty)serializable2).setMany(bl3);
        if (((SDOProperty)serializable2).getType().isChangeSummaryType()) {
            ((SDOProperty)serializable2).setReadOnly(true);
        }
        if (typeDefParticle != null) {
            this.updateOwnerAndBuildMapping(sDOType, (SDOProperty)serializable2, string2, string, element, string4, string5);
        }
        if (bl2) {
            this.addRootElementToDescriptor((SDOProperty)serializable2, string, element.getName());
        }
        ((SDOProperty)serializable2).setFinalized(true);
    }

    private SDOProperty processRef(GlobalRef globalRef) {
        boolean bl = globalRef.isElement();
        SDOProperty sDOProperty = null;
        SDOProperty sDOProperty2 = this.getExistingGlobalProperty(globalRef.getUri(), globalRef.getLocalName(), bl);
        if (sDOProperty2 != null && sDOProperty2.isFinalized()) {
            sDOProperty = (SDOProperty)globalRef.getProperty();
            sDOProperty.setValueProperty(sDOProperty2.isValueProperty());
            sDOProperty.setNullable(sDOProperty2.isNullable());
            sDOProperty.setName(sDOProperty2.getName());
            sDOProperty.setXsdLocalName(sDOProperty2.getXsdLocalName());
            sDOProperty.setNamespaceQualified(sDOProperty2.isNamespaceQualified());
            sDOProperty.setAliasNames(sDOProperty2.getAliasNames());
            sDOProperty.setDefault(sDOProperty2.getDefault());
            sDOProperty.setSubstitutable(sDOProperty2.isSubstitutable());
            sDOProperty.setSubstitutableElements(sDOProperty2.getSubstitutableElements());
            if (sDOProperty.getType() == null) {
                sDOProperty.setType(sDOProperty2.getType());
                if (sDOProperty2.getType().isDataType()) {
                    sDOProperty.setContainment(false);
                }
            }
            sDOProperty.setOpposite(sDOProperty2.getOpposite());
            sDOProperty.setReadOnly(sDOProperty2.isReadOnly());
            sDOProperty.setXsd(sDOProperty2.isXsd());
            sDOProperty.setAppInfoElements(sDOProperty2.getAppInfoElements());
            int n = ((SDOProperty)globalRef.getProperty()).getIndexInDeclaredProperties();
            sDOProperty.buildMapping(globalRef.getUri(), n);
            sDOProperty.setFinalized(true);
        } else if (this.isImportProcessor) {
            sDOProperty = new SDOProperty(this.aHelperContext);
            sDOProperty.setGlobal(true);
            sDOProperty.setUri(globalRef.getUri());
            sDOProperty.setName(globalRef.getLocalName());
            QName qName = new QName(globalRef.getUri(), globalRef.getLocalName());
            if (bl) {
                sDOProperty.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.TRUE);
                this.getGeneratedGlobalElements().put(qName, sDOProperty);
            } else {
                this.getGeneratedGlobalAttributes().put(qName, sDOProperty);
            }
        } else {
            throw SDOException.referencedPropertyNotFound(globalRef.getUri(), globalRef.getLocalName());
        }
        return sDOProperty;
    }

    private void updateCollisionProperty(SDOType sDOType, SDOProperty sDOProperty) {
        sDOType.setSequenced(true);
        SDOType sDOType2 = sDOType;
        while (sDOType2.getBaseTypes() != null && sDOType2.getBaseTypes().size() > 0) {
            sDOType2 = (Type)sDOType2.getBaseTypes().get(0);
            sDOType2.setSequenced(true);
        }
        sDOProperty.setNameCollision(true);
        sDOProperty.setType(SDOConstants.SDO_OBJECT);
        sDOProperty.setContainment(true);
        sDOProperty.setMany(true);
        sDOProperty.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.TRUE);
    }

    private SDOProperty createNewProperty(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, Annotation annotation) {
        Object object;
        SDOProperty sDOProperty = null;
        if (bl2) {
            sDOProperty = this.getExistingGlobalProperty(string, string2, bl3);
        }
        if (sDOProperty == null) {
            sDOProperty = new SDOProperty(this.aHelperContext);
        }
        sDOProperty.setGlobal(bl2);
        sDOProperty.setXsd(true);
        sDOProperty.setNullable(bl4);
        if (bl3) {
            sDOProperty.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, Boolean.TRUE);
        }
        sDOProperty.setXsdLocalName(string2);
        sDOProperty.setNamespaceQualified(bl);
        sDOProperty.setContainment(true);
        if (bl2) {
            object = new QName(string, string2);
            if (bl3) {
                this.getGeneratedGlobalElements().put((QName)object, sDOProperty);
            } else {
                this.getGeneratedGlobalAttributes().put((QName)object, sDOProperty);
            }
        }
        if (annotation != null && (object = annotation.getDocumentation()) != null && object.size() > 0) {
            sDOProperty.setInstanceProperty(SDOConstants.DOCUMENTATION_PROPERTY, object);
        }
        return sDOProperty;
    }

    private void addRootElementToDescriptor(SDOProperty sDOProperty, String string, String string2) {
        if (!sDOProperty.getType().isDataType()) {
            NamespaceResolver namespaceResolver = sDOProperty.getType().getXmlDescriptor().getNamespaceResolver();
            String string3 = null;
            if (namespaceResolver != null) {
                string3 = namespaceResolver.resolveNamespaceURI(string);
            }
            if (string3 == null || string3.equals("")) {
                sDOProperty.getType().getXmlDescriptor().addRootElement(string2);
            } else {
                sDOProperty.getType().getXmlDescriptor().addRootElement(string3 + ":" + string2);
            }
        } else {
            SDOTypeHelper sDOTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
            SDOWrapperType sDOWrapperType = (SDOWrapperType)sDOTypeHelper.getWrappersHashMap().get(sDOProperty.getType().getQName());
            XMLDescriptor xMLDescriptor = sDOWrapperType.getXmlDescriptor(sDOProperty.getXsdType());
            if (sDOWrapperType != null) {
                xMLDescriptor.addRootElement(string2);
                QName qName = new QName(string, string2);
                ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().addDescriptorByQName(qName, xMLDescriptor);
            }
        }
    }

    private void updateOwnerAndBuildMapping(SDOType sDOType, SDOProperty sDOProperty, String string, String string2, SimpleComponent simpleComponent, String string3, String string4) {
        boolean bl = true;
        SDOProperty sDOProperty2 = sDOType.getProperty(sDOProperty.getName());
        if (sDOProperty2 != null) {
            sDOProperty = sDOProperty2;
            if (this.inRestriction) {
                return;
            }
            this.updateCollisionProperty(sDOType, sDOProperty);
        } else {
            sDOType.addDeclaredProperty(sDOProperty);
        }
        QName qName = this.getQNameForString(string, string3);
        if (qName != null && qName.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            if (qName.getLocalPart().equals("ID")) {
                sDOType.setInstanceProperty(SDOConstants.ID_PROPERTY, sDOProperty.getName());
            } else if (qName.getLocalPart().equals("IDREF")) {
                sDOProperty.setContainment(false);
                String string5 = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_PROPERTYTYPE_QNAME);
                if (string5 != null) {
                    bl = false;
                }
            } else if (qName.getLocalPart().equals("IDREFS")) {
                sDOProperty.setContainment(false);
                String string6 = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_PROPERTYTYPE_QNAME);
                if (string6 != null) {
                    bl = false;
                    sDOProperty.setMany(true);
                } else {
                    sDOProperty.setMany(false);
                }
            }
        }
        if (bl) {
            sDOProperty.buildMapping(string4);
        }
    }

    private void setDefaultValue(SDOProperty sDOProperty, SimpleComponent simpleComponent) {
        if (simpleComponent.getFixed() != null) {
            Object object = this.convertDefaultValue(sDOProperty.getType(), simpleComponent.getFixed());
            sDOProperty.setDefault(object);
        } else if (simpleComponent.getDefaultValue() != null) {
            Object object = this.convertDefaultValue(sDOProperty.getType(), simpleComponent.getDefaultValue());
            sDOProperty.setDefault(object);
        } else if (sDOProperty.getType().getQName().equals(SDOConstants.SDO_STRING.getQName()) && simpleComponent.isSetDefaultValue()) {
            sDOProperty.setDefault("");
        }
    }

    private Object convertDefaultValue(Type type, String string) {
        Class clazz;
        if (type != null && (clazz = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getJavaWrapperTypeForSDOType(type)) != null) {
            Object object = ((SDODataHelper)this.aHelperContext.getDataHelper()).convertFromStringValue(string, clazz);
            return object;
        }
        return string;
    }

    private void processSimpleAttribute(String string, String string2, SDOType sDOType, Attribute attribute, boolean bl, boolean bl2, SDOType sDOType2) {
        Serializable serializable;
        if (attribute == null) {
            return;
        }
        SDOProperty sDOProperty = null;
        String string3 = null;
        String string4 = null;
        if (sDOType != null) {
            string4 = sDOType.getURI();
        }
        if (attribute.getRef() != null) {
            Object object;
            String string5 = attribute.getRef();
            String string6 = null;
            String string7 = null;
            int n = string5.indexOf(58);
            if (n != -1) {
                object = string5.substring(0, n);
                string6 = string5.substring(n + 1, string5.length());
                string7 = this.getURIForPrefix((String)object);
            } else {
                string6 = string5;
                string7 = string2;
            }
            object = sDOType.getProperty(string6);
            if (object != null) {
                if (this.inRestriction) {
                    return;
                }
                this.updateCollisionProperty(sDOType, (SDOProperty)object);
            } else {
                Object object2;
                SDOProperty sDOProperty2 = new SDOProperty(this.aHelperContext);
                sDOProperty2.setName(string6);
                sDOProperty2.setGlobal(false);
                sDOProperty2.setContainment(false);
                sDOProperty2.setXsd(true);
                sDOProperty2.setMany(false);
                if (attribute.getAnnotation() != null && (object2 = attribute.getAnnotation().getDocumentation()) != null) {
                    sDOProperty2.setInstanceProperty(SDOConstants.DOCUMENTATION_PROPERTY, object2);
                }
                sDOProperty2.setFinalized(true);
                object2 = new GlobalRef();
                ((GlobalRef)object2).setProperty(sDOProperty2);
                sDOType.addDeclaredProperty(sDOProperty2);
                ((GlobalRef)object2).setIsElement(false);
                ((GlobalRef)object2).setOwningType(sDOType);
                ((GlobalRef)object2).setUri(string7);
                ((GlobalRef)object2).setLocalName(string6);
                this.addGlobalRef((GlobalRef)object2);
            }
            return;
        }
        if (bl && (serializable = this.getExistingGlobalProperty(string, attribute.getName(), false)) != null && ((SDOProperty)serializable).isFinalized()) {
            return;
        }
        sDOProperty = this.createNewProperty(string, attribute.getName(), bl2, bl, false, false, attribute.getAnnotation());
        if (attribute.getAnnotation() != null) {
            sDOProperty.setAppInfoElements(attribute.getAnnotation().getAppInfo());
        }
        if ((string3 = attribute.getType()) != null) {
            sDOProperty.setName(attribute.getName());
            serializable = this.getQNameForString(string2, string3);
            if (bl) {
                this.processGlobalItem(string, string2, string3);
            }
            if (((QName)serializable).equals(XMLConstants.BASE_64_BINARY_QNAME) || ((QName)serializable).equals(XMLConstants.HEX_BINARY_QNAME) || ((QName)serializable).equals(XMLConstants.DATE_QNAME) || ((QName)serializable).equals(XMLConstants.TIME_QNAME) || ((QName)serializable).equals(XMLConstants.DATE_TIME_QNAME)) {
                sDOProperty.setXsdType((QName)serializable);
            }
            if (!(sDOType2 = this.getSDOTypeForName(string, string2, string3)).isFinalized() && ((QName)serializable).getNamespaceURI().equals(string) && sDOType2.isDataType()) {
                SimpleType simpleType = (SimpleType)this.rootSchema.getTopLevelSimpleTypes().get(((QName)serializable).getLocalPart());
                this.processGlobalSimpleType(string, string2, simpleType);
            }
            if (sDOProperty.getXsdType() == null && sDOType2.getXsdType() != null) {
                sDOProperty.setXsdType(sDOType2.getXsdType());
            }
        } else if (attribute.getSimpleType() != null) {
            sDOProperty.setName(attribute.getName());
            string3 = attribute.getName();
        } else {
            sDOProperty.setName(attribute.getName());
            sDOType2 = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getSDOTypeFromXSDType(SDOConstants.ANY_TYPE_QNAME);
        }
        sDOType2 = this.processSimpleComponentAnnotations(sDOType, attribute, sDOProperty, string, string2, sDOType2);
        sDOProperty.setType(sDOType2);
        sDOProperty.setContainment(false);
        this.setDefaultValue(sDOProperty, attribute);
        if (sDOProperty.getType().isChangeSummaryType()) {
            sDOProperty.setReadOnly(true);
        }
        if (sDOType != null) {
            this.updateOwnerAndBuildMapping(sDOType, sDOProperty, string2, string, attribute, string3, string4);
        }
        sDOProperty.setFinalized(true);
    }

    private SDOType processSimpleComponentAnnotations(SDOType sDOType, SimpleComponent simpleComponent, SDOProperty sDOProperty, String string, String string2, SDOType object) {
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string3 = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_ALIASNAME_QNAME);
        if (string3 != null) {
            object6 = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlConversionManager();
            object5 = (java.util.List)((XMLConversionManager)object6).convertObject(string3, java.util.List.class);
            sDOProperty.setAliasNames((java.util.List)object5);
        }
        if ((object6 = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_READONLY_QNAME)) != null) {
            object5 = new Boolean((String)object6);
            sDOProperty.setReadOnly((Boolean)object5);
        }
        if ((object5 = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_DATATYPE_QNAME)) != null) {
            object4 = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getXSDTypeFromSDOType((Type)object);
            if (object4 == null && !((SDOType)object).isDataType()) {
                object4 = new QName(((SDOType)object).getURI(), ((SDOType)object).getName());
            }
            sDOProperty.setXsdType((QName)object4);
            object = object3 = this.getSDOTypeForName(string, string2, (String)object5);
            object2 = this.aHelperContext.getTypeHelper().getOpenContentProperty("commonj.sdo/xml", "dataType");
            sDOProperty.setInstanceProperty((Property)object2, object3);
        }
        if ((object4 = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_STRING_QNAME)) != null) {
            object3 = this.getQNameForString(string2, simpleComponent.getType());
            sDOProperty.setXsdType((QName)object3);
            object = SDOConstants.SDO_STRING;
        }
        if ((object3 = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_NAME_QNAME)) != null) {
            sDOProperty.setName((String)object3);
            if (sDOProperty.isGlobal() && string != null) {
                object2 = new QName(string, (String)object3);
                ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getOpenContentProperties().put(object2, sDOProperty);
            }
        } else if (sDOProperty.isGlobal() && string != null) {
            object2 = new QName(string, sDOProperty.getName());
            ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getOpenContentProperties().put(object2, sDOProperty);
        }
        if ((object2 = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_PROPERTYTYPE_QNAME)) != null) {
            Object object7;
            String string4 = string;
            int n = ((String)object2).indexOf(58);
            if (n > -1) {
                object7 = ((String)object2).substring(0, n);
                string4 = this.getURIForPrefix((String)object7);
            }
            object7 = new NonContainmentReference();
            ((NonContainmentReference)object7).setPropertyTypeName((String)object2);
            ((NonContainmentReference)object7).setPropertyTypeURI(string4);
            ((NonContainmentReference)object7).setOwningType(sDOType);
            ((NonContainmentReference)object7).setOwningProp(sDOProperty);
            String string5 = (String)simpleComponent.getAttributesMap().get(SDOConstants.SDOXML_OPPOSITEPROPERTY_QNAME);
            ((NonContainmentReference)object7).setOppositePropName(string5);
            this.getNonContainmentReferences().add((NonContainmentReference)object7);
        }
        return object;
    }

    private void postProcessing() {
        SDOProperty sDOProperty;
        Object object;
        Object object2;
        Object object3;
        int n = this.getNonContainmentReferences().size();
        for (int i = 0; i < n; ++i) {
            NonContainmentReference nonContainmentReference = this.getNonContainmentReferences().get(i);
            object3 = nonContainmentReference.getOwningType();
            if (object3 == null) continue;
            object2 = nonContainmentReference.getPropertyTypeName();
            String string = nonContainmentReference.getPropertyTypeURI();
            object = this.getSDOTypeForName(string, string, (String)object2);
            if (object == null || (sDOProperty = nonContainmentReference.getOwningProp()) == null) continue;
            if (((SDOType)object).isDataType()) {
                throw SDOException.propertyTypeAnnotationTargetCannotBeDataTypeTrue(((SDOType)object).getName(), sDOProperty.getName());
            }
            sDOProperty.setType((Type)object);
            sDOProperty.setContainment(false);
            sDOProperty.buildMapping(sDOProperty.getType().getURI());
            String string2 = nonContainmentReference.getOppositePropName();
            if (string2 == null) continue;
            SDOProperty sDOProperty2 = ((SDOType)object).getProperty(string2);
            sDOProperty.setOpposite(sDOProperty2);
            sDOProperty2.setOpposite(sDOProperty);
        }
        for (Type type : this.getGlobalRefs().keySet()) {
            int n2;
            object3 = this.getGlobalRefs().get(type);
            object2 = new ArrayList();
            if (object3 != null) {
                for (n2 = 0; n2 < object3.size(); ++n2) {
                    object = (GlobalRef)object3.get(n2);
                    sDOProperty = this.processRef((GlobalRef)object);
                    if (!sDOProperty.isFinalized()) continue;
                    object2.add(object);
                }
            }
            for (n2 = 0; n2 < object2.size(); ++n2) {
                object3.remove(object2.get(n2));
            }
        }
    }

    private void addGlobalRef(GlobalRef globalRef) {
        java.util.List<GlobalRef> list = this.getGlobalRefs().get(globalRef.getOwningType());
        if (null == list) {
            list = new ArrayList<GlobalRef>();
            list.add(globalRef);
            this.getGlobalRefs().put(globalRef.getOwningType(), list);
        } else {
            list.add(globalRef);
        }
    }

    private void initialize() {
        if (null == this.packageName) {
            String string = (String)this.rootSchema.getAttributesMap().get(SDOConstants.SDOJAVA_PACKAGE_QNAME);
            this.packageName = null != string ? string : (null == this.rootSchema.getTargetNamespace() || this.rootSchema.getTargetNamespace().equals("") ? "noNamespace" : SDOUtil.getPackageNameFromURI(this.rootSchema.getTargetNamespace()));
            this.packageName = this.packageName + ".";
        }
    }

    private SDOType createSDOTypeForName(String string, String string2, String string3) {
        SDOType sDOType = null;
        int n = string2.indexOf(58);
        if (n == -1) {
            SDOType sDOType2 = new SDOType(string, string2, (SDOTypeHelper)this.aHelperContext.getTypeHelper());
            this.anonymousTypes.add(sDOType2);
            return sDOType2;
        }
        String string4 = string2.substring(0, n);
        String string5 = string2.substring(n + 1, string2.length());
        String string6 = this.getURIForPrefix(string4);
        sDOType = this.getOrCreateType(string6, string5, string3);
        return sDOType;
    }

    private SDOType getSDOTypeForName(String string, String string2, String string3) {
        return this.getSDOTypeForName(string, string2, true, string3);
    }

    private SDOType getSDOTypeForName(String string, String string2, boolean bl, String string3) {
        int n = string3.indexOf(58);
        if (n != -1) {
            String string4 = string3.substring(0, n);
            String string5 = string3.substring(n + 1, string3.length());
            String string6 = this.getURIForPrefix(string4);
            QName qName = new QName(string6, string5);
            SDOType sDOType = this.generatedTypesByXsdQName.get(qName);
            if (null == sDOType && null == (sDOType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getSDOTypeFromXSDType(qName)) && null == (sDOType = this.getExisitingType(string6, string5))) {
                sDOType = this.findSdoType(string, string2, string3, string5, string6);
            }
            if (null == sDOType && !(sDOType = this.getOrCreateType(string6, string5, string5)).isFinalized()) {
                this.getGeneratedTypes().put(new QName(sDOType.getURI(), sDOType.getName()), sDOType);
            }
            return sDOType;
        }
        String string7 = (String)this.itemNameToSDOName.get(string3);
        if (string7 != null) {
            string3 = string7;
        }
        SDOType sDOType = null;
        if (bl && string2 != null) {
            QName qName = new QName(string2, string3);
            sDOType = ((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getSDOTypeFromXSDType(qName);
            if (null == sDOType) {
                sDOType = this.generatedTypesByXsdQName.get(qName);
            }
        }
        if (null == sDOType) {
            sDOType = this.getExisitingType(string, string3);
            if (null == sDOType) {
                return this.findSdoType(string, string2, string3, string3, string);
            }
            return this.getOrCreateType(string, string3, string3);
        }
        return sDOType;
    }

    private SDOType getOrCreateType(String string, String string2, String string3) {
        SDOTypeHelper sDOTypeHelper;
        SDOType sDOType;
        String string4 = string2;
        int n = string4.indexOf(58);
        if (n != -1) {
            string4 = string4.substring(n + 1, string4.length());
        }
        if ((sDOType = (SDOType)(sDOTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper()).getType(string, string4)) == null) {
            QName qName = new QName(string, string4);
            sDOType = (SDOType)this.getGeneratedTypes().get(qName);
            if (sDOType == null) {
                QName qName2 = new QName(string, string3);
                sDOType = this.getTypeForXSDQName(qName2);
                if (sDOType == null) {
                    sDOType = new SDOType(string, string4, sDOTypeHelper);
                    sDOType.setXsd(true);
                    sDOType.setXsdLocalName(string3);
                } else {
                    sDOType.setQName(qName);
                }
            }
        }
        return sDOType;
    }

    private SDOProperty getExistingGlobalProperty(String string, String string2, boolean bl) {
        SDOProperty sDOProperty = (SDOProperty)this.aHelperContext.getXSDHelper().getGlobalProperty(string, string2, bl);
        if (sDOProperty == null) {
            QName qName = new QName(string, string2);
            sDOProperty = bl ? (SDOProperty)this.getGeneratedGlobalElements().get(qName) : (SDOProperty)this.getGeneratedGlobalAttributes().get(qName);
        }
        return sDOProperty;
    }

    private SDOType getExisitingType(String string, String string2) {
        SDOType sDOType = (SDOType)((SDOTypeHelper)this.aHelperContext.getTypeHelper()).getType(string, string2);
        if (sDOType == null) {
            QName qName = new QName(string, string2);
            sDOType = (SDOType)this.getGeneratedTypes().get(qName);
        }
        return sDOType;
    }

    private SDOType findSdoType(String string, String string2, String string3, String string4, String string5) {
        SDOType sDOType = this.getExisitingType(string5, string4);
        if (sDOType == null && (string5 != null && string5.equals(string) || string5 == null && string == null)) {
            this.processGlobalItem(string, string2, string3);
            String string6 = (String)this.itemNameToSDOName.get(string4);
            if (string6 != null) {
                string4 = string6;
            }
            sDOType = this.getExisitingType(string5, string4);
        }
        if (null == sDOType && !(sDOType = this.getOrCreateType(string5, string4, string4)).isFinalized()) {
            this.getGeneratedTypes().put(new QName(sDOType.getURI(), sDOType.getName()), sDOType);
        }
        return sDOType;
    }

    public void setGeneratedTypes(Map<QName, Type> map) {
        this.generatedTypes = map;
    }

    public void setGeneratedGlobalElements(Map<QName, Property> map) {
        this.generatedGlobalElements = map;
    }

    public void setGeneratedGlobalAttributes(Map<QName, Property> map) {
        this.generatedGlobalAttributes = map;
    }

    public java.util.List<SDOType> getAnonymousTypes() {
        return this.anonymousTypes;
    }

    public void setAnonymousTypes(java.util.List<SDOType> list) {
        this.anonymousTypes = list;
    }

    public Map<QName, Type> getGeneratedTypes() {
        if (null == this.generatedTypes) {
            this.generatedTypes = new HashMap<QName, Type>();
        }
        return this.generatedTypes;
    }

    public Map<QName, Property> getGeneratedGlobalElements() {
        if (null == this.generatedGlobalElements) {
            this.generatedGlobalElements = new HashMap<QName, Property>();
        }
        return this.generatedGlobalElements;
    }

    public Map<QName, SDOType> getGeneratedTypesByXsdQName() {
        return this.generatedTypesByXsdQName;
    }

    public void setGeneratedTypesByXsdQName(Map<QName, SDOType> map) {
        this.generatedTypesByXsdQName = map;
    }

    public Map<QName, Property> getGeneratedGlobalAttributes() {
        if (null == this.generatedGlobalAttributes) {
            this.generatedGlobalAttributes = new HashMap<QName, Property>();
        }
        return this.generatedGlobalAttributes;
    }

    private void processSubstitutionGroups(Collection collection, String string, String string2) {
        for (Element element : collection) {
            Object object;
            if (element.getSubstitutionGroup() == null) continue;
            String string3 = element.getSubstitutionGroup();
            String string4 = null;
            String string5 = null;
            int n = string3.indexOf(58);
            if (n != -1) {
                object = string3.substring(0, n);
                string4 = string3.substring(n + 1, string3.length());
                string5 = this.getURIForPrefix((String)object);
            } else {
                string4 = string3;
                string5 = string2;
            }
            object = this.getExistingGlobalProperty(string5, string4, true);
            SDOProperty sDOProperty = this.getExistingGlobalProperty(string, element.getName(), true);
            if (object == null || sDOProperty == null) continue;
            if (((SDOProperty)object).getSubstitutableElements() == null) {
                ((SDOProperty)object).setSubstitutableElements(new ArrayList<SDOProperty>());
                ((SDOProperty)object).setSubstitutable(true);
            }
            ((SDOProperty)object).getSubstitutableElements().add(sDOProperty);
        }
    }

    private void processAnyAttribute(String string, String string2, SDOType sDOType) {
        sDOType.setOpen(true);
    }

    private SDOType getTypeForName(String string, String string2, String string3) {
        Type type = this.getGeneratedTypes().get(string3);
        if (type != null) {
            return (SDOType)type;
        }
        String string4 = (String)this.itemNameToSDOName.get(string3);
        if (string4 != null) {
            return this.getTypeForName(string, string2, string4);
        }
        return this.getSDOTypeForName(string, string2, false, string3);
    }

    private QName getQNameForString(String string, String string2) {
        if (null == string2) {
            return null;
        }
        int n = string2.indexOf(58);
        if (n != -1) {
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1, string2.length());
            String string5 = this.getURIForPrefix(string3);
            QName qName = new QName(string5, string4);
            return qName;
        }
        QName qName = new QName(string, string2);
        return qName;
    }

    private void processGlobalItem(String string, String string2, String string3) {
        if (this.rootSchema == null) {
            return;
        }
        String string4 = null;
        int n = string3.indexOf(58);
        string4 = n != -1 ? string3.substring(n + 1, string3.length()) : string3;
        SimpleType simpleType = (SimpleType)this.rootSchema.getTopLevelSimpleTypes().get(string4);
        if (simpleType == null) {
            ComplexType complexType = (ComplexType)this.rootSchema.getTopLevelComplexTypes().get(string4);
            if (complexType == null) {
                Element element = (Element)this.rootSchema.getTopLevelElements().get(string4);
                if (element == null) {
                    Attribute attribute = (Attribute)this.rootSchema.getTopLevelAttributes().get(string4);
                    if (attribute != null) {
                        this.processGlobalAttribute(string, string2, attribute);
                    }
                } else {
                    this.processGlobalElement(string, string2, element);
                }
            } else {
                this.processGlobalComplexType(string, string2, complexType);
            }
        } else {
            this.processGlobalSimpleType(string, string2, simpleType);
        }
    }

    public Schema getSchema(Source source, SchemaResolver schemaResolver) {
        return this.getSchema(source, new SchemaResolverWrapper(schemaResolver));
    }

    public Schema getSchema(Source source, SchemaResolverWrapper schemaResolverWrapper) {
        try {
            Object object;
            Object object2;
            Object object32;
            XMLContext xMLContext = new XMLContext(this.getSchemaProject());
            XMLUnmarshaller xMLUnmarshaller = xMLContext.createUnmarshaller();
            xMLUnmarshaller.setEntityResolver(schemaResolverWrapper.getSchemaResolver());
            Schema schema = (Schema)xMLUnmarshaller.unmarshal(source);
            java.util.List list = schema.getImports();
            for (Object object32 : list) {
                object2 = this.getReferencedSchema(source, ((Import)object32).getNamespace(), ((Include)object32).getSchemaLocation(), schemaResolverWrapper);
                if (object2 == null) continue;
                object = this.getSchema((Source)object2, schemaResolverWrapper);
                ((Include)object32).setSchema((Schema)object);
            }
            object32 = schema.getIncludes();
            object2 = object32.iterator();
            while (object2.hasNext()) {
                object = (Include)object2.next();
                Source source2 = this.getReferencedSchema(source, schema.getTargetNamespace(), ((Include)object).getSchemaLocation(), schemaResolverWrapper);
                if (source2 == null) continue;
                Schema schema2 = this.getSchema(source2, schemaResolverWrapper);
                ((Include)object).setSchema(schema2);
            }
            return schema;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Source getReferencedSchema(Source source, String string, String string2, SchemaResolverWrapper schemaResolverWrapper) {
        if (string.equals("commonj.sdo/java") || string.equals("commonj.sdo") || string.equals("commonj.sdo/xml")) {
            return null;
        }
        return schemaResolverWrapper.resolveSchema(source, string, string2);
    }

    public Project getSchemaProject() {
        if (this.schemaProject == null) {
            this.schemaProject = new SchemaModelProject();
        }
        return this.schemaProject;
    }

    public Schema getRootSchema() {
        return this.rootSchema;
    }

    public void setProcessImports(boolean bl) {
        this.processImports = bl;
    }

    public boolean isProcessImports() {
        return this.processImports;
    }

    public void setReturnAllTypes(boolean bl) {
        this.returnAllTypes = bl;
    }

    public boolean isReturnAllTypes() {
        return this.returnAllTypes;
    }

    private boolean maxOccursGreaterThanOne(String string) {
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase("unbounded")) {
            return true;
        }
        return !string.equals("1");
    }

    private String getURIForPrefix(String string) {
        NamespaceResolver namespaceResolver;
        String string2 = null;
        for (int i = this.namespaceResolvers.size() - 1; i >= 0 && ((string2 = (namespaceResolver = (NamespaceResolver)this.namespaceResolvers.get(i)).resolveNamespacePrefix(string)) == null || string2.equals("")); --i) {
        }
        if (null == string2) {
            throw SDOException.prefixUsedButNotDefined(string);
        }
        return string2;
    }

    private java.util.List<NonContainmentReference> getNonContainmentReferences() {
        if (null == this.nonContainmentReferences) {
            this.nonContainmentReferences = new ArrayList<NonContainmentReference>();
        }
        return this.nonContainmentReferences;
    }

    private Map<Type, java.util.List<GlobalRef>> getGlobalRefs() {
        if (null == this.globalRefs) {
            this.globalRefs = new HashMap<Type, java.util.List<GlobalRef>>();
        }
        return this.globalRefs;
    }

    public boolean isImportProcessor() {
        return this.isImportProcessor;
    }

    public void setIsImportProcessor(boolean bl) {
        this.isImportProcessor = bl;
    }

    private void preprocessGlobalTypes(Schema schema) {
        Serializable serializable;
        Object object;
        Object object22;
        String string = schema.getTargetNamespace();
        Collection collection = schema.getTopLevelComplexTypes().values();
        for (Object object22 : collection) {
            object = new QName(string, ((ComplexType)object22).getName());
            serializable = this.preprocessComplexType((ComplexType)object22, schema);
            serializable.setXsdType((QName)object);
            this.generatedTypesByXsdQName.put((QName)object, (SDOType)serializable);
        }
        Collection collection2 = schema.getTopLevelSimpleTypes().values();
        object22 = collection2.iterator();
        while (object22.hasNext()) {
            object = (SimpleType)object22.next();
            serializable = new QName(string, ((SimpleType)object).getName());
            SDODataType sDODataType = this.preprocessSimpleType((SimpleType)object, schema);
            sDODataType.setXsdType((QName)serializable);
            this.generatedTypesByXsdQName.put((QName)serializable, sDODataType);
        }
    }

    private SDOType preprocessComplexType(ComplexType complexType, Schema schema) {
        String string = (String)complexType.getAttributesMap().get(SDOConstants.SDOXML_NAME_QNAME);
        if (null == string) {
            string = complexType.getName();
        }
        SDOTypeHelper sDOTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
        String string2 = schema.getTargetNamespace();
        SDOType sDOType = (SDOType)sDOTypeHelper.getType(string2, string);
        QName qName = new QName(schema.getTargetNamespace(), complexType.getName());
        if (null == sDOType) {
            sDOType = (SDOType)this.getGeneratedTypes().get(qName);
            if (sDOType == null) {
                sDOType = new SDOType(string2, string, sDOTypeHelper);
                sDOType.setXsdLocalName(complexType.getName());
                sDOType.preInitialize(this.packageName, this.namespaceResolvers);
            }
            sDOType.setXsd(true);
            if (!sDOType.getQName().equals(sDOType.getXsdType())) {
                // empty if block
            }
            this.getGeneratedTypesByXsdQName().put(qName, sDOType);
            this.getGeneratedTypes().put(sDOType.getQName(), sDOType);
        } else if (!this.returnAllTypes) {
            this.processedComplexTypes.put(qName, complexType);
        }
        return sDOType;
    }

    private SDODataType preprocessSimpleType(SimpleType simpleType, Schema schema) {
        String string = (String)simpleType.getAttributesMap().get(SDOConstants.SDOXML_NAME_QNAME);
        if (null == string) {
            string = simpleType.getName();
        }
        SDOTypeHelper sDOTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
        String string2 = schema.getTargetNamespace();
        SDODataType sDODataType = (SDODataType)sDOTypeHelper.getType(string2, string);
        QName qName = new QName(schema.getTargetNamespace(), simpleType.getName());
        if (null == sDODataType) {
            SDOType sDOType = (SDOType)this.getGeneratedTypes().get(qName);
            if (null == sDOType) {
                sDOType = (SDOType)this.aHelperContext.getTypeHelper().getType(qName.getNamespaceURI(), qName.getLocalPart());
            }
            if (sDOType != null && sDOType.isFinalized()) {
                return (SDODataType)sDOType;
            }
            sDODataType = new SDODataType(string2, string, sDOTypeHelper);
            String string3 = (String)simpleType.getAttributesMap().get(SDOConstants.SDOJAVA_INSTANCECLASS_QNAME);
            if (string3 != null) {
                sDODataType.setInstanceProperty(SDOConstants.JAVA_CLASS_PROPERTY, string3);
            }
            if (sDOType != null) {
                this.generatedTypes.remove(qName);
                this.generatedTypesByXsdQName.remove(qName);
                Iterator iterator = sDOType.getNonFinalizedReferencingProps().iterator();
                Iterator iterator2 = sDOType.getNonFinalizedMappingURIs().iterator();
                while (iterator.hasNext()) {
                    SDOProperty sDOProperty = (SDOProperty)iterator.next();
                    sDOProperty.setType(sDODataType);
                    sDODataType.getNonFinalizedReferencingProps().add(sDOProperty);
                    sDODataType.getNonFinalizedMappingURIs().add(iterator2.next());
                }
                if (this.anonymousTypes.contains(sDOType)) {
                    this.anonymousTypes.remove(sDOType);
                }
            }
            sDODataType.setXsdLocalName(simpleType.getName());
            sDODataType.setXsd(true);
            if (!sDODataType.getQName().equals(sDODataType.getXsdType())) {
                // empty if block
            }
            this.generatedTypesByXsdQName.put(qName, sDODataType);
            this.getGeneratedTypes().put(sDODataType.getQName(), sDODataType);
        } else if (!this.returnAllTypes) {
            this.processedSimpleTypes.put(qName, simpleType);
        }
        return sDODataType;
    }

    private SDOType getTypeForXSDQName(QName qName) {
        SDOType sDOType = this.generatedTypesByXsdQName.get(qName);
        if (null == sDOType) {
            SDOTypeHelper sDOTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
            sDOType = sDOTypeHelper.getSDOTypeFromXSDType(qName);
        }
        return sDOType;
    }

    public class GlobalRef {
        private SDOType owningType;
        private boolean isElement;
        private String uri;
        private String localName;
        private Property property;

        public void setOwningType(SDOType sDOType) {
            this.owningType = sDOType;
        }

        public SDOType getOwningType() {
            return this.owningType;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String string) {
            this.uri = string;
        }

        public Property getProperty() {
            return this.property;
        }

        public void setProperty(Property property) {
            this.property = property;
        }

        public String getLocalName() {
            return this.localName;
        }

        public void setLocalName(String string) {
            this.localName = string;
        }

        public boolean isElement() {
            return this.isElement;
        }

        public void setIsElement(boolean bl) {
            this.isElement = bl;
        }
    }

    public class NonContainmentReference {
        private SDOType owningType;
        private SDOProperty owningProp;
        private String propertyTypeName;
        private String propertyTypeURI;
        private String oppositePropName;

        public void setOwningType(SDOType sDOType) {
            this.owningType = sDOType;
        }

        public SDOType getOwningType() {
            return this.owningType;
        }

        public void setOwningProp(SDOProperty sDOProperty) {
            this.owningProp = sDOProperty;
        }

        public SDOProperty getOwningProp() {
            return this.owningProp;
        }

        public void setPropertyTypeName(String string) {
            this.propertyTypeName = string;
        }

        public String getPropertyTypeName() {
            return this.propertyTypeName;
        }

        public void setPropertyTypeURI(String string) {
            this.propertyTypeURI = string;
        }

        public String getPropertyTypeURI() {
            return this.propertyTypeURI;
        }

        public void setOppositePropName(String string) {
            this.oppositePropName = string;
        }

        public String getOppositePropName() {
            return this.oppositePropName;
        }
    }
}

