/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import commonj.sdo.helper.DataFactory;
import commonj.sdo.helper.HelperContext;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.StrBuffer;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.oxm.unmapped.UnmappedContentHandler;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.SDOXMLDocument;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class SDOUnmappedContentHandler
implements UnmappedContentHandler {
    private UnmarshalRecord parentRecord;
    private SDOXMLDocument xmlDocument;
    private QName currentSchemaType;
    private StrBuffer currentBuffer;
    private Stack currentDataObjects = new Stack();
    private Stack currentProperties = new Stack();
    private boolean rootProcessed;
    private boolean isInCharacterBlock = false;
    private HelperContext aHelperContext;
    private int lastEvent = -1;
    private static final int START_ELEMENT = 0;
    private static final int END_ELEMENT = 1;
    private Map uriToPrefixMap;
    protected Map namespaceMap;
    private static final String NO_NAMESPACE = null;
    private int depth = 0;

    public SDOUnmappedContentHandler() {
        this.currentBuffer = new StrBuffer();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        Stack<String> stack;
        if (null == this.namespaceMap) {
            this.namespaceMap = new HashMap();
        }
        if (this.uriToPrefixMap == null) {
            this.uriToPrefixMap = new HashMap();
        }
        if ((stack = (Stack<String>)this.namespaceMap.get(string)) == null) {
            stack = new Stack<String>();
            this.namespaceMap.put(string, stack);
        }
        stack.push(string2);
        Stack<String> stack2 = (Stack<String>)this.uriToPrefixMap.get(string2);
        if (stack2 == null) {
            stack2 = new Stack<String>();
            this.uriToPrefixMap.put(string2, stack2);
        }
        stack2.push(string);
    }

    public void endPrefixMapping(String string) throws SAXException {
        Stack stack;
        if (null == this.namespaceMap) {
            return;
        }
        Stack stack2 = (Stack)this.namespaceMap.get(string);
        String string2 = null;
        if (stack2 != null && stack2.size() > 0) {
            string2 = (String)stack2.pop();
        }
        if (string2 != null && this.uriToPrefixMap != null && (stack = (Stack)this.uriToPrefixMap.get(string2)) != null && stack.size() > 0) {
            stack.pop();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.isInCharacterBlock) {
            if (!this.currentBuffer.toString().trim().equals("")) {
                DataObject dataObject = (DataObject)this.currentDataObjects.peek();
                dataObject.getSequence().addText(this.currentBuffer.toString());
            }
            this.currentBuffer.reset();
        }
        if (!this.rootProcessed) {
            this.processRoot(string, string2, string3, attributes);
        } else {
            this.processNonRoot(string, string2, string3, attributes);
        }
        this.lastEvent = 0;
    }

    private QName getTypeAttributeQName(Attributes attributes) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string = attributes.getValue(i);
            String string2 = attributes.getURI(i);
            String string3 = attributes.getLocalName(i);
            if (!"http://www.w3.org/2001/XMLSchema-instance".equals(string2) || !"type".equals(string3)) continue;
            int n2 = string.indexOf(58);
            String string4 = string.substring(0, n2);
            String string5 = null;
            Stack stack = (Stack)this.getNamespaceMap().get(string4);
            if (stack != null && stack.size() > 0) {
                string5 = (String)stack.peek();
            }
            if (string5 != null) {
                QName qName;
                String string6 = string.substring(n2 + 1, string.length());
                this.currentSchemaType = qName = new QName(string5, string6);
                return qName;
            }
            throw XMLMarshalException.namespaceNotFound(string4);
        }
        return null;
    }

    private void processAttributes(Attributes attributes, DataObject dataObject, boolean bl) {
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            String string = attributes.getValue(i);
            String string2 = attributes.getURI(i);
            String string3 = attributes.getLocalName(i);
            if (attributes.getQName(i) != null && attributes.getQName(i).startsWith("xmlns:")) continue;
            if (bl && "schemaLocation".equals(string3)) {
                this.getXmlDocument().setSchemaLocation(string);
                continue;
            }
            if (bl && "noNamespaceSchemaLocation".equals(string3)) {
                this.getXmlDocument().setNoNamespaceSchemaLocation(string);
                continue;
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(string2) && "type".equals(string3)) continue;
            if ("ref".equals(string3) && "commonj.sdo".equals(string2)) {
                ((SDODataObject)dataObject)._setSdoRef(string);
                continue;
            }
            HelperContext helperContext = ((SDOType)dataObject.getType()).getHelperContext();
            Property property = helperContext.getXSDHelper().getGlobalProperty(string2, string3, false);
            if (property != null) {
                object = ((SDODataHelper)helperContext.getDataHelper()).convertFromStringValue(string, property.getType());
                dataObject.set(property, object);
                continue;
            }
            object = ((SDODataHelper)helperContext.getDataHelper()).convertFromStringValue(string, SDOConstants.SDO_STRING);
            property = this.defineNewSDOProperty(string2, string3, false, SDOConstants.SDO_STRING);
            dataObject.set(property, object);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
    }

    public void skippedEntity(String string) throws SAXException {
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.currentDataObjects.size() == 0 && this.currentProperties.size() == 0) {
            return;
        }
        if (this.currentDataObjects.size() == 1 && this.currentProperties.size() == 0) {
            this.parentRecord.getUnmarshaller().getUnmarshalListener().afterUnmarshal(this.currentDataObjects.peek(), null);
            this.currentDataObjects.pop();
            --this.depth;
            return;
        }
        this.setElementPropertyValue();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.isInCharacterBlock) {
            this.currentBuffer.reset();
            this.isInCharacterBlock = true;
        }
        this.currentBuffer.append(cArray, n, n2);
    }

    private void setElementPropertyValue() {
        Object object;
        Object object2;
        Property property = (Property)this.currentProperties.pop();
        boolean bl = true;
        if (this.lastEvent == 1) {
            bl = false;
        } else {
            if (this.depth > this.currentDataObjects.size()) {
                bl = true;
            } else {
                object2 = (DataObject)this.currentDataObjects.peek();
                if (object2.getInstanceProperties().size() > 0) {
                    bl = false;
                    if (!this.currentBuffer.toString().trim().equals("")) {
                        object = (DataObject)this.currentDataObjects.peek();
                        object.getSequence().addText(this.currentBuffer.toString());
                    }
                } else {
                    this.currentDataObjects.pop();
                }
            }
            --this.depth;
        }
        this.lastEvent = 1;
        if (bl && (!this.isInCharacterBlock || this.currentBuffer.length() == 0)) {
            return;
        }
        object2 = (DataObject)this.currentDataObjects.peek();
        if (property != null) {
            object = null;
            if (bl) {
                object = this.currentBuffer.toString();
                ((SDOProperty)property).setType(SDOConstants.SDO_STRING);
                ((SDOProperty)property).setContainment(false);
            } else {
                object = object2;
                this.currentDataObjects.pop();
                --this.depth;
                object2 = this.currentDataObjects.isEmpty() ? null : (DataObject)this.currentDataObjects.peek();
            }
            HelperContext helperContext = ((SDOType)object2.getType()).getHelperContext();
            if (this.currentSchemaType != null) {
                SDOType sDOType = ((SDOTypeHelper)helperContext.getTypeHelper()).getSDOTypeFromXSDType(this.currentSchemaType);
                if (sDOType != null) {
                    ((SDOProperty)property).setType(sDOType);
                }
                if (property.getType() != null && bl) {
                    object = ((SDODataHelper)helperContext.getDataHelper()).convertFromStringValue((String)object, property.getType(), this.currentSchemaType);
                }
                this.currentSchemaType = null;
            } else if (property.getType() != null && property.getType().isDataType()) {
                object = ((SDODataHelper)helperContext.getDataHelper()).convertFromStringValue((String)object, property.getType());
            }
            if (object2 != null) {
                if (!bl) {
                    this.parentRecord.getUnmarshaller().getUnmarshalListener().afterUnmarshal(object, object2);
                }
                if (property.isMany()) {
                    object2.getList(property).add(object);
                } else {
                    object2.set(property, object);
                }
            }
            this.currentBuffer.reset();
        }
    }

    private void processNonRoot(String string, String string2, String string3, Attributes attributes) throws SAXException {
        DataObject dataObject = (DataObject)this.currentDataObjects.peek();
        if (dataObject != null && !dataObject.getType().isOpen()) {
            return;
        }
        Property property = this.aHelperContext.getXSDHelper().getGlobalProperty(string, string2, true);
        if (property != null) {
            this.currentProperties.push(property);
            SDOType sDOType = (SDOType)property.getType();
            if (property.getType().isDataType()) {
                ++this.depth;
            } else {
                XMLDescriptor xMLDescriptor = sDOType.getXmlDescriptor();
                this.giveToOXToProcess(string, string2, string3, attributes, xMLDescriptor);
            }
        } else {
            String string4 = string2;
            String string5 = string;
            QName qName = this.getTypeAttributeQName(attributes);
            Type type = null;
            if (qName != null) {
                string4 = qName.getLocalPart();
                string5 = qName.getNamespaceURI();
                type = this.aHelperContext.getTypeHelper().getType(string5, string4);
            }
            if (type == null) {
                type = this.aHelperContext.getTypeHelper().getType("org.eclipse.persistence.sdo", "OpenSequencedType");
                Type type2 = this.aHelperContext.getTypeHelper().getType("commonj.sdo", "DataObject");
                SDOProperty sDOProperty = this.defineNewSDOProperty(string, string2, true, type2);
                DataObject dataObject2 = this.aHelperContext.getDataFactory().create(type);
                this.processAttributes(attributes, dataObject2, false);
                this.currentDataObjects.push(dataObject2);
                ++this.depth;
                this.parentRecord.setCurrentObject(dataObject2);
                this.currentProperties.push(sDOProperty);
            } else {
                XMLDescriptor xMLDescriptor = ((SDOType)type).getXmlDescriptor();
                this.giveToOXToProcess(string, string2, string3, attributes, xMLDescriptor);
                SDOProperty sDOProperty = this.defineNewSDOProperty(string, string2, true, type);
                this.currentProperties.push(sDOProperty);
                return;
            }
        }
    }

    private void processRoot(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        QName qName;
        DataFactory dataFactory = this.aHelperContext.getDataFactory();
        SDOTypeHelper sDOTypeHelper = (SDOTypeHelper)this.aHelperContext.getTypeHelper();
        this.getXmlDocument().setRootElementName(string2);
        this.getXmlDocument().setRootElementURI(string);
        Property property = this.aHelperContext.getXSDHelper().getGlobalProperty(string, string2, true);
        Type type = null;
        if (property != null) {
            type = property.getType();
        } else {
            qName = this.getTypeAttributeQName(attributes);
            if (qName != null) {
                string4 = qName.getLocalPart();
                String string5 = null;
                String string6 = qName.getPrefix();
                if (string6 == null) {
                    string5 = null;
                } else {
                    Stack stack = (Stack)this.getNamespaceMap().get(string6);
                    if (stack != null && stack.size() > 0) {
                        string5 = (String)stack.peek();
                    }
                }
                type = sDOTypeHelper.getType(string5, string4);
            }
        }
        qName = null;
        if (type != null) {
            this.giveToOXToProcess(string, string2, string3, attributes, ((SDOType)type).getXmlDescriptor());
            return;
        }
        string4 = this.aHelperContext.getTypeHelper().getType("org.eclipse.persistence.sdo", "OpenSequencedType");
        qName = dataFactory.create((Type)string4);
        this.currentDataObjects.push(qName);
        ++this.depth;
        this.processAttributes(attributes, (DataObject)qName, true);
        this.getXmlDocument().setRootObject((DataObject)qName);
        this.rootProcessed = true;
        this.parentRecord.setCurrentObject(this.getXmlDocument());
    }

    private SDOProperty defineNewSDOProperty(String string, String string2, boolean bl, Type type) {
        SDOProperty sDOProperty;
        DataObject dataObject = (DataObject)this.currentDataObjects.peek();
        if (string != null && string.equals("")) {
            string = NO_NAMESPACE;
        }
        if ((sDOProperty = (SDOProperty)dataObject.getInstanceProperty(string2)) != null && this.equalStrings(sDOProperty.getUri(), string)) {
            if (bl && this.aHelperContext.getXSDHelper().isElement((Property)sDOProperty)) {
                return sDOProperty;
            }
            if (!bl && this.aHelperContext.getXSDHelper().isAttribute((Property)sDOProperty)) {
                return sDOProperty;
            }
        }
        SDOProperty sDOProperty2 = new SDOProperty(this.aHelperContext);
        sDOProperty2.setName(string2);
        sDOProperty2.setMany(bl);
        sDOProperty2.setContainment(!type.isDataType());
        sDOProperty2.setType(type);
        sDOProperty2.setUri(string);
        sDOProperty2.setInstanceProperty(SDOConstants.XMLELEMENT_PROPERTY, bl);
        return sDOProperty2;
    }

    private void giveToOXToProcess(String string, String string2, String string3, Attributes attributes, XMLDescriptor xMLDescriptor) throws SAXException {
        UnmarshalRecord unmarshalRecord;
        AbstractSession abstractSession = ((SDOXMLHelper)this.aHelperContext.getXMLHelper()).getXmlContext().getReadSession(xMLDescriptor);
        if (xMLDescriptor.hasInheritance()) {
            QName qName;
            unmarshalRecord = new UnmarshalRecord((TreeObjectBuilder)xMLDescriptor.getObjectBuilder());
            unmarshalRecord.setNamespaceMap(this.namespaceMap);
            unmarshalRecord.setUriToPrefixMap(this.uriToPrefixMap);
            unmarshalRecord.setAttributes(attributes);
            Class clazz = xMLDescriptor.getInheritancePolicy().classFromRow(unmarshalRecord, abstractSession);
            if (clazz == null && (qName = xMLDescriptor.getDefaultRootElementType()) != null) {
                Object v = xMLDescriptor.getInheritancePolicy().getClassIndicatorMapping().get(qName);
                if (v == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(qName, xMLDescriptor.getInheritancePolicy().getDescriptor());
                }
                clazz = (Class)v;
            }
            if (clazz != null) {
                xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(clazz);
            } else if (Modifier.isAbstract(xMLDescriptor.getJavaClass().getModifiers())) {
                throw DescriptorException.missingClassIndicatorField(unmarshalRecord, xMLDescriptor.getInheritancePolicy().getDescriptor());
            }
        }
        unmarshalRecord = (UnmarshalRecord)xMLDescriptor.getObjectBuilder().createRecord(abstractSession);
        unmarshalRecord.setParentRecord(this.parentRecord);
        unmarshalRecord.setUnmarshaller(this.parentRecord.getUnmarshaller());
        unmarshalRecord.setXMLReader(this.parentRecord.getXMLReader());
        unmarshalRecord.startDocument();
        unmarshalRecord.setNamespaceMap(this.namespaceMap);
        unmarshalRecord.setUriToPrefixMap(this.uriToPrefixMap);
        unmarshalRecord.startElement(string, string2, string3, attributes);
        this.parentRecord.getXMLReader().setContentHandler(unmarshalRecord);
        try {
            unmarshalRecord.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", unmarshalRecord);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
        this.currentDataObjects.push(unmarshalRecord.getCurrentObject());
        ++this.depth;
    }

    private SDOXMLDocument getXmlDocument() {
        if (this.xmlDocument == null) {
            this.xmlDocument = new SDOXMLDocument();
        }
        return this.xmlDocument;
    }

    public void setUnmarshalRecord(UnmarshalRecord unmarshalRecord) {
        this.parentRecord = unmarshalRecord;
        this.aHelperContext = (HelperContext)unmarshalRecord.getUnmarshaller().getProperty("sdoHelperContext");
        if (this.parentRecord.getParentRecord() == null) {
            this.rootProcessed = false;
        } else {
            this.rootProcessed = true;
            if (this.parentRecord.getParentRecord().getCurrentObject() instanceof DataObject) {
                this.currentDataObjects.push(this.parentRecord.getParentRecord().getCurrentObject());
                ++this.depth;
            }
        }
        this.namespaceMap = this.parentRecord.getNamespaceMap();
        this.uriToPrefixMap = this.parentRecord.getUriToPrefixMap();
    }

    public Map getNamespaceMap() {
        if (this.namespaceMap == null) {
            this.namespaceMap = new HashMap();
        }
        return this.namespaceMap;
    }

    private boolean equalStrings(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }
}

