/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.MappingNodeValue;
import org.eclipse.persistence.internal.oxm.TreeObjectBuilder;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.ContainerMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.sdo.SDOChangeSummary;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.ValueStore;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBHelperContext;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBListWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBValueStore
implements ValueStore {
    private JAXBHelperContext jaxbHelperContext;
    private Object entity;
    private XMLDescriptor descriptor;
    private SDODataObject dataObject;
    private Map<Property, JAXBListWrapper> listWrappers;

    public JAXBValueStore(JAXBHelperContext jAXBHelperContext, SDOType sDOType) {
        this.jaxbHelperContext = jAXBHelperContext;
        QName qName = sDOType.getXsdType();
        if (null == qName) {
            qName = sDOType.getQName();
        }
        this.listWrappers = new WeakHashMap<Property, JAXBListWrapper>();
        XPathFragment xPathFragment = new XPathFragment(qName.getLocalPart());
        xPathFragment.setNamespaceURI(qName.getNamespaceURI());
        JAXBContext jAXBContext = (JAXBContext)this.jaxbHelperContext.getJAXBContext();
        this.descriptor = jAXBContext.getXMLContext().getDescriptorByGlobalType(xPathFragment);
        if (null == this.descriptor) {
            this.descriptor = jAXBContext.getXMLContext().getDescriptor(qName);
            if (null == this.descriptor) {
                throw SDOException.sdoJaxbNoDescriptorForType(sDOType.getQName(), qName);
            }
        }
        this.entity = this.descriptor.getInstantiationPolicy().buildNewInstance();
    }

    public JAXBValueStore(JAXBHelperContext jAXBHelperContext, Object object) {
        this.jaxbHelperContext = jAXBHelperContext;
        this.listWrappers = new WeakHashMap<Property, JAXBListWrapper>();
        JAXBContext jAXBContext = (JAXBContext)this.jaxbHelperContext.getJAXBContext();
        this.descriptor = (XMLDescriptor)jAXBContext.getXMLContext().getSession(object).getDescriptor(object);
        this.entity = object;
    }

    private JAXBValueStore(JAXBHelperContext jAXBHelperContext, Object object, XMLDescriptor xMLDescriptor, SDODataObject sDODataObject, Map<Property, JAXBListWrapper> map) {
        this.jaxbHelperContext = jAXBHelperContext;
        this.entity = object;
        this.descriptor = xMLDescriptor;
        this.dataObject = sDODataObject;
        this.listWrappers = map;
        for (JAXBListWrapper jAXBListWrapper : this.listWrappers.values()) {
            jAXBListWrapper.getCurrentElements().setValueStore(this);
        }
    }

    SDODataObject getDataObject() {
        return this.dataObject;
    }

    Object getEntity() {
        return this.entity;
    }

    XMLDescriptor getEntityDescriptor() {
        return this.descriptor;
    }

    JAXBHelperContext getJAXBHelperContext() {
        return this.jaxbHelperContext;
    }

    @Override
    public void initialize(DataObject dataObject) {
        this.dataObject = (SDODataObject)dataObject;
    }

    @Override
    public Object getDeclaredProperty(int n) {
        SDOProperty sDOProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(n);
        if (sDOProperty.getType().isChangeSummaryType()) {
            return this.dataObject.getChangeSummary();
        }
        DatabaseMapping databaseMapping = this.getJAXBMappingForProperty(sDOProperty);
        Object object = databaseMapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
        if (sDOProperty.isMany()) {
            JAXBListWrapper jAXBListWrapper = this.listWrappers.get(sDOProperty);
            if (null != jAXBListWrapper) {
                return jAXBListWrapper;
            }
            jAXBListWrapper = new JAXBListWrapper(this, sDOProperty);
            this.listWrappers.put(sDOProperty, jAXBListWrapper);
            return jAXBListWrapper;
        }
        if (null == object || sDOProperty.getType().isDataType()) {
            return object;
        }
        if (sDOProperty.isContainment()) {
            return this.jaxbHelperContext.wrap(object, (Property)sDOProperty, (DataObject)this.dataObject);
        }
        return this.jaxbHelperContext.wrap(object);
    }

    @Override
    public void setDeclaredProperty(int n, Object object) {
        SDOProperty sDOProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(n);
        if (sDOProperty.getType().isChangeSummaryType()) {
            return;
        }
        DatabaseMapping databaseMapping = this.getJAXBMappingForProperty(sDOProperty);
        Object object2 = object;
        Object object3 = databaseMapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
        if (sDOProperty.getType().isDataType()) {
            if (!sDOProperty.isMany()) {
                AbstractSession abstractSession = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
                XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)databaseMapping;
                if (xMLDirectMapping.hasConverter()) {
                    object2 = xMLDirectMapping.getConverter().convertDataValueToObjectValue(object2, abstractSession);
                } else {
                    DatabaseField databaseField = databaseMapping.getField();
                    object2 = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(object2, this.descriptor.getObjectBuilder().getFieldClassification(databaseField));
                }
            }
            databaseMapping.setAttributeValueInObject(this.entity, object2);
        } else if (sDOProperty.isMany()) {
            ListWrapper listWrapper = (ListWrapper)this.getDeclaredProperty(n);
            listWrapper.addAll((Collection)((List)object2));
        } else {
            XMLCompositeObjectMapping xMLCompositeObjectMapping;
            if (databaseMapping.isAbstractCompositeObjectMapping()) {
                xMLCompositeObjectMapping = (XMLCompositeObjectMapping)databaseMapping;
                if (object3 != null && xMLCompositeObjectMapping.getContainerAccessor() != null) {
                    xMLCompositeObjectMapping.getContainerAccessor().setAttributeValueInObject(object3, null);
                }
            }
            object2 = this.jaxbHelperContext.unwrap((DataObject)object);
            databaseMapping.getAttributeAccessor().setAttributeValueInObject(this.entity, object2);
            if (databaseMapping.isAbstractCompositeObjectMapping()) {
                xMLCompositeObjectMapping = (XMLCompositeObjectMapping)databaseMapping;
                if (object != null && xMLCompositeObjectMapping.getContainerAccessor() != null) {
                    xMLCompositeObjectMapping.getContainerAccessor().setAttributeValueInObject(object2, this.entity);
                }
            }
        }
    }

    @Override
    public boolean isSetDeclaredProperty(int n) {
        SDOProperty sDOProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(n);
        if (sDOProperty.getType().isChangeSummaryType()) {
            return true;
        }
        DatabaseMapping databaseMapping = this.getJAXBMappingForProperty(sDOProperty);
        if (sDOProperty.isMany()) {
            Collection collection = (Collection)databaseMapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
            if (null == collection) {
                return false;
            }
            return !collection.isEmpty();
        }
        return null != databaseMapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
    }

    @Override
    public void unsetDeclaredProperty(int n) {
        SDOProperty sDOProperty = (SDOProperty)this.dataObject.getType().getDeclaredProperties().get(n);
        DatabaseMapping databaseMapping = this.getJAXBMappingForProperty(sDOProperty);
        if (sDOProperty.isMany()) {
            Object object;
            Object object2;
            ContainerMapping containerMapping = (ContainerMapping)((Object)databaseMapping);
            ContainerPolicy containerPolicy = containerMapping.getContainerPolicy();
            if (databaseMapping.isAbstractCompositeCollectionMapping() && ((XMLCompositeCollectionMapping)(object2 = (XMLCompositeCollectionMapping)databaseMapping)).getContainerAccessor() != null && (object = databaseMapping.getAttributeValueFromObject(this.entity)) != null) {
                AbstractSession abstractSession = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
                Object object3 = containerPolicy.iteratorFor(object);
                while (containerPolicy.hasNext(object3)) {
                    Object object4 = containerPolicy.next(object3, abstractSession);
                    ((XMLCompositeCollectionMapping)object2).getContainerAccessor().setAttributeValueInObject(object4, null);
                }
            }
            object2 = containerPolicy.containerInstance();
            databaseMapping.getAttributeAccessor().setAttributeValueInObject(this.entity, object2);
        } else {
            XMLCompositeObjectMapping xMLCompositeObjectMapping;
            Object object = databaseMapping.getAttributeAccessor().getAttributeValueFromObject(this.entity);
            if (databaseMapping.isAbstractCompositeObjectMapping() && (xMLCompositeObjectMapping = (XMLCompositeObjectMapping)databaseMapping).getContainerAccessor() != null && object != null) {
                xMLCompositeObjectMapping.getContainerAccessor().setAttributeValueInObject(object, null);
            }
            databaseMapping.getAttributeAccessor().setAttributeValueInObject(this.entity, null);
        }
    }

    @Override
    public Object getOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOpenContentProperty(Property property, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSetOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unsetOpenContentProperty(Property property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setManyProperty(Property property, Object object) {
    }

    @Override
    public ValueStore copy() {
        AbstractSession abstractSession = ((JAXBContext)this.jaxbHelperContext.getJAXBContext()).getXMLContext().getSession(this.entity);
        Object object = this.entity;
        this.entity = this.descriptor.getInstantiationPolicy().buildNewInstance();
        for (SDOProperty sDOProperty : this.dataObject.getType().getProperties()) {
            if (sDOProperty.getType().isChangeSummaryType()) continue;
            DatabaseMapping databaseMapping = this.getJAXBMappingForProperty(sDOProperty);
            AttributeAccessor attributeAccessor = databaseMapping.getAttributeAccessor();
            Object object2 = attributeAccessor.getAttributeValueFromObject(object);
            if (databaseMapping.isCollectionMapping()) {
                Object object3;
                Object object4 = null;
                SDOChangeSummary sDOChangeSummary = (SDOChangeSummary)this.dataObject.getChangeSummary();
                if (null != sDOChangeSummary) {
                    object3 = this.listWrappers.get(sDOProperty);
                    object4 = (List)sDOChangeSummary.getOriginalElements().get(object3);
                }
                if (null == object4) {
                    object3 = databaseMapping.getContainerPolicy();
                    object4 = ((ContainerPolicy)object3).containerInstance();
                    if (null != object2) {
                        Object object5 = ((ContainerPolicy)object3).iteratorFor(object2);
                        while (((ContainerPolicy)object3).hasNext(object5)) {
                            ((ContainerPolicy)object3).addInto(((ContainerPolicy)object3).nextEntry(object5), object4, abstractSession);
                        }
                    }
                }
                attributeAccessor.setAttributeValueInObject(this.entity, object4);
                continue;
            }
            attributeAccessor.setAttributeValueInObject(this.entity, object2);
        }
        return new JAXBValueStore(this.jaxbHelperContext, object, this.descriptor, this.dataObject, this.listWrappers);
    }

    DatabaseMapping getJAXBMappingForProperty(SDOProperty sDOProperty) {
        Object object;
        XMLField xMLField;
        Cloneable cloneable;
        DatabaseMapping databaseMapping = sDOProperty.getXmlMapping();
        if (databaseMapping instanceof XMLObjectReferenceMapping) {
            cloneable = (XMLObjectReferenceMapping)databaseMapping;
            xMLField = (XMLField)((XMLObjectReferenceMapping)cloneable).getFields().get(0);
        } else {
            xMLField = (XMLField)databaseMapping.getField();
        }
        cloneable = (TreeObjectBuilder)this.descriptor.getObjectBuilder();
        XPathNode xPathNode = ((TreeObjectBuilder)cloneable).getRootXPathNode();
        XPathFragment xPathFragment = xMLField.getXPathFragment();
        while (xPathNode != null && xPathFragment != null) {
            if (xPathFragment.isAttribute()) {
                if (sDOProperty.isMany() && !sDOProperty.isContainment() && !sDOProperty.getType().isDataType()) {
                    xPathFragment = null;
                    break;
                }
                object = xPathNode.getAttributeChildrenMap();
                xPathNode = null == object ? null : (XPathNode)xPathNode.getAttributeChildrenMap().get(xPathFragment);
            } else {
                object = xPathNode.getNonAttributeChildrenMap();
                xPathNode = null == object ? null : (XPathNode)xPathNode.getNonAttributeChildrenMap().get(xPathFragment);
            }
            if ((xPathFragment = xPathFragment.getNextFragment()) == null || !xPathFragment.nameIsText() || !sDOProperty.isMany() || sDOProperty.isContainment()) continue;
            xPathFragment = null;
            break;
        }
        if (null == xPathFragment && xPathNode != null && xPathNode.getNodeValue().isMappingNodeValue()) {
            object = (MappingNodeValue)xPathNode.getNodeValue();
            return ((MappingNodeValue)object).getMapping();
        }
        throw SDOException.sdoJaxbNoMappingForProperty(sDOProperty.getName(), xMLField.getXPath());
    }
}

