/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.broker;

import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.SessionBrokerIdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ServerSession;

public class SessionBroker
extends DatabaseSessionImpl {
    protected SessionBroker parent;
    protected Map sessionNamesByClass;
    protected Map sessionsByName = new HashMap(2);
    protected Sequencing sequencing;

    public SessionBroker() {
        super(new DatabaseLogin());
        this.sessionNamesByClass = new HashMap(2);
    }

    protected SessionBroker(Map map) {
        super(new DatabaseLogin());
        this.sessionNamesByClass = map;
    }

    public SessionBroker acquireClientSessionBroker() {
        this.log(2, "connection", "acquire_client_session_broker");
        SessionBroker sessionBroker = this.copySessionBroker();
        sessionBroker.parent = this;
        sessionBroker.getIdentityMapAccessorInstance().setIdentityMapManager(this.getIdentityMapAccessorInstance().getIdentityMapManager());
        sessionBroker.commitManager = this.getCommitManager();
        sessionBroker.commandManager = this.getCommandManager();
        sessionBroker.externalTransactionController = this.getExternalTransactionController();
        sessionBroker.setServerPlatform(this.getServerPlatform());
        for (String string : this.getSessionsByName().keySet()) {
            AbstractSession abstractSession = this.getSessionForName(string);
            if (abstractSession instanceof ServerSession) {
                if (abstractSession.getProject().hasIsolatedClasses()) {
                    throw ValidationException.isolatedDataNotSupportedInSessionBroker(string);
                }
                sessionBroker.internalRegisterSession(string, ((ServerSession)abstractSession).acquireClientSession());
                continue;
            }
            throw ValidationException.cannotAcquireClientSessionFromSession();
        }
        sessionBroker.initializeSequencing();
        return sessionBroker;
    }

    public Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        if (this.isServerSessionBroker()) {
            throw ValidationException.cannotAcquireHistoricalSession();
        }
        SessionBroker sessionBroker = this.copySessionBroker();
        for (String string : this.getSessionsByName().keySet()) {
            AbstractSession abstractSession = this.getSessionForName(string);
            sessionBroker.registerSession(string, abstractSession.acquireHistoricalSession(asOfClause));
        }
        return sessionBroker;
    }

    public void releaseJTSConnection() {
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            abstractSession.releaseJTSConnection();
        }
    }

    public UnitOfWorkImpl acquireUnitOfWork() {
        if (this.isServerSessionBroker()) {
            return this.acquireClientSessionBroker().acquireUnitOfWork();
        }
        return super.acquireUnitOfWork();
    }

    public void addDescriptor(ClassDescriptor classDescriptor) {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    public void addDescriptors(Vector vector) throws ValidationException {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    public void addDescriptors(Project project) throws ValidationException {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    protected void basicBeginTransaction() throws DatabaseException {
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            abstractSession.beginTransaction();
        }
    }

    protected void basicCommitTransaction() throws DatabaseException {
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            if (abstractSession.isConnected()) continue;
            throw DatabaseException.databaseAccessorNotConnected();
        }
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            abstractSession.commitTransaction();
        }
    }

    protected void basicRollbackTransaction() throws DatabaseException {
        DatabaseException databaseException = null;
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            try {
                abstractSession.rollbackTransaction();
            }
            catch (DatabaseException databaseException2) {
                databaseException = databaseException2;
            }
        }
        if (databaseException != null) {
            throw databaseException;
        }
    }

    public boolean containsQuery(String string) {
        boolean bl = this.getQueries().containsKey(string);
        if (this.isClientSessionBroker() && !bl) {
            String string22 = null;
            AbstractSession abstractSession = null;
            for (String string22 : this.getSessionsByName().keySet()) {
                abstractSession = this.getSessionForName(string22);
                if (!(abstractSession instanceof ClientSession) || !((ClientSession)abstractSession).getParent().getBroker().containsQuery(string)) continue;
                return true;
            }
        }
        return bl;
    }

    protected SessionBroker copySessionBroker() {
        SessionBroker sessionBroker = new SessionBroker(this.getSessionNamesByClass());
        sessionBroker.accessor = this.getAccessor();
        sessionBroker.name = this.getName();
        sessionBroker.sessionLog = this.getSessionLog();
        sessionBroker.project = this.project;
        sessionBroker.eventManager = this.getEventManager().clone(sessionBroker);
        sessionBroker.shouldPropagateChanges = this.shouldPropagateChanges;
        return sessionBroker;
    }

    public Accessor getAccessor(Class clazz) {
        if (clazz == null) {
            throw QueryException.unnamedQueryOnSessionBroker(null);
        }
        return this.getSessionForClass(clazz).getAccessor(clazz);
    }

    public Accessor getAccessor(String string) {
        return this.getSessionForName(string).getAccessor(string);
    }

    public AsOfClause getAsOfClause() {
        Iterator iterator = this.getSessionsByName().values().iterator();
        if (iterator.hasNext()) {
            return ((AbstractSession)iterator.next()).getAsOfClause();
        }
        return null;
    }

    public SessionBroker getParent() {
        return this.parent;
    }

    public AbstractSession getParentIdentityMapSession(DatabaseQuery databaseQuery, boolean bl, boolean bl2) {
        if (databaseQuery == null) {
            return this;
        }
        return this.getSessionForQuery(databaseQuery).getParentIdentityMapSession(databaseQuery, bl, bl2);
    }

    public AbstractSession getExecutionSession(DatabaseQuery databaseQuery) {
        AbstractSession abstractSession = this.getSessionForQuery(databaseQuery);
        return abstractSession.getExecutionSession(databaseQuery);
    }

    public Platform getPlatform(Class clazz) {
        if (clazz == null) {
            return super.getDatasourcePlatform();
        }
        return this.getSessionForClass(clazz).getDatasourcePlatform();
    }

    public DatabaseQuery getQuery(String string) {
        DatabaseQuery databaseQuery = super.getQuery(string);
        if (this.isClientSessionBroker() && databaseQuery == null) {
            String string22 = null;
            AbstractSession abstractSession = null;
            for (String string22 : this.getSessionsByName().keySet()) {
                abstractSession = this.getSessionForName(string22);
                if (!(abstractSession instanceof ClientSession) || (databaseQuery = ((ClientSession)abstractSession).getParent().getBroker().getQuery(string)) == null) continue;
                return databaseQuery;
            }
        }
        return databaseQuery;
    }

    public DatabaseQuery getQuery(String string, Vector vector) {
        DatabaseQuery databaseQuery = super.getQuery(string, vector);
        if (this.isClientSessionBroker() && databaseQuery == null) {
            String string22 = null;
            AbstractSession abstractSession = null;
            for (String string22 : this.getSessionsByName().keySet()) {
                abstractSession = this.getSessionForName(string22);
                if (!(abstractSession instanceof ClientSession) || (databaseQuery = ((ClientSession)abstractSession).getParent().getBroker().getQuery(string, vector)) == null) continue;
                return databaseQuery;
            }
        }
        return databaseQuery;
    }

    public AbstractSession getSessionForClass(Class clazz) throws ValidationException {
        if (clazz == null) {
            return this;
        }
        String string = (String)this.getSessionNamesByClass().get(clazz);
        if (string == null) {
            throw ValidationException.noSessionRegisteredForClass(clazz);
        }
        return (AbstractSession)this.getSessionsByName().get(string);
    }

    public AbstractSession getSessionForName(String string) throws ValidationException {
        AbstractSession abstractSession = (AbstractSession)this.getSessionsByName().get(string);
        if (abstractSession == null) {
            throw ValidationException.noSessionRegisteredForName(string);
        }
        return abstractSession;
    }

    protected AbstractSession getSessionForQuery(DatabaseQuery databaseQuery) {
        Class clazz;
        if (databaseQuery.hasSessionName()) {
            return this.getSessionForName(databaseQuery.getSessionName());
        }
        if (databaseQuery.getDescriptor() != null) {
            clazz = databaseQuery.getDescriptor().getJavaClass();
        } else {
            clazz = databaseQuery.getReferenceClass();
            if (clazz == null) {
                throw QueryException.unnamedQueryOnSessionBroker(databaseQuery);
            }
        }
        return this.getSessionForClass(clazz);
    }

    protected Map getSessionNamesByClass() {
        return this.sessionNamesByClass;
    }

    public Map getSessionsByName() {
        return this.sessionsByName;
    }

    public void initializeDescriptors() {
        if (!this.isClientSessionBroker()) {
            for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
                databaseSessionImpl.initializeSequencing();
            }
            if (this.hasExternalTransactionController()) {
                this.getExternalTransactionController().initializeSequencingListeners();
            }
        }
        super.initializeDescriptors();
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            if (databaseSessionImpl.getProject().hasGenericHistorySupport()) {
                this.getProject().setHasGenericHistorySupport(true);
            }
            if (!databaseSessionImpl.getProject().hasIsolatedClasses()) continue;
            this.getProject().setHasIsolatedClasses(true);
        }
        if (this.isServerSessionBroker()) {
            this.sequencing = null;
        }
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new SessionBrokerIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public Object internalExecuteQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord) throws DatabaseException, QueryException {
        AbstractSession abstractSession = this.getSessionForQuery(databaseQuery);
        return abstractSession.internalExecuteQuery(databaseQuery, abstractRecord);
    }

    public boolean isBroker() {
        return true;
    }

    public boolean isClientSessionBroker() {
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            if (!abstractSession.isClientSession()) continue;
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        if (this.getSessionsByName() == null || this.getSessionsByName().isEmpty()) {
            return false;
        }
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            if (abstractSession.isConnected()) continue;
            return false;
        }
        return true;
    }

    public boolean isServerSessionBroker() {
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            if (!abstractSession.isServerSession()) continue;
            return true;
        }
        return false;
    }

    public boolean isSessionBroker() {
        return true;
    }

    public void login() throws DatabaseException {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.getEventManager().preLogin(this);
        if (!this.isConnected()) {
            this.getServerPlatform().initializeExternalTransactionController();
        }
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            databaseSessionImpl.getEventManager().preLogin(databaseSessionImpl);
            if (databaseSessionImpl.isConnected()) continue;
            databaseSessionImpl.connect();
        }
        this.initializeDescriptors();
        if (this.getCommandManager() != null) {
            this.getCommandManager().initialize();
        }
        this.isLoggedIn = true;
    }

    public void login(String string, String string2) throws DatabaseException {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.getEventManager().preLogin(this);
        if (!this.isConnected()) {
            this.getServerPlatform().initializeExternalTransactionController();
        }
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            databaseSessionImpl.getEventManager().preLogin(databaseSessionImpl);
            databaseSessionImpl.getDatasourceLogin().setUserName(string);
            databaseSessionImpl.getDatasourceLogin().setPassword(string2);
            if (databaseSessionImpl.isConnected()) continue;
            databaseSessionImpl.connect();
        }
        this.initializeDescriptors();
        this.isLoggedIn = true;
    }

    public void logout() throws DatabaseException {
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            databaseSessionImpl.logout();
        }
        if (!this.isClientSessionBroker() && this.hasExternalTransactionController()) {
            this.getExternalTransactionController().clearSequencingListeners();
        }
        this.sequencing = null;
        this.isLoggedIn = false;
    }

    public void registerSession(String string, AbstractSession abstractSession) {
        abstractSession.setIsInBroker(true);
        this.getSessionsByName().put(string, abstractSession);
        abstractSession.setBroker(this);
        abstractSession.setName(string);
        Iterator iterator = abstractSession.getDescriptors().values().iterator();
        Iterator iterator2 = abstractSession.getDescriptors().keySet().iterator();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)iterator.next();
            Class clazz = (Class)iterator2.next();
            this.getSessionNamesByClass().put(clazz, string);
            this.getDescriptors().put(clazz, classDescriptor);
        }
    }

    public void registerSession(String string, Session session) {
        this.registerSession(string, (AbstractSession)session);
    }

    public void internalRegisterSession(String string, AbstractSession abstractSession) {
        abstractSession.setIsInBroker(true);
        this.getSessionsByName().put(string, abstractSession);
        abstractSession.setBroker(this);
        abstractSession.setName(string);
    }

    public void release() {
        if (this.isClientSessionBroker()) {
            this.log(2, "connection", "releasing_client_session_broker");
        }
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            abstractSession.release();
        }
        super.release();
    }

    public void setIntegrityChecker(IntegrityChecker integrityChecker) {
        super.setIntegrityChecker(integrityChecker);
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            abstractSession.setIntegrityChecker(integrityChecker);
        }
    }

    public void setSessionLog(SessionLog sessionLog) {
        super.setSessionLog(sessionLog);
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            abstractSession.setSessionLog(sessionLog);
        }
    }

    public void setLog(Writer writer) {
        super.setLog(writer);
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            abstractSession.setLog(writer);
        }
    }

    public void setProfiler(SessionProfiler sessionProfiler) {
        super.setProfiler(sessionProfiler);
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            abstractSession.setProfiler(sessionProfiler);
        }
    }

    protected void setSessionNameByClass(HashMap hashMap) {
        this.sessionNamesByClass = hashMap;
    }

    public void setSessionsByName(Map map) {
        this.sessionsByName = map;
    }

    public void setSynchronized(boolean bl) {
        if (!this.isServerSessionBroker()) {
            super.setSynchronized(bl);
            Iterator iterator = this.getSessionsByName().values().iterator();
            while (iterator.hasNext()) {
                ((AbstractSession)iterator.next()).setSynchronized(bl);
            }
        }
    }

    public void writesCompleted() {
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            if (abstractSession.isConnected()) continue;
            throw DatabaseException.databaseAccessorNotConnected();
        }
        for (AbstractSession abstractSession : this.getSessionsByName().values()) {
            abstractSession.writesCompleted();
        }
    }

    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    protected SequencingHome getSequencingHome() {
        return null;
    }

    public Sequencing getSequencing() {
        return this.sequencing;
    }

    public int howManySequencingCallbacks() {
        if (this.isClientSessionBroker()) {
            return this.getParent().howManySequencingCallbacks();
        }
        int n = 0;
        Iterator iterator = this.getSessionsByName().values().iterator();
        while (iterator.hasNext()) {
            if (!((DatabaseSessionImpl)iterator.next()).isSequencingCallbackRequired()) continue;
            ++n;
        }
        return n;
    }

    public boolean isSequencingCallbackRequired() {
        return this.howManySequencingCallbacks() > 0;
    }
}

