/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.codegen.ClassDefinition;
import org.eclipse.persistence.internal.codegen.CodeGenerator;
import org.eclipse.persistence.internal.codegen.NonreflectiveMethodDefinition;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sequencing.TableSequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.tools.schemaframework.FieldDefinition;
import org.eclipse.persistence.tools.schemaframework.ForeignKeyConstraint;
import org.eclipse.persistence.tools.schemaframework.TableCreator;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class TableCreatorClassGenerator {
    protected String className = "TableCreator";
    protected String packageName = "";
    protected String outputPath = "";
    protected String outputFileName = "TableCreator.java";
    protected Writer outputWriter;
    protected TableCreator tableCreator;

    public TableCreatorClassGenerator() {
    }

    public TableCreatorClassGenerator(TableCreator tableCreator) {
        this();
        this.tableCreator = tableCreator;
    }

    public TableCreatorClassGenerator(TableCreator tableCreator, String string, Writer writer) {
        this(tableCreator);
        this.outputWriter = writer;
        this.setClassName(string);
    }

    public TableCreatorClassGenerator(TableCreator tableCreator, String string, String string2) {
        this(tableCreator);
        this.setClassName(string);
        this.setOutputFileName(string2);
    }

    protected void addFieldLines(FieldDefinition fieldDefinition, NonreflectiveMethodDefinition nonreflectiveMethodDefinition) {
        String string = "field" + fieldDefinition.getName();
        nonreflectiveMethodDefinition.addLine("FieldDefinition " + string + " = new FieldDefinition();");
        nonreflectiveMethodDefinition.addLine(string + ".setName(\"" + fieldDefinition.getName() + "\");");
        String string2 = fieldDefinition.getTypeName();
        if (string2 != null) {
            nonreflectiveMethodDefinition.addLine(string + ".setTypeName(\"" + fieldDefinition.getTypeName() + "\");");
        } else {
            nonreflectiveMethodDefinition.addLine(string + ".setType(" + fieldDefinition.getType().getName() + ".class);");
        }
        nonreflectiveMethodDefinition.addLine(string + ".setSize(" + fieldDefinition.getSize() + ");");
        nonreflectiveMethodDefinition.addLine(string + ".setSubSize(" + fieldDefinition.getSubSize() + ");");
        nonreflectiveMethodDefinition.addLine(string + ".setIsPrimaryKey(" + fieldDefinition.isPrimaryKey() + ");");
        nonreflectiveMethodDefinition.addLine(string + ".setIsIdentity(" + fieldDefinition.isIdentity() + ");");
        nonreflectiveMethodDefinition.addLine(string + ".setUnique(" + fieldDefinition.isUnique() + ");");
        nonreflectiveMethodDefinition.addLine(string + ".setShouldAllowNull(" + fieldDefinition.shouldAllowNull() + ");");
        nonreflectiveMethodDefinition.addLine("table.addField(" + string + ");");
    }

    protected void addForeignKeyLines(ForeignKeyConstraint foreignKeyConstraint, NonreflectiveMethodDefinition nonreflectiveMethodDefinition) {
        String string = "foreignKey" + foreignKeyConstraint.getName();
        nonreflectiveMethodDefinition.addLine("ForeignKeyConstraint " + string + " = new ForeignKeyConstraint();");
        nonreflectiveMethodDefinition.addLine(string + ".setName(\"" + foreignKeyConstraint.getName() + "\");");
        nonreflectiveMethodDefinition.addLine(string + ".setTargetTable(\"" + foreignKeyConstraint.getTargetTable() + "\");");
        Enumeration enumeration = foreignKeyConstraint.getSourceFields().elements();
        while (enumeration.hasMoreElements()) {
            nonreflectiveMethodDefinition.addLine(string + ".addSourceField(\"" + enumeration.nextElement() + "\");");
        }
        enumeration = foreignKeyConstraint.getTargetFields().elements();
        while (enumeration.hasMoreElements()) {
            nonreflectiveMethodDefinition.addLine(string + ".addTargetField(\"" + enumeration.nextElement() + "\");");
        }
        nonreflectiveMethodDefinition.addLine("table.addForeignKeyConstraint(" + string + ");");
    }

    protected NonreflectiveMethodDefinition buildConstructor() {
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName(this.getClassName());
        nonreflectiveMethodDefinition.setIsConstructor(true);
        nonreflectiveMethodDefinition.addLine("setName(\"" + this.getTableCreator().getName() + "\");");
        nonreflectiveMethodDefinition.addLine("");
        Enumeration enumeration = this.getTableCreator().getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            TableDefinition tableDefinition = (TableDefinition)enumeration.nextElement();
            nonreflectiveMethodDefinition.addLine("addTableDefinition(build" + tableDefinition.getName() + "Table());");
        }
        return nonreflectiveMethodDefinition;
    }

    protected NonreflectiveMethodDefinition buildLoginMethod(DatabaseLogin databaseLogin) {
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName("applyLogin");
        String string = databaseLogin.getClass().getName();
        if (databaseLogin.getClass().equals(DatabaseLogin.class)) {
            string = Helper.getShortClassName(databaseLogin);
        }
        nonreflectiveMethodDefinition.addLine(string + " login = new " + string + "();");
        nonreflectiveMethodDefinition.addLine("login.usePlatform(new " + databaseLogin.getPlatformClassName() + "());");
        nonreflectiveMethodDefinition.addLine("login.setDriverClass(" + databaseLogin.getDriverClassName() + ".class);");
        nonreflectiveMethodDefinition.addLine("login.setConnectionString(\"" + databaseLogin.getConnectionString() + "\");");
        if (databaseLogin.getUserName() != null) {
            nonreflectiveMethodDefinition.addLine("login.setUserName(\"" + databaseLogin.getUserName() + "\");");
        }
        if (databaseLogin.getPassword() != null) {
            nonreflectiveMethodDefinition.addLine("login.setPassword(\"" + databaseLogin.getPassword() + "\");");
        }
        nonreflectiveMethodDefinition.addLine("");
        nonreflectiveMethodDefinition.addLine("// Configuration properties.");
        nonreflectiveMethodDefinition.addLine("login.setUsesNativeSequencing(" + databaseLogin.shouldUseNativeSequencing() + ");");
        if (!databaseLogin.shouldUseNativeSequencing()) {
            nonreflectiveMethodDefinition.addLine("login.setSequenceTableName(\"" + ((TableSequence)databaseLogin.getDefaultSequence()).getTableName() + "\");");
            nonreflectiveMethodDefinition.addLine("login.setSequenceNameFieldName(\"" + ((TableSequence)databaseLogin.getDefaultSequence()).getNameFieldName() + "\");");
            nonreflectiveMethodDefinition.addLine("login.setSequenceCounterFieldName(\"" + ((TableSequence)databaseLogin.getDefaultSequence()).getCounterFieldName() + "\");");
        }
        nonreflectiveMethodDefinition.addLine("login.setShouldBindAllParameters(" + databaseLogin.shouldBindAllParameters() + ");");
        nonreflectiveMethodDefinition.addLine("login.setShouldCacheAllStatements(" + databaseLogin.shouldCacheAllStatements() + ");");
        nonreflectiveMethodDefinition.addLine("login.setUsesByteArrayBinding(" + databaseLogin.shouldUseByteArrayBinding() + ");");
        nonreflectiveMethodDefinition.addLine("login.setUsesStringBinding(" + databaseLogin.shouldUseStringBinding() + ");");
        nonreflectiveMethodDefinition.addLine("if (login.shouldUseByteArrayBinding()) { // Can only be used with binding.");
        nonreflectiveMethodDefinition.addLine("\tlogin.setUsesStreamsForBinding(" + databaseLogin.shouldUseStreamsForBinding() + ");");
        nonreflectiveMethodDefinition.addLine("}");
        nonreflectiveMethodDefinition.addLine("login.setShouldForceFieldNamesToUpperCase(" + databaseLogin.shouldForceFieldNamesToUpperCase() + ");");
        nonreflectiveMethodDefinition.addLine("login.setShouldOptimizeDataConversion(" + databaseLogin.shouldOptimizeDataConversion() + ");");
        nonreflectiveMethodDefinition.addLine("login.setShouldTrimStrings(" + databaseLogin.shouldTrimStrings() + ");");
        nonreflectiveMethodDefinition.addLine("login.setUsesBatchWriting(" + databaseLogin.shouldUseBatchWriting() + ");");
        nonreflectiveMethodDefinition.addLine("if (login.shouldUseBatchWriting()) { // Can only be used with batch writing.");
        nonreflectiveMethodDefinition.addLine("\tlogin.setUsesJDBCBatchWriting(" + databaseLogin.shouldUseJDBCBatchWriting() + ");");
        nonreflectiveMethodDefinition.addLine("}");
        nonreflectiveMethodDefinition.addLine("login.setUsesExternalConnectionPooling(" + databaseLogin.shouldUseExternalConnectionPooling() + ");");
        nonreflectiveMethodDefinition.addLine("login.setUsesExternalTransactionController(" + databaseLogin.shouldUseExternalTransactionController() + ");");
        nonreflectiveMethodDefinition.addLine("setLogin(login);");
        return nonreflectiveMethodDefinition;
    }

    protected NonreflectiveMethodDefinition buildTableMethod(TableDefinition tableDefinition) {
        Serializable serializable;
        NonreflectiveMethodDefinition nonreflectiveMethodDefinition = new NonreflectiveMethodDefinition();
        nonreflectiveMethodDefinition.setName("build" + tableDefinition.getName() + "Table");
        nonreflectiveMethodDefinition.setReturnType("TableDefinition");
        nonreflectiveMethodDefinition.addLine("TableDefinition table = new TableDefinition();");
        nonreflectiveMethodDefinition.addLine("table.setName(\"" + tableDefinition.getName() + "\");");
        Enumeration<Object> enumeration = tableDefinition.getFields().elements();
        while (enumeration.hasMoreElements()) {
            nonreflectiveMethodDefinition.addLine("");
            serializable = (FieldDefinition)enumeration.nextElement();
            this.addFieldLines((FieldDefinition)serializable, nonreflectiveMethodDefinition);
        }
        enumeration = tableDefinition.getForeignKeys().elements();
        while (enumeration.hasMoreElements()) {
            nonreflectiveMethodDefinition.addLine("");
            serializable = (ForeignKeyConstraint)enumeration.nextElement();
            this.addForeignKeyLines((ForeignKeyConstraint)serializable, nonreflectiveMethodDefinition);
        }
        nonreflectiveMethodDefinition.addLine("");
        nonreflectiveMethodDefinition.addLine("return table;");
        return nonreflectiveMethodDefinition;
    }

    public void generate(boolean bl) throws ValidationException {
        if (this.getOutputWriter() == null) {
            try {
                this.setOutputWriter(new OutputStreamWriter(new FileOutputStream(this.getOutputPath() + this.getOutputFileName())));
            }
            catch (IOException iOException) {
                throw ValidationException.fileError(iOException);
            }
        }
        CodeGenerator codeGenerator = new CodeGenerator(bl);
        codeGenerator.setOutput(this.getOutputWriter());
        this.generateCreatorClass().write(codeGenerator);
        try {
            this.getOutputWriter().flush();
            this.getOutputWriter().close();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    public void generate() throws ValidationException {
        this.generate(true);
    }

    protected ClassDefinition generateCreatorClass() {
        ClassDefinition classDefinition = new ClassDefinition();
        classDefinition.setName(this.getClassName());
        classDefinition.setSuperClass("org.eclipse.persistence.tools.schemaframework.TableCreator");
        classDefinition.setPackageName(this.getPackageName());
        classDefinition.addImport("org.eclipse.persistence.sessions.*");
        classDefinition.addImport("org.eclipse.persistence.tools.schemaframework.*");
        classDefinition.setComment("This class was generated by the TopLink table creator generator." + Helper.cr() + "It stores the meta-data (tables) that define the database schema." + Helper.cr() + "@see org.eclipse.persistence.sessions.factories.TableCreatorClassGenerator");
        classDefinition.addMethod(this.buildConstructor());
        Enumeration enumeration = this.getTableCreator().getTableDefinitions().elements();
        while (enumeration.hasMoreElements()) {
            TableDefinition tableDefinition = (TableDefinition)enumeration.nextElement();
            classDefinition.addMethod(this.buildTableMethod(tableDefinition));
        }
        return classDefinition;
    }

    public String getClassName() {
        return this.className;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public Writer getOutputWriter() {
        return this.outputWriter;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public TableCreator getTableCreator() {
        return this.tableCreator;
    }

    protected String printString(Object object) {
        if (object == null || object == Helper.getNullWrapper()) {
            return "null";
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        return "new " + Helper.getShortClassName(object) + "(" + object + ")";
    }

    protected String removeDots(String string) {
        StringWriter stringWriter = new StringWriter();
        int n = 0;
        int n2 = string.indexOf(46, n);
        while (n2 >= 0) {
            stringWriter.write(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(46, n);
        }
        stringWriter.write(string.substring(n, string.length()));
        return stringWriter.toString();
    }

    public void setClassName(String string) {
        int n = string.lastIndexOf(".");
        if (n >= 0) {
            this.className = string.substring(n + 1, string.length());
            this.setPackageName(string.substring(0, n));
        } else {
            this.className = string;
        }
        this.setOutputFileName(string);
    }

    public void setOutputFileName(String string) {
        this.outputFileName = string.indexOf(".java") < 0 ? string + ".java" : string;
    }

    public void setOutputPath(String string) {
        this.outputPath = string;
    }

    public void setOutputWriter(Writer writer) {
        this.outputWriter = writer;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public void setTableCreator(TableCreator tableCreator) {
        this.tableCreator = tableCreator;
    }

    public static void write(TableCreator tableCreator, String string, Writer writer) {
        TableCreatorClassGenerator tableCreatorClassGenerator = new TableCreatorClassGenerator(tableCreator, string, writer);
        tableCreatorClassGenerator.generate();
    }

    public static void write(TableCreator tableCreator, String string, String string2) {
        TableCreatorClassGenerator tableCreatorClassGenerator = new TableCreatorClassGenerator(tableCreator, string, string2);
        tableCreatorClassGenerator.generate();
    }
}

