/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.remote;

import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DistributedSessionIdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.internal.sessions.remote.RemoteCursoredStream;
import org.eclipse.persistence.internal.sessions.remote.RemoteScrollableCursor;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.Project;

public abstract class DistributedSession
extends AbstractSession {
    protected transient RemoteConnection remoteConnection;

    protected DistributedSession(int n) {
    }

    public DistributedSession(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
        this.project = new Project();
    }

    public abstract UnitOfWorkImpl acquireUnitOfWork();

    public void beginTransaction() {
        this.getTransactionMutex().acquire();
        this.getRemoteConnection().beginTransaction();
    }

    public void commitTransaction() {
        this.getRemoteConnection().commitTransaction();
        this.getTransactionMutex().release();
    }

    public RemoteCursoredStream cursorSelectObjects(CursoredStreamPolicy cursoredStreamPolicy) {
        return this.getRemoteConnection().cursorSelectObjects(cursoredStreamPolicy, this);
    }

    public RemoteScrollableCursor cursorSelectObjects(ScrollableCursorPolicy scrollableCursorPolicy) {
        return this.getRemoteConnection().cursorSelectObjects(scrollableCursorPolicy, this);
    }

    public Object executeQuery(String string) throws DatabaseException {
        return this.executeQuery(string, new Vector(1));
    }

    public Object executeQuery(String string, Class clazz) throws DatabaseException {
        return this.executeQuery(string, clazz, new Vector(1));
    }

    public Object executeQuery(String string, Class clazz, Vector vector) throws DatabaseException {
        Transporter transporter = this.getRemoteConnection().remoteExecuteNamedQuery(string, clazz, vector);
        transporter.getQuery().setSession(this);
        return transporter.getQuery().extractRemoteResult(transporter);
    }

    public Object executeQuery(String string, Vector vector) throws DatabaseException {
        if (this.containsQuery(string)) {
            return super.executeQuery(string, vector);
        }
        return this.executeQuery(string, null, vector);
    }

    public abstract Object executeQuery(DatabaseQuery var1);

    public Object executeQuery(DatabaseQuery databaseQuery, AbstractRecord abstractRecord) {
        databaseQuery.setTranslationRow(abstractRecord);
        return this.executeQuery(databaseQuery);
    }

    public Vector getDefaultReadOnlyClasses() {
        Vector vector = this.getRemoteConnection().getDefaultReadOnlyClasses();
        return vector;
    }

    public ClassDescriptor getDescriptor(Class clazz) {
        ClassDescriptor classDescriptor = (ClassDescriptor)this.getDescriptors().get(clazz);
        if (classDescriptor == null) {
            classDescriptor = this.getRemoteConnection().getDescriptor(clazz);
            if (classDescriptor == null) {
                return null;
            }
            this.getDescriptors().put(clazz, classDescriptor);
            classDescriptor.remoteInitialization(this);
        }
        return classDescriptor;
    }

    public ClassDescriptor getDescriptorCorrespondingTo(ClassDescriptor classDescriptor) {
        return (ClassDescriptor)this.getDescriptors().get(classDescriptor.getJavaClass());
    }

    public abstract Object getObjectCorrespondingTo(Object var1, Map var2, Map var3, ObjectLevelReadQuery var4);

    public abstract Object getObjectsCorrespondingToAll(Object var1, Map var2, Map var3, ObjectLevelReadQuery var4, ContainerPolicy var5);

    public RemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public boolean hasCorrespondingDescriptor(ClassDescriptor classDescriptor) {
        return this.getDescriptors().containsKey(classDescriptor.getJavaClass());
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new DistributedSessionIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public abstract Object instantiateRemoteValueHolderOnServer(RemoteValueHolder var1);

    public boolean isConnected() {
        return this.getRemoteConnection() != null;
    }

    public boolean isDistributedSession() {
        return true;
    }

    public boolean isRemoteSession() {
        return false;
    }

    public void privilegedAddDescriptor(ClassDescriptor classDescriptor) {
        this.getDescriptors().put(classDescriptor.getJavaClass(), classDescriptor);
    }

    public void rollbackTransaction() {
        this.getRemoteConnection().rollbackTransaction();
        this.getTransactionMutex().release();
    }

    protected void setRemoteConnection(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "()";
    }

    public void release() {
        this.remoteConnection.release();
    }
}

