/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.transaction;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.exceptions.TransactionException;
import org.eclipse.persistence.internal.sequencing.SequencingCallback;
import org.eclipse.persistence.internal.sequencing.SequencingCallbackFactory;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.logging.SessionLogEntry;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.broker.SessionBroker;
import org.eclipse.persistence.transaction.AbstractTransactionController;

public abstract class AbstractSynchronizationListener {
    protected AbstractTransactionController controller;
    protected AbstractSession session;
    protected UnitOfWorkImpl unitOfWork;
    protected Object transaction;
    protected Object transactionKey;
    protected SequencingCallback sequencingCallback;
    protected Map<DatabaseSession, SequencingCallback> sequencingCallbackMap;

    public AbstractSynchronizationListener() {
    }

    protected AbstractSynchronizationListener(UnitOfWorkImpl unitOfWorkImpl, AbstractSession abstractSession, Object object, AbstractTransactionController abstractTransactionController) {
        this.session = abstractSession;
        this.unitOfWork = unitOfWorkImpl;
        this.transaction = object;
        this.controller = abstractTransactionController;
        this.transactionKey = abstractTransactionController.getTransactionKey(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCompletion() {
        UnitOfWorkImpl unitOfWorkImpl = this.getUnitOfWork();
        if (this.unitOfWork == null) {
            return;
        }
        try {
            Object object = this.getTransactionController().getTransactionStatus();
            this.getTransactionController().logTxStateTrace(unitOfWorkImpl, "TX_beforeCompletion", object);
            this.session.startOperationProfile("TXBeforeCompletion");
            this.getSession().setWasJTSTransactionInternallyStarted(false);
            if (!unitOfWorkImpl.isActive()) {
                throw TransactionException.inactiveUnitOfWork(unitOfWorkImpl);
            }
            if (!this.getTransactionController().canIssueSQLToDatabase_impl(object)) {
                if (this.getSession().isInTransaction()) {
                    this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
                    if (this.getUnitOfWork().wasTransactionBegunPrematurely()) {
                        this.getUnitOfWork().setWasTransactionBegunPrematurely(false);
                    }
                    this.getSession().rollbackTransaction();
                }
                this.getSession().releaseJTSConnection();
                return;
            }
            if (this.getSession().isInTransaction()) {
                this.getSession().getTransactionMutex().setActiveThread(Thread.currentThread());
            }
            if (this.getTransactionController().isSequencingCallbackRequired()) {
                this.getTransactionController().currentlyProcessedListeners.put(this.getTransactionKey(), this);
            }
            unitOfWorkImpl.issueSQLbeforeCompletion();
            unitOfWorkImpl.setPendingMerge();
        }
        catch (RuntimeException runtimeException) {
            unitOfWorkImpl.log(new SessionLogEntry(unitOfWorkImpl, 6, "transaction", runtimeException));
            this.handleException(runtimeException);
        }
        finally {
            if (this.getTransactionController().isSequencingCallbackRequired()) {
                this.getTransactionController().currentlyProcessedListeners.remove(this.getTransactionKey());
            }
            this.getSession().releaseJTSConnection();
            this.session.endOperationProfile("TXBeforeCompletion");
        }
    }

    public void afterCompletion(Object object) {
        UnitOfWorkImpl unitOfWorkImpl = this.getUnitOfWork();
        if (unitOfWorkImpl == null) {
            if (this.getTransactionController().isSequencingCallbackRequired() && this.getTransactionController().canMergeUnitOfWork_impl(object)) {
                this.callSequencingCallback();
            }
        } else {
            try {
                this.getTransactionController().logTxStateTrace(unitOfWorkImpl, "TX_afterCompletion", object);
                this.session.startOperationProfile("TXAfterCompletion");
                if (!unitOfWorkImpl.isActive()) {
                    throw TransactionException.inactiveUnitOfWork(unitOfWorkImpl);
                }
                if (this.getTransactionController().canMergeUnitOfWork_impl(object)) {
                    if (this.getTransactionController().isSequencingCallbackRequired()) {
                        this.callSequencingCallback();
                    }
                    if (unitOfWorkImpl.isMergePending()) {
                        unitOfWorkImpl.mergeClonesAfterCompletion();
                    }
                } else {
                    this.getSession().releaseJTSConnection();
                    unitOfWorkImpl.afterExternalTransactionRollback();
                }
            }
            catch (RuntimeException runtimeException) {
                unitOfWorkImpl.log(new SessionLogEntry(unitOfWorkImpl, 6, "transaction", runtimeException));
                throw runtimeException;
            }
            finally {
                this.session.endOperationProfile("TXAfterCompletion");
            }
            if (unitOfWorkImpl.shouldResumeUnitOfWorkOnTransactionCompletion() && this.getTransactionController().canMergeUnitOfWork_impl(object)) {
                unitOfWorkImpl.synchronizeAndResume();
                unitOfWorkImpl.setSynchronized(false);
            } else {
                unitOfWorkImpl.release();
                if (this.getSession().isClientSession() || this.getSession().isSessionBroker() && ((SessionBroker)this.getSession()).isClientSessionBroker()) {
                    this.getSession().release();
                }
            }
            this.getTransactionController().removeUnitOfWork(this.getTransactionKey());
            this.setUnitOfWork(null);
            this.setSession(null);
        }
        if (this.getTransactionController().isSequencingCallbackRequired()) {
            this.getTransactionController().removeSequencingListener(this.getTransactionKey());
            this.sequencingCallback = null;
            this.sequencingCallbackMap = null;
        }
        this.setTransaction(null);
        this.setTransactionKey(null);
    }

    public void handleException(RuntimeException runtimeException) {
        throw runtimeException;
    }

    protected AbstractTransactionController getTransactionController() {
        return this.controller;
    }

    protected void setTransactionController(AbstractTransactionController abstractTransactionController) {
        this.controller = abstractTransactionController;
    }

    protected Object getTransaction() {
        return this.transaction;
    }

    protected void setTransaction(Object object) {
        this.transaction = object;
    }

    protected Object getTransactionKey() {
        return this.transactionKey;
    }

    protected void setTransactionKey(Object object) {
        this.transactionKey = object;
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    protected void setSession(AbstractSession abstractSession) {
        this.session = abstractSession;
    }

    protected UnitOfWorkImpl getUnitOfWork() {
        return this.unitOfWork;
    }

    protected void setUnitOfWork(UnitOfWorkImpl unitOfWorkImpl) {
        this.unitOfWork = unitOfWorkImpl;
    }

    protected void callSequencingCallback() {
        if (this.sequencingCallback != null) {
            this.sequencingCallback.afterCommit(null);
        } else if (this.sequencingCallbackMap != null) {
            Iterator<SequencingCallback> iterator = this.sequencingCallbackMap.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().afterCommit(null);
            }
        }
    }

    public SequencingCallback getSequencingCallback(DatabaseSession databaseSession, SequencingCallbackFactory sequencingCallbackFactory) {
        if (this.getTransactionController().numSessionsRequiringSequencingCallback() == 1) {
            if (this.sequencingCallback == null) {
                this.sequencingCallback = sequencingCallbackFactory.createSequencingCallback();
            }
            return this.sequencingCallback;
        }
        if (this.getTransactionController().numSessionsRequiringSequencingCallback() > 1) {
            SequencingCallback sequencingCallback = null;
            if (this.sequencingCallbackMap == null) {
                this.sequencingCallbackMap = new HashMap<DatabaseSession, SequencingCallback>(this.getTransactionController().numSessionsRequiringSequencingCallback());
            } else {
                sequencingCallback = this.sequencingCallbackMap.get(databaseSession);
            }
            if (sequencingCallback == null) {
                sequencingCallback = sequencingCallbackFactory.createSequencingCallback();
                this.sequencingCallbackMap.put(databaseSession, sequencingCallback);
            }
            return sequencingCallback;
        }
        return null;
    }
}

