/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypeAttrs;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;

public class FieldInfo {
    public String fieldName;
    public String fieldTypeName;
    public String fieldTypeSubname;
    public String fieldTypeOwner;
    public String fieldTypeMod;
    public String fieldMethodName;
    public String fieldMethodNo;
    public String fieldPackageName;
    public String fieldCharacterSetName;
    public int fieldSequence;
    public int fieldDataLevel;
    public int fieldDataLength;
    public int fieldDataPrecision;
    public int fieldDataScale;
    public int fieldNo;

    public FieldInfo(AllTypeAttrs allTypeAttrs) throws SQLException {
        this.fieldName = allTypeAttrs.attrName;
        this.fieldTypeName = allTypeAttrs.attrTypeName;
        this.fieldTypeSubname = null;
        this.fieldTypeOwner = allTypeAttrs.attrTypeOwner;
        this.fieldTypeMod = allTypeAttrs.attrTypeMod;
        this.fieldMethodName = null;
        this.fieldMethodNo = null;
        this.fieldPackageName = null;
        this.fieldSequence = -1;
        this.fieldDataLevel = -1;
        this.fieldDataLength = allTypeAttrs.attrLength;
        this.fieldDataPrecision = allTypeAttrs.attrPrecision;
        this.fieldDataScale = allTypeAttrs.attrScale;
        this.fieldNo = allTypeAttrs.attrNo;
        this.fieldCharacterSetName = allTypeAttrs.characterSetName;
    }

    public FieldInfo(UserArguments userArguments) throws SQLException {
        this.fieldNo = userArguments.POSITION;
        this.fieldName = userArguments.ARGUMENT_NAME;
        this.fieldTypeOwner = userArguments.TYPE_OWNER;
        this.fieldTypeName = userArguments.TYPE_NAME;
        if (SqlReflector.isNull(this.fieldTypeName)) {
            this.fieldTypeName = userArguments.DATA_TYPE;
        }
        if ("PL/SQL BOOLEAN".equalsIgnoreCase(this.fieldTypeName)) {
            this.fieldTypeName = "BOOLEAN";
        }
        this.fieldTypeSubname = userArguments.TYPE_SUBNAME;
        this.fieldTypeMod = "";
        if ("REF".equalsIgnoreCase(userArguments.DATA_TYPE) || "PL/SQL RECORD".equalsIgnoreCase(userArguments.DATA_TYPE) || "PL/SQL TABLE".equalsIgnoreCase(userArguments.DATA_TYPE) || "VARRAY".equalsIgnoreCase(userArguments.DATA_TYPE) || "TABLE".equalsIgnoreCase(userArguments.DATA_TYPE)) {
            this.fieldTypeMod = userArguments.DATA_TYPE;
        }
        this.fieldPackageName = userArguments.PACKAGE_NAME;
        this.fieldMethodName = userArguments.OBJECT_NAME;
        this.fieldMethodNo = userArguments.OVERLOAD;
        this.fieldSequence = userArguments.sequence;
        this.fieldDataLevel = -1;
        this.fieldDataLength = "PL/SQL RECORD".equalsIgnoreCase(userArguments.DATA_TYPE) ? 0 : userArguments.DATA_LENGTH;
        this.fieldDataPrecision = userArguments.DATA_PRECISION;
        this.fieldDataScale = userArguments.DATA_SCALE;
        this.fieldCharacterSetName = userArguments.CHARACTER_SET_NAME;
    }

    public static FieldInfo[] getFieldInfo(Iterator iterator) throws SQLException {
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return FieldInfo.getFieldInfo(arrayList);
    }

    public static FieldInfo[] getFieldInfo(ArrayList arrayList) throws SQLException {
        ArrayList<FieldInfo> arrayList2 = new ArrayList<FieldInfo>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (e instanceof UserArguments) {
                arrayList2.add(new FieldInfo((UserArguments)e));
                continue;
            }
            arrayList2.add(new FieldInfo((AllTypeAttrs)e));
        }
        FieldInfo[] fieldInfoArray = new FieldInfo[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            fieldInfoArray[i] = (FieldInfo)arrayList2.get(i);
        }
        return fieldInfoArray;
    }
}

