/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypeMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;

public class MethodInfo {
    public String methodName;
    public String methodNo;
    public String methodType;
    public int parameters;
    public int results;

    public MethodInfo(UserArguments userArguments) throws SQLException {
        this.methodName = userArguments.OBJECT_NAME;
        this.methodNo = userArguments.OVERLOAD;
        this.methodType = "PUBLIC";
        this.parameters = userArguments.sequence == 0 ? 0 : userArguments.POSITION;
        if (this.parameters < 0) {
            this.parameters = 0;
        }
        this.results = 1 - userArguments.POSITION;
        if (this.results < 0) {
            this.results = 0;
        }
    }

    public MethodInfo(AllTypeMethods allTypeMethods) throws SQLException {
        this.methodName = allTypeMethods.methodName;
        this.methodNo = allTypeMethods.methodNo;
        this.methodType = allTypeMethods.methodType;
        this.parameters = allTypeMethods.parameters;
        this.results = allTypeMethods.results;
    }

    public static MethodInfo[] getMethodInfo(Iterator iterator) throws SQLException {
        Object object;
        Vector<MethodInfo> vector = new Vector<MethodInfo>();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof AllArguments) {
                vector.addElement(new MethodInfo((AllArguments)object));
                continue;
            }
            if (object instanceof UserArguments) {
                vector.addElement(new MethodInfo((UserArguments)object));
                continue;
            }
            vector.addElement(new MethodInfo((AllTypeMethods)object));
        }
        object = new MethodInfo[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object[i] = (MethodInfo)vector.elementAt(i);
        }
        return object;
    }

    public static MethodInfo[] groupBy(Iterator iterator) throws SQLException {
        MethodInfo[] methodInfoArray = MethodInfo.getMethodInfo(iterator);
        Hashtable<String, MethodInfo> hashtable = new Hashtable<String, MethodInfo>();
        for (int i = 0; i < methodInfoArray.length; ++i) {
            String string = methodInfoArray[i].methodName + "," + methodInfoArray[i].methodNo;
            MethodInfo methodInfo = (MethodInfo)hashtable.get(string);
            if (methodInfo == null) {
                hashtable.put(string, methodInfoArray[i]);
            }
            if (methodInfo != null && methodInfo.parameters < methodInfoArray[i].parameters) {
                methodInfo.parameters = methodInfoArray[i].parameters;
            }
            if (methodInfo == null || methodInfo.results >= methodInfoArray[i].results) continue;
            methodInfo.results = methodInfoArray[i].results;
        }
        methodInfoArray = new MethodInfo[hashtable.size()];
        Enumeration enumeration = hashtable.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            methodInfoArray[n++] = (MethodInfo)enumeration.nextElement();
        }
        return methodInfoArray;
    }
}

