/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllMethodResults;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;

public class ResultInfo {
    public String resultTypeName;
    public String resultTypeSubname;
    public boolean ncharFormOfUse;
    public String resultTypeOwner;
    public String resultTypeMod;
    public String methodName;
    public String methodNo;
    public int sequence;
    public int dataLength;
    public int dataPrecision;
    public int dataScale;

    public ResultInfo(AllMethodResults allMethodResults) throws SQLException {
        this.resultTypeMod = allMethodResults.resultTypeMod;
        this.resultTypeOwner = allMethodResults.resultTypeOwner;
        this.resultTypeName = allMethodResults.resultTypeName;
        if ("PL/SQL BINARY INTEGER".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "BINARY_INTEGER";
        } else if ("PL/SQL BOOLEAN".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "BOOLEAN";
        } else if ("PL/SQL PLS INTEGER".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "PLS_INTEGER";
        } else if ("PL/SQL LONG".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "LONG";
        } else if ("PL/SQL LONG RAW".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "LONG RAW";
        } else if ("PL/SQL RAWID".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "PL/SQL RAWID";
        } else if ("PL/SQL URAWID".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "PL/SQL URAWID";
        }
        this.resultTypeSubname = null;
        this.ncharFormOfUse = false;
        if ("NCHAR_CS".equals(allMethodResults.characterSetName)) {
            this.ncharFormOfUse = true;
        }
        this.methodName = allMethodResults.methodName;
        this.methodNo = allMethodResults.methodNo;
        this.sequence = -1;
        this.dataLength = 0;
        this.dataPrecision = 0;
        this.dataScale = 0;
    }

    public ResultInfo(UserArguments userArguments) throws SQLException {
        this.resultTypeMod = "";
        if ("REF".equalsIgnoreCase(userArguments.DATA_TYPE) || "PL/SQL RECORD".equalsIgnoreCase(userArguments.DATA_TYPE) || "PL/SQL TABLE".equalsIgnoreCase(userArguments.DATA_TYPE) || "VARRAY".equalsIgnoreCase(userArguments.DATA_TYPE) || "TABLE".equalsIgnoreCase(userArguments.DATA_TYPE)) {
            this.resultTypeMod = userArguments.DATA_TYPE;
        }
        this.resultTypeOwner = userArguments.TYPE_OWNER;
        if ("PUBLIC".equalsIgnoreCase(this.resultTypeOwner)) {
            this.resultTypeOwner = "SYS";
        }
        this.resultTypeName = userArguments.TYPE_NAME;
        if (SqlReflector.isNull(this.resultTypeName)) {
            this.resultTypeName = userArguments.PLS_TYPE;
        }
        if (SqlReflector.isNull(this.resultTypeName)) {
            this.resultTypeName = userArguments.DATA_TYPE;
        }
        if ("PL/SQL BOOLEAN".equalsIgnoreCase(this.resultTypeName)) {
            this.resultTypeName = "BOOLEAN";
        }
        this.resultTypeSubname = userArguments.TYPE_SUBNAME;
        this.ncharFormOfUse = false;
        if ("NCHAR_CS".equals(userArguments.CHARACTER_SET_NAME)) {
            this.ncharFormOfUse = true;
        }
        this.methodName = userArguments.OBJECT_NAME;
        this.methodNo = userArguments.OVERLOAD;
        this.sequence = userArguments.sequence;
        this.dataLength = userArguments.DATA_LENGTH;
        this.dataPrecision = userArguments.DATA_PRECISION;
        this.dataScale = userArguments.DATA_SCALE;
    }

    public static ResultInfo getResultInfo(Iterator iterator) throws SQLException {
        Object object;
        Vector<ResultInfo> vector = new Vector<ResultInfo>();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object instanceof UserArguments) {
                vector.addElement(new ResultInfo((UserArguments)object));
                continue;
            }
            vector.addElement(new ResultInfo((AllMethodResults)object));
        }
        object = new ResultInfo[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            object[i] = (ResultInfo)vector.elementAt(i);
        }
        if (((E)object).length == 0) {
            throw new SQLException("Exhausted ResultSet in ResultInfo");
        }
        return object[0];
    }
}

