/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.viewcache;

import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.MethodFilter;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.RowsCacheEntry;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.SingleColumnViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.UserArguments;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRow;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ViewRowFactory;

public class ViewCache
implements Externalizable {
    public static final String PARAMETER_USER = "USER";
    public static final String PARAMETER_ALL = "ALL";
    private Connection m_conn;
    private String m_user;
    private Hashtable m_rowsCacheIndex;
    private ArrayList m_rowsCache;
    private int m_hits;
    private int m_visits;
    private boolean m_viewCacheDebug = false;
    static final String VIEW_CACHE_PREFIX = "viewcachefor";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator getRows(String string, String[] stringArray, String[] stringArray2, Object[] objectArray, String[] stringArray3) throws SQLException {
        Object object;
        Object object2;
        ++this.m_visits;
        String string2 = this.makeKey(string, stringArray, stringArray2, objectArray, stringArray3);
        ArrayList<ViewRow> arrayList = (ArrayList<ViewRow>)this.m_rowsCacheIndex.get(string2);
        ArrayList<ViewRow> arrayList2 = arrayList;
        if (arrayList2 == null) {
            for (int i = 0; i < this.m_rowsCache.size(); ++i) {
                object2 = new RowsCacheEntry(string, stringArray, stringArray2, objectArray, null);
                object = (RowsCacheEntry)this.m_rowsCache.get(i);
                RowsCacheEntry rowsCacheEntry = ((RowsCacheEntry)object).compare((RowsCacheEntry)object2);
                if (rowsCacheEntry != null) {
                    if (this.m_viewCacheDebug) {
                        System.out.println("viewcache.hit.query.relaxed: " + i);
                    }
                    arrayList2 = new ArrayList<ViewRow>();
                    for (int j = 0; j < rowsCacheEntry.getRows().size(); ++j) {
                        ViewRow viewRow = (ViewRow)rowsCacheEntry.getRows().get(j);
                        boolean bl = true;
                        for (int k = 0; k < rowsCacheEntry.getKeys().length; ++k) {
                            if (k + 1 < rowsCacheEntry.getKeys().length && rowsCacheEntry.getKeys()[k].equals(rowsCacheEntry.getKeys()[k + 1])) {
                                if (viewRow.equals(rowsCacheEntry.getKeys()[k], rowsCacheEntry.getValues()[k]) || viewRow.equals(rowsCacheEntry.getKeys()[k], rowsCacheEntry.getValues()[k])) continue;
                                bl = false;
                                ++k;
                                continue;
                            }
                            if (viewRow.equals(rowsCacheEntry.getKeys()[k], rowsCacheEntry.getValues()[k])) continue;
                            bl = false;
                        }
                        if (!bl) continue;
                        arrayList2.add(viewRow);
                    }
                    break;
                }
                if (!this.m_viewCacheDebug) continue;
                System.out.println("viewcache.no.match.query: " + i + ", diff=" + rowsCacheEntry);
            }
        }
        if (arrayList == null && stringArray3.length == 1 && stringArray3[0].equalsIgnoreCase("SEQUENCE") && ViewRowFactory.hasSequence(string)) {
            if (arrayList2 == null) {
                String string3 = this.makeKey(string, stringArray, stringArray2, objectArray, new String[0]);
                arrayList2 = (ArrayList)this.m_rowsCacheIndex.get(string3);
            }
            if (arrayList2 != null) {
                arrayList = (ArrayList)arrayList2.clone();
                UserArguments.orderBySequence(arrayList);
                if (this.m_viewCacheDebug) {
                    System.out.println("viewcache.hit.query.unordered.sequence");
                }
            }
        } else if (arrayList == null && stringArray3.length == 1 && stringArray3[0].equalsIgnoreCase("POSITION") && ViewRowFactory.hasPosition(string)) {
            if (arrayList2 == null) {
                String string4 = this.makeKey(string, stringArray, stringArray2, objectArray, new String[0]);
                arrayList2 = (ArrayList)this.m_rowsCacheIndex.get(string4);
            }
            if (arrayList2 != null) {
                arrayList = (ArrayList<ViewRow>)arrayList2.clone();
                UserArguments.orderByPosition(arrayList);
                if (this.m_viewCacheDebug) {
                    System.out.println("viewcache.hit.query.unordered.position");
                }
            }
        }
        if (arrayList == null) {
            arrayList = arrayList2;
        }
        if (arrayList == null) {
            String string5 = this.makeQuery(string, stringArray, stringArray2, objectArray, stringArray3);
            object2 = null;
            object = null;
            if (this.m_conn == null) {
                throw new SQLException("ERROR: null JDBC connection.");
            }
            try {
                object = this.m_conn.prepareStatement(string5);
                long l = 0L;
                if (this.m_viewCacheDebug) {
                    l = System.currentTimeMillis();
                    System.out.println("viewcache.execute.query: " + string5);
                }
                object2 = object.executeQuery();
                arrayList = new ArrayList();
                while (object2.next()) {
                    arrayList.add(ViewRowFactory.createViewRow(string, stringArray, (ResultSet)object2));
                    if (!this.m_viewCacheDebug) continue;
                    System.out.print(".");
                }
                if (this.m_viewCacheDebug) {
                    System.out.println("\nviewcache.execute.query.result.set.next.elapse: " + (System.currentTimeMillis() - l));
                }
            }
            finally {
                if (object2 != null) {
                    object2.close();
                }
                if (object != null) {
                    object.close();
                }
            }
            this.m_rowsCacheIndex.put(string2, arrayList);
            this.m_rowsCache.add(new RowsCacheEntry(string, stringArray, stringArray2, objectArray, arrayList));
        } else {
            ++this.m_hits;
            if (this.m_viewCacheDebug) {
                String string6 = this.makeQuery(string, stringArray, stringArray2, objectArray, stringArray3);
                System.out.println("viewcache.hit.query: " + string6);
            }
        }
        if (arrayList == null) {
            arrayList = new ArrayList<ViewRow>();
        }
        if (this.m_viewCacheDebug) {
            System.out.println("viewcache.execute.query.result.size: " + arrayList.size());
            System.out.println("viewcache.hit.rate: " + string2 + ", " + this.m_hits + "/" + this.m_visits);
        }
        return arrayList.iterator();
    }

    public Object[] getOutParameters(String string, Object[] objectArray, int[] nArray) throws SQLException {
        Object object;
        ++this.m_visits;
        Object[] objectArray2 = this.toObject(nArray);
        String string2 = this.makeKey(string, new String[0], new String[0], objectArray, new String[0]);
        ArrayList<Object> arrayList = (ArrayList<Object>)this.m_rowsCacheIndex.get(string2);
        if (arrayList == null && this.m_conn != null) {
            int n;
            arrayList = new ArrayList<Object>();
            object = this.m_conn.prepareCall(string);
            for (n = 1; n < objectArray.length + 1; ++n) {
                if (!(objectArray[n - 1] instanceof byte[])) {
                    throw new SQLException("input type not supported: " + objectArray[n - 1].getClass().getName());
                }
                object.setBytes(n, (byte[])objectArray[n - 1]);
            }
            while (n < objectArray.length + nArray.length + 1) {
                object.registerOutParameter(n, nArray[n - objectArray.length - 1]);
                ++n;
            }
            object.executeUpdate();
            for (n = objectArray.length; n < objectArray.length + nArray.length; ++n) {
                int n2 = n - objectArray.length;
                if (nArray[n2] == 4) {
                    arrayList.add(new Integer(object.getInt(n + 1)));
                    continue;
                }
                if (nArray[n2] != 12) continue;
                arrayList.add(object.getString(n + 1));
            }
            object.close();
            this.m_rowsCacheIndex.put(string2, arrayList);
            this.m_rowsCache.add(new RowsCacheEntry(string, new String[0], new String[0], objectArray2, arrayList));
        }
        object = null;
        if (arrayList != null) {
            object = arrayList.toArray(new Object[0]);
        }
        return object;
    }

    private Object[] toObject(int[] nArray) {
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = new Integer(nArray[i]);
        }
        return objectArray;
    }

    private String makeKey(String string, String[] stringArray, String[] stringArray2, Object[] objectArray, String[] stringArray3) {
        int n;
        String string2 = string;
        if (stringArray.length != 0) {
            string2 = string2 + "[";
            for (n = 0; n < stringArray.length; ++n) {
                string2 = string2 + stringArray[n] + (n > 0 ? ", " : "");
            }
            string2 = string2 + "]";
        }
        string2 = string2 + "(";
        for (n = 0; n < stringArray2.length; ++n) {
            string2 = string2 + stringArray2[n] + ", ";
        }
        string2 = string2 + ": ";
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] instanceof byte[]) {
                byte[] byArray = (byte[])objectArray[n];
                for (int i = 0; i < byArray.length; ++i) {
                    string2 = string2 + byArray[i];
                }
                string2 = string2 + ", ";
                continue;
            }
            string2 = string2 + objectArray[n] + ", ";
        }
        string2 = string2 + ")";
        for (n = 0; n < stringArray3.length; ++n) {
            string2 = string2 + stringArray3[n] + "(o)";
        }
        return string2.toUpperCase();
    }

    private String makeQuery(String string, String[] stringArray, String[] stringArray2, Object[] objectArray, String[] stringArray3) {
        int n;
        String string2 = "SELECT " + ViewRowFactory.getProject(string, stringArray) + " FROM " + string;
        if (stringArray2.length > 0) {
            string2 = string2 + " WHERE ";
        }
        boolean bl = false;
        for (n = 0; n < stringArray2.length; ++n) {
            if (!bl && n < stringArray2.length - 1 && stringArray2[n].equals(stringArray2[n + 1])) {
                string2 = string2 + "(";
                bl = true;
            }
            string2 = string2 + stringArray2[n];
            string2 = objectArray[n] == null || "".equals(objectArray[n]) ? string2 + " IS NULL" : ("NOT NULL".equals(objectArray[n]) ? string2 + " IS NOT NULL" : (objectArray[n] instanceof String ? string2 + "='" + (String)objectArray[n] + "'" : (objectArray[n] instanceof String && ((String)objectArray[n]).indexOf("%") > -1 ? string2 + " like '" + (String)objectArray[n] + "'" : string2 + "=" + objectArray[n])));
            if (bl && n < stringArray2.length - 1 && stringArray2[n].equals(stringArray2[n + 1])) {
                string2 = string2 + " OR ";
                continue;
            }
            if (bl && n < stringArray2.length - 1) {
                string2 = string2 + ") AND ";
                bl = false;
                continue;
            }
            if (bl) {
                string2 = string2 + ")";
                bl = false;
                continue;
            }
            if (n >= stringArray2.length - 1) continue;
            string2 = string2 + " AND ";
        }
        for (n = 0; n < stringArray3.length; ++n) {
            if (n == 0) {
                string2 = string2 + " ORDER BY ";
            }
            string2 = string2 + stringArray3[n];
            if (n == stringArray3.length - 1) continue;
            string2 = string2 + ", ";
        }
        return string2;
    }

    public ViewCache() {
    }

    public ViewCache(Connection connection, String string) {
        this.m_conn = connection;
        this.m_user = string;
        this.m_rowsCacheIndex = new Hashtable();
        this.m_rowsCache = new ArrayList();
        this.m_hits = 0;
        this.m_visits = 0;
    }

    public void init(ViewCache viewCache) {
        int n = this.m_rowsCache.size();
        for (int i = 0; i < n; ++i) {
            RowsCacheEntry rowsCacheEntry = (RowsCacheEntry)this.m_rowsCache.get(i);
            try {
                this.getRows(rowsCacheEntry);
                continue;
            }
            catch (Exception exception) {
                System.err.println("WARNING: error in refreshing view cache for view " + rowsCacheEntry.getView());
            }
        }
    }

    public void refresh() {
        int n = this.m_rowsCache.size();
        for (int i = 0; i < n; ++i) {
            RowsCacheEntry rowsCacheEntry = (RowsCacheEntry)this.m_rowsCache.get(i);
            try {
                this.getRows(rowsCacheEntry);
                continue;
            }
            catch (Exception exception) {
                System.err.println("WARNING: error in refreshing view cache for view " + rowsCacheEntry.getView());
            }
        }
    }

    private Iterator getRows(RowsCacheEntry rowsCacheEntry) throws SQLException {
        return this.getRows(rowsCacheEntry.getView(), rowsCacheEntry.getSelects(), rowsCacheEntry.getKeys(), rowsCacheEntry.getValues(), new String[0]);
    }

    public void fetch(String string, MethodFilter methodFilter) throws SQLException {
        if (this.m_viewCacheDebug) {
            System.out.println("viewcache.fetch: " + string);
        }
        if (PARAMETER_ALL.equalsIgnoreCase(string = this.dbifyName(string)) || PARAMETER_USER.equalsIgnoreCase(string)) {
            this.getRows("ALL_ARGUMENTS", new String[0], new String[0], new Object[0], new String[0]);
        } else {
            String[] stringArray = null;
            Object[] objectArray = null;
            if (methodFilter != null && methodFilter.isSingleMethod()) {
                stringArray = new String[]{"PACKAGE_NAME", "OBJECT_NAME"};
                objectArray = new Object[]{string, methodFilter.getSingleMethodName()};
            } else {
                stringArray = new String[]{"PACKAGE_NAME"};
                objectArray = new Object[]{string};
            }
            this.getRows("ALL_ARGUMENTS", new String[0], stringArray, objectArray, new String[0]);
        }
    }

    public int getHits() {
        return this.m_hits;
    }

    public int getVisits() {
        return this.m_visits;
    }

    public void reset(Connection connection) {
        this.m_conn = connection;
    }

    public void close() {
        try {
            if (this.m_conn != null) {
                this.m_conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getUser() {
        return this.m_user;
    }

    public String getFileName(String string) {
        return ViewCache.getFileName(string, this.m_user);
    }

    public static String getFileName(String string, String string2) {
        return (string == null ? "" : string + File.separator) + VIEW_CACHE_PREFIX + string2.toLowerCase();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n;
        if (this.m_viewCacheDebug) {
            System.out.println("viewcache.read.external");
        }
        this.m_user = (String)objectInput.readObject();
        this.m_hits = (Integer)objectInput.readObject();
        this.m_visits = (Integer)objectInput.readObject();
        int n2 = (Integer)objectInput.readObject();
        this.m_rowsCache = new ArrayList(n2);
        for (n = 0; n < n2; ++n) {
            RowsCacheEntry rowsCacheEntry = (RowsCacheEntry)objectInput.readObject();
            this.m_rowsCache.add(rowsCacheEntry);
        }
        n = (Integer)objectInput.readObject();
        this.m_rowsCacheIndex = new Hashtable(n);
        for (int i = 0; i < n; ++i) {
            String string = (String)objectInput.readObject();
            int n3 = (Integer)objectInput.readObject();
            ArrayList<ViewRow> arrayList = new ArrayList<ViewRow>(n3);
            for (int j = 0; j < n3; ++j) {
                ViewRow viewRow = (ViewRow)objectInput.readObject();
                arrayList.add(viewRow);
            }
            this.m_rowsCacheIndex.put(string, arrayList);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Object object;
        if (this.m_viewCacheDebug) {
            System.out.println("viewcache.write.external");
        }
        objectOutput.writeObject(this.m_user);
        objectOutput.writeObject(new Integer(this.m_hits));
        objectOutput.writeObject(new Integer(this.m_visits));
        objectOutput.writeObject(new Integer(this.m_rowsCache.size()));
        for (int i = 0; i < this.m_rowsCache.size(); ++i) {
            object = (RowsCacheEntry)this.m_rowsCache.get(i);
            objectOutput.writeObject(object);
        }
        objectOutput.writeObject(new Integer(this.m_rowsCacheIndex.size()));
        Enumeration enumeration = this.m_rowsCacheIndex.keys();
        object = this.m_rowsCacheIndex.elements();
        while (enumeration.hasMoreElements()) {
            objectOutput.writeObject(enumeration.nextElement());
            ArrayList arrayList = (ArrayList)object.nextElement();
            objectOutput.writeObject(new Integer(arrayList.size()));
            for (int i = 0; i < arrayList.size(); ++i) {
                objectOutput.writeObject(arrayList.get(i));
            }
        }
    }

    public String printSummary() {
        String string = "";
        string = string + "****" + this.getFileName(null) + "****" + "\n";
        string = string + "schema: " + this.m_user + "\n";
        string = string + "hits/visits: " + this.m_hits + "/" + this.m_visits + "\n";
        for (int i = 0; i < this.m_rowsCache.size(); ++i) {
            RowsCacheEntry rowsCacheEntry = (RowsCacheEntry)this.m_rowsCache.get(i);
            string = string + rowsCacheEntry.printSummary();
        }
        return string;
    }

    public String dbifyName(String string) {
        if (string == null) {
            return "";
        }
        if (string.equals("")) {
            return "";
        }
        if (SqlName.isQuoted(string)) {
            return string.substring(1, string.length() - 1);
        }
        String string2 = string.toUpperCase();
        String string3 = "";
        try {
            Iterator iterator = this.getRows("DUAL", new String[]{"UPPER('" + string + "') AS UPPER_NAME"}, new String[0], new Object[0], new String[0]);
            if (iterator.hasNext()) {
                SingleColumnViewRow singleColumnViewRow = (SingleColumnViewRow)iterator.next();
                string3 = singleColumnViewRow.getValue();
            } else {
                string3 = string2;
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            string3 = string2;
        }
        return string3;
    }
}

