/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.visit;

import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.AttributeField;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlRecordType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.PlsqlTableType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.ProcedureMethod;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlObjectType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlPackageType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlToplevelType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.TypeClass;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherListener;
import org.eclipse.persistence.platform.database.oracle.publisher.visit.PublisherVisitor;

public class PublisherWalker
implements PublisherVisitor {
    protected PublisherListener listener;

    public PublisherWalker(PublisherListener publisherListener) {
        this.listener = publisherListener;
    }

    public PublisherListener getListener() {
        return this.listener;
    }

    public void visit(SqlType sqlType) {
        String string = null;
        if (sqlType.hasConversion()) {
            string = sqlType.getTargetTypeName();
        }
        this.listener.handleSqlType(sqlType.getName(), sqlType.getTypecode(), string);
    }

    @Override
    public void visit(SqlObjectType sqlObjectType) {
        String string = null;
        if (sqlObjectType.hasConversion()) {
            string = sqlObjectType.getTargetTypeName();
        }
        this.listener.handleObjectType(sqlObjectType.getName(), string);
    }

    @Override
    public void visit(SqlPackageType sqlPackageType) {
        this.listener.beginPackage(sqlPackageType.getName());
        try {
            ProcedureMethod[] procedureMethodArray;
            for (ProcedureMethod procedureMethod : procedureMethodArray = sqlPackageType.getDeclaredMethods()) {
                procedureMethod.accept(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.listener.endPackage();
    }

    @Override
    public void visit(SqlToplevelType sqlToplevelType) {
        try {
            ProcedureMethod[] procedureMethodArray;
            for (ProcedureMethod procedureMethod : procedureMethodArray = sqlToplevelType.getDeclaredMethods()) {
                procedureMethod.accept(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void visit(PlsqlRecordType plsqlRecordType) {
        String string = null;
        if (plsqlRecordType.hasConversion()) {
            string = plsqlRecordType.getTargetTypeName();
        }
        AttributeField[] attributeFieldArray = null;
        int n = 0;
        try {
            attributeFieldArray = plsqlRecordType.getFields(true);
            n = attributeFieldArray.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listener.beginPlsqlRecord(plsqlRecordType.getTypeName(), string, n);
        if (attributeFieldArray != null && n > 0) {
            for (int i = 0; i < n; ++i) {
                AttributeField attributeField = attributeFieldArray[i];
                this.listener.beginPlsqlRecordField(attributeField.getName(), i);
                ((SqlType)attributeField.getType()).accept(this);
                this.listener.endPlsqlRecordField(attributeField.getName(), i);
            }
        }
        this.listener.endPlsqlRecord(plsqlRecordType.getTypeName());
    }

    @Override
    public void visit(PlsqlTableType plsqlTableType) {
        String string = null;
        if (plsqlTableType.hasConversion()) {
            string = plsqlTableType.getTargetTypeName();
        }
        this.listener.beginPlsqlTable(plsqlTableType.getTypeName(), string);
        try {
            if (plsqlTableType.getComponentType() != null) {
                ((SqlType)plsqlTableType.getComponentType()).accept(this);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listener.endPlsqlTable(plsqlTableType.getTypeName());
    }

    @Override
    public void visit(ProcedureMethod procedureMethod) {
        TypeClass[] typeClassArray = procedureMethod.getParamTypes();
        int n = typeClassArray.length;
        this.listener.beginMethod(procedureMethod.getName(), n);
        SqlType sqlType = (SqlType)procedureMethod.getReturnType();
        if (sqlType != null) {
            this.listener.handleMethodReturn(sqlType.getName());
            sqlType.accept(this);
        }
        String[] stringArray = procedureMethod.getParamNames();
        int[] nArray = procedureMethod.getParamModes();
        for (int i = 0; i < n; ++i) {
            SqlType sqlType2 = (SqlType)typeClassArray[i];
            int n2 = nArray[i];
            String string = "IN";
            if (n2 == 2) {
                string = "OUT";
            } else if (n2 == 3) {
                string = "INOUT";
            }
            this.listener.beginMethodArg(stringArray[i], string, i);
            sqlType2.accept(this);
            this.listener.endMethodArg(stringArray[i]);
        }
        this.listener.endMethod(procedureMethod.getName());
    }
}

