/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.internal.xr.Util;
import org.eclipse.persistence.tools.dbws.DBWSPackager;

public class JarArchiver
implements DBWSPackager.Archiver {
    static final int BUF_SIZE = 1024;
    static final String DEFAULT_JAR_FILENAME = "dbws.jar";
    static final String DEFAULT_MANIFEST = Attributes.Name.MANIFEST_VERSION.toString() + ": 1.0\n" + "Created-by: DBWSBuilder 1.0\n\n";
    protected DBWSPackager packager;
    protected String jarFilename = null;
    protected JarOutputStream jarOutputStream = null;
    protected File f;
    protected FileInputStream fis;
    protected byte[] buffer = new byte[1024];

    public JarArchiver() {
    }

    public JarArchiver(DBWSPackager dBWSPackager) {
        this.packager = dBWSPackager;
    }

    @Override
    public DBWSPackager getPackager() {
        return this.packager;
    }

    @Override
    public void setPackager(DBWSPackager dBWSPackager) {
        this.packager = dBWSPackager;
    }

    @Override
    public String getFilename() {
        return this.jarFilename;
    }

    @Override
    public void setFilename(String string) {
        if (!string.endsWith(".jar")) {
            string = string + ".jar";
        }
        this.jarFilename = string;
    }

    @Override
    public void archive() {
        try {
            JarOutputStream jarOutputStream = this.buildJarOutputStream();
            if (jarOutputStream != null) {
                Manifest manifest = this.buildManifest();
                if (manifest != null) {
                    ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
                    jarOutputStream.putNextEntry(zipEntry);
                    manifest.write(new BufferedOutputStream(jarOutputStream));
                    jarOutputStream.closeEntry();
                }
                this.addFilesToJarOutputStream(jarOutputStream);
                jarOutputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Manifest buildManifest() {
        Manifest manifest = null;
        try {
            new Manifest(new ByteArrayInputStream(DEFAULT_MANIFEST.getBytes("ISO-8859-1")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return manifest;
    }

    protected JarOutputStream buildJarOutputStream() {
        JarOutputStream jarOutputStream = null;
        try {
            if (this.jarFilename == null || this.jarFilename.length() == 0) {
                this.jarFilename = DEFAULT_JAR_FILENAME;
            }
            jarOutputStream = new JarOutputStream(new FileOutputStream(new File(this.packager.getStageDir(), this.jarFilename)));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return jarOutputStream;
    }

    protected JarEntry getSchemaJarEntry() {
        return new JarEntry("eclipselink-dbws-schema.xsd");
    }

    protected JarEntry getSWARefJarEntry() {
        return new JarEntry("swaref.xsd");
    }

    protected JarEntry getOrJarEntry() {
        return new JarEntry(Util.META_INF_PATHS[0] + "eclipselink-dbws-or.xml");
    }

    protected JarEntry getOxJarEntry() {
        return new JarEntry(Util.META_INF_PATHS[0] + "eclipselink-dbws-ox.xml");
    }

    protected JarEntry getSessionsJarEntry() {
        return new JarEntry(Util.META_INF_PATHS[0] + this.packager.getSessionsFileName());
    }

    protected JarEntry getServiceJarEntry() {
        return new JarEntry(Util.META_INF_PATHS[0] + "eclipselink-dbws.xml");
    }

    protected void addFilesToJarOutputStream(JarOutputStream jarOutputStream) {
        try {
            jarOutputStream.putNextEntry(this.getSchemaJarEntry());
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws-schema.xsd");
            this.fis = new FileInputStream(this.f);
            int n = 0;
            while (n != -1) {
                jarOutputStream.write(this.buffer, 0, n);
                n = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
            if (this.packager.hasAttachments()) {
                jarOutputStream.putNextEntry(this.getSWARefJarEntry());
                this.f = new File(this.packager.getStageDir(), "swaref.xsd");
                this.fis = new FileInputStream(this.f);
                n = 0;
                while (n != -1) {
                    jarOutputStream.write(this.buffer, 0, n);
                    n = this.fis.read(this.buffer);
                }
                this.fis.close();
                this.f.deleteOnExit();
            }
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws-or.xml");
            if (this.f.length() > 0L) {
                jarOutputStream.putNextEntry(this.getOrJarEntry());
                this.fis = new FileInputStream(this.f);
                n = 0;
                while (n != -1) {
                    jarOutputStream.write(this.buffer, 0, n);
                    n = this.fis.read(this.buffer);
                }
                this.fis.close();
            }
            this.f.deleteOnExit();
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws-ox.xml");
            if (this.f.length() > 0L) {
                jarOutputStream.putNextEntry(this.getOxJarEntry());
                this.fis = new FileInputStream(this.f);
                n = 0;
                while (n != -1) {
                    jarOutputStream.write(this.buffer, 0, n);
                    n = this.fis.read(this.buffer);
                }
                this.fis.close();
            }
            this.f.deleteOnExit();
            jarOutputStream.putNextEntry(this.getSessionsJarEntry());
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws-sessions.xml");
            this.fis = new FileInputStream(this.f);
            n = 0;
            while (n != -1) {
                jarOutputStream.write(this.buffer, 0, n);
                n = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
            jarOutputStream.putNextEntry(this.getServiceJarEntry());
            this.f = new File(this.packager.getStageDir(), "eclipselink-dbws.xml");
            this.fis = new FileInputStream(this.f);
            n = 0;
            while (n != -1) {
                jarOutputStream.write(this.buffer, 0, n);
                n = this.fis.read(this.buffer);
            }
            this.fis.close();
            this.f.deleteOnExit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public String getOrProjectPathPrefix() {
        return Util.META_INF_PATHS[0];
    }

    @Override
    public String getOxProjectPathPrefix() {
        return Util.META_INF_PATHS[0];
    }

    @Override
    public String getWSDLPathPrefix() {
        return "wsdl/";
    }
}

