/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.ProcedureArgument;
import org.eclipse.persistence.internal.xr.ProcedureOutputArgument;
import org.eclipse.persistence.internal.xr.QNameTransformer;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.StoredFunctionQueryHandler;
import org.eclipse.persistence.internal.xr.StoredProcedureQueryHandler;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.OperationModel;
import org.eclipse.persistence.tools.dbws.Util;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredFunction;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;
import org.eclipse.persistence.tools.dbws.oracle.OracleHelper;
import org.eclipse.persistence.tools.dbws.oracle.PLSQLStoredArgument;

public class ProcedureOperationModel
extends OperationModel {
    protected String catalogPattern;
    protected String schemaPattern;
    protected String procedurePattern;
    protected int overload;

    public String getCatalogPattern() {
        return this.catalogPattern;
    }

    public void setCatalogPattern(String string) {
        this.catalogPattern = "null".equalsIgnoreCase(string) ? null : string;
    }

    public String getSchemaPattern() {
        return this.schemaPattern;
    }

    public void setSchemaPattern(String string) {
        this.schemaPattern = "null".equalsIgnoreCase(string) ? null : string;
    }

    public String getProcedurePattern() {
        return this.procedurePattern;
    }

    public void setProcedurePattern(String string) {
        this.procedurePattern = string;
    }

    public int getOverload() {
        return this.overload;
    }

    public void setOverload(int n) {
        this.overload = n;
    }

    @Override
    public boolean isProcedureOperation() {
        return true;
    }

    @Override
    public void buildOperation(DBWSBuilder dBWSBuilder) {
        super.buildOperation(dBWSBuilder);
        boolean bl = dBWSBuilder.getDatabasePlatform().getClass().getName().contains("Oracle");
        List<DbStoredProcedure> list = dBWSBuilder.loadProcedures(this.catalogPattern, this.schemaPattern, this.procedurePattern, this.overload, bl);
        for (DbStoredProcedure dbStoredProcedure : list) {
            Object object;
            String string;
            Object object3;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.name == null || this.name.length() == 0) {
                if (dbStoredProcedure.getOverload() > 0) {
                    stringBuilder.append(dbStoredProcedure.getOverload());
                    stringBuilder.append('_');
                }
                if (dbStoredProcedure.getCatalog() != null && dbStoredProcedure.getCatalog().length() > 0) {
                    stringBuilder.append(dbStoredProcedure.getCatalog());
                    stringBuilder.append('_');
                }
                if (dbStoredProcedure.getSchema() != null && dbStoredProcedure.getSchema().length() > 0) {
                    stringBuilder.append(dbStoredProcedure.getSchema());
                    stringBuilder.append('_');
                }
                stringBuilder.append(dbStoredProcedure.getName());
            } else {
                stringBuilder.append(this.name);
            }
            QueryOperation queryOperation = new QueryOperation();
            queryOperation.setName(stringBuilder.toString());
            Object object4 = dbStoredProcedure.isFunction() ? new StoredFunctionQueryHandler() : new StoredProcedureQueryHandler();
            stringBuilder = new StringBuilder();
            if (dBWSBuilder.databasePlatform.getClass().getName().contains("Oracle")) {
                if (dbStoredProcedure.getSchema() != null && dbStoredProcedure.getSchema().length() > 0) {
                    stringBuilder.append(dbStoredProcedure.getSchema());
                    stringBuilder.append('.');
                }
                if (dbStoredProcedure.getCatalog() != null && dbStoredProcedure.getCatalog().length() > 0) {
                    stringBuilder.append(dbStoredProcedure.getCatalog());
                    stringBuilder.append('.');
                }
            } else {
                if (dbStoredProcedure.getCatalog() != null && dbStoredProcedure.getCatalog().length() > 0) {
                    stringBuilder.append(dbStoredProcedure.getCatalog());
                    stringBuilder.append('.');
                }
                if (dbStoredProcedure.getSchema() != null && dbStoredProcedure.getSchema().length() > 0) {
                    stringBuilder.append(dbStoredProcedure.getSchema());
                    stringBuilder.append('.');
                }
            }
            stringBuilder.append(dbStoredProcedure.getName());
            object4.setName(stringBuilder.toString());
            dBWSBuilder.logMessage(Level.FINEST, "Building QueryOperation for " + object4.getName());
            queryOperation.setQueryHandler((QueryHandler)object4);
            SimpleXMLFormat simpleXMLFormat = null;
            if (this.isSimpleXMLFormat() || this.getReturnType() == null) {
                simpleXMLFormat = new SimpleXMLFormat();
            }
            if (this.simpleXMLFormatTag != null && this.simpleXMLFormatTag.length() > 0) {
                simpleXMLFormat.setSimpleXMLFormatTag(this.simpleXMLFormatTag);
            }
            if (this.xmlTag != null && this.xmlTag.length() > 0) {
                if (simpleXMLFormat == null) {
                    simpleXMLFormat = new SimpleXMLFormat();
                }
                simpleXMLFormat.setXMLTag(this.xmlTag);
            }
            Object object5 = null;
            if (!dbStoredProcedure.isFunction() && dBWSBuilder.getPlatformClassname().contains("Oracle") && Util.noOutArguments(dbStoredProcedure)) {
                object5 = new Result();
                object5.setType(new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd"));
            } else if (dbStoredProcedure.isFunction()) {
                object3 = (DbStoredFunction)dbStoredProcedure;
                DbStoredArgument dbStoredArgument = ((DbStoredFunction)object3).getReturnArg();
                if (dbStoredArgument.getJdbcTypeName().contains("CURSOR")) {
                    object5 = new CollectionResult();
                    object5.setType(Util.SXF_QNAME_CURSOR);
                } else {
                    object5 = new Result();
                    object5.setType(Util.getXMLTypeFromJDBCType(dbStoredArgument.getJdbcType()));
                }
            } else if (!dBWSBuilder.getPlatformClassname().contains("Oracle")) {
                if (this.returnType != null) {
                    object3 = null;
                    Object var12_14 = null;
                    string = null;
                    int n = this.returnType.indexOf(58);
                    object5 = new Result();
                    if (n > 0) {
                        object = null;
                        String string2 = this.returnType.substring(0, n);
                        object3 = dBWSBuilder.schema.getNamespaceResolver().resolveNamespacePrefix(string2);
                        if (object3 == null) {
                            object3 = "";
                        }
                        string = this.returnType.substring(n + 1);
                        if ("http://www.w3.org/2001/XMLSchema".equals(object3)) {
                            object = (QName)QNameTransformer.SCHEMA_QNAMES.get(string);
                            if (object == null) {
                                object = new QName("http://www.w3.org/2001/XMLSchema", string, string2 == null ? "" : string2);
                            }
                        } else {
                            object = new QName((String)(object3 == null ? "" : object3), string, string2 == null ? "" : string2);
                        }
                        object5.setType((QName)object);
                    } else {
                        object5.setType(Util.qNameFromString("{" + dBWSBuilder.getTargetNamespace() + "}" + this.returnType, dBWSBuilder.schema));
                    }
                } else if (this.isCollection) {
                    object5 = new CollectionResult();
                    if (this.isSimpleXMLFormat()) {
                        object5.setType(Util.SXF_QNAME_CURSOR);
                    }
                } else {
                    object5 = new Result();
                    object5.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
                }
            }
            if (this.binaryAttachment) {
                object3 = new Attachment();
                object3.setMimeType("application/octet-stream");
                object5.setAttachment((Attachment)object3);
            }
            for (DbStoredArgument dbStoredArgument : dbStoredProcedure.getArguments()) {
                string = dbStoredArgument.getName();
                if (string == null) continue;
                ProcedureOutputArgument procedureOutputArgument = null;
                object = null;
                Util.InOut inOut = dbStoredArgument.getInOut();
                QName qName = null;
                qName = bl ? OracleHelper.getXMLTypeFromJDBCType(dbStoredArgument, dBWSBuilder.getTargetNamespace()) : Util.getXMLTypeFromJDBCType(dbStoredArgument.getJdbcType());
                if (inOut == Util.InOut.IN) {
                    object = new Parameter();
                    object.setName(string);
                    object.setType(qName);
                    procedureOutputArgument = new ProcedureArgument();
                    procedureOutputArgument.setName(string);
                    procedureOutputArgument.setParameterName(string);
                    object4.getInArguments().add(procedureOutputArgument);
                } else {
                    ProcedureOutputArgument procedureOutputArgument2 = procedureOutputArgument = new ProcedureOutputArgument();
                    procedureOutputArgument2.setName(string);
                    procedureOutputArgument2.setParameterName(string);
                    if (dbStoredArgument.getJdbcTypeName().contains("CURSOR") && this.returnType == null) {
                        procedureOutputArgument2.setResultType(Util.SXF_QNAME_CURSOR);
                        if (object5 == null) {
                            object5 = new CollectionResult();
                            object5.setType(Util.SXF_QNAME_CURSOR);
                        }
                    } else {
                        if (this.returnType != null && simpleXMLFormat == null) {
                            qName = Util.qNameFromString("{" + dBWSBuilder.getTargetNamespace() + "}" + this.returnType, dBWSBuilder.schema);
                        }
                        procedureOutputArgument2.setResultType(qName);
                        if (object5 == null) {
                            object5 = this.isCollection ? new CollectionResult() : new Result();
                            object5.setType(qName);
                        }
                    }
                    if (inOut == Util.InOut.INOUT) {
                        object4.getInOutArguments().add(procedureOutputArgument2);
                    } else {
                        object4.getOutArguments().add(procedureOutputArgument2);
                    }
                }
                if (dbStoredArgument instanceof PLSQLStoredArgument) {
                    procedureOutputArgument.setComplexTypeName(((PLSQLStoredArgument)dbStoredArgument).getPlSqlTypeName());
                    if (object4 instanceof StoredProcedureQueryHandler) {
                        // empty if block
                    }
                }
                if (object == null) continue;
                queryOperation.getParameters().add(object);
            }
            if (simpleXMLFormat != null) {
                object5.setSimpleXMLFormat(simpleXMLFormat);
                if (dBWSBuilder.oxProject.getDescriptorForAlias("simple-xml-format") == null) {
                    object3 = new SimpleXMLFormatProject();
                    dBWSBuilder.oxProject.addDescriptor(object3.buildXRRowSetModelDescriptor());
                }
            }
            queryOperation.setResult(object5);
            dBWSBuilder.xrServiceModel.getOperations().put(queryOperation.getName(), queryOperation);
        }
        if (ProcedureOperationModel.requiresSimpleXMLFormat(dBWSBuilder.xrServiceModel) && dBWSBuilder.schema.getTopLevelElements().get("simple-xml-format") == null) {
            Util.addSimpleXMLFormat(dBWSBuilder.schema);
        }
    }
}

