/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.ArrayList;
import org.eclipse.persistence.internal.xr.Attachment;
import org.eclipse.persistence.internal.xr.CollectionResult;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.QueryHandler;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.Result;
import org.eclipse.persistence.internal.xr.SQLQueryHandler;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormat;
import org.eclipse.persistence.internal.xr.sxf.SimpleXMLFormatProject;
import org.eclipse.persistence.tools.dbws.BindingModel;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.OperationModel;
import org.eclipse.persistence.tools.dbws.Util;

public class SQLOperationModel
extends OperationModel {
    protected String sqlText;
    protected ArrayList<BindingModel> bindings = new ArrayList();

    public String getSQLText() {
        return this.sqlText;
    }

    public void setSQLText(String string) {
        this.sqlText = string;
    }

    public void addBinding(BindingModel bindingModel) {
        this.bindings.add(bindingModel);
    }

    public ArrayList<BindingModel> getBindings() {
        return this.bindings;
    }

    public void setBindings(ArrayList<BindingModel> arrayList) {
        this.bindings = arrayList;
    }

    @Override
    public boolean isSQLOperation() {
        return true;
    }

    @Override
    public void buildOperation(DBWSBuilder dBWSBuilder) {
        Object object;
        super.buildOperation(dBWSBuilder);
        QueryOperation queryOperation = new QueryOperation();
        queryOperation.setName(this.name);
        SQLQueryHandler sQLQueryHandler = new SQLQueryHandler();
        Object object2 = this.isCollection ? new CollectionResult() : new Result();
        SimpleXMLFormat simpleXMLFormat = null;
        if (this.isSimpleXMLFormat() || this.getReturnType() == null) {
            simpleXMLFormat = new SimpleXMLFormat();
            if (this.simpleXMLFormatTag != null && this.simpleXMLFormatTag.length() > 0) {
                simpleXMLFormat.setSimpleXMLFormatTag(this.simpleXMLFormatTag);
            }
            object2.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
        }
        if (this.xmlTag != null && this.xmlTag.length() > 0) {
            if (simpleXMLFormat == null) {
                simpleXMLFormat = new SimpleXMLFormat();
                object2.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
            }
            simpleXMLFormat.setXMLTag(this.xmlTag);
        }
        if (simpleXMLFormat != null) {
            object2.setSimpleXMLFormat(simpleXMLFormat);
            if (dBWSBuilder.oxProject.getDescriptorForAlias("simple-xml-format") == null) {
                object = new SimpleXMLFormatProject();
                dBWSBuilder.oxProject.addDescriptor(object.buildXRRowSetModelDescriptor());
            }
        }
        if (this.binaryAttachment) {
            object = new Attachment();
            object.setMimeType("application/octet-stream");
            object2.setAttachment((Attachment)object);
        }
        if (this.returnType != null && this.returnType.length() > 0) {
            object2.setType(Util.qNameFromString("{" + dBWSBuilder.getTargetNamespace() + "}" + this.returnType, dBWSBuilder.schema));
        } else {
            object2.setType(org.eclipse.persistence.internal.xr.Util.SXF_QNAME);
            object2.setSimpleXMLFormat(simpleXMLFormat == null ? new SimpleXMLFormat() : simpleXMLFormat);
        }
        queryOperation.setResult((Result)object2);
        sQLQueryHandler.setSqlString(BindingModel.convertJDBCParameterBindingMarkers(this.sqlText, this.bindings));
        if (!this.bindings.isEmpty()) {
            for (BindingModel bindingModel : this.bindings) {
                Parameter parameter = new Parameter();
                parameter.setName(bindingModel.name);
                parameter.setType(Util.qNameFromString(bindingModel.type, dBWSBuilder.schema));
                queryOperation.getParameters().add(parameter);
            }
        }
        queryOperation.setQueryHandler((QueryHandler)sQLQueryHandler);
        dBWSBuilder.xrServiceModel.getOperations().put(queryOperation.getName(), queryOperation);
        if (SQLOperationModel.requiresSimpleXMLFormat(dBWSBuilder.xrServiceModel) && dBWSBuilder.schema.getTopLevelElements().get("simple-xml-format") == null) {
            Util.addSimpleXMLFormat(dBWSBuilder.schema);
        }
    }
}

