/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.OutputStream;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.schema.SchemaModelProject;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Import;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.xr.Parameter;
import org.eclipse.persistence.internal.xr.QueryOperation;
import org.eclipse.persistence.internal.xr.XRServiceModel;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.tools.dbws.NamingConventionTransformer;
import org.w3c.dom.Element;

public class WSDLGenerator {
    public static final String BINDING_SUFFIX = "_SOAP_HTTP";
    public static final String EMPTY_RESPONSE = "EmptyResponse";
    public static final String EXCEPTION_SUFFIX = "Exception";
    public static final String FAULT_SUFFIX = "Fault";
    public static final String NS_SCHEMA_PREFIX = "xsd";
    public static final String NS_TNS_PREFIX = "tns";
    public static final String NS_WSDL_SOAP = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String NS_WSDL_SOAP_PREFIX = "soap";
    public static final String PORT_SUFFIX = "_Interface";
    public static final String REQUEST_SUFFIX = "Request";
    public static final String RESPONSE_SUFFIX = "Response";
    public static final String SOAP_STYLE = "document";
    public static final String SOAP_TRANSPORT = "http://schemas.xmlsoap.org/soap/http";
    public static final String SOAP_USE = "literal";
    public static final String TAG_SCHEMA = "schema";
    public static final String TAG_SOAP_ADDRESS = "address";
    public static final String TAG_SOAP_BINDING = "binding";
    public static final String TAG_SOAP_BODY = "body";
    public static final String TAG_SOAP_FAULT = "fault";
    public static final String TAG_SOAP_OPERATION = "operation";
    public static final String TYPE_SUFFIX = "Type";
    protected XRServiceModel xrServiceModel;
    protected NamingConventionTransformer nct;
    protected String serviceName;
    protected String serviceNameSpace;
    protected String importedSchemaNameSpace;
    protected String wsdlLocationURI;
    protected boolean hasAttachments;
    protected OutputStream os;

    public WSDLGenerator(XRServiceModel xRServiceModel, NamingConventionTransformer namingConventionTransformer, String string, boolean bl, String string2, OutputStream outputStream) {
        this.xrServiceModel = xRServiceModel;
        this.nct = namingConventionTransformer;
        this.wsdlLocationURI = string;
        this.hasAttachments = bl;
        this.os = outputStream;
        this.importedSchemaNameSpace = string2;
        this.serviceName = xRServiceModel.getName() + "Service";
        this.serviceNameSpace = string2 + "Service";
    }

    public Definition generateWSDL() throws WSDLException {
        Object object;
        WSDLFactory wSDLFactory = WSDLFactory.newInstance();
        ExtensionRegistry extensionRegistry = wSDLFactory.newPopulatedExtensionRegistry();
        Definition definition = wSDLFactory.newDefinition();
        definition.setTargetNamespace(this.serviceNameSpace);
        definition.setQName(new QName(this.serviceNameSpace, this.serviceName));
        definition.addNamespace(NS_TNS_PREFIX, this.serviceNameSpace);
        definition.addNamespace("ns1", this.importedSchemaNameSpace);
        definition.addNamespace(NS_SCHEMA_PREFIX, "http://www.w3.org/2001/XMLSchema");
        definition.addNamespace(NS_WSDL_SOAP_PREFIX, NS_WSDL_SOAP);
        Types types = definition.createTypes();
        Schema schema = (Schema)extensionRegistry.createExtension(Types.class, new QName("http://www.w3.org/2001/XMLSchema", TAG_SCHEMA));
        schema.setElement(this.createInlineSchema());
        types.addExtensibilityElement((ExtensibilityElement)schema);
        definition.setTypes(types);
        PortType portType = definition.createPortType();
        portType.setUndefined(false);
        portType.setQName(new QName(this.serviceNameSpace, this.serviceName + PORT_SUFFIX));
        definition.addPortType(portType);
        Binding binding = definition.createBinding();
        binding.setUndefined(false);
        binding.setQName(new QName(this.serviceNameSpace, this.serviceName + BINDING_SUFFIX));
        binding.setPortType(portType);
        SOAPBinding sOAPBinding = (SOAPBinding)extensionRegistry.createExtension(Binding.class, new QName(NS_WSDL_SOAP, TAG_SOAP_BINDING));
        sOAPBinding.setStyle(SOAP_STYLE);
        sOAPBinding.setTransportURI(SOAP_TRANSPORT);
        binding.addExtensibilityElement((ExtensibilityElement)sOAPBinding);
        definition.addBinding(binding);
        Service service = definition.createService();
        service.setQName(new QName(this.serviceNameSpace, this.serviceName));
        Port port = definition.createPort();
        port.setName(this.serviceName + "Port");
        port.setBinding(binding);
        SOAPAddress sOAPAddress = (SOAPAddress)extensionRegistry.createExtension(Port.class, new QName(NS_WSDL_SOAP, TAG_SOAP_ADDRESS));
        sOAPAddress.setLocationURI(this.wsdlLocationURI);
        port.addExtensibilityElement((ExtensibilityElement)sOAPAddress);
        service.addPort(port);
        definition.addService(service);
        boolean bl = false;
        for (org.eclipse.persistence.internal.xr.Operation operation : this.xrServiceModel.getOperationsList()) {
            if (operation instanceof QueryOperation) continue;
            bl = true;
            break;
        }
        if (bl) {
            org.eclipse.persistence.internal.xr.Operation operation;
            object = definition.createMessage();
            object.setUndefined(false);
            object.setQName(new QName(this.serviceNameSpace, EMPTY_RESPONSE));
            operation = definition.createPart();
            operation.setName("emptyResponse");
            operation.setElementName(new QName(this.serviceNameSpace, EMPTY_RESPONSE));
            object.addPart((Part)operation);
            definition.addMessage((Message)object);
            Message message = definition.createMessage();
            message.setUndefined(false);
            message.setQName(new QName(this.serviceNameSpace, "FaultType"));
            Part part = definition.createPart();
            part.setName(TAG_SOAP_FAULT);
            part.setElementName(new QName(this.serviceNameSpace, "FaultType"));
            message.addPart(part);
            definition.addMessage(message);
        }
        for (org.eclipse.persistence.internal.xr.Operation operation : this.xrServiceModel.getOperationsList()) {
            this.createMethodDefinition(wSDLFactory, extensionRegistry, definition, operation);
        }
        if (this.os != null) {
            object = wSDLFactory.newWSDLWriter();
            object.writeWSDL(definition, this.os);
        }
        return definition;
    }

    private void createMethodDefinition(WSDLFactory wSDLFactory, ExtensionRegistry extensionRegistry, Definition definition, org.eclipse.persistence.internal.xr.Operation operation) throws WSDLException {
        SOAPBody sOAPBody;
        BindingOutput bindingOutput;
        Output output;
        PortType portType;
        Message message = definition.createMessage();
        message.setUndefined(false);
        message.setQName(new QName(this.serviceNameSpace, operation.getName() + REQUEST_SUFFIX));
        Part part = definition.createPart();
        part.setName(operation.getName() + REQUEST_SUFFIX);
        part.setElementName(new QName(this.serviceNameSpace, operation.getName()));
        message.addPart(part);
        definition.addMessage(message);
        Message message2 = null;
        if (operation.hasResponse()) {
            message2 = definition.createMessage();
            message2.setUndefined(false);
            message2.setQName(new QName(this.serviceNameSpace, operation.getName() + RESPONSE_SUFFIX));
            portType = definition.createPart();
            portType.setName(operation.getName() + RESPONSE_SUFFIX);
            portType.setElementName(new QName(this.serviceNameSpace, operation.getName() + RESPONSE_SUFFIX));
            message2.addPart((Part)portType);
            definition.addMessage(message2);
        }
        portType = definition.getPortType(new QName(this.serviceNameSpace, this.serviceName + PORT_SUFFIX));
        Operation operation2 = definition.createOperation();
        operation2.setUndefined(false);
        operation2.setName(operation.getName());
        Input input = definition.createInput();
        input.setMessage(message);
        operation2.setInput(input);
        if (operation.hasResponse()) {
            output = definition.createOutput();
            output.setMessage(message2);
            operation2.setOutput(output);
        }
        portType.addOperation(operation2);
        output = definition.getBinding(new QName(this.serviceNameSpace, this.serviceName + BINDING_SUFFIX));
        BindingOperation bindingOperation = definition.createBindingOperation();
        bindingOperation.setName(operation.getName());
        SOAPOperation sOAPOperation = (SOAPOperation)extensionRegistry.createExtension(BindingOperation.class, new QName(NS_WSDL_SOAP, TAG_SOAP_OPERATION));
        sOAPOperation.setSoapActionURI(this.serviceNameSpace + ":" + operation2.getName());
        bindingOperation.addExtensibilityElement((ExtensibilityElement)sOAPOperation);
        BindingInput bindingInput = definition.createBindingInput();
        SOAPBody sOAPBody2 = (SOAPBody)extensionRegistry.createExtension(BindingInput.class, new QName(NS_WSDL_SOAP, TAG_SOAP_BODY));
        sOAPBody2.setUse(SOAP_USE);
        bindingInput.addExtensibilityElement((ExtensibilityElement)sOAPBody2);
        bindingOperation.setBindingInput(bindingInput);
        if (operation.hasResponse()) {
            bindingOutput = definition.createBindingOutput();
            sOAPBody = (SOAPBody)extensionRegistry.createExtension(BindingOutput.class, new QName(NS_WSDL_SOAP, TAG_SOAP_BODY));
            sOAPBody.setUse(SOAP_USE);
            bindingOutput.addExtensibilityElement((ExtensibilityElement)sOAPBody);
            bindingOperation.setBindingOutput(bindingOutput);
        }
        if (!(operation instanceof QueryOperation)) {
            bindingOutput = definition.createBindingOutput();
            sOAPBody = (SOAPBody)extensionRegistry.createExtension(BindingOutput.class, new QName(NS_WSDL_SOAP, TAG_SOAP_BODY));
            sOAPBody.setUse(SOAP_USE);
            bindingOutput.addExtensibilityElement((ExtensibilityElement)sOAPBody);
            bindingOperation.setBindingOutput(bindingOutput);
            BindingFault bindingFault = definition.createBindingFault();
            String string = "FaultException";
            bindingFault.setName(string);
            SOAPFault sOAPFault = (SOAPFault)extensionRegistry.createExtension(BindingFault.class, new QName(NS_WSDL_SOAP, TAG_SOAP_FAULT));
            sOAPFault.setUse(SOAP_USE);
            sOAPFault.setName(string);
            bindingFault.addExtensibilityElement((ExtensibilityElement)sOAPFault);
            bindingOperation.addBindingFault(bindingFault);
            Message message3 = definition.getMessage(new QName(this.serviceNameSpace, EMPTY_RESPONSE));
            Output output2 = definition.createOutput();
            output2.setName(operation.getName() + EMPTY_RESPONSE);
            output2.setMessage(message3);
            operation2.setOutput(output2);
            Message message4 = definition.getMessage(new QName(this.serviceNameSpace, "FaultType"));
            Fault fault = definition.createFault();
            fault.setMessage(message4);
            fault.setName(string);
            operation2.addFault(fault);
        }
        output.addBindingOperation(bindingOperation);
    }

    private Element createInlineSchema() {
        Object object;
        Sequence sequence;
        String string;
        ComplexType complexType;
        String string2;
        SchemaModelProject schemaModelProject = new SchemaModelProject();
        XMLContext xMLContext = new XMLContext((Project)schemaModelProject);
        XMLMarshaller xMLMarshaller = xMLContext.createMarshaller();
        XMLDescriptor xMLDescriptor = (XMLDescriptor)schemaModelProject.getClassDescriptor(org.eclipse.persistence.internal.oxm.schema.model.Schema.class);
        if (xMLDescriptor.getNamespaceResolver() == null) {
            xMLDescriptor.setNamespaceResolver(new NamespaceResolver());
        }
        xMLDescriptor.getNamespaceResolver().put(NS_TNS_PREFIX, this.serviceNameSpace);
        xMLDescriptor.getNamespaceResolver().put(NS_SCHEMA_PREFIX, "http://www.w3.org/2001/XMLSchema");
        if (this.hasAttachments) {
            xMLDescriptor.getNamespaceResolver().put("ref", "http://ws-i.org/profiles/basic/1.1/xsd");
        }
        org.eclipse.persistence.internal.oxm.schema.model.Schema schema = new org.eclipse.persistence.internal.oxm.schema.model.Schema();
        schema.setTargetNamespace(this.serviceNameSpace);
        schema.setElementFormDefault(true);
        Import import_ = new Import();
        import_.setNamespace(this.importedSchemaNameSpace);
        import_.setSchemaLocation("eclipselink-dbws-schema.xsd");
        schema.getImports().add(import_);
        if (this.hasAttachments) {
            Import import_2 = new Import();
            import_2.setNamespace("http://ws-i.org/profiles/basic/1.1/xsd");
            import_2.setSchemaLocation("swaref.xsd");
            schema.getImports().add(import_2);
        }
        boolean bl = false;
        for (org.eclipse.persistence.internal.xr.Operation operation : this.xrServiceModel.getOperationsList()) {
            org.eclipse.persistence.internal.oxm.schema.model.Element element;
            Sequence sequence2;
            ComplexType complexType2;
            org.eclipse.persistence.internal.oxm.schema.model.Element element2;
            string2 = operation.getName();
            complexType = new ComplexType();
            string = string2.substring(string2.indexOf(95) + 1);
            complexType.setName(string2 + REQUEST_SUFFIX + TYPE_SUFFIX);
            sequence = null;
            if (operation.getParameters().size() > 0) {
                sequence = new Sequence();
                for (Parameter parameter : operation.getParameters()) {
                    element2 = new org.eclipse.persistence.internal.oxm.schema.model.Element();
                    element2.setName(parameter.getName());
                    if ("theInstance".equals(parameter.getName())) {
                        complexType2 = new ComplexType();
                        sequence2 = new Sequence();
                        complexType2.setSequence(sequence2);
                        element = new org.eclipse.persistence.internal.oxm.schema.model.Element();
                        element.setRef("ns1:" + string);
                        sequence2.addElement(element);
                        element2.setComplexType(complexType2);
                    } else {
                        element2.setName(parameter.getName());
                        if (parameter.getType().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                            element2.setType("xsd:" + parameter.getType().getLocalPart());
                        } else if (parameter.getType().getNamespaceURI().equals(this.importedSchemaNameSpace)) {
                            element2.setType("ns1:" + parameter.getType().getLocalPart());
                        } else {
                            element2.setType(parameter.getType().getLocalPart());
                        }
                    }
                    sequence.addElement(element2);
                }
                complexType.setSequence(sequence);
            }
            schema.addTopLevelComplexTypes(complexType);
            object = new org.eclipse.persistence.internal.oxm.schema.model.Element();
            object.setName(operation.getName());
            object.setType("tns:" + complexType.getName());
            schema.addTopLevelElement((org.eclipse.persistence.internal.oxm.schema.model.Element)object);
            if (operation instanceof QueryOperation) {
                Sequence sequence3;
                Parameter parameter;
                parameter = (QueryOperation)operation;
                element2 = new ComplexType();
                element2.setName(operation.getName() + RESPONSE_SUFFIX + TYPE_SUFFIX);
                complexType2 = new Sequence();
                sequence2 = new org.eclipse.persistence.internal.oxm.schema.model.Element();
                sequence2.setName("result");
                if (parameter.isAttachment()) {
                    sequence2.setType("ref:swaref");
                } else if (parameter.isSimpleXMLFormat() || parameter.getResultType().equals(new QName("http://www.w3.org/2001/XMLSchema", "any"))) {
                    element = new ComplexType();
                    sequence3 = new Sequence();
                    sequence3.addAny(new Any());
                    element.setSequence(sequence3);
                    sequence2.setComplexType((ComplexType)element);
                } else if (parameter.getResultType().getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                    sequence2.setType("xsd:" + parameter.getResultType().getLocalPart());
                } else {
                    element = new ComplexType();
                    sequence3 = new Sequence();
                    element.setSequence(sequence3);
                    org.eclipse.persistence.internal.oxm.schema.model.Element element3 = new org.eclipse.persistence.internal.oxm.schema.model.Element();
                    if (!parameter.isUserDefined()) {
                        element3.setRef("ns1:" + string);
                    } else {
                        element3.setRef("ns1:" + parameter.getResultType().getLocalPart());
                    }
                    element3.setMinOccurs("0");
                    if (parameter.isCollection()) {
                        element3.setMaxOccurs("unbounded");
                    }
                    sequence3.addElement(element3);
                    sequence2.setComplexType((ComplexType)element);
                }
                complexType2.addElement((org.eclipse.persistence.internal.oxm.schema.model.Element)sequence2);
                element2.setSequence((Sequence)complexType2);
                schema.addTopLevelComplexTypes((ComplexType)element2);
                element = new org.eclipse.persistence.internal.oxm.schema.model.Element();
                element.setName(operation.getName() + RESPONSE_SUFFIX);
                element.setType("tns:" + element2.getName());
                schema.addTopLevelElement(element);
                continue;
            }
            bl = true;
        }
        if (bl) {
            org.eclipse.persistence.internal.xr.Operation operation;
            org.eclipse.persistence.internal.oxm.schema.model.Element element = new org.eclipse.persistence.internal.oxm.schema.model.Element();
            element.setName(EMPTY_RESPONSE);
            operation = new ComplexType();
            element.setComplexType((ComplexType)operation);
            schema.addTopLevelElement(element);
            string2 = new org.eclipse.persistence.internal.oxm.schema.model.Element();
            string2.setName("FaultType");
            complexType = new ComplexType();
            string2.setComplexType(complexType);
            string = new Sequence();
            complexType.setSequence((Sequence)string);
            sequence = new org.eclipse.persistence.internal.oxm.schema.model.Element();
            sequence.setName("faultCode");
            sequence.setMinOccurs("1");
            sequence.setType("xsd:string");
            string.addElement((org.eclipse.persistence.internal.oxm.schema.model.Element)sequence);
            object = new org.eclipse.persistence.internal.oxm.schema.model.Element();
            object.setMinOccurs("1");
            object.setName("faultString");
            object.setType("xsd:string");
            string.addElement((org.eclipse.persistence.internal.oxm.schema.model.Element)object);
            schema.addTopLevelElement((org.eclipse.persistence.internal.oxm.schema.model.Element)string2);
        }
        return xMLMarshaller.objectToXML((Object)schema).getDocumentElement();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceNameSpace() {
        return this.serviceNameSpace;
    }
}

